/*
 * This file is part of "mazewar", an interactive
 * multiuser action game for non-BSD-Unix-systems.
 * Copyright (C) 1988 Hans Korneder      korn@altger.uucp
 * Permission is granted to the public
 * to copy all parts of the source, as long as no money
 * is made out of it, and the copyrightmessage is not removed.
 */

#define MAZE_DAEMON	"/usr/local/lib/mw_daemon_pipe"
#define MAZE_PIPE   "/tmp/mw_user_XXXXXX"
#define MAZE_SCORES "/usr/local/lib/mw_score_tbl"

/* message-typen */
#define MESSAGES 12345
#define ANMELD   MESSAGES+0 /* new player comes in */
#define SP_ANZ   MESSAGES+4 /* show player status */
#define BEWEGUNG MESSAGES+5 /* player moves */
#define BILD_NEU MESSAGES+7 /* screen refresh */
#define EXIT     127

struct anmeldung /* from the keyboard-client to the server */
	{
	int  an_magic;
	int  an_pid;
	int  an_uid;
	char an_pipe[32];
	} ;

struct sp_anzeige /* fromm the server to the screen client */
	{
	int  sp_magic;
	int  sp_pid;
	int  sp_lfd_nr;
	long sp_score;
	int  sp_x_pos;
	int  sp_y_pos;
	char sp_name[9];
	char sp_richtg;
	char sp_flag; /* 1=in the game, 2=visible */
	} ;

struct bewegung /* from the keyboard client to the server */
	{
	int  be_magic;
	int  be_pid;
	int  be_code; /* also uid ! */
	} ;

#define MAZE_ROWS 19
#define MAZE_COLS 40
extern char maze[MAZE_ROWS][MAZE_COLS];
