/*
 * tstring.h
 *
 * 88-10-01 v1.0	created by greg yachuk, placed in the public domain
 * 88-10-06 v1.1	changed prerequisite list handling
 * 88-11-11 v1.2	fixed some bugs and added environment variables
 * 89-07-12 v1.3	stop appending shell commands, and flush output
 * 89-08-01 v1.4 AB	lots of new options and code
 * 89-10-30 v1.5	-f -S -q options, took some changes from v1.4
 * 90-04-18 v1.6	-b -- -W options, emulate <<, non-BSD cleanup
 */
#define	tnew(t)		((t *) talloc(sizeof(t)))
#define	tfree(t)	(free((char *) t))

#define	tstrcat(s,p)	(strcat(strcpy(talloc(strlen(s)+strlen(p)+1),(s)),(p)))
#define	tstrcpy(s)	(strcpy(talloc(strlen(s)+1), (s)))

#ifdef COHERENT
extern char *talloc();
extern char *trealloc();
extern char *tstrncpy();
extern int terror();
extern char *tstrspan();
extern char *tunquote();
extern char *tsplit();
extern char *token();
extern char **tokenize();
extern char *tgets();
#else
#ifdef	__STDC__
extern char *talloc(int n);
extern char *trealloc(char *s, int n);
extern char *tstrncpy(char *s, int n);
extern int terror(int n, char *s);
extern char *tstrspan(char *str);
extern char *tunquote(char *str);
extern char *tsplit(char *s, char *seps, char **dp);
extern char *token(char *s, char *sep, char *schar);
extern char **tokenize(char *input);
extern char *tgets(FILE * fd);
#else
extern char *talloc();
extern char *trealloc();
extern char *tstrncpy();
extern int terror();
extern char *tstrspan();
extern char *tunquote();
extern char *tsplit();
extern char *token();
extern char **tokenize();
extern char *tgets();
#endif
#endif
