/* struct_symbol.h - Internal symbol structure
   Copyright (C) 1987 Free Software Foundation, Inc.

This file is part of GAS, the GNU Assembler.

GAS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GAS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GAS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

struct symbol			/* our version of an nlist node */
{
  symbol_type	sy_symbol;	/* what we write in .o file (if permitted) */
  long unsigned sy_name_offset;	/* 4-origin position of sy_name in symbols */
				/* part of object file. */
				/* 0 for (nameless) .stabd symbols. */
				/* Not used until write_object_file() time. */
  long int	sy_number;	/* 24 bit symbol number. */
				/* Symbol numbers start at 0 and are */
				/* unsigned. */
  struct symbol * sy_next;	/* forward chain, or NULL */
#ifdef coff
  struct symbol * sy_previous;	/* backward chain, or NULL */
#endif /* coff */
  struct frag *	sy_frag;	/* NULL or -> frag this symbol attaches to. */
  struct symbol *sy_forward;	/* value is really that of this other symbol */
#ifdef coff
  unsigned int sy_flags;	/* Internal use only flags (see coff.h) */
  AUXENT sy_auxent;		/* Auxiliary entry. */
#endif /* coff */
};

typedef struct symbol symbolS;

#ifdef coff

#define sy_name		sy_symbol.n_name	/* Symbol name */
#define sy_zeroes	sy_symbol.n_zeroes	/* All 0 if pointer to str. */
#define sy_offset	sy_symbol.n_offset	/* Offset in string table */
#define	sy_value	sy_symbol.n_value	/* Symbol 0 or ptr in file */
#define sy_scnum	sy_symbol.n_scnum	/* Section number */
#define sy_type		sy_symbol.n_type	/* Type and derived type */
#define sy_sclass	sy_symbol.n_sclass	/* Storage class */
#define sy_numaux	sy_symbol.n_numaux	/* Number of aux. entries */

#else /* coff */

#define sy_name		sy_symbol.n_un.n_name
				/* Name field always points to a string. */
				/* 0 means .stabd-like anonymous symbol. */
#define sy_strx		sy_symbol.n_un.n_strx
#define sy_type 	sy_symbol.n_type
#define sy_other	sy_symbol.n_other
#define sy_desc		sy_symbol.n_desc
#define sy_value	sy_symbol.n_value
				/* Value of symbol is this value + object */
				/* file address of sy_frag. */

#endif /* coff */

typedef unsigned valueT;	/* The type of n_value. Helps casting. */

/* end: struct_symbol.h */
#ifndef WORKING_DOT_WORD
struct broken_word {
	struct broken_word *next_broken_word;/* One of these strucs per .word x-y */
	fragS	*frag;		/* Which frag its in */
	char	*word_goes_here;/* Where in the frag it is */
	fragS	*dispfrag;	/* where to add the break */
	symbolS	*add;		/* symbol_x */
	symbolS	*sub;		/* - symbol_y */
	long	addnum;		/* + addnum */
	int	added;		/* nasty thing happend yet? */
				/* 1: added and has a long-jump */
				/* 2: added but uses someone elses long-jump */
	struct broken_word *use_jump; /* points to broken_word with a similar
					 long-jump */
};
extern struct broken_word *broken_words;
#endif
