#include "stack.h"

extern char* malloc();
extern char* realloc();

stack* stack_init(chunk_size, element_size)
unsigned long chunk_size;
unsigned long element_size;
{
    stack* st;
    if((st = (stack*)malloc(sizeof(stack))) == (stack*)0)
	return (stack*)0;
    if((st->data = malloc(chunk_size)) == (char*)0) {
	free(st);
	return (stack*)0;
    }
    st->pointer = 0;
    st->size = chunk_size;
    st->chunk_size = chunk_size;
    st->element_size = element_size;
    return st;
}

void stack_delete(st)
stack* st;
{
    free(st->data);
    free(st);
}

char* stack_push(st, element)
stack* st;
char* element;
{
    if(st->pointer + st->element_size >= st->size) {
	st->size += st->chunk_size;
	if((st->data = realloc(st->data, st->size)) == (char*)0)
	    return (char*)0;
    }
    memcpy(st->data + st->pointer, element, st->element_size);
    st->pointer += st->element_size;
    return st->data + st->pointer;
}

char* stack_pop(st)
stack* st;
{
    if((st->pointer -= st->element_size) < 0) {
	st->pointer = 0;
	return (char*)0;
    }
    return st->data + st->pointer;
}

char* stack_top(st)
stack* st;
{
    return st->data + st->pointer - st->element_size;
}
