#include "oformat.h"
#include "as.h"
#include "md.h"
#include "struc-symbol.h"
#include "symbols.h"    
#include "write.h"

#ifdef COHERENT
#define R_OFF8		07
#define STYP_REG	0
#endif

/* Relocation. */

/*
 *		emit_relocations()
 *
 * Crawl along a fixS chain. Emit the segment's relocations.
 */
    
void
emit_relocations (fixP, segment_address_in_file)
register fixS *	fixP;	/* Fixup chain for this segment. */
relax_addressT	segment_address_in_file;
{
    RELOC			ri;
    register symbolS *		symbolP;
#ifdef SORT_RELOCATIONS
    static int c_compare_fix();
    register unsigned long	nfix = 0;
    register unsigned long	ix;
    fixS** fix_array;
#endif /* SORT_RELOCATIONS */
    
    bzero((char *)&ri,sizeof(ri));
#ifdef SORT_RELOCATIONS
    {
	register fixS* fix_tmp;
	for(fix_tmp = fixP; fix_tmp; fix_tmp = fix_tmp->fx_next)
	    if (fix_tmp->fx_addsy)
		nfix++;
	fix_array = (fixS**)alloca(sizeof(fixS*)*nfix);
	for(ix = 0, fix_tmp = fixP; fix_tmp; fix_tmp = fix_tmp->fx_next)
	    if (fix_tmp->fx_addsy)
		fix_array[ix++] = fix_tmp;
	qsort(fix_array, ix, sizeof(fixS*), c_compare_fix);
    }

    for (ix = 0; ix < nfix; ix++) {
	fixP = fix_array[ix];
	symbolP = fixP->fx_addsy;
#else /* SORT_RELOCATIONS */
    for ( ; fixP;  fixP = fixP->fx_next) {
	if (symbolP = fixP->fx_addsy) {
#endif /* SORT_RELOCATIONS */
#if defined(PROCESSOR_68000)
	    ri.r_type = (fixP->fx_pcrel ? 
			 ( fixP->fx_size == 1 ? R_PCRBYTE :
			  fixP->fx_size == 2 ? R_PCRWORD :
			  R_PCRLONG):
			 ( fixP->fx_size == 1 ? R_RELBYTE :
			  fixP->fx_size == 2 ? R_RELWORD :
			  R_RELLONG));
#elif defined(PROCESSOR_i386)
	    /* !!!! R_OFF8 & R_DIR16 are a vague guess, completly unested. */
	    ri.r_type = (fixP->fx_pcrel ? 
			 ( fixP->fx_size == 1 ? R_PCRBYTE :
			  fixP->fx_size == 2 ? R_PCRWORD :
			  R_PCRLONG):
			 ( fixP->fx_size == 1 ? R_OFF8 :
			  fixP->fx_size == 2 ? R_DIR16 :
			  R_DIR32));
#else
	    you lose
#endif /* PROCESSOR_68000 || PROCESSOR_i386 */
		ri.r_vaddr = fixP->fx_frag->fr_address + fixP->fx_where;
	    /* If symbol associated to relocation entry is a bss symbol 
	       or undefined symbol just remember the index of the symbol.
	       Otherwise store the index of the symbol describing the 
	       section the symbol belong to. This heuristic speeds up ld.
	       */
	    /* Local symbols can generate relocation information. In case
	       of structure return for instance. But they have no symbol
	       number because they won't be emitted in the final object.
	       In the case where they are in the BSS section, this leads
	       to an incorrect r_symndx.
	       Under bsd the loader do not care if the symbol reference is
	       incorrect. But the SYS V ld complains about this. To avoid
	       this we associate the symbol to the associated section, 
	       *even* if it is the BSS section. */
	    /* If someone can tell me why the other symbols of the bss 
	       section are not associated with the .bss section entry, 
	       I'd be gratefull. I guess that it has to do with the special
	       nature of the .bss section. Or maybe this is because the 
	       bss symbols are declared in the common section and can
	       be resized later. Can it break code some where ? */
	    ri.r_symndx =
	S_GET_SEGMENT(symbolP) == C_TEXT_SECTION ? dot_text_symbol->sy_number :
	S_GET_SEGMENT(symbolP) == C_DATA_SECTION ? dot_data_symbol->sy_number :
	       (SF_GET_LOCAL(symbolP) ? dot_bss_symbol->sy_number :
		symbolP->sy_number); /* bss or undefined */
	    
	    append (&next_object_file_charP,
		    (char *)& ri,
		    (unsigned long)RELSZ);
#ifndef SORT_RELOCATIONS
	}
#endif /* SORT_RELOCATIONS */
    }
}

#ifdef SORT_RELOCATIONS
static int
c_compare_fix(fixP_first, fixP_second)
register fixS** fixP_first;
register fixS** fixP_second;
{
    register unsigned long first = (*fixP_first)->fx_frag->fr_address +
	(*fixP_first)->fx_where;
    register unsigned long second = (*fixP_second)->fx_frag->fr_address +
	(*fixP_second)->fx_where;
    return first < second ? -1 : first > second ? 1 : 0;
}
#endif /* SORT_RELOCATIONS */

/* Coff file generation & utilities */

/* Convert a lvalue to machine dependent data */
#define MD(s,v)   \
  md_number_to_chars((char *)&(s)->v,(s)->v, sizeof((s)->v))

void
c_header_append(aouthdr, filehdr, where)
AOUTHDR*	aouthdr;
FILHDR*		filehdr;
char**		where;
{
    /* Eventually swap bytes for cross compilation for file header */
    MD(filehdr, f_magic);
    MD(filehdr, f_nscns);
    MD(filehdr, f_timdat);
    MD(filehdr, f_symptr);
    MD(filehdr, f_nsyms);
    MD(filehdr, f_opthdr);
    MD(filehdr, f_flags);
    append(where, (char *)filehdr, FILHSZ);

#ifndef NO_OPTIONAL_HEADER
    /* Eventually swap bytes for cross compilation for a.out header */
    MD(aouthdr, magic);
    MD(aouthdr, vstamp);
    MD(aouthdr, tsize);
    MD(aouthdr, dsize);
    MD(aouthdr, bsize);
    MD(aouthdr, entry);
    MD(aouthdr, text_start);
    MD(aouthdr, data_start);
    append(where, (char *)aouthdr, sizeof(struct aouthdr));
#endif /* NO_OPTIONAL_HEADER */
}

/*
 * Beware ! If you cross compile to another ENDIAN machine,
 * the symbol table values will not be valid any more.
 */

void
c_symbol_append(symbolP, where)
symbolS *	symbolP;
char**		where;
{
    SYMENT			*syment	= &symbolP->sy_symbol;
    char	  		numaux	= syment->n_numaux;
    register AUXENT*		auxP	= &symbolP->sy_auxent;
    register unsigned short	type 	= S_GET_DATA_TYPE(symbolP);

    MD(syment, n_value);
    MD(syment, n_scnum);
    MD(syment, n_type);
    MD(syment, n_sclass);
    MD(syment, n_numaux);
    append(where, (char *)syment, SYMESZ);

    /* Should do the following : if(.file entry) MD(..)... else
       if(static entry) MD(..)
     */
    if(numaux == 1) {
#if 0 /* This code has never been tested */
	/* The most common case, x_sym entry. */
	if((SF_GET(symbolP) & (SF_FILE | SF_STATICS)) == 0) {
	    MD(auxP, x_sym.x_tagndx);
	    if(ISFCN(type))
		MD(auxP, x_sym.x_misc.x_fsize);
	    else {
		MD(auxP, x_sym.x_misc.x_lnno);
		MD(auxP, x_sym.x_misc.x_size);
	    }
	    if(ISARY(type)) {
		register int index;
		for(index = 0; index < DIMNUM; index++)
		    MD(auxP, x_sym.x_fcnary.x_ary.x_dimen[index]);
	    } else {
		MD(auxP, x_sym.x_fcnary.x_fcn.x_lnnoptr);
		MD(auxP, x_sym.x_fcnary.x_fcn.x_endndx);
	    }
	    MD(auxP, x_sym.x_tvndx);
	} else if(SF_GET_FILE(symbolP))	/* .file */
	    ;
	else if(SF_GET_STATICS(symbolP)) { /* .text, .data, .bss symbols */
	    MD(auxP, x_scn.x_scnlen);
	    MD(auxP, x_scn.x_nreloc);
	    MD(auxP, x_scn.x_nlinno);
	}
#endif /* 0 */
	append(where, (char *)auxP, AUXESZ);
    } else if(numaux > 0)
	as_warn("more than one auxent for symbol");
    
    return;
}

void
c_section_header_append(header, where)
SCNHDR*		header;
char**		where;
{
    MD(header, s_paddr);
    MD(header, s_vaddr);
    MD(header, s_size);
    MD(header, s_scnptr);
    MD(header, s_relptr);
    MD(header, s_lnnoptr);
    MD(header, s_nreloc);
    MD(header, s_nlnno);
    MD(header, s_flags);
    append(where, (char *)header, SCNHSZ);

    return;
}


void emit_symbols(symbol_rootP, where)
symbolS *	symbol_rootP;
char**		where;
{
    symbolS *	symbolP;
    /*
     * Emit all symbols left in the symbol chain.
     */
    for(symbolP = symbol_rootP; symbolP; symbolP = symbolP -> sy_next) {
	/* Used to save the offset of the name. It is used to point
	   to the string in memory but must be a file offset. */
	register char *	temp;

	temp = S_GET_NAME(symbolP);
	if (SF_GET_STRING(symbolP)) {
	    S_SET_OFFSET(symbolP, symbolP->sy_name_offset);
	    S_SET_ZEROES(symbolP, 0);
	} else {
	    memset(symbolP->sy_name, '\0', SYMNMLEN);
	    strncpy(symbolP->sy_name, temp, SYMNMLEN);
	}
	SYMBOL_OUTPUT(symbolP, where);
	S_SET_NAME(symbolP,temp);
    }
}

/* Merge a debug symbol containing debug information into a normal
   symbol. */

void
c_symbol_merge(debug, normal)
symbolS* debug;
symbolS* normal;
{
    S_SET_DATA_TYPE(normal, S_GET_DATA_TYPE(debug));
    S_SET_STORAGE_CLASS(normal, S_GET_STORAGE_CLASS(debug));
    S_SET_NUMBER_AUXILIARY(normal, S_GET_NUMBER_AUXILIARY(debug));
    /* Move all the auxiliary information */
    if(S_GET_NUMBER_AUXILIARY(debug))
	memcpy((char*)&normal->sy_auxent, (char*)&debug->sy_auxent,
	       AUXESZ);
    /* Move the debug flags. */
    SF_SET_DEBUG_FIELD(normal, SF_GET_DEBUG_FIELD(debug));
}

c_dot_file_symbol(filename)
char*	filename;
{
    symbolS* symbolP;
    
    symbolP = symbol_new(".file", SEG_DEBUG, 0,
			       C_FILE, &zero_address_frag);
    S_SET_NUMBER_AUXILIARY(symbolP, 1);
    SA_SET_FILE_FNAME(symbolP, filename);
    SF_SET_DEBUG(symbolP);

    /* Make sure that the symbol is first on the symbol chain */
    if(symbol_rootP != symbolP) {
	symbol_lastP = symbol_lastP->sy_previous;
	DL_REMOVE(symbolP);
	DL_INSERT(symbolP, symbol_rootP);
	symbol_rootP = symbolP;
    }
}
/* 
 * Build a 'section static' symbol.
 */

char* 
c_section_symbol(name, value, length, nreloc, nlnno)
char* name;
long value;
long length;
unsigned short nreloc;
unsigned short nlnno;
{
    symbolS*	symbolP;

    symbolP = symbol_new(name,
			       (name[1] == 't' ? SEG_TEXT : 
				name[1] == 'd' ? SEG_DATA :
			                         SEG_BSS),
			       value,
			       C_STAT,
			       &zero_address_frag);

    S_SET_NUMBER_AUXILIARY(symbolP, 1);

    SA_SET_SCN_SCNLEN(symbolP, length);
    SA_SET_SCN_NRELOC(symbolP, nreloc);
    SA_SET_SCN_NLINNO(symbolP, nlnno);

    SF_SET_STATICS(symbolP);

    return (char*)symbolP;
}

void
c_section_header(header, name, core_address, size,
		 data_ptr, reloc_ptr, lineno_ptr,
		 reloc_number, lineno_number)
SCNHDR*			header;
char*			name;
long			core_address;
long			size;
long			data_ptr;
long			reloc_ptr;
long			lineno_ptr;
long			reloc_number;
long			lineno_number;
{
    strncpy(header->s_name, name, 8);
    header->s_paddr = header->s_vaddr = core_address;
    header->s_size = size;
    header->s_scnptr = data_ptr;
    header->s_relptr = reloc_ptr;
    header->s_lnnoptr = lineno_ptr;
    header->s_nreloc = reloc_number;
    header->s_nlnno = lineno_number;
    header->s_flags = STYP_REG | ( name[1] == 't' ? STYP_TEXT :
	                           name[1] == 'd' ? STYP_DATA :
#ifdef STYP_INFO
				   name[1] == 'b' ? STYP_BSS : STYP_INFO 
#else /* STYP_INFO */
				   STYP_BSS
#endif /* STYP_INFO */
				);
    return ;
}

/* Line number handling */

int text_lineno_number = 0;
lineno* lineno_rootP = (lineno*)0;
lineno* lineno_lastP = (lineno*)0;

lineno*
c_line_new(paddr, line_number, frag)
long paddr;
unsigned short line_number;
fragS* frag;
{
    lineno* new_line = (lineno*)xmalloc(sizeof(lineno));

    new_line->line.l_addr.l_paddr = paddr;
    new_line->line.l_lnno = line_number;
    new_line->frag = (char*)frag;
    new_line->next = (lineno*)0;

    if(lineno_rootP == (lineno*)0)
	lineno_rootP = new_line;
    else 
	lineno_lastP->next = new_line;
    lineno_lastP = new_line;
}

void
emit_lineno(line, where)
lineno* line;
char** where;
{
    register LINENO* line_entry;

    for(;line;line = line->next) {
	line_entry = &line->line;
	/* No matter which member of the union we process, they are
	   both long. */
	MD(line_entry, l_addr.l_paddr);
	MD(line_entry, l_lnno);
	append(where, (char *)line_entry, LINESZ);
    }
    return ;
}
