.TH fgrep "" "Extension" Command
fgrep \- search a file for a character string
.PP
.B "fgrep [options] string [file ...]"
.PP
.I Fgrep
(fast
.I grep)
searches files for a character string and prints all lines that
contain that string.
.I Fgrep
is different from
.I grep
and
.I egrep
because it searches for a string, instead of searching for a pattern
that matches an expression. It uses a fast and compact algorithm.
.PP
The characters $, *, [, ^, |, (, ), and \\ are interpreted literally by
.I fgrep
, that is,
.I fgrep
does not recognize full regular expressions as does
.I egrep.
Since these characters have special meaning to the shell, it is
safest to enclose the entire
.I string
in single quotes '...'.
.PP
If no files are specified,
.I fgrep
assumes standard input. Normally, each line found is copied
to the standard output. The file name is printed before each
line found if there is more than one input file.
.PP
Command line options are:
.PP
.DS
\-c	Print only a count of the lines that contain the
	pattern.
\-y	Convert lower case characters in file to upper case
	during comparisons.
\-l	Print the names of files whith matching lines once,
	serarated by new\-lines. Does not repeat the names of
	files when the pattern is found more than once.
\-n	Precede each line by its line number in the file
	(first line is 1).
\-v	Print all lines expect those that contain the pattern.
\-x	Print only lines matched entirely.
\-h	Do not print names of files.
\-p	Precede each line by the pattern match.
\-s	Do not output anything, return only the exit status.
\-e \fIspecial string\fR
	Search for a \fIspecial string \fR (\fIstring\fR begins with a \-).
\-f \fIfile\fR
	Take the list of \fIstrings\fR from \fIfile\fR.
.DE
.SH "See also"
.PP
ed, egrep, grep, sed, sh
.SH Diagnostics
.PP
Exit status is 0 if any matches are found, 1 if none, 2 for
syntax errors or inaccessible files (even if matches were
found).
.SH Bugs
.PP
Ideally there should be only one
.I grep
command, but there is not a single algorithm that spans a wide
enough range of space\-time tradeoffs. Lines are limited to
256 characters; longer lines are truncated.
