/*
** dired.h - miscellaneous global declarations and defines
**
** dired.h 1.33   Delta'd: 14:56:17 2/28/92   Mike Lijewski, CNSF
**
** Copyright (c) 1991 Cornell University
** All rights reserved.
**
** Redistribution and use in source and binary forms are permitted
** provided that: (1) source distributions retain this entire copyright
** notice and comment, and (2) distributions including binaries display
** the following acknowledgement:  ``This product includes software
** developed by Cornell University'' in the documentation or other
** materials provided with the distribution and in all advertising
** materials mentioning features or use of this software. Neither the
** name of the University nor the names of its contributors may be used
** to endorse or promote products derived from this software without
** specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef __DIRED_H
#define __DIRED_H


#include <stdio.h>
#include <string.h>
#include "classes.h"

/*
** Our directory stack.  Initialized in main() and used in
** read_commands() when calling dired() and when popping directories
** off the stack when 'q' is typed.
*/
extern DirStack *dir_stack;

/*
** commands to get long listing
*/
extern const char *const ls_cmd[4];

/*
** The four ways we sort the listing.  These must have the values
** 0, 1, 2, 3, respectively, which they should if your compiler isn't
** busted.
*/
enum sort_order { ALPHABETICALLY,
                  MODIFICATION_TIME,
                  ACCESS_TIME,
                  INODE_CHANGE_TIME
                 };

/*
** How listings are sorted.  This variable is controlled by a few inline
** functions defined in this file, dired.h.
*/
extern sort_order how_to_sort;

/*
** modeline prefix
*/
extern const char *const modeline_prefix;

/*
** our version number for `V' command
*/
extern const char *const version;

/*
** variables for HELP
*/
extern const char *const help_file[];
extern const int   HELP_FILE_DIM;
extern const char *const HELP_MSG[];

/*
** variable set when window size has changed - defined in utilities.C
*/
extern int win_size_changed;

//
// for POSIX compatibility
//
#ifndef EXIT_FAILURE
#define EXIT_FAILURE 1
#endif
#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS 1
#endif

/*
** all of the external functions defined by dired
*/

//
// externs from `commands.C'
//
extern void read_commands(DirList *);

//
// externs from `dired.C'
//
extern void dired(char *);

//
// externs from `utilities.C'
//
extern void     cleanup(int);
extern void     display_string(const char *str, size_t len = 0); 
extern void     error(const char *format, ...);
extern void     exec_command(char *cmd, int prompt = 1);
extern char    *expand_tilde(char *str);
extern char    *fgetline(FILE *fp);
extern char    *get_current_directory();
extern DirList *get_directory_listing(char *dirname);
extern char    *get_file_name(DirList *list);
extern int      get_key(DirList *dl);
extern int      goal_column(DirList *l);
extern void     initialize();
extern void     initial_listing(DirList *dl);
extern int      is_directory(const char *dir);
extern int      is_regular_file(const char *file);
extern void     leftshift_current_line(DirList *dl);
extern int      lines_displayed(DirList *dl);
extern void     message(const char *msg);
extern char    *prompt(const char *msg);
extern int      read_and_exec_perm(const char *dir);
extern void     redisplay();
extern void     rightshift_current_line(DirList *dl);
extern void     set_signals();
#ifdef NO_STRCHR
extern char    *strchr(const char *s, char charwanted);
extern char    *strrchr(const char *s, char charwanted);
#endif /* NO_STRCHR */
#ifdef NO_STRSTR
extern char    *strstr(const char *, const char *);
#endif /* NO_STRSTR */
extern void     update_modeline(const char *head_string, const char *tail_string);
extern void     unset_signals();
extern void     winch(int);

//
// INLINES
//

/*
** max - the maximum of two integer arguments.
*/
inline int max(int x, int y)
{
    return x >= y ? x : y;
}

/*
** set_sort_order - sets the sorting order.
*/
inline void set_sort_order(sort_order order)
{
    how_to_sort = order;
}

/*
** the_sort_order - returns the sorting order, the current value
** of how_to_sort.
*/
inline sort_order the_sort_order(void)
{
  return how_to_sort;
}

//
// On my RS/6000, running Cfront 2.1, I need this stuff
// Too bad they can't get their header files cleaned up.
//
#ifdef _IBMR2
extern "C" {
    extern int   symlink(const char *, const char *);
    extern int   isatty(int);
    extern char *getcwd(char *, size_t);
    extern char *getenv(const char *);
    extern int   putenv(const char *);
}
#endif

//
// a number of g++ implementation seem not to have this defined
//
#if defined(__GNUG__) && !defined(NO_STRSTR)
extern "C" {
	extern char *strstr(const char *, const char *);
}
#endif

#endif /* __DIRED_H */
