.tr ||
.TH terminfo 8/16/82
.SH NAME
.PP
terminfo \- terminal capability data base
.SH SYNOPSIS
.PP
/usr/lib/terminfo
.SH DESCRIPTION
.PP
.I Terminfo
is a data base describing terminals.
It is used, for example, by
.I vi
and
.I curses.
Terminals are described in
.I terminfo
by giving a set of capabilities which they have and by describing
how operations are performed.
Padding requirements and initialization sequences
are included in
.I terminfo.
.PP
Entries in
.I terminfo
consist of a number of comma-separated fields.
White space after each comma is ignored.
The first entry for each terminal gives the names which are known for the
terminal, separated by `|' characters.
The first name given is the most common abbreviation for the terminal,
the last name given should be a long name fully identifying the terminal,
and all others are understood as synonyms for the terminal name.
All names but the last should be in lower case and contain no blanks;
the last name may well contain upper case and blanks for readability.
.PP
Terminal names (except for the last, verbose entry) should
be chosen using the following conventions.
The particular piece of hardware making up the terminal should
have a root name chosen, thus ``hp2621''.
This name should not contain hyphens, except that synonyms may
be chosen that do not conflict with other names.
Modes that the hardware can be in, or user preferences, should
be indicated by appending a hyphen and an indicator of the mode.
Thus, a vt100 in 132 column mode would be vt100-w.
The following suffixes should be used where possible:
.LP
.nf
.ta 1i 5i
\fBSuffix	Meaning	Example\fP
-w	Wide mode (more than 80 columns)	vt100-w
-am	With auto. margins (usually default)	vt100-am
-nam	Without automatic margins	vt100-nam
-\fIn\fP	Number of lines on the screen	aaa-60
-na	No arrow keys (leave them in local)	c100-na
-\fIn\fPp	Number of pages of memory	c100-4p
-rv	Reverse video	c100-rv
.fi
.SH CAPABILITIES
.PP
The variable is the name by which the programmer (at the terminfo level)
accesses the capability.
The capname is the short name used in the text of the database,
and is used by a person updating the database.
.PP
Capability names have no hard length limit, but an informal limit of 5
characters has been adopted to keep them short.
Whenever possible, names are chosen to be the same as or similar to
the ANSI X3.64-1979 standard.  Semantics are also intended to match
those of the specification.
.LP
.nf
(P)	indicates padding may be specified
(G)	indicates that the string is passed through tparm with
	parms as given (#\fIi\fP).
(*)	indicates that padding may be based on the number of
	lines affected
(#\fIi\fP)	indicates the \fIi\fPth parameter.

.ta \w'enter_alt_charset_mode  'u +\w'Capname  'u
\fBVariable	Capname	Description\fR
.I Booleans:
auto_left_margin,	bw	cub1 wraps from column 0 to last column
auto_right_margin,	am	Terminal has automatic margins
beehive_glitch,	xsb	Beehive (f1=escape, f2=ctrl C)
ceol_standout_glitch,	xhp	Standout not erased by overwriting (hp)
eat_newline_glitch,	xenl	newline ignored after 80 cols (Concept)
erase_overstrike,	eo	Can erase overstrikes with a blank
generic_type,	gn	Generic line type (e.g. dialup, switch).
hard_copy,	hc	Hardcopy terminal
has_meta_key,	km	Has a meta key (shift, sets parity bit)
has_status_line,	hs	Has extra ``status line''
insert_null_glitch,	in	Insert mode distinguishes nulls
memory_above,	da	Display may be retained above the screen
memory_below,	db	Display may be retained below the screen
move_insert_mode,	mir	Safe to move while in insert mode
move_standout_mode,	msgr	Safe to move in standout modes
over_strike,	os	Terminal overstrikes
status_line_esc_ok,	eslok	Escape can be used on the status line
teleray_glitch,	xt	Tabs destructive, magic so char (Teleray 1061)
tilde_glitch,	hz	Hazeltine; can't print ~'s
transparent_underline,	ul	underline character overstrikes
xon_xoff,	xon	Terminal uses xon/xoff handshaking

.I Numbers:
columns,	cols	Number of columns in a line
init_tabs,	it	Tabs initially every # spaces
lines,	lines	Number of lines on screen or page
lines_of_memory,	lm	Lines of memory if > lines.  0 means varies
magic_cookie_glitch,	xmc	Number of blank chars left by smso or rmso
padding_baud_rate,	pb	Lowest baud rate where cr/nl padding is needed
virtual_terminal,	vt	Virtual terminal number (CB/Unix)
width_status_line,	wsl	No. columns in status line

.I Strings:
back_tab,	cbt	Back tab (P)
bell,	bel	Audible signal (bell) (P)
carriage_return,	cr	Carriage return (P*)
change_scroll_region,	csr	change to lines #1 through #2 (vt100) (PG)
clear_all_tabs,	tbc	Clear all tab stops. (P)
clear_screen,	clear	Clear screen (P*)
clr_eol,	el	Clear to end of line (P)
clr_eos,	ed	Clear to end of display (P*)
column_address,	hpa	Set cursor column (PG)
command_character,	CC	Term. settable cmd char in prototype
cursor_address,	cup	Screen relative cursor motion to row #1 col #2 (PG)
cursor_down,	cud1	Down one line
cursor_home,	home	Home cursor (if no cup)
cursor_invisible,	civis	Make cursor invisible
cursor_left,	cub1	Move cursor left one space.
cursor_mem_address,	mrcup	Memory relative cursor addressing
cursor_normal,	cnorm	Make cursor appear normal (undo vs/vi)
cursor_right,	cuf1	Non-destructive space (cursor right)
cursor_to_ll,	ll	Last line, first column (if no cup)
cursor_up,	cuu1	Upline (cursor up)
cursor_visible,	cvvis	Make cursor very visible
delete_character,	dch1	Delete character (P*)
delete_line,	dl1	Delete line (P*)
dis_status_line,	dsl	Disable status line
down_half_line,	hd	Half-line down (forward 1/2 linefeed)
enter_alt_charset_mode,	smacs	Start alternate character set (P)
enter_blink_mode,	blink	Turn on blinking
enter_bold_mode,	bold	Turn on bold (extra bright) mode
enter_ca_mode,	smcup	String to begin programs that use cup
enter_delete_mode,	smdc	Delete mode (enter)
enter_dim_mode,	dim	Turn on half-bright mode
enter_insert_mode,	smir	Insert mode (enter);
enter_protected_mode,	prot	Turn on protected mode
enter_reverse_mode,	rev	Turn on reverse video mode
enter_secure_mode,	invis	Turn on blank mode (chars invisible)
enter_standout_mode,	smso	Begin stand out mode
enter_underline_mode,	smul	Start underscore mode
erase_chars	ech	Erase #1 characters (PG)
exit_alt_charset_mode,	rmacs	End alternate character set (P)
exit_attribute_mode,	sgr0	Turn off all attributes
exit_ca_mode,	rmcup	String to end programs that use cup
exit_delete_mode,	rmdc	End delete mode
exit_insert_mode,	rmir	End insert mode
exit_standout_mode,	rmso	End stand out mode
exit_underline_mode,	rmul	End underscore mode
flash_screen,	flash	Visible bell (may not move cursor)
form_feed,	ff	Hardcopy terminal page eject (P*)
from_status_line,	fsl	Return from status line
init_1string,	is1	Terminal initialization string
init_2string,	is2	Terminal initialization string
init_3string,	is3	Terminal initialization string
init_file,	if	Name of file containing is
insert_character,	ich1	Insert character (P)
insert_line,	il1	Add new blank line (P*)
insert_padding,	ip	Insert pad after character inserted (P*)
key_backspace,	kbs	Sent by backspace key
key_catab,	ktbc	Sent by clear-all-tabs key.
key_clear,	kclr	Sent by clear screen or erase key.
key_ctab,	kctab	Sent by clear-tab key
key_dc,	kdch1	Sent by delete character key.
key_dl,	kdl1	Sent by delete line key.
key_down,	kcud1	Sent by terminal down arrow key
key_eic,	krmir	Sent by rmir or smir in insert mode.
key_eol,	kel	Sent by clear-to-end-of-line key.
key_eos,	ked	Sent by clear-to-end-of-screen key.
key_f0,	kf0	Sent by function key f0.
key_f1,	kf1	Sent by function key f1.
key_f10,	kf10	Sent by function key f10.
key_f2,	kf2	Sent by function key f2.
key_f3,	kf3	Sent by function key f3.
key_f4,	kf4	Sent by function key f4.
key_f5,	kf5	Sent by function key f5.
key_f6,	kf6	Sent by function key f6.
key_f7,	kf7	Sent by function key f7.
key_f8,	kf8	Sent by function key f8.
key_f9,	kf9	Sent by function key f9.
key_home,	khome	Sent by home key.
key_ic,	kich1	Sent by ins char/enter ins mode key.
key_il,	kil1	Sent by insert line.
key_left,	kcub1	Sent by terminal left arrow key.
key_ll,	kll	Sent by home down key.
key_npage,	knp	Sent by next-page key.
key_ppage,	kpp	Sent by previous-page key.
key_right,	kcuf1	Sent by terminal right arrow key.
key_sf,	kind	Sent by scroll-forward/down key.
key_sr,	kri	Sent by scroll-backward/up key.
key_stab,	khts	Sent by set-tab key.
key_up,	kcuu1	Sent by terminal up arrow key.
keypad_local,	rmkx	Out of "keypad transmit" mode.
keypad_xmit,	smkx	Put terminal in "keypad transmit" mode.
label_f0,	lf0	Labels on function key f0 if not f0
label_f1,	lf1	Labels on function key f1 if not f1
label_f10,	lf10	Labels on function key f10 if not f10
label_f2,	lf2	Labels on function key f2 if not f2
label_f3,	lf3	Labels on function key f3 if not f3
label_f4,	lf4	Labels on function key f4 if not f4
label_f5,	lf5	Labels on function key f5 if not f5
label_f6,	lf6	Labels on function key f6 if not f6
label_f7,	lf7	Labels on function key f7 if not f7
label_f8,	lf8	Labels on function key f8 if not f8
label_f9,	lf9	Labels on function key f9 if not f9
meta_on,	smm	Turn on "meta mode" (8th bit)
meta_off,	rmm	Turn off "meta mode"
newline,	nel	Newline (behaves like cr followed by lf)
pad_char,	pad	Pad character (rather than null)
parm_dch,	dch	Delete #1 chars (PG*)
parm_delete_line,	dl	Delete #1 lines (PG*)
parm_down_cursor,	cud	Move cursor down #1 lines. (PG*)
parm_ich,	ich	Insert #1 blank chars (PG*)
parm_index,	indn	Scroll forward #1 lines (PG)
parm_insert_line,	il	Add #1 new blank lines (PG*)
parm_left_cursor,	cub	Move cursor left #1 spaces (PG)
parm_right_cursor,	cuf	Move cursor right #1 spaces. (PG*)
parm_rindex,	rin	Scroll backward #1 lines (PG)
parm_up_cursor,	cuu	Move cursor up #1 lines. (PG*)
pkey_key,	pfkey	Prog funct key #1 to type string #2
pkey_local,	pfloc	Prog funct key #1 to execute string #2
pkey_xmit,	pfx	Prog funct key #1 to xmit string #2
print_screen,	mc0	Print contents of the screen
prtr_off,	mc4	Turn off the printer
prtr_on,	mc5	Turn on the printer
repeat_char,	rep	Repeat char #1 #2 times.  (PG*)
reset_1string,	rs1	Reset terminal completely to sane modes.
reset_2string,	rs2	Reset terminal completely to sane modes.
reset_3string,	rs3	Reset terminal completely to sane modes.
reset_file,	rf	Name of file containing reset string.
restore_cursor,	rc	Restore cursor to position of last sc.
row_address,	vpa	Vertical position absolute (set row). (PG)
save_cursor,	sc	Save cursor position. (P)
scroll_forward,	ind	Scroll text up (P)
scroll_reverse,	ri	Scroll text down (P)
set_attributes,	sgr	Define the video attributes (PG9)
set_tab,	hts	Set a tab in all rows, current column.
set_window,	wind	Current window is lines #1-#2 cols #3-#4
tab,	ht	Tab to next 8 space hardware tab stop.
to_status_line,	tsl	Go to status line, column #1
underline_char,	uc	Underscore one char and move past it
up_half_line,	hu	Half-line up (reverse 1/2 linefeed)
.fi
.PP
.B "A Sample Entry"
.PP
The following entry, which describes the Concept\-100, is among the more
complex entries in the
.I terminfo
file as of this writing.
.PP
.nf
.ta .3i
concept100\||\|c100|\|\|concept\||\|c104\||\|c100-4p\||\|concept 100,
	is2=\eEU\eEf\eE7\eE5\eE8\eEl\eENH\eEK\eE\e200\eEo&\e200\eEo\e47\eE,
	cr=^M, cud1=^J, ind=^J, bel=^G, smcup=\eEU\eEv  8p\eEp\er,
	rmcup=\eEv    $<6>\eEp\er\en, il1=\eE^R$<3*>, am, cub1=^H,
	ed=\eE^C$<16*>, el=\eE^U$<16>, clear=^L$<2*>,
	cup=\eEa%p1%' '%+%c%p2%' '%+%c, cols#80, dch1=\eE^A$<16*>,
	dl1=\eE^B$<3*>, rmir=\eE\e200, eo, smir=\eE^P, in, ip=$<16*>,
	lines#24, mir, cuf1=\eE=, ht=\et$<8>, kbs=^h, ul, cuu1=\eE;,
	db, smul=\eEG, rmul=\eEg, xenl, cvvis=\eEW, cnorm=\eEw,
	flash=\eEk$<20>\eEK, pb#9600, vt#8, smul=\eEG, rmul=\eEg,
	smso=\eEE\eED, rmso=\eEd\eEe, dim=\eEE, rev=\eED, blink=\eEC,
	prot=\eEI, invis=\eEH, sgr0=\eEN\e200, rep=\eEr%p1%c%p2%' '%+%c$<.2*>,
	smkx=\eEX, rmkx=\eEx, kcuu1=\eE;, kcud1=\eE<, kcub1=\eE>,
	kcuf1=\eE=, khome=\eE?, kf1=\eE5, kf2=\eE6, kf3=\eE7,
.fi
.PP
Entries may continue onto multiple lines by placing white space at
the beginning of each line except the first.
Comments may be included on lines beginning with ``#''.
Capabilities in
.I terminfo
are of three types:
Boolean capabilities which indicate that the terminal has
some particular feature, numeric capabilities giving the size of the terminal
or the size of particular delays, and string
capabilities, which give a sequence which can be used to perform particular
terminal operations.
.PP
.B "Types of Capabilities"
.PP
All capabilities have short codes.  For instance, the fact that
the Concept has \*(lqautomatic margins\*(rq (i.e. an automatic return and linefeed
when the end of a line is reached) is indicated by the capability \fBam\fR.
Hence the description of the Concept includes \fBam\fR.
Numeric capabilities are followed by the character `#' and then the value.
Thus \fBcols\fR which indicates the number of columns the terminal has
gives the value `80' for the Concept.
.PP
Finally, string valued capabilities, such as \fBel\fR (clear to end of line
sequence) are given by the two character code, an `=', and then a string
ending at the next following `,'.  A delay in milliseconds may appear
anywhere in such a capability, enclosed in $<..> brackets,
as in \fBel\fP=\eEK$<3>,
and padding characters are supplied by
.I tputs
to provide this delay.
The delay can be either a number, e.g. `20', or a number followed by
an `*', i.e. `3*'.  A `*' indicates that the padding required is proportional
to the number of lines affected by the operation, and the amount given is
the per-affected-unit padding required.
(In the case of insert character, the factor is still the number of
.I lines
affected.
This is always one unless the terminal has \fBxenl\fP and the software uses it.)
When a `*' is specified, it is sometimes useful to give a delay of the form
`3.5' to specify a delay per unit to tenths of milliseconds.
(Only one decimal place is allowed.)
.PP
A number of escape sequences are provided in the string valued capabilities
for easy encoding of characters there.  A \fB\eE\fR (or \fB\ee\fP)
maps to an ESCAPE
character, \fB^x\fR maps to a control-x for any appropriate x, and the sequences
\fB\en \er \et \eb \ef \es\fR give a newline,
return, tab, backspace, formfeed and space, respectively.
Finally, characters may be given as three octal digits after a \fB\e\fR,
and the characters \fB^\fR, \fB\e\fR and comma may be given
as \fB\e^\fR, \fB\e\e\fR and \fB\e,\fR.
.PP
For convenience when testing entries, individual capabilities may be easily
commented out by directly preceding the name of the capability by a period.
Thus the entry
.DT
.nf
	33\||\|tty33\||\|tty\||\|model 33 teletype,
		cr=^M, cud1=^J, .ind=^J, bel=^G, cols#72, hc, os,
.fi
.ad
is equivalent to the entry
.DT
.nf
	33\||\|tty33\||\|tty\||\|model 33 teletype,
		cr=^M, cud1=^J, bel=^G, cols#72, hc, os,
.fi
.ad
the \fBind\fP capability having been 'commented out'.
.br
.ne 5
.PP
.B "Preparing Descriptions"
.PP
We now outline how to prepare descriptions of terminals.
The most effective way to prepare a terminal description is by imitating
the description of a similar terminal in
.I terminfo
and to build up a description gradually, using partial descriptions
with
.I vi
to check that they are correct.
Be aware that a very unusual terminal may expose deficiencies in
the ability of the
.I terminfo
file to describe it
or bugs in
.I vi.
To easily test a new terminal description you can set the environment variable
TERMINFO to a pathname of a file containing the description you are working
on and the editor will look there rather than in
.I /usr/lib/terminfo.
To get the padding for insert line right (if the terminal manufacturer
did not document it) a severe test is to edit /etc/passwd at 9600 baud,
delete 16 or so lines from the middle of the screen, then hit the `u'
key several times quickly.
If the terminal messes up, more padding is usually needed.
A similar test can be used for insert character.
.PP
.B "Basic capabilities"
.PP
The number of columns on each line for the terminal is given by the
\fBcols\fR numeric capability.  If the terminal is a CRT, then the
number of lines on the screen is given by the \fBlines\fR capability.
If the terminal wraps around to the beginning of the next line when
it reaches the right margin, then it should have the \fBam\fR capability.
If the terminal can clear its screen, then this is given by the
\fBclear\fR string capability.
If the terminal overstrikes
(rather than clearing a position when a character is struck over)
then it should have the \fBos\fR capability.
If the terminal is a printing terminal, with no soft copy unit,
give it both
.B hc
and
.BR os .
.RB ( os
applies to storage scope terminals, such as Tektronix 4010
series, as well as hard copy and APL terminals.)
If there is a code to move the cursor to the left edge of the current
row, give this as
.BR cr .
(Normally this will be carriage return, control M.)
If there is a code to produce an audible signal (bell, beep, etc)
give this as
.BR bel .
.PP
If there is a code to move the cursor one position to the left
(such as backspace) that capability should be given as
.BR cub1 .
Similarly, codes to move forward, up, and down should be
given as
.BR cuf1 ,
.BR cuu1 ,
and
.BR cud1 .
These local cursor motions should not alter the text they pass over,
for example, you would not normally use `\fBcuf1\fP=\es' because the
space would erase the character moved over.
.PP
A very important point here is that the local cursor motions encoded
in
.I terminfo
are undefined at the left and top edges of a CRT terminal.
Programs should never attempt to backspace around the left edge,
unless
.B bw
is given,
and never attempt to go up locally off the top.
In order to scroll text up, a program will go to the bottom of the screen
and send the
.B ind
(index) string.
.PP
To scroll text down, a program goes to the top of the screen and sends the
.B ri
(reverse index) string.
The strings
.B ind
and
.B ri
are undefined when not on their respective edges of the screen.
.PP
The \fBam\fR capability tells whether the cursor sticks at the right
edge of the screen when text is output, but this does not necessarily
apply to a
.B cuf1
from the last column.
The only local motion which is defined from the left edge is if
.B bw
is given, then a
.B cub1
from the left edge will move to the right edge of the previous row.
If
.B bw
is not given, the effect is undefined.
This is useful for drawing a box around the edge of the screen, for example.
If the terminal has switch selectable automatic margins,
the
.I terminfo
file usually assumes that this is on, i.e. \fBam\fR.
If the terminal has a command which moves to the first column of the next
line, that command can be given as
.B nel
(newline).
It does not matter if the command clears the remainder of the current line,
so if the terminal has no
.B cr
and
.B lf
it may still be possible to craft a working
.B nel
out of one or both of them.
.PP
These capabilities suffice to describe hardcopy and \*(lqglass-tty\*(rq terminals.
Thus the model 33 teletype is described as
.PP
.DT
.nf
	33\||\|tty33\||\|tty\||\|model 33 teletype,
		cr=^M, cud1=^J, ind=^J, bel=^G, cols#72, hc, os,
.PP
while the Lear Siegler ADM\-3 is described as
.PP
.DT
.nf
	adm3\||\|3\||\|lsi adm3,
		cr=^M, cud1=^J, ind=^J, bel=^G,
		am, cub1=^H, clear=^Z, lines#24, cols#80,
.fi
.PP
.B "Parameterized Strings"
.PP
Cursor addressing and other strings requiring parameters
in the terminal are described by a
parameterized string capability, with 
.I printf
like escapes \fB%x\fR in it.
For example, to address the cursor, the
.B cup
capability is given, using two parameters:
the row and column to address to.
(Rows and columns are numbered from zero and refer to the
physical screen visible to the user, not to any unseen memory.)
If the terminal has memory relative cursor addressing,
that can be indicated by
.BR mrcup .
.PP
The parameter mechanism uses a stack and special \fB%\fP codes
to manipulate it.  Typically a sequence will push one of the
parameters onto the stack and then print it in some format.
Often more complex operations are necessary.
.PP
The \fB%\fR encodings have the following meanings:
.PP
.DT
.nf
.ta .5i 1.5i
	%%	outputs `%'
	%d	print pop() as in printf
	%2d	print pop() like %2d
	%02d	print pop() like %02d
	%3d	print pop() like %3d
	%03d	print pop() like %03d
	%c	print pop() like %c
	%s	print pop() like %s

	%p[1-9]	push ith parm
	%P[a-z]	set variable [a-z] to pop()
	%g[a-z]	get variable [a-z] and push it
	%'c'	char constant c
	%{nn}	integer constant nn

	%+ %- %* %/ %m
		arithmetic (%m is mod): push(pop() op pop())
	%& %| %^	bit operations: push(pop() op pop())
	%= %> %<	logical operations: push(pop() op pop())
	%! %~	unary operations push(op pop())
	%i	add 1 to first two parms (for ANSI terminals)

	%? expr %t thenpart %e elsepart %;
		if-then-else, %e elsepart is optional.
		else-if's are possible ala Algol 68:
		%? c1 %t %e c2 %t %e c3 %t %e c4 %t %e %;
.fi
.PP
It should be noted that the binary operators above (e.g. %+, %-, %m, etc.)
all work in the usual fashion, i.e.
.ce
%gx %gy %m
yields \fBx mod y\fR not \fBy mod x\fR.
.PP
Consider the HP2645, which, to get to row 3 and column 12, needs
to be sent \eE&a12c03Y padded for 6 milliseconds.  Note that the order
of the rows and columns is inverted here, and that the row and column
are printed as two digits.
Thus its \fBcup\fR capability is \*(lqcup=\eE&%p2%2dc%p1%2dY$<6>\*(rq.
.PP
The Microterm ACT-IV needs the current row and column sent
preceded by a \fB^T\fR, with the row and column simply encoded in binary,
\*(lqcup=^T%p1%c%p2%c\*(rq.
Terminals which use \*(lq%c\*(rq need to be able to
backspace the cursor (\fBcub1\fR),
and to move the cursor up one line on the screen (\fBcuu1\fR).
This is necessary because it is not always safe to transmit \fB\en\fR,
\fB^D\fR and \fB\er\fR, as the system may change or discard them.
(The library routines dealing with terminfo set tty modes so that
tabs are never expanded, so \et is safe to send.
This turns out to be essential for the Ann Arbor 4080.)
.PP
A final example is the LSI ADM-3a, which uses row and column
offset by a blank character, thus \*(lqcup=\eE=%p1%' '%+%c%p2%' '%+%c\*(rq.
After sending `\eE=', this pushes the first parameter, pushes the
ASCII value for a space (32), adds them (pushing the sum on the stack
in place of the two previous values) and outputs that value as a character.
Then the same is done for the second parameter.
More complex arithmetic is possible using the stack.
.PP
If the terminal has row or column absolute cursor addressing,
these can be given as single parameter capabilities
.B hpa
(horizontal position absolute)
and
.B vpa
(vertical position absolute).
Sometimes these are shorter than the more general two parameter
sequence (as with the hp2645) and can be used in preference to
.B cup .
If there are parameterized local motions (e.g. move
.I n
spaces to the right) these can be given as
.BR cud ,
.BR cub ,
.BR cuf ,
and
.BR cuu
with a single parameter indicating how many spaces to move.
These are primarily useful if the terminal does not have
.BR cup ,
such as the Tektronix 4025.
.PP
.B "Cursor motions"
.PP
If the terminal has a fast way to home the cursor
(to very upper left corner of screen) then this can be given as
\fBhome\fR; similarly a fast way of getting to the lower left hand corner
can be given as \fBll\fR; this may involve going up with \fBcuu1\fR
from the home position,
but a program should never do this itself (unless \fBll\fR does) because it
can make no assumption about the effect of moving up from the home position.
Note that the home position is the same as addressing to (0,0):
to the top left corner of the screen, not of memory.
(Thus, the \eEH sequence on HP terminals cannot be used for
.BR home .)
.PP
.B "Area clears"
.PP
If the terminal can clear from the current position to the end of the
line, leaving the cursor where it is, this should be given as \fBel\fR.
If the terminal can clear from the current position to the end of the
display, then this should be given as \fBed\fR.
\fBed\fR is only defined from the first column of a line.
(Thus, it can be simulated by a request to delete a large number of lines,
if a true
.B ed
is not available.)
.PP
.B "Insert/delete line"
.PP
If the terminal can open a new blank line before the line where the cursor
is, this should be given as \fBil1\fR; this is done only from the first
position of a line.  The cursor must then appear on the newly blank line.
If the terminal can delete the line which the cursor is on, then this
should be given as \fBdl1\fR; this is done only from the first position on
the line to be deleted.
Versions of
.B il1
and
.B dl1
which take a single parameter and insert or delete that many lines can
be given as
.B il
and
.BR dl .
If the terminal has a settable scrolling region (like the vt100)
the command to set this can be described with the
.B csr
capability, which takes two parameters:
the top and bottom lines of the scrolling region.
The cursor position is, alas, undefined after using this command.
It is possible to get the effect of insert or delete line using
this command \- the
.B sc
and
.B rc
(save and restore cursor) commands are also useful.
Inserting lines at the top or bottom of the screen can also be
done using
.B ri
or
.B ind
on many terminals without true insert/delete line,
and are often faster even on terminals with those features.
.PP
If the terminal has the ability to define a window as part of
memory, which all commands affect,
it should be given as the parameterized string
.BR wind .
The four parameters are the starting and ending lines in memory
and the starting and ending columns in memory, in that order.
.PP
If the terminal can retain display memory above then the
\fBda\fR capability should be given; if display memory can be retained
below then \fBdb\fR should be given.  These indicate
that deleting a line or scrolling may bring non-blank lines up from below
or that scrolling back with \fBri\fR may bring down non-blank lines.
.PP
.B "Insert/delete character"
.PP
There are two basic kinds of intelligent terminals with respect to
insert/delete character which can be described using
.I terminfo.
The most common insert/delete character operations affect only the characters
on the current line and shift characters off the end of the line rigidly.
Other terminals, such as the Concept 100 and the Perkin Elmer Owl, make
a distinction between typed and untyped blanks on the screen, shifting
upon an insert or delete only to an untyped blank on the screen which is
either eliminated, or expanded to two untyped blanks.  You can find out
which kind of terminal you have by clearing the screen and then typing
text separated by cursor motions.  Type \*(lqabc\ \ \ \ def\*(rq using local
cursor motions (not spaces) between the \*(lqabc\*(rq and the \*(lqdef\*(rq.
Then position the cursor before the \*(lqabc\*(rq and put the terminal in insert
mode.  If typing characters causes the rest of the line to shift
rigidly and characters to fall off the end, then your terminal does
not distinguish between blanks and untyped positions.  If the \*(lqabc\*(rq
shifts over to the \*(lqdef\*(rq which then move together around the end of the
current line and onto the next as you insert, you have the second type of
terminal, and should give the capability \fBin\fR, which stands for
\*(lqinsert null\*(rq.
While these are two logically separate attributes (one line vs. multi line
insert mode, and special treatment of untyped spaces) we have seen no
terminals whose insert mode cannot be described with the single attribute.
.PP
Termcap can describe both terminals which have an insert mode, and terminals
which send a simple sequence to open a blank position on the current line.
Give as \fBsmir\fR the sequence to get into insert mode.
Give as \fBrmir\fR the sequence to leave insert mode.
Now give as \fBich1\fR any sequence needed to be sent just before sending
the character to be inserted.  Most terminals with a true insert mode
will not give \fBich1\fR, terminals which send a sequence to open a screen
position should give it here.  (Insert mode is usually
preferable to the sequence
to open a position on the screen if your terminal has both.)
If post insert padding is needed, give this as a number of milliseconds
in \fBip\fR (a string option).  Any other sequence which may need to be
sent after an insert of a single character may also be given in \fBip\fR.
If your terminal needs both to be placed into an `insert mode' and
a special code to precede each inserted character, then both
.BR smir / rmir
and
.B ich1
can be given, and both will be used.
The
.B ich
capability, with one parameter,
.I n ,
will repeat the effects of
.B ich1
.I n
times.
.PP
It is occasionally necessary to move around while in insert mode
to delete characters on the same line (e.g. if there is a tab after
the insertion position).  If your terminal allows motion while in
insert mode you can give the capability \fBmir\fR to speed up inserting
in this case.  Omitting \fBmir\fR will affect only speed.   Some terminals
(notably Datamedia's) must not have \fBmir\fR because of the way their
insert mode works.
.PP
Finally, you can specify
.B dch1
to delete a single character,
.B dch
with one parameter,
.I n ,
to delete
.I n characters,
and delete mode by giving \fBsmdc\fR and \fBrmdc\fR
to enter and exit delete mode (any mode the terminal needs to be placed
in for
.B dch1
to work).
.PP
A command to erase
.I n
characters (equivalent to outputting
.I n
blanks without moving the cursor)
can be given as
.B ech
with one parameter.
.PP
.B "Highlighting, underlining, and visible bells"
.PP
If your terminal has one or more kinds of display attributes,
these can be represented in a number of different ways.
You should choose one display form as
.I standout mode ,
representing a good, high contrast, easy on the eyes,
format for highlighting error messages and other attention getters.
(If you have a choice, reverse video plus half bright is good,
or reverse video alone.)
The sequences to enter and exit standout mode
are given as \fBsmso\fR and \fBrmso\fR respectively.
If the code to change into or out of standout
mode leaves one or even two blank spaces on the screen,
as the TVI 912 and Teleray 1061 do,
then \fBxmc\fR should be given to tell how many spaces are left.
.PP
Codes to begin underlining and end underlining can be given as \fBsmul\fR
and \fBrmul\fR respectively.
If the terminal has a code to underline the current character and move
the cursor one space to the right, 
such as the Microterm Mime,
this can be given as \fBuc\fR.
.PP
Other capabilities to enter various highlighting modes include
.B blink
(blinking)
.B bold
(bold or extra bright)
.B dim
(dim or half bright)
.B invis
(blanking or invisible text)
.B prot
(protected)
.B rev
(reverse video)
.B sgr0
(turn off
.I all
attribute modes)
.B smacs
(enter alternate character set mode)
and
.B rmacs
(exit alternate character set mode).
Turning on any of these modes singly may or may not turn off other modes.
.PP
If there is a sequence to set arbitrary combinations of modes,
this should be given as
.B sgr
(set attributes),
taking 9 parameters.
Each parameter is either 0 or 1, as the corresponding attribute is on or off.
The 9 parameters are, in order:
standout, underline, reverse, blink, dim, bold, invis, protect, alternate
character set.
Not all modes need be supported by
.BR sgr ,
only those for which corresponding separate attribute commands exist.
.PP
Terminals with the ``magic cookie'' glitch
.RB ( xmc )
deposit special ``cookies'' when they receive mode setting sequences,
which affect the display algorithm, rather than having extra bits for
each character.
Some terminals, such as the HP 2621, automatically leave standout
mode when they move to a new line or the cursor is addressed.
Programs using standout mode should exit standout mode before
moving the cursor or sending a newline,
unless the
.B msgr
capability, asserting that it is safe to move in standout mode, is present.
.PP
If the terminal has
a way of flashing the screen to indicate an error quietly (a bell replacement)
then this can be given as \fBflash\fR; it must not move the cursor.
.PP
If the cursor needs to be made more visible than normal when it is
not on the bottom line (to make, for example, a non-blinking underline into an
easier to find block or blinking underline)
give this sequence as
.BR cvvis .
If there is a way to make the cursor completely invisible, give that as
.BR civis .
The capability
.BR cnorm
should be given which undoes the effects of both of these modes.
.PP
If the terminal needs to be in a special mode when running
a program that uses these capbilities,
the codes to enter and exit this mode can be given as \fBsmcup\fR and \fBrmcup\fR.
This arises, for example, from terminals like the Concept with more than
one page of memory.
If the terminal has only memory relative cursor addressing and not screen
relative cursor addressing, a one screen-sized window must be fixed into
the terminal for cursor addressing to work properly.
This is also used for the Tektronix 4025,
where
.B smcup
sets the command character to be the one used by terminfo.
.PP
If your terminal correctly generates underlined characters
(with no special codes needed)
even though it does not overstrike,
then you should give the capability \fBul\fR.
If overstrikes are erasable with a blank,
then this should be indicated by giving \fBeo\fR.
.PP
.B Keypad
.PP
If the terminal has a keypad that transmits codes when the keys are pressed,
this information can be given. Note that it is not possible to handle
terminals where the keypad only works in local (this applies, for example,
to the unshifted HP 2621 keys).
If the keypad can be set to transmit or not transmit,
give these codes as \fBsmkx\fR and \fBrmkx\fR.
Otherwise the keypad is assumed to always transmit.
The codes sent by the left arrow, right arrow, up arrow, down arrow,
and home keys can be given as \fBkcub1, kcuf1, kcuu1, kcud1,
\fRand\fB khome\fR respectively.
If there are function keys such as f0, f1, ..., f10, the codes they send
can be given as \fBkf0, kf1, ..., kf10\fR.
If these keys have labels other than the default f0 through f10, the labels
can be given as \fBlf0, lf1, ..., lf10\fR.
The codes transmitted by certain other special keys can be given:
.B kbs
(backspace),
.B ktbc
(clear all tabs),
.B kctab
(clear the tab stop in this column),
.B kclr
(clear screen or erase key),
.B kdch1
(delete character),
.B kdl1
(delete line),
.B krmir
(exit insert mode),
.B kel
(clear to end of line),
.B ked
(clear to end of screen),
.B kich1
(insert character or enter insert mode),
.B kil1
(insert line),
.B knp
(next page),
.B kpp
(previous page),
.B kind
(scroll forward/down),
.B kri
(scroll backward/up),
.B khts
(set a tab stop in this column).
.PP
.B "Tabs and Initialization"
.PP
If the terminal has hardware tabs, the command to advance to the next
tab stop can be given as
.B ht
(usually control I).
A ``backtab'' command which moves leftward to the next tab stop can
be given as
.BR cbt .
By convention, if the teletype modes indicate that tabs are being
expanded by the computer rather than being sent to the terminal,
programs should not use
.B ht
or
.B cbt
even if they are present, since the user may not have the tab stops
properly set.
If the terminal has hardware tabs activated by control I, then
.B tabs
is given, in addition to
.BR ht .
This is normally used by the
.I tset
command to determine whether to set the mode for hardware tab expansion.
.PP
Other capabilities
include
.BR is1 ,
.BR is2 ,
and
.BR is3 ,
initialization strings for the terminal,
and \fBif\fR, the name of a file containing long initialization strings.
These strings are expected to set the terminal into modes consistent
with the rest of the terminfo description.
They are normally sent to the terminal, by the
.I tset
program, each time the user logs in.
They will be printed in the following order:
.BR is1 ;
.BR is2 ;
setting tabs using
.B tbc
and
.BR hts ;
.BR if ;
and finally
.BR is3 .
Most initialization is done with
.B is2 .
Special terminal modes can be set up without duplicating strings
by putting the common sequences in
.B is2
and special cases in
.B is1
and
.BR is3 .
A pair of sequences that does a harder reset from a totally unknown state
can be analogously given as
.BR rs1 ,
.BR rs2 ,
.BR rf ,
and
.BR rs3 ,
analogous to
.B is2
and
.BR if .
These strings are output by the
.I reset
program, which is used when the terminal gets into a wedged state.
Commands are normally placed in
.B rs2
and
.B rf
only if they produce annoying effects on the screen and are not
necessary when logging in.
For example, the command to set the vt100 into 80 column mode would
normally be part of
.BR is2 ,
but it causes an annoying glitch of the screen and is not normally
needed since the terminal is usually already in 80 column mode.
.PP
If there are commands to set and clear tab stops, they can be given as
.B tbc
(clear all tab stops)
and
.B hts
(set a tab stop in the current column of every row).
If a more complex sequence is needed to set the tabs than can be
described by this, the sequence can be placed in
.B is2
or
.BR if .
.PP
.B Delays
.PP
Certain capabilities control padding in the teletype driver.
These are primarily needed by hard copy terminals, and are used
by the
.I tset
program to set teletype modes appropriately.
Delays embedded in the capabilities
.B cr ,
.B ind ,
.B cub1 ,
.B ff ,
and
.B tab
will cause the appropriate delay bits to be set in the teletype driver.
If
.B pb
(padding baud rate)
is given,
these values can be ignored at baud rates below the value of
.B pb .
.PP
.B Miscellaneous
.PP
If the terminal requires other than a null (zero) character as a pad,
then this can be given as \fBpad\fR.
Only the first character of the
.B pad
string is used.
.PP
If the terminal has an extra ``status line'' that is not normally
used by software, this fact can be indicated.
If the status line is viewed as an extra line below the bottom line,
into which one can cursor address normally,
(such as the Heathkit h19's 25th line, or the 24th line of a vt100
which is set to a 23 line scrolling region)
the capability
.B hs
should be given.
Special strings to go to the beginning of the status
line and to return from the status line can be given as
.B tsl
and
.BR fsl .
.RB ( fsl
must leave the cursor position in the same place it was before
.BR tsl .)
.B tsl
takes one parameter, which is the column number of the status line
the cursor is to be moved to.
If escape sequences and other special commands, such as tab, work
while in the status line, the flag
.B eslok
can be given.
A string which turns off the status line (or otherwise erases its
contents) should be given as
.B dsl .
If the terminal has commands to save and restore the position of the cursor,
give them as
.B sc
and
.BR rc .
The status line is normally assumed to be the same width as the rest
of the screen, e.g.
.B cols .
If the status line is a different width (possibly because the terminal
does not allow an entire line to be loaded) the width, in columns,
can be indicated with the numeric parameter
.B wsl .
.PP
If the terminal can move up or down half a line,
this can be indicated with
.B hu
(half line up)
and
.B hd
(half line down).
This is primarily useful for superscripts and subscripts on hardcopy terminals.
If a hardcopy terminal can eject to the next page (form feed), give this as
.B ff
(usually control L).
.PP
If there is a command to repeat a given character a given number of
times (to save time transmitting a large number of identical characters)
this can be indicated with the parameterized string
.BR rep .
The first parameter is the character to be repeated and the second
is the number of times to repeat it.
Thus, tparm(repeat_char, 'x', 10) is the same as `xxxxxxxxxx'.
.PP
If the terminal has a settable command character, such as the Tektronix 4025,
this can be indicated with
.BR CC .
A prototype command character is chosen which is used in all capabilities.
This character is given in the
.B CC
capability to identify it.
The following convention is supported on some UNIX systems:
The environment is to be searched for a
.B CC
variable, and if found, all
occurrances of the prototype character are replaced with the character
in the environment variable.
.PP
Terminal descriptions that do not represent a specific kind of known
terminal, such as
.I switch ,
.I dialup ,
.I patch ,
and
.I network ,
should include the
.B gn
(generic) capability so that programs can complain that they don't know
how to talk to the terminal.
(This capability does not apply to
.I virtual
terminal descriptions for which the escape sequences are known.)
.PP
If the terminal uses xon/xoff handshaking for flow control, give
.BR xon .
Padding information should still be included so that routines can
make better decisions about costs, but actual pad characters may
not be transmitted.
.PP
If the terminal has a ``meta key'' which acts as a shift key,
setting the 8th bit of any character transmitted, this fact can
be indicated with
.BR km .
Otherwise, software will assume that the 8th bit is parity and it
will usually be cleared.
If strings exist to turn this ``meta mode'' on and off, they
can be given as
.B smm
and
.BR rmm .
.PP
If the terminal has more lines of memory than will fit on the screen
at once, the number of lines of memory can be indicated with
.BR lm .
A value of 0 indicates that the number of lines is not fixed,
but that there is still more memory than fits on the screen.
.PP
If the terminal is one of those supported by the CB-UNIX virtual
terminal protocol, the terminal number can be given as
.BR vt .
.PP
Media copy
strings which control an auxillary printer connected to the terminal
can be given as
.BR mc0 :
print the contents of the screen,
.BR mc4 :
turn on the printer, and
.BR mc5 :
turn off the printer.
When the printer is on, all text sent to the terminal will be sent
to the printer.
It is undefined whether the text is also displayed on the terminal screen
when the printer is on.
.PP
Strings to program function keys can be given as
.BR pfkey ,
.BR pfloc ,
and
.BR pfx .
Each of these strings takes two parameters: the function key number to
program (from 0 to 10) and the string to program it with.
Function key numbers out of this range may program undefined keys in
a terminal dependent manner.
The difference between the capabilities is that
.B pfkey
causes pressing the given key to be the same as the user typing the
given string,
.B pfloc
causes the string to be executed by the terminal in local, and
.B pfx
causes the string to be transmitted to the computer.
.PP
.B "Glitches and Braindamage"
.PP
Hazeltine terminals, which don't allow `~' characters to be displayed should
indicate \fBhz\fR.
.PP
Terminals which ignore a linefeed immediately after an \fBam\fR wrap,
such as the Concept and vt100,
should indicate \fBxenl\fR.
.PP
If
.B el
is required to get rid of standout
(instead of merely writing normal text on top of it),
\fBxhp\fP should be given.
.PP
Teleray terminals, where tabs turn all characters moved over to blanks,
should indicate \fBxt\fR (destructive tabs).
This glitch is also taken to mean that it is not possible to position
the cursor on top of a ``magic cookie'',
that to erase standout mode it is instead necessary to use
delete and insert line.
.PP
The Beehive Superbee, which is unable to correctly transmit the escape
or control C characters, has
.BR xsb ,
indicating that the f1 key is used for escape and f2 for control C.
(Only certain superbees have this problem, depending on the ROM.)
.PP
Other specific terminal problems may be corrected by adding more
capabilities of the form \fBx\fIx\fR.
.PP
.B "Similar Terminals"
.PP
If there are two very similar terminals,
one can be defined as being just like the other with certain exceptions.
The string capability \fBuse\fR can be given
with the name of the similar terminal.
The capabilities given before
.B use
override those in the terminal type invoked by
.BR use .
A capability can be cancelled with \fBxx@\fR where xx is the capability.
For example, the entry
.PP
	2621-nl, smkx@, rmkx@, use=2621,
.PP
defines a 2621-nl that does not have the \fBsmkx\fR or \fBrmkx\fR capabilities,
and hence does not turn on the function key labels when in visual mode.
This is useful for different modes for a terminal, or for different
user preferences.  An terminal may have as many \fBuse\fR entries as needed.
They are handled in the order given in the description, that is, later
.BR use 's
will not overwrite capabilities defined earlier in the entry.
.SH FILES
.PP
.DT
/usr/lib/terminfo	file containing terminal descriptions
.br
/usr/lib/terminfo/?/*	directories containing compiled descriptions
.SH "SEE ALSO"
.PP
ex, curses, tset, vi, ul, more
.SH AUTHOR
.PP
Pavel Curtis
.sp
.nf
Ported to Coherent by:
Udo Munk
Oberstr. 21
4040 Neuss 1
Germany
phone: +49 2131/275348
.fi
