.ll 6i		\" line length
.lt 6i		\" title length
.ds N "cu"	\" program name
.de HD		\" header macro
'sp 1v
.tl 'cu'Command'cu'
'sp 2v
..
.de FO		\" footer macro
'sp 3v
.tl 'Connect Unix system'UNIX'Page %'
'bp
..
.de SH		\" subheader macro
.nf
\\$1
.fi
..
.de ST		\" start a table
.in 1i
.nf
..
.de ET		\" end a table
.fi
.in 0
..
.wh 0 HD	\" traps for header
.wh -5 FO	\" and footer
.nh		\" disable hyphenation
.ce
CU - Connect another Unix system

.SH USAGE
.in 1i
cu [-dtmo] [-a|c] [-b baud] [-l line] [sitename]
.in 0i

.SH DESCRIPTION
.in 1i
\*N allows to communicate with a remote system. The input taken from
the keyboard of the local system will be sent to the remote site, and
the output of the remote system will be sent back so that you can see it
on your screen. In this way \*N simulates a tty unit connected to
a remote computer system.

\*N recognizes the following command line arguments:
.in 0i

-d	[ Debug mode ]
.in 1i
Prints additional information on your terminal. This is useful when
line speed errors or dial failures appear.
.in 0i

-t	[ Test mode ]
.in 1i
All operations will be done as usual but the connection will not be
made. This option is often used with the debug mode to prohibit the
modem from dialing.
.in 0i

-m	[ crlf Mapping ]
.in 1i
This option can be used when communicatin with a raw device wich
does not expand a linefeed character (lf) to 'cr,fl' (carriage return
and linefeed). This should not be used with UNIX to UNIX connections.
.in 0i

-o	[ Output log ]
.in 1i
All output of the remote system will be written to the default log
file ''./cu.log''. The log file will be overwritten by subsequent
calls. Since UNIX systems echo their input characters, both input
and output will be written to the file.
.in 0i

-a	[ Alternate library ]
.in 1i
Normally \*N takes its system information (such as phone number
and communication device) from the file /usr/lib/uucp/L.sys.
Because ''L.sys'' should not contain non-UUCP systems, \*N uses
an alternate system library. 
.br
Use this option to force \*N to take it's system information from
it's own library (normally /usr/local/lib/Cu.sys).
.in 0i

-c	[ direct Connection ]
.in 1i
The connection will be made directly to the tty line specified.
\*N will not dial when you use this option.
Run \*N without any options to get the default tty line and line
speed.
.in 0i

-b <n>   [ line speed (Baud) ]
.in 1i
The connection will be made at <n> baud. Normally \*N takes the
line speed from the file /usr/lib/uucp/L-devices, so you do not
have to specify the line speed.
.in 0i

-l <dev> [ tty Line ]
.in 1i
The connection will be made via tty line <dev>. Normally the
communication line is taken from the file /usr/lib/uucp/L-devices.
Like -b you should use this option with direct connections, only.
.in 0i

sitename
.in 1i
The UUCP name of the remote site you want to call. This name must
be present either in the 'L.sys' file or in the 'Cu.sys'.
Either the site name or the -c option (direct connection) must
be specified.
.in 0i


.SH "ONLINE COMMANDS"
.in 1i
There are several commands you may issue while you are connected
to a remote system. Each command must be prefixed by an escape character.
This version of \*N uses the tilde (~) as escape character.
.in 0i

~b	[ Break signal ]
.in 1i
Send a break signal to the remote system. On UNIX systems this signal
forces the ''getty'' to re-initialize itself at a different line speed.
You should use this command when the remote system sends junk after
connecting.
.in 0i

~c	[ Clear screen ]
.in 1i
Clear the screen on your local system. This command sens nothing to
the remote site. To clear the screen the ANSI Escape Sequence ED
(<esc>[2J) is used.
.in 0i

~.	[ Quit ]
.in 1i
This command terminates the conversation. Before \*N exits the modem
will be forced to hang up. ~. sends nothing to the remote system.
.in 0i

~s	[ Send ASCII file ]
.in 1i
Sometimes you may want to send a text you have already written on
your local system to the connected remote system.
When you issue the send command, the \*N will prompt for a file
name. Type in the name of your text file and press <ENTER>. \*N
then opens the file and sends its contents to the remote site.
The characters read from your text file will be sent like
characters you type on your keyboard.
.br
When you want to copy your file ''foo.bar'' to the connected
UNIX site do the following:

.ST
- Issue the ''cat'' command on the remote system:
  $ cat >foo.bar
- Type in ~sfoo.bar
- Wait until the transfer is complete
- Type <control-D>
.ET
.in 0i

~!	[ Local system shell ]
.in 1i
This command starts a local shell on your system
without terminating the remote connection.
This allows you to perform some tasks on your local computer
and then return to the remote session without having to dial
again.
.br
To get back to the remote system type ctrl-D to terminate
the local subshell.
.in 0


To send a tilde (~) to the remote system just type ~~.




.SH "***** Files *****"

.in 1i
.nf
/usr/lib/uucp/L.sys		UUCP system information
/usr/lib/uucp/L-devices		tty line device information
/usr/local/lib/Cu.sys
/u/lib/Cu.sys			non-UUCP system information
.fi
.in 0i


.SH "***** See Also *****"

.in 1i
.nf
UUCP, uucp, getty, cat, file
.fi
.in 0i


.SH "***** Author *****"

.in 1i
.nf
(C) by Nils M. Holm, 1991
Modifyed by Udo Munk, 1992
.fi
.in 0i

