/*
 * String-Paket
 *
 * Autor: Jeff Taylor, The Toolsmith (C) Copyright 1985
 * Environment: UNIX 4.2 BSD; CC compiler
 */

#include <stdio.h>

/* copy_until - kopiert von 'src' nach 'dst' bis zu 'delimiters' */
void copy_until(dst, src, delimiters)
register char *dst, *src;
char *delimiters;
{
	register char *d;

	while (*src != '\0') {
		for (d = delimiters; *d != '\0'; ++d) {
			if (*src == *d)
				goto out;
		}
		*dst++ = *src++;
	}
out:
	*dst = '\0';
}

/* itoa - Integer --> ASCII */
char *itoa(n, ascii)
register int n;
register char *ascii;
{
	register int power;

	if (n < 0) {
		n = -n;
		*ascii++ = '-';
	}
	power = 1;
	while (n / power >= 10)
		power = power * 10;
	do {
		*ascii++ = (n / power) + '0';
		n = n % power;
		power = power / 10;
	} while (power != 0);
	*ascii = '\0';
	return(ascii);
}

/* newcpy - String in frisch allokierten Speicher kopieren */
char *newcpy(string)
char *string;
{
	void panic();
	char *malloc(), *strcpy();
	register char *p;

	/* abschliessendes Null-Byte mit aufnehmen */
	if ((p = malloc(strlen(string) + 1)) == NULL)
		panic();
	return(strcpy(p, string));
}

/* panic - Fehlermeldung und Abbruch wenn kein Speicher mehr */
void panic()
{
	fprintf(stderr, "out of memory\n");
	exit(1);
}
