/*	scan rfc822 headers	*/
/*	and build a link-list	*/
/*	to be passed to the 	*/
/*	mail-reader.		*/

#include	<stdio.h>
#include	<string.h>
#include	<ctype.h>
#include	<curses.h>

#include	"comb.h"

/* ISFROM stolen from deliver */
#define	ISFROM(p)	((p)[0] == 'F' && (p)[1] == 'r' && (p)[2] == 'o' \
			&& (p)[3] == 'm' && (p)[4] == ' ')

#define	YES 1
#define NO -1
#define SOH '\001'

char	junk[MAXLINE];
char	from_who[MAXLINE];
char	from_path[MAXLINE];
char	when_sent[MAXLINE];
char	subject[MAXLINE];
long	position;
long	prev_pos;	/* save position for add-list	   */
long	last_pos;	/* end-of-file mark for rescanning */
int	newmail;
int	linecnt;

static	FILE	*mailfile;
extern	int	num_msgs;
extern	char	mailpath[];
extern	HEADER	*root;

#define	NUMBRFC 34
#define MAXLRFC 15

char	legal_rfc[NUMBRFC][MAXLRFC] = {
	"X-",	/* 0 */
	"To:",
	"cc:",
	"Cc:",
	"bcc:",
	"From:", /* 5 */
	"Date:", 
	"Sender:",
	"Resent-",
	"Subject:", /* 9 */
	"Invalid-",
	"Received:",
	"Reply-To:",
	"Keywords:",
	"Comments:",
	"Encrypted:", /* 15 */
	"References:",
	"Message-Id:",
	"In-Reply-To:",
	"Return-path:",
	"Return-Path:", /* 20 */
	"Posted-Date:",
	"Precedence",
	"Organization:",
	"Newsgroups:",	/* these were added for those get news via mail-feeds */
	"Path:",
	"Lines:",
	"Approved:",
	"Apparently-",
	"Nntp-",
	"Xref:",
	"Article-I.D.",
	"Errors-",
	"Via:"
	};

stripnl(st,sd)
char *st;
char *sd;
{
	while ((*sd = *st) != '\0') {
		st++;
		sd++;
		if (*st == '\n')
		{
			*sd = '\0';
			return;
		}
	}
}

grokdate2(mid)
char	*mid;
{
	int	date;
	char	doy[20];
	char	moy[20];
	char	when[20];
	char	*loc;

	loc = mid;

	while (isdigit(*loc) == 0) *loc++;

	if(sscanf(loc,"%2d %s",&date,&moy[0]) == 2)
	{
		if (isdigit(moy[0]))
		{	/* looks like they are switched */
			loc = mid;
			while(*loc++ != ':');
			if(sscanf(loc,"%s %s %2d",&doy[0],&moy[0],&date) == 3)
			{
				sprintf(when,"%3s %2d",moy,date);
				strcpy(mid,when);
			}
			else strcpy(mid,"Unknwn");
			return;
		}
		else
		{
			sprintf(when,"%3s %2d",moy,date);
			strcpy(mid,when);
		}
	}
	else	strcpy(mid,"Unknwn");
}

char	*groksubj(subj)
char	*subj;
{
	char	*subjx = subj;
	while (*subj++ != ' ');
	stripnl(subj,subjx);
	return(subjx);
}	

grokname2(f)
char	f[];
{
	char	*n = f;

	while (*f++ != ':');
	while ((*f == ' ') || (*f == '\t')) *f++;
	while ((*n = *f) != '<')
		{
		  n++;
		  f++;
		}
	*n = '\0';
}

grokname3(f)
char f[];
{
	char	*n = f;

	while (*f++ != ':');
	while ((*f == ' ') || (*f == '\t')) *f++;
	while	((*f != ' ') && (*f != '\n') &&
		(*f != '\r') && (*f != '\0'))
		*n++ = *f++;
	*n = '\0';
}

grokboth(f,p)
char	f[], p[];
{
	char	*name;
	
	/* contains real name in Comment? */
	if (strstr(f,"(") && strstr(f,")"))
	{
		if ((name = strtok(f," \t\n")) == NULL) strcpy(f,'\0');
		if ((name = strtok(NULL," \t\n")) != NULL) strcpy(p,name);
		if ((name = strtok(NULL,"()")) != NULL) strcpy(f,name);		
	}
	if (strstr(f,"<") && strstr(f,">"))
	{
		strcpy(junk,f);
		grokname2(junk);
		strcpy(f,junk);
		if ((name = strtok(p,"<>")) == NULL) strcpy(p,'\0');
		if ((name = strtok(NULL,"<>")) != NULL) strcpy(p,name);
	}
}

grokfrom(f)
char	f[];
{
	char	w[MAXLINE];
	char	p[MAXLINE];

	strcpy(w,f);
	strcpy(p,f);
	if (strstr(w,"("))
	{
		grokboth(w,p);
	}
	else if (strstr(w,"<"))
	{
		grokboth(w,p);
	}
	else {
		grokname3(w);
		strcpy(p,w);
	}
	if (from_path[0] == '\0') {
		strncpy(from_path,strcat(from_path,p),MAXLINE-1);
	}
	strncpy(from_who,w,20);
	from_who[20] = '\0';
	from_path[MAXLINE-1] = '\0';
}

/*	rfc822_field()					*/
/*		check if it's a legal field.		*/
/*		process relevant fields, return YES	*/
/*		if legal, NO if illegal.		*/
/*		if the line begins with ' ' or '\t'	*/
/*		assume it's a continuation field and	*/
/*		return YES				*/
int rfc822_field(field)
char	field[];
{
	int	i;

	if     ((field[0] == ' ') ||
		(field[0] == '\n') ||
		(field[0] == '\t')) return YES;
	for(i = 0; i < NUMBRFC; i++)
	{
		if (strncmp(field,legal_rfc[i],strlen(legal_rfc[i])) == 0) {
			switch (i) {
				case	5 : { /* From: */
					if (from_who[0] == '\0') {
						grokfrom(field);
					}
					break;
					}
				case	6 : { /* Date: */
					if (when_sent[0] == '\0') {
						strcpy(junk,field);
						grokdate2(junk);
						strcpy(when_sent,junk);
					}
					break;
					}
				case	9 : { /* Subject: */
					if (subject[0] == '\0') {
						strcpy(junk,field);
						groksubj(junk);
						strncpy(subject,junk,LSUBJ-1);
						if (strlen(junk) > LSUBJ-1) {
							subject[LSUBJ-2] = '$';
							subject[LSUBJ-1] = '\0';
						}
					}
					break;
					}
				default : break;
			}
			return YES;
		}
	}
	return NO;
}	

char	*strdup(s)
char	*s;
{
	char	*p;
	if ((p = (char *) malloc(strlen(s)+1)) == NULL)
		fail("Could not allocate memory in strdup()");
	if (p!=NULL)
		strcpy(p,s);
	return p;
}

HEADER	*addlist(node,prev,when,from,path,subj)
HEADER	*node, *prev;
char	*when, *from, *path, *subj;
{
	char	space;

	if (node == NULL)
		{
		if ((node = (HEADER *) malloc(sizeof(HEADER))) == NULL)
			{
			fprintf(stderr,"Out of Memory.\n\n");
			fprintf(stderr,"Could not allocate enough to\n");
			fprintf(stderr,"build lis of entire mailbox.\n\n");
			fprintf(stderr,"PLEASE DELETE SOME MESSAGES\n\n");
			fprintf(stderr,"Please press a key:\n");
			space = getchar();
			return NULL;
			};
		node->when_sent = strdup(when);
		node->from_who = strdup(from);
		node->from_path = strdup(path);
		node->subject = strdup(subj);
		node->position = prev_pos;
		node->size = position - prev_pos;
		node->lines = linecnt;
		node->status = 0;
		node->prev = prev;
		node->next = NULL;
		}
	else node->next = addlist(node->next,node,when,from,path,subj);
	return node;
}

int parse_one()
{
	char	buf[MAXBUF];

	/* initialize dest vars. */
	from_who[0] = '\0';
	when_sent[0] = '\0';
	from_path[0] = '\0';
	subject[0] = '\0';

	if (newmail != YES)
	{
		move(21,40); printw("%02d",num_msgs+1); refresh();
	}
	
	/* skip the heading 01 01 01 01 0a string */
	fgets(buf,MAXBUF,mailfile);

	if (fgets(buf,MAXBUF,mailfile) == NULL)
		return EOF;

	linecnt = 1;


	while (ISFROM(buf) || buf[0] == '>'|| buf[0] == '\n')
	{
		if(fgets(buf,MAXBUF,mailfile) == NULL)
			return EOF;
		linecnt++;
	}
	
	while(rfc822_field(buf) != NO)
		{
		/* this must be the header */
		if(fgets(buf,MAXBUF,mailfile) == NULL)
			return EOF;
		linecnt++;
		}

	/* that's it, we got our message, save position */
	/* and skip to next message			*/
	prev_pos = position;
	num_msgs++;
	while ((*buf = fgetc(mailfile)) != SOH) /* skip to EOM which is 0x01 0x01 0x01 0x01 '\n' */
	{
		if(*buf == EOF)
		{
			position = ftell(mailfile);
			root = addlist(root,NULL,when_sent,from_who,from_path,subject);
			return EOF;
		}
		if (*buf == '\n') linecnt++;
	}
	/* should be start of 01 01 01 01 0a string */
	if ((*buf = fgetc(mailfile)) == SOH) { /*grab the extra SOH */
		*buf = fgetc(mailfile); /* grab two more SOH */
		*buf = fgetc(mailfile);
		*buf = fgetc(mailfile); /*grab the extra '\n' */
	}
	position = ftell(mailfile); /* remember the next message position */
	root = addlist(root,NULL,when_sent,from_who,from_path,subject);
	return 0;
}

getheaders()
{
	position = 0L;
	num_msgs = 0;
	newmail = NO;
	if ((mailfile = fopen(mailpath,"r")) == NULL)
		{
		fail("Error opening mailbox in getheaders()");
		}
	while (parse_one() != EOF);
	if (fseek(mailfile,0L,2) != 0)
		{
		fail("Error seeking to EOF in getheaders()");
		}
	last_pos = ftell(mailfile);
	fclose(mailfile);
}

rescan()
{
	position = last_pos;
	newmail = YES;
	if ((mailfile = fopen(mailpath,"r")) == NULL)
		{
		fail("Error opening mailbox in rescan()");
		}
	if (fseek(mailfile,position,0) != 0)
		{
		fail("Error seeking beginning of new messages in rescan()");
		}
	while(parse_one() != EOF);
	if (fseek(mailfile,0L,2) != 0)
		{
		fail("Error seeking to EOF in rescan()");
		}
	last_pos = ftell(mailfile);
	fclose(mailfile);
}
