#include	<sys/stat.h>

#include	<curses.h>
#include	<string.h>
#include	<signal.h>

#include	"comb.h"

extern	replymsg();
extern	char *tempnam();

WINDOW	*glass;

HEADER	*root;
HEADER	*current_msg;
HEADER	*current_top;
HEADER	*current_bot;

static	FILE	*mailfile;
static	FILE	*mailpipe;

char	homedir[MAXLINE];
char	shell[MAXLINE];
char	mailpath[MAXLINE];
char	pager[MAXLINE];
char	printer[MAXLINE];
char	editor[MAXLINE];	/* name of editor user likes or default	  */
char	organization[MAXLINE];	/* shell variable, prepended to sent mail */
char	quotechar[MAXLINE];	/* characters to prepend to quoted messg  */
char	dest[MAXLINE];		/* name of person sending message to      */
char	command[MAXLINE];	/* for passing stuff to the shell.	  */
char	subject[MAXLINE];	/* subject passed to sendthis()		  */
char	sitename[30];		/* sitename of this system		  */
char	signature[MAXLINE];	/* filename of signature (.sig.mail)	  */
int	deleted_msgs;
int	num_msgs;
static	char	ch;

/*	user preferences, not implemented yet.	*/
int	bell_pref;
int	sort_pref;
int	disp_pref;

fail(mssg)
char *mssg;
{
	clear();
	standend();
	mvaddstr(10,4,mssg);
	standout();
	mvaddstr(20,4,"FATAL ERROR.  Please press a key to continue.");
	refresh();
	ch = getch();
	resetty();
	endwin();
	exit(FAIL);
}

/* i can't believe i forgot to do this. */
setsignals()
{
	int fail();

	signal(SIGSEGV,fail);
	signal(SIGALRM,fail);
	signal(SIGHUP,fail);
	signal(SIGINT,SIG_IGN);
	signal(SIGKILL,fail);
	signal(SIGTERM,fail);
	signal(SIGPIPE,fail);
#ifndef _I386
	signal(SIGDIVE,fail);
#else
	signal(SIGFPE,fail);
#endif
	signal(SIGQUIT,SIG_IGN);
}

prevlink()
{
	if (current_msg != NULL) {
		if (current_msg->prev != NULL) {
			if (sort_pref == SORTCHRONO)
			{
				if (current_msg == current_bot)
					current_top = current_top->prev;
			}
			if (sort_pref == SORTRECEIVED)
			{
				if (current_msg == current_top)
					current_top = current_top->prev;
			}
			current_msg = current_msg->prev;
		}
	}
}

nextlink()
{
	if (current_msg != NULL) {
		if (current_msg->next != NULL) {
			if (sort_pref == SORTCHRONO)
			{
				if (current_msg == current_top)
					current_top = current_top->next;
			}
			if (sort_pref == SORTRECEIVED)
			{
				if (current_msg == current_bot)
					current_top = current_top->next;
			}
			current_msg = current_msg->next;
		}
	}
}

prevmsg()
{
	showtime();
	if (sort_pref == SORTCHRONO) nextlink();
	if (sort_pref == SORTRECEIVED) prevlink();
}

nextmsg()
{
	showtime();
	if (sort_pref == SORTCHRONO) prevlink();
	if (sort_pref == SORTRECEIVED) nextlink();
}

isend()	/* <end> key has been pressed?  if so, move down to the end */
{
	int	lineup;

	lineup = 0;
	if ((ch = getch()) != '4') { beep(); return; }
	if ((ch = getch()) != 'H') { beep(); return; }
	if (sort_pref == SORTRECEIVED)
	{
	while (current_msg->next != NULL) current_msg = current_msg->next;
	/* okay, we're at the bottom. */
	current_top = current_msg;
	while ((current_top->prev != NULL) && (lineup++ < 11))
		current_top = current_top->prev;
	}
	if (sort_pref == SORTCHRONO)
	{
	while (current_msg->prev != NULL) current_msg = current_msg->prev;
	/* okay, we're at the bottom. */
	current_top = current_msg;
	while ((current_top->next != NULL) && (lineup++ < 11))
		current_top = current_top->next;
	}
}		

fixptr()
{
	current_msg = root;
	if ((sort_pref == SORTCHRONO) && (root != NULL))
	{
		while(current_msg->next != NULL)
			current_msg = current_msg->next;
	}
	
	current_top = current_msg;
}

loop()
{
	setsignals();

	root = NULL;

	glass = initscr();

	savetty();

	clear();
	titlepage();
	refresh();
	
	noecho();
	raw();

	(void) ismail();

	getheaders();

	fixptr();	/* make sure pointers are straight */

	clear(); refresh();

	deleted_msgs = 0;

	show_headers();
	drawmenu();
	refresh();

	while (ch = getch())
	{
		switch(ch) {
			case 'Q' :
			case 'q' : { if (deleted_msgs > 0)
					{
					if (updatemailbox(root) == FAIL)
						{ clearworkarea();
						  refresh();
						  break; }
					}
					resetty();
					endwin(); exit(0);
				   }
			case '\033': { /* ESC has been hit */
				if ((ch = getch()) != '[')
					{ beep(); break; }
				else {
					switch(ch=getch())
					{
					/* keyboard escapes (ANSI) */
					case 'A' : {prevmsg(); break;}
					case 'B' : {nextmsg(); break;}
					case 'H' : {
					    if(sort_pref == SORTRECEIVED)
					    {
						current_msg = root;
						current_top = root;
						break;
					    }
					    if(sort_pref == SORTCHRONO)
					    {
					    while(current_msg->next != NULL)
					        current_msg = current_msg->next;
					    current_top = current_msg;
					    }
					    break;
					}
					case '2' : {isend(); break;}
					default	 : {beep(); break;}
					}
				}
			break;
			}
			case '\014':{redrawmenu();break;}
			case '?' : {
				helpscreens();
				redrawmenu();
				refresh();
				break;
			}
			case 'k' :	/* move up   */
			case 'K' : {prevmsg(); break;}
			case 'j' :	/* move down */
			case 'J' : {nextmsg(); break;}
			case 'd' :	/* delete msg */
			case 'D' : if ((current_msg != NULL)
					 && (current_msg->status < 2))
			{
				current_msg->status=current_msg->status | 2;
				deleted_msgs++;
				break;
			}
			case 'u' : 	/* undelete msg */
			case 'U' : if ((current_msg != NULL) 
				&& (current_msg->status & 2))
				{
				current_msg->status=(current_msg->status & 1);
				deleted_msgs--;
				break;
				}
				else break;
			case 's' :	/* save a msg	  */
			case 'S' : {
				savemsg(current_msg);
				clearworkarea();
				break;
			}
			case 'f' :	/* forward a msg  */
			case 'F' : {
				forwardmsg(current_msg);
				redrawmenu();
				break;
			}
			case 'm' :	/* mail a message */
			case 'M' : {
				sendmsg();
				redrawmenu();
				break;
			}
			case 'R' :
			case 'r' : {	/* reply to a message */
				if (current_msg != NULL) {
					replymsg(current_msg);
					redrawmenu();
					refresh();
				}
				break;
			}
			case 'p' : 	/* print */
			case 'P' : {
				char tmpsnd[80];
				char *junk;

				if (current_msg != NULL)
				{
				junk = tempnam("/tmp", "comb");
				strcpy(tmpsnd,junk);
				filemsg(current_msg,tmpsnd,DONTQUOTE);

				sprintf(command,"cat %s | %s",tmpsnd,printer);
				system(command);

				}
				unlink(tmpsnd); /* bye-bye */

				break;
			}
			case '\r' :
			case '\n' : {

				char tmpsnd[80];
				char *junk;

				if (current_msg != NULL)
				{
				clear();
				refresh();
				junk = tempnam("/tmp", "comb");
				strcpy(tmpsnd,junk);
				filemsg(current_msg,tmpsnd,DONTQUOTE);

				sprintf(command,"cat %s | %s",tmpsnd,pager);

				echo();
				noraw();

				system(command);
				fprintf(stderr, "after system\n");

				noecho();
				raw();
				getch(); /* wait for user to hit keyboard */

				current_msg->status=current_msg->status | 1;
/*				nextmsg();
*/				}
				unlink(tmpsnd); /* bye-bye */

				redrawmenu();
				break;
			}
			case 'c' :
			case 'C' : {
				   configure();
				   break;
				   }
			case '#' : {
					 echo();
					 noraw();
					 clear();
					 refresh();

					 system(shell); 

					 raw();
					 noecho();

					 redrawmenu();
					 break; }
			default  : {beep(); break;}
		}
		show_headers();
		mvaddstr(18,1,"Command: "); refresh();
		refresh();
	}
}

main(argc,argv)
int argc;
char *argv[];
{
    char c;
    
    while(--argc > 0)
    {
	if (*argv[argc]++ == '-')
		switch(c = *argv[argc]++)
		{
		case 'f' : {
			strcpy(mailpath,argv[argc]); break;
			}
		case 'v' : {
			printf("%s: v%s\n",argv[0],VERSION);
			break;
			}
		default  : {
			argc = 0;
			printf("Illegal option: %c\n",c);
			break;
			}
		} /* switch */
    } /* while */
    if (argc > 0) {
	fprintf(stderr,"Usage: %s [-fmailbox] [-v]\n",argv[0]);
	exit(2);
    } /* usage */

    environment();		/* retrieve user-defined variables */
    rc();
    loop();
}
