#include	<stdio.h>
#include	<curses.h>
#include	<string.h>

#include	"comb.h"

static	FILE	*mailpipe;
extern	char	organization[];
extern	char	editor[];
extern	char	pager[];
extern	char	printer[];
extern	char	quotechar[];
extern	char	homedir[];
extern  char	command[];
extern	char	signature[];
extern	char	shell[];
extern	int	disp_pref;
extern	int	bell_pref;
extern	int	sort_pref;
extern  char	rcfile[MAXLINE];

configure()
{
	char ch;
	char junkline[MAXLINE];
	char *junk;
	char sigfile[50];
	char alifile[50];

	junk = junkline;

	if (signature[0] != '\0') strcpy(sigfile,signature);
	else {
		strcpy(sigfile,homedir);
		strcat(sigfile,"/.sig.mail");
	}
	strcpy(alifile,homedir);
	strcat(alifile,"/.aliases");
	clear();
	while(YES)
	{
		MVADDCEOL(3,1,"Editor           :");
		mvaddstr(4,10,"[Set by shell variable $EDITOR]");
		MVADDCEOL(5,1,"Pager            :");
		mvaddstr(6,10,"[Set by shell variable $PAGER]");
		MVADDCEOL(7,1,"Device (Printer) :");
		mvaddstr(8,10,"[Set by shell variable $PRINTDEV]");
		MVADDCEOL(9,1,"Organization     :");
		mvaddstr(10,10,"[Set by shell variable $ORGANIZATION]");
		MVADDCEOL(11,1,"Quote String     :");
		mvaddstr(12,10,"[Set by shell variable $QUOTE]");


		mvaddstr(14,10,"Method of sort	       :");
		mvaddstr(15,10,"Units for size of mail : ");
		mvaddstr(16,10,"Bell                   :");

		MVADDCEOL(18,1,"Signature        :");
		MVADDCEOL(20,1,"Aliases          :");
		standout();
		mvaddstr(14,1,"Toggles:");
		mvaddstr (1,1,"Configuration:");
		mvaddstr(3,1,"E"); mvaddstr(5,1,"P"); 
		mvaddstr(7,1,"D");
		mvaddstr(9,1,"O"); mvaddstr(11,1,"Q");
		mvaddstr(18,1,"S"); mvaddstr(20,1,"A");
		mvaddstr(14,10,"M"); mvaddstr(15,10,"U");
		mvaddstr(16,10,"B");
		mvaddstr(3,20,editor);
		mvaddstr(5,20,pager);
		mvaddstr(7,20,printer);
		mvaddstr(9,20,organization);
		mvaddstr(11,20,quotechar);
		mvaddstr(18,20,sigfile);
		mvaddstr(20,20,alifile);
		switch(sort_pref)
		{
			case SORTCHRONO	: { 
				mvaddstr(14,36,"Reverse order of receipt");
				break;
			}
			case SORTRECEIVED : {
				mvaddstr(14,36,"Order of receipt        ");
				break;
			}
			default		: {
				mvaddstr(14,36,"Illegal Value.  Bug?   ");
				break;
			}
		}
		switch(disp_pref)
		{
			case SHOWBYTE	: {
				mvaddstr(15,36,"Display sizes in bytes.");
				break;
			}
			case SHOWLINE	: {
				mvaddstr(15,36,"Display sizes in lines.");
				break;
			}
			case 0		: {
				mvaddstr(15,36,"Don't display sizes.   ");
				break;
			}
			default		: {
				mvaddstr(15,36,"Illegal value.  Bug?   ");
				break;
			}
		}
		switch(bell_pref)
		{
			case BELLRINGIT : {
			      mvaddstr(16,36,"Ring the bell when appropriate");
			      break;
			}
			case BELLQUIET	: {
			      mvaddstr(16,36,"Don't ever ring the bell.     ");
			      break;
			}
			default		: {
			      mvaddstr(16,36,"Illegal value.                ");
			      break;
			}
		}
		standend();
		showtime();

		mvaddstr(22,1,"First Letter of Item to Change, <ESC> to exit,");
		mvaddstr(23,1,"'W' to save these configs in ");
		addstr(rcfile);
		addstr(": ");

		refresh();
		ch = getch();
		switch(ch)
		{
		case '\033'	: {
				  redrawmenu();
				  return;
				  break;
				  }
		case 'm'	:
		case 'M'	: {
				  if (sort_pref == SORTCHRONO)
					sort_pref = SORTRECEIVED;
				  else sort_pref = SORTCHRONO;
				  fixptr();
				  break;
				}
		case 'b'	:
		case 'B'	: {
				  if (bell_pref == BELLRINGIT)
					bell_pref = BELLQUIET;
				  else bell_pref = BELLRINGIT;
				  break;
				}
		case 'u'	:
		case 'U'	: {
				  if (disp_pref == 0)
					{ disp_pref = SHOWBYTE; break; }
				  if (disp_pref == SHOWBYTE)
					{ disp_pref = SHOWLINE; break; }
				  if (disp_pref == SHOWLINE)
					{ disp_pref = 0; break; }
				}
		case 'S'	:
		case 's'	: {
				  sprintf(command,"%s %s",editor,sigfile);
				  system(command);
				  clear();
				  break;
				  }
		case 'A'	:
		case 'a'	: {
				  sprintf(command,"%s %s",editor,alifile);
				  system(command);
				  clear();
				  break;
				  }
		case 'Q'	:
		case 'q'	: {
				  MVCGETS(11,20,junk,quotechar);
				  break;
				  }
		case 'e'	:
		case 'E'	: {
				  MVCGETS(3,20,junk,editor);
				  break;				  
				  }
		case 'p'	:
		case 'P'	: {
				  MVCGETS(5,20,junk,pager);
				  break;				  
				  }
		case 'd'	:
		case 'D'	: {
				  MVCGETS(7,20,junk,printer);
				  break;
				  }
		case 'w'	:
		case 'W'	: {
					generaterc();
					addstr("Written.");
					break;
				}
		case 'o'	:
		case 'O'	: {
				  MVCGETS(9,20,junk,organization);
				  break;				  
				  }
		default		: beep();
		}
	}
}

/* generaterc:					*/
/* 	make a .combrc in user's home directory	*/
/*	based on currect configuration.		*/
/*						*/
/*	if there's already a .combrc, save it.	*/
generaterc()
{
	if ((mailpipe = fopen(rcfile,"w")) == NULL)
		fail("Error opening $HOME/.combrc for generation.");
	fprintf(mailpipe,"# this .combrc generated by CoMB ");
	fprintf(mailpipe,"%s\n",VERSION);
	if (strlen(editor) > 0)
		fprintf(mailpipe,"editor=%s\n",editor);
	if (strlen(pager) > 0)
		fprintf(mailpipe,"pager=%s\n",pager);
	if (strlen(shell) > 0)
		fprintf(mailpipe,"shell=%s\n",shell);
	if (strlen(organization) > 0)
		fprintf(mailpipe,"organization=%s\n",organization);
	if (strlen(quotechar) > 0)
		fprintf(mailpipe,"quote=%s\n",quotechar);
	if (strlen(signature) > 0)
		fprintf(mailpipe,"signature=%s\n",signature);
	if (disp_pref == 0) fprintf("display-size=no");
	if (disp_pref == SHOWBYTE) fprintf(mailpipe,"display-size=bytes\n");
	if (disp_pref == SHOWLINE) fprintf(mailpipe,"display-size=lines\n");
	if (sort_pref == SORTCHRONO) fprintf(mailpipe,"sort=reverse-chrono\n");
	if (sort_pref == SORTRECEIVED) fprintf(mailpipe,"sort=chronological\n");
	if (bell_pref == BELLRINGIT) fprintf(mailpipe,"bell=yes\n");
	if (bell_pref == BELLQUIET) fprintf(mailpipe,"bell=no\n");
	fclose(mailpipe);
}
