.\" Copyright (c) 1980 The Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms are permitted
.\" provided that the above copyright notice and this paragraph are
.\" duplicated in all such forms and that any documentation,
.\" advertising materials, and other materials related to such
.\" distribution and use acknowledge that the software was developed
.\" by the University of California, Berkeley.  The name of the
.\" University may not be used to endorse or promote products derived
.\" from this software without specific prior written permission.
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
.\" IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
.\" WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.\"
.\"	@(#)checknr.1	6.3 (Berkeley) 10/30/88
.\"
.TH CHECKNR "" "October 30, 1988"
.SH NAME
.PP
checknr \- check nroff/troff files
.SH SYNOPSIS
.PP
.B checknr
[
.B \-s
] [
.B \-f
] [
.BR \-a ".x1.y1.x2.y2. ... .xn.yn"
] [
.BR \-c ".x1.x2.x3 ... .xn"
] [
\fIfile\fP ...
]
.SH DESCRIPTION
.PP
.I Checknr
checks a list of
.IR nroff (1)
or
.IR troff (1)
input files for certain kinds of errors
involving mismatched opening and closing delimiters
and unknown commands.
If no files are specified,
.I checknr
checks the standard input.
Delimeters checked are:
.IP (1)
Font changes using \efx ... \efP.
.IP (2)
Size changes using \esx ... \es0.
.IP (3)
Macros that come in open ... close forms, for example,
the .TS and .TE macros which must always come in pairs.
.PP
.I Checknr
knows about the
.IR ms (7)
and
.IR me (7)
macro packages.
.PP
Additional pairs of macros can be added to the list using the
.B \-a
option.
This must be followed by groups of six characters, each group defining
a pair of macros.
The six characters are
a period,
the first macro name,
another period,
and the second macro name.
For example, to define a pair .BS and .ES, use \-\fBa\fP.BS.ES
.PP
The
.B \-c
option defines commands which would otherwise be complained about
as undefined.
.PP
The
.B \-f
option requests
.I checknr
to ignore \ef font changes.
.PP
The
.B \-s
option requests
.I checknr
to ignore \es size changes.
.PP
.I Checknr
is intended to be used on documents that are prepared with
.I checknr
in mind, much the same as
.I lint.
It expects a certain document writing style for \ef and \es commands,
in that each \efx must be terminated with \efP and
each \esx must be terminated with \es0.
While it will work to directly go into the next font or explicitly
specify the original font or point size,
and many existing documents actually do this,
such a practice will produce complaints from
.I checknr.
Since it is probably better to use the \efP and \es0 forms anyway,
you should think of this as a contribution to your document
preparation style.
.SH "SEE ALSO"
.PP
nroff(1), troff(1), checkeq(1), ms(7), me(7)
.SH DIAGNOSTICS
.PP
Complaints about unmatched delimiters.
.br
Complaints about unrecognized commands.
.br
Various complaints about the syntax of commands.
.SH BUGS
.PP
There is no way to define a 1 character macro name using
.BR \-a .
.br
Does not correctly recognize certain reasonable constructs,
such as conditionals.
