.TH CALLS 1 UNSUP
.SH NAME
.PP
calls \- print out calling pattern of a C program
.SH SYNOPSIS
.PP
calls [-aeitv] [-w n] [-f function] [-F function[/file.c]] [-D name[=def]] [-U name] [-I dir] [filenames]
.SH DESCRIPTION
.PP
.I Calls
is intended to help analyze the flow of a program by laying out the
functions called in a hierarchical manner.
.I Calls
invokes the C preprocessor on the named C source files, and outputs
the analyzed calling pattern to standard output.
All filenames given will have their calling sequences combined into
one hierarchy.
If a filename of \- is seen, standard input will be read.
.PP
Functions called but not defined within the source file are shown as:
.br
.RS
function
.RE
.PP
While functions defined in the source files are listed with the file they
are declared in in brackets, as shown:
.br
.RS
function [main.c] , or
.br
function [static in main.c]
.RE
or if the function is not being described
.RS
function [see also %d] , or
.br
function [see below]
.RE
.PP
Recursive references are shown as:
.br
.RS
function <<< recursive >>>
.RE
.PP
For example, given the file
.B prog.c
.br
.RS
.nf
main() {
	abc();
	def();
}
abc() {
	ghi();
	jkl();
}
static mno() { }
ghi() {
	abc();
	def();
	mno();
}
.fi
.RE
.sp
Executing "calls prog.c" will produce:
.sp
.RS
.nf
    1	main [prog.c]
    2		abc [prog.c]
    3			ghi [prog.c]
    4				abc <<< recursive >>>
    5				def
    6				mno [static in prog.c]
    7			jkl
    8		def
.fi
.RE
.SH FLAGS
.PP
.B -a
.br
Normally only the first call to a function is recorded for any
given function, under this option all calls are recorded. This may
make the output for some large programs very verbose and these are
normally not needed to show the calling structure of a program.
.PP
.B -e
.br
Normally an index listing (-i below) does not contain the external
functions called in the program, under this option these are also listed.
Note this option also turns on the indexing option, -i.
.PP
.B "-f function"
.br
The named function will be printed as the root of a calling tree.
.PP
.B "-F function\[/file\]"
.br
The named static function (in the given file) is used as the base of a
calling tree, as above.  This allows closer examination of sources such
as that of dbx(1) that have many functions with the same name.
.PP
.B -h
.br
Display a brief help message.
.PP
.B -i
.br
This option produces an index of all the functions declared in the
processed files. Optionally all functions mentioned can be output;
see -e above.
.PP
.B -t
.br
This option instructs
.I calls
not to display calling trees that were
not explicitly asked for on the command line. Using this option as
well as the index option one can produce just a list of the functions
declared in a file.
.PP
.B -v
.br
Be less verbose in the index output, do not output any defined functions
that were not present in any of the output trees.
Note this also turns on the index option.
For a list of all functions called
by 'missle' one might examine the index output of "calls -vt -f missle *.c".
.PP
.B "-w n"
.br
Set the max indentation width to n.  The default is 96 columns.
.PP
.B "-D name"
.br
.B "-D name=def"
.br
Define the
.I name
for the preprocessor, as if by #define.
If no definition is given, the name is defined as 1.
.PP
.B "-U name"
.br
Remove any initial definition of
.I name
in the preprocessor.
.PP
.B "-I dir"
.br
Change the path for searching for #include files whose names do not
begin with / to look in
.I dir
before looking in the directories on the standard list.
.br
.SH BUGS
.PP
Static functions must be declared (in full) 
.I before
used to work properly.
.br
Output width checking is only done on the first character on a new line.
.SH AUTHOR
.PP
Originally from the net. Major revisions by Kevin Braunsdorf, PUCC.
.SH "SEE ALSO"
.PP
cpp(1), cc(1), ctags(1)
