/*
 * BASIC by Phil Cockcroft
 */
/*
 * terminal specific configuration routines for COHERENT
 */
#include "coherent/conf.h"
#include <sgtty.h>

extern  int     ter_width;
extern  char    noedit;

#ifdef  MCBREAK
static  char    doneset;
#endif

static struct sgttyb ntio, otio;

static  int     got_mode;

setu_term()
{
	ioctl(0,TIOCGETP,(char *)&otio);

	ntio=otio;

	ntio.sg_flags |= CBREAK;
	ntio.sg_flags &= ~ECHO;

	ioctl(0,TIOCSETP,(char *)&ntio);

	if(ter_width <= 0)
		ter_width=DEFPAGE;
	got_mode = 1;
#ifdef MCBREAK
	doneset = 1;
#endif
}

set_term()
{
	if(noedit || !got_mode)
		return;
#ifdef MCBREAK
	if(doneset)
		return;
	doneset = 1;
#endif
	ioctl(0,TIOCSETP,(char *)&ntio);
}

rset_term(type)
{
	if(noedit || !got_mode)
		return;
#ifdef MCBREAK
	if(!type){
		/* in editing loop */
		if(doneset)
			return;
	} else
		doneset = 0;
#endif
	ioctl(0,TIOCSETP,(char *)&otio);
}
