/*
 * Print a line of text in Gothic (Black) Script. Very simple routine,
 * just a lot of data to worry about...
 *
 * Remember to escape all backslashes when editing characters...
 *  -- hyc, 12-29-91
 */

#include <stdio.h>
#include <ctype.h>

struct letter {
	char *lines[9];
} glyphs[96] = {
  {	"  ",	/* space */
	"  ",
	"  ",
	"  ",
	"  ",
	"  ",
	"  ",
	"  ",
	"  " },

  {	"   ",	/* ! bang */
	"/\\ ",
	"\\/ ",
	"}{ ",
	"\\/ ",
	"   ",
	"<> ",
	"   ",
	"   " },

  {	"",	/* " double-quote */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* # sharp */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* $ dollar */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* % per-cent */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* & ampersand */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* ' single quote */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* ( left paren */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* ) right paren */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* * asterisk */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* + plus */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* , comma */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* - hyphen */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"   ",	/* . period */
	"   ",
	"   ",
	"   ",
	"   ",
	"   ",
	"<> ",
	"   ",
	"   " },

  {	"",	/* / slash */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* 0 */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* 1 */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* 2 */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* 3 */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* 4 */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* 5 */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* 6 */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* 7 */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* 8 */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* 9 */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* : */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* ; */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* < */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* = */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* > */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* ? */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",	/* @ */
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },


#ifdef ITALIC
  {	"           ",
	" _--_,     ",
	"   ,\\\\     ",
	"  ~' \\\\    ",
	"   |==\\\\   ",
	"   |   \\\\. ",
	" _---_  \\/ ",
	"(          ",
	"           " },
#else
  {	"  ___    ",
	" -   -_, ",
	"(  ~/||  ",
	"(  / ||  ",
	" \\/==||  ",
	" /_ _||  ",
	"(  - \\\\, ",
	"         ",
	"         " },
#endif

  {	"          ",
	"_-_ _,,   ",
	"   -/  )  ",
	"  ~||_<   ",
	"   || \\\\  ",
	"   ,/--|| ",
	"  _--_-'  ",
	" (        ",
	"          " },

  {	"         ",
	"  ,- _~. ",
	" (' /|   ",
	"((  ||   ",
	"((  ||   ",
	" ( / |   ",
	"  -____- ",
	"         ",
	"         " },

  {	"          ",
	"-_____    ",
	"  ' | -,  ",
	" /| |  |` ",
	" || |==|| ",
	"~|| |  |, ",
	" ~-____,  ",
	"(         ",
	"          " },

  {	"         ",
	"  ,- _~, ",
	" (' /| / ",
	"((  ||/= ",
	"((  ||   ",
	" ( / |   ",
	"  -____- ",
	"         ",
	"         " },

#ifdef ITALIC
  {	"  __    ",
	"_// --_/",
	"  ||    ",
	" ~+|-/  ",
	"  ||    ",
	"  ||    ",
	" ,/     ",
	"        ",
	"        " },
#else
  {	"    _ ,",
	"  ,- - ",
	" _||_  ",
	"' ||   ",
	"  ||   ",
	"  |,   ",
	"_-/    ",
	"       ",
	"       " },
#endif

  {	"    __ ,  ",
	"  ,-| ~   ",
	" ('||/__, ",
	"(( |||  | ",
	"(( |||==| ",
	" ( / |  , ",
	"  -____/  ",
	"          ",
	"          " },

  {	"          ",
	"_-_-      ",
	"  /,      ",
	"  || __   ",
	" ~||-  -  ",
	"  ||===|| ",
	" ( \\_, |  ",
	"       `  ",
	"          " },

  {	"     ",
	"_-_, ",
	"  // ",
	"  || ",
	" ~|| ",
	"  || ",
	"_-_, ",
	"     ",
	"     " },

  {	"      ",
	" _-_,,",
	"(  // ",
	"  _|| ",
	"  _|| ",
	"   || ",
	"-__-, ",
	"      ",
	"      " },

  {	"         ",
	"_-_-,    ",
	"  // ,   ",
	"  ||/\\\\  ",
	" ~|| <   ",
	"  ||/\\\\  ",
	" _-__,\\\\,",
	"         ",
	"         " },

  {	"        ",
	"_-_-    ",
	" /,     ",
	" ||     ",
	"~||     ",
	" ||     ",
	"(  -__, ",
	"        ",
	"        " },

  {	"          ",
	"  /\\\\,/\\\\,",
	" /| || || ",
	" || || || ",
	" ||=|= || ",
	"~|| || || ",
	" |, \\\\,\\\\,",
	"_-        ",
	"          " },

  {	"    __   ",
	"   /  -, ",
	"  ||   ) ",
	" ~||---) ",
	" ~||---, ",
	" ~||  /  ",
	"  |, /   ",
	"-_-  --~ ",
	"         " },

  {	"    __     ",
	"  ,-||-,   ",
	" ('|||  )  ",
	"(( |||--)) ",
	"(( |||--)) ",
	" ( / |  )  ",
	"  -____-   ",
	"           ",
	"           " },

  {	"         ",
	"-__ /\\\\  ",
	"  ||  \\\\ ",
	" /||__|| ",
	" \\||__|| ",
	"  ||  |, ",
	"_-||-_/  ",
	"  ||     ",
	"         " },

  {	"    __     ",
	"  ,-||-,   ",
	" ('|||  )  ",
	"(( |||--)) ",
	"(( |||--)) ",
	" ( / |  )  ",
	"  -____-\\\\ ",
	"           ",
	"           " },

  {	"        ",
	"-__ /\\  ",
	"  || \\, ",
	" /|| /  ",
	" \\||/-  ",
	"  ||  \\ ",
	"_---_-|,",
	"        ",
	"        " },

  {	"        ",
	"  -_-/  ",
	" (_ /   ",
	"(_ --_  ",
	"  --_ ) ",
	" _/  )) ",
	"(_-_-   ",
	"        ",
	"        " },

  {	" ___        ",
	"-   ---___- ",
	"   (' ||    ",
	"  ((  ||    ",
	" ((   ||    ",
	"  (( //     ",
	"    -____-  ",
	"            ",
	"            " },

  {	" _ _    _ ,",
	"- - /  - - ",
	"  ('||  || ",
	" (( ||--|| ",
	" (( ||--|| ",
	" (( /   || ",
	"   -___-\\\\,",
	"           ",
	"           " },

  {	" _      ",
	"- - _-  ",
	"  )-  ) ",
	"  )___) ",
	" ~)___) ",
	"  )  )  ",
	" /-_/   ",
	"        ",
	"        " },

  {	" _        ",
	"- - /, /, ",
	"  )/ )/ ) ",
	"  )__)__) ",
	" ~)__)__) ",
	"  )  )  ) ",
	" /-_/-_/  ",
	"          ",
	"          " },

  {	" _       ",
	"- -    /`",
	"  \\\\  /  ",
	"   \\\\/   ",
	"  ==/\\== ",
	"   / \\\\  ",
	"\\\\/   \\\\,",
	"         ",
	"         " },

  {	"         ",
	"-_   _   ",
	"  |,- `  ",
	" ~||__)) ",
	" ~||__)) ",
	"  |_ _,  ",
	" -' -    ",
	"( _-_    ",
	" -   '   " },

  {	"      ",
	"_-___ ",
	"    / ",
	"   /  ",
	" =/=  ",
	" /    ",
	"/-__- ",
	"      ",
	"      " },

  {	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },
#ifdef ITALIC
  {	"       ",
	"       ",
	"       ",
	" _-_   ",
	"|| \\\\, ",
	"|| ||  ",
	"\\\\/\\\\, ",
	"       ",
	"       " },
#else
  {	"      ",
	"      ",
	"  _   ",
	" < \\, ",
	" /-|| ",
	"(( || ",
	" \\/\\\\ ",
	"      ",
	"      " },
#endif

  {	"      ",
	",,    ",
	"||    ",
	"||/|, ",
	"|| || ",
	"|| |' ",
	"\\\\/   ",
	"      ",
	"      " },

  {	"     ",
	"     ",
	"     ",
	" _-_ ",
	"||   ",
	"||   ",
	"\\\\,/ ",
	"     ",
	"     " },
#ifdef ITALIC
  {	"        ",
	"     ,  ",
	"    ||  ",
	" _-_||  ",
	"|| \\\\|  ",
	"||  ||  ",
	" \\\\/\\\\, ",
	"        ",
	"        " },
#else
  {	"      ",
	" |\\   ",
	"  \\\\  ",
	" / \\\\ ",
	"|| || ",
	"|| || ",
	" \\\\/  ",
	"      ",
	"      " },
#endif
  {	"      ",
	"      ",
	"      ",
	" _-_  ",
	"|| \\\\ ",
	"||/   ",
	"\\\\,/  ",
	"      ",
	"      " },

  {	"     ",
	"  /\\ ",
	" ||  ",
	"=||= ",
	" ||  ",
	" ||  ",
	" \\\\, ",
	"     ",
	"     " },

  {	"      ",
	"      ",
	"  _   ",
	" / \\\\ ",
	"|| || ",
	"|| || ",
	"\\\\_-| ",
	" /  \\ ",
	"'----`" },
#ifdef ITALIC
  {	"      ",
	" ,    ",
	"||    ",
	"||,<> ",
	"|| || ",
	"|| || ",
	"<>,|| ",
	"   |/ ",
	"  ./  " },

  {	"   ",
	"   ",
	"<> ",
	"-_ ",
	"|| ",
	"|| ",
	"\\\\,",
	"   ",
	"   " },
#else
  {	"      ",
	",,    ",
	"||    ",
	"||/\\\\ ",
	"|| || ",
	"|| || ",
	"\\\\ |/ ",
	"  _/  ",
	"      " },

  {	"   ",
	"   ",
	" ' ",
	"\\\\ ",
	"|| ",
	"|| ",
	"\\\\ ",
	"   ",
	"   " },
#endif
  {	"   ",
	"   ",
	" ' ",
	"\\\\ ",
	"|| ",
	"|| ",
	"|| ",
	"|; ",
	"/  " },

  {	"     ",
	",,   ",
	"||   ",
	"||/\\ ",
	"||_< ",
	"|| | ",
	"\\\\,\\ ",
	"     ",
	"     " },

  {	"   ",
	",, ",
	"|| ",
	"|| ",
	"|| ",
	"|| ",
	"\\\\ ",
	"   ",
	"   " },

  {	"         ",
	"         ",
	"         ",
	"\\\\/\\\\/\\\\ ",
	"|| || || ",
	"|| || || ",
	"\\\\ \\\\ \\\\ ",
	"         ",
	"         " },

  {	"      ",
	"      ",
	"      ",
	"\\\\/\\\\ ",
	"|| || ",
	"|| || ",
	"\\\\ \\\\ ",
	"      ",
	"      " },

  {	"      ",
	"      ",
	"      ",
	" /'\\\\ ",
	"|| || ",
	"|| || ",
	"\\\\,/  ",
	"      ",
	"      " },

  {	"      ",
	"      ",
	"      ",
	"-_-_  ",
	"|| \\\\ ",
	"|| || ",
	"||-'  ",
	"|/    ",
	"'     " },

  {	"      ",
	"      ",
	"      ",
	" /'\\\\ ",
	"|| || ",
	"|| || ",
	"\\\\,|| ",
	"   || ",
	"   '` " },

  {	"      ",
	"      ",
	"      ",
	",._-_ ",
	" ||   ",
	" ||   ",
	" \\\\,  ",
	"      ",
	"      " },

  {	"      ",
	"      ",
	"      ",
	" _-_, ",
	"||_.  ",
	" ~ || ",
	",-_-  ",
	"      ",
	"      " },

  {	"     ",
	"  ,  ",
	" ||  ",
	"=||= ",
	" ||  ",
	" ||  ",
	" \\\\, ",
	"     ",
	"     " },

  {	"      ",
	"      ",
	"      ",
	"\\\\ \\\\ ",
	"|| || ",
	"|| || ",
	"\\\\/\\\\ ",
	"      ",
	"      " },

  {	"     ",
	"     ",
	";    ",
	"\\\\/\\ ",
	"|| | ",
	"|| | ",
	"\\\\/  ",
	"     ",
	"     " },

  {	"       ",
	"       ",
	";      ",
	"\\\\/\\/\\ ",
	"|| | | ",
	"|| | | ",
	"\\\\/\\\\/ ",
	"       ",
	"       " },

  {	"      ",
	"      ",
	",     ",
	"\\\\ /` ",
	" \\\\   ",
	" /\\\\  ",
	"/  \\; ",
	"      ",
	"      " },
#ifdef ITALIC
  {	"      ",
	"      ",
	"      ",
	"-_ -_ ",
	"|| || ",
	"|| || ",
	"\\\\,|| ",
	"   |/ ",
	"  ./  " },
#else
  {	"       ",
	"       ",
	"       ",
	"'\\\\/\\\\ ",
	" || ;' ",
	" ||/   ",
	" |/    ",
	"(      ",
	" -_-   " },

#endif
  {	"    ",
	"    ",
	"    ",
	"/\\\\ ",
	" /  ",
	"/\\\\ ",
	" || ",
	" /  ",
	"(,  " },

  {	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" },

  {	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"" }
	};

main(argc,argv)
int argc; char *argv[];
{
	char buffer[256];

	if (argc < 2) { /* read message from stdin */
		while (gets (buffer) != NULL)
			print (buffer);
	} else {
		for (--argc; argc != 1; argc--) {
			argv[argc]--;
			*argv[argc]=' ';
		}
		print (argv[1]);
	}
}

print(buf)
char *buf;
{
	register int i;
	register char *ptr;

	for (i=0; i<9; i++) {
		for (ptr=buf;*ptr;ptr++) {
			if (isprint (*ptr))
				fputs(glyphs[*ptr-' '].lines[i], stdout);
			else
				fputs(glyphs[0].lines[i], stdout);
		}
		putchar('\n');
	}
	putchar('\n');
}
