/* From: amos shapir <amos@cs.huji.ac.il> */
/* modified by Frank Kaefer <fkk@stasys.sta.sub.org> */

/*
 * small banner 8x8 matrix
 */

#include <stdio.h>
extern char chrtab[][8];
#ifdef HEBREW
extern char htab[][8];
#endif HEBREW
#define NMSG	80

main(argc, argv)
char **argv;
{
	register char *sp;
	register int i, j, t, j1, t1;
	static char msg[NMSG];
	int hebrew = 0, shadow = 0;

	while(argc > 1 && argv[1][0] == '-') {
		argc--;
		argv++;
		switch(argv[0][1]) {
#ifdef HEBREW
		case 'h':
			hebrew = 1;
			break;
#endif HEBREW
		case 's':
			shadow = 1;
			break;
		}
	}
	if(argc > 1)
		strncpy(msg, *++argv, NMSG);
	else {
		fputs("Message: ", stderr);
		for(sp=msg, i=0; (*sp++ = getchar())!='\n' && i<NMSG-1; i++)
			;
		*--sp = '\0';
	}

	for (i=0; i<8; i++) {
		if(shadow)
			for (j=i; j<7; j++)
				putchar(' ');
		for (sp = msg; *sp; sp++) {
			if((t = *sp) == '\\') {
				for(t=0,j=0;j<3 && *++sp>='0' && *sp<='7'; j++)
					t = t*8 + *sp - '0';
				if(j == 0) {
					t = *sp;
					if(t == 'h') {
						hebrew = 1;
						continue;
					} else if(t == 'e') {
						hebrew = 0;
						continue;
					}
				} else if(j < 3)
					sp--;
			} else
				t = *sp;
			if(hebrew) {
				if(shadow && i<7)
#ifdef HEBREW
					t1 = htab[t & 037][i+1];
				t = htab[t & 037][i];
#else HEBREW
					;
				;
#endif HEBREW
			} else {
				if(shadow && i<7)
					t1 = chrtab[t & 0177][i+1];
				t = chrtab[t & 0177][i];
			}
			if(shadow) {
				for (j1=0, j=0200; (j|j1)!=0; j1=j, j >>= 1)
					putchar((j&t) ? (j&t1) ? ' ' : '_'
					 : (j1&t) ? '/' : ' ');
			} else {
				for (j=0200; j!=0; j >>= 1)
					putchar((j&t) ? '#' : ' ');
			}
		}
		putchar('\n');
	}
}

/* char generator table from IBM PC */
char chrtab[128][8] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 00 */
	0x7E, 0x81, 0xA5, 0x81, 0xBD, 0x99, 0x81, 0x7E,	/* 01 */
	0x7E, 0xFF, 0xDB, 0xFF, 0xC3, 0xE7, 0xFF, 0x7E,	/* 02 */
	0x6C, 0xFE, 0xFE, 0xFE, 0x7C, 0x38, 0x10, 0x00,	/* 03 */
	0x10, 0x38, 0x7C, 0xFE, 0x7C, 0x38, 0x10, 0x00,	/* 04 */
	0x38, 0x7C, 0x38, 0xFE, 0xFE, 0x7C, 0x38, 0x7C,	/* 05 */
	0x10, 0x10, 0x38, 0x7C, 0xFE, 0x7C, 0x38, 0x7C,	/* 06 */
	0x00, 0x00, 0x18, 0x3C, 0x3C, 0x18, 0x00, 0x00,	/* 07 */
	0xFF, 0xFF, 0xE7, 0xC3, 0xC3, 0xE7, 0xFF, 0xFF,	/* 08 */
	0x00, 0x3C, 0x66, 0x42, 0x42, 0x66, 0x3C, 0x00,	/* 09 */
	0xFF, 0xC3, 0x99, 0xBD, 0xBD, 0x99, 0xC3, 0xFF,	/* 0A */
	0x0F, 0x07, 0x0F, 0x7D, 0xCC, 0xCC, 0xCC, 0x78,	/* 0B */
	0x3C, 0x66, 0x66, 0x66, 0x3C, 0x18, 0x7E, 0x18,	/* 0C */
	0x3F, 0x33, 0x3F, 0x30, 0x30, 0x70, 0xF0, 0xE0,	/* 0D */
	0x7F, 0x63, 0x7F, 0x63, 0x63, 0x67, 0xE6, 0xC0,	/* 0E */
	0x99, 0x5A, 0x3C, 0xE7, 0xE7, 0x3C, 0x5A, 0x99,	/* 0F */
	0x80, 0xE0, 0xF8, 0xFE, 0xF8, 0xE0, 0x80, 0x00,	/* 10 */
	0x02, 0x0E, 0x3E, 0xFE, 0x3E, 0x0E, 0x02, 0x00,	/* 11 */
	0x18, 0x3C, 0x7E, 0x18, 0x18, 0x7E, 0x3C, 0x18,	/* 12 */
	0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x66, 0x00,	/* 13 */
	0x7F, 0xDB, 0xDB, 0x7B, 0x1B, 0x1B, 0x1B, 0x00,	/* 14 */
	0x3E, 0x63, 0x38, 0x6C, 0x6C, 0x38, 0xCC, 0x78,	/* 15 */
	0x00, 0x00, 0x00, 0x00, 0x7E, 0x7E, 0x7E, 0x00,	/* 16 */
	0x18, 0x3C, 0x7E, 0x18, 0x7E, 0x3C, 0x18, 0xFF,	/* 17 */
	0x18, 0x3C, 0x7E, 0x18, 0x18, 0x18, 0x18, 0x00,	/* 18 */
	0x18, 0x18, 0x18, 0x18, 0x7E, 0x3C, 0x18, 0x00,	/* 19 */
	0x00, 0x18, 0x0C, 0xFE, 0x0C, 0x18, 0x00, 0x00,	/* 1A */
	0x00, 0x30, 0x60, 0xFE, 0x60, 0x30, 0x00, 0x00,	/* 1B */
	0x00, 0x00, 0xC0, 0xC0, 0xC0, 0xFE, 0x00, 0x00,	/* 1C */
	0x00, 0x24, 0x66, 0xFF, 0x66, 0x24, 0x00, 0x00,	/* 1D */
	0x00, 0x18, 0x3C, 0x7E, 0xFF, 0xFF, 0x00, 0x00,	/* 1E */
	0x00, 0xFF, 0xFF, 0x7E, 0x3C, 0x18, 0x00, 0x00,	/* 1F */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 20 */
	0x30, 0x78, 0x78, 0x30, 0x30, 0x00, 0x30, 0x00,	/* 21 */
	0x6C, 0x6C, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 22 */
	0x6C, 0x6C, 0xFE, 0x6C, 0xFE, 0x6C, 0x6C, 0x00,	/* 23 */
	0x30, 0x7C, 0xC0, 0x78, 0x0C, 0xF8, 0x30, 0x00,	/* 24 */
	0x00, 0xC6, 0xCC, 0x18, 0x30, 0x66, 0xC6, 0x00,	/* 25 */
	0x38, 0x6C, 0x38, 0x76, 0xDC, 0xCC, 0x76, 0x00,	/* 26 */
	0x60, 0x60, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 27 */
	0x18, 0x30, 0x60, 0x60, 0x60, 0x30, 0x18, 0x00,	/* 28 */
	0x60, 0x30, 0x18, 0x18, 0x18, 0x30, 0x60, 0x00,	/* 29 */
	0x00, 0x66, 0x3C, 0xFF, 0x3C, 0x66, 0x00, 0x00,	/* 2A */
	0x00, 0x30, 0x30, 0xFC, 0x30, 0x30, 0x00, 0x00,	/* 2B */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x60,	/* 2C */
	0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00,	/* 2D */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00,	/* 2E */
	0x06, 0x0C, 0x18, 0x30, 0x60, 0xC0, 0x80, 0x00,	/* 2F */
	0x7C, 0xC6, 0xCE, 0xDE, 0xF6, 0xE6, 0x7C, 0x00,	/* 30 */
	0x30, 0x70, 0x30, 0x30, 0x30, 0x30, 0xFC, 0x00,	/* 31 */
	0x78, 0xCC, 0x0C, 0x38, 0x60, 0xCC, 0xFC, 0x00,	/* 32 */
	0x78, 0xCC, 0x0C, 0x38, 0x0C, 0xCC, 0x78, 0x00,	/* 33 */
	0x1C, 0x3C, 0x6C, 0xCC, 0xFE, 0x0C, 0x1E, 0x00,	/* 34 */
	0xFC, 0xC0, 0xF8, 0x0C, 0x0C, 0xCC, 0x78, 0x00,	/* 35 */
	0x38, 0x60, 0xC0, 0xF8, 0xCC, 0xCC, 0x78, 0x00,	/* 36 */
	0xFC, 0xCC, 0x0C, 0x18, 0x30, 0x30, 0x30, 0x00,	/* 37 */
	0x78, 0xCC, 0xCC, 0x78, 0xCC, 0xCC, 0x78, 0x00,	/* 38 */
	0x78, 0xCC, 0xCC, 0x7C, 0x0C, 0x18, 0x70, 0x00,	/* 39 */
	0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x00,	/* 3A */
	0x00, 0x30, 0x30, 0x00, 0x00, 0x30, 0x30, 0x60,	/* 3B */
	0x18, 0x30, 0x60, 0xC0, 0x60, 0x30, 0x18, 0x00,	/* 3C */
	0x00, 0x00, 0xFC, 0x00, 0x00, 0xFC, 0x00, 0x00,	/* 3D */
	0x60, 0x30, 0x18, 0x0C, 0x18, 0x30, 0x60, 0x00,	/* 3E */
	0x78, 0xCC, 0x0C, 0x18, 0x30, 0x00, 0x30, 0x00,	/* 3F */
	0x7C, 0xC6, 0xDE, 0xDE, 0xDE, 0xC0, 0x78, 0x00,	/* 40 */
	0x30, 0x78, 0xCC, 0xCC, 0xFC, 0xCC, 0xCC, 0x00,	/* 41 */
	0xFC, 0x66, 0x66, 0x7C, 0x66, 0x66, 0xFC, 0x00,	/* 42 */
	0x3C, 0x66, 0xC0, 0xC0, 0xC0, 0x66, 0x3C, 0x00,	/* 43 */
	0xF8, 0x6C, 0x66, 0x66, 0x66, 0x6C, 0xF8, 0x00,	/* 44 */
	0xFE, 0x62, 0x68, 0x78, 0x68, 0x62, 0xFE, 0x00,	/* 45 */
	0xFE, 0x62, 0x68, 0x78, 0x68, 0x60, 0xF0, 0x00,	/* 46 */
	0x3C, 0x66, 0xC0, 0xC0, 0xCE, 0x66, 0x3E, 0x00,	/* 47 */
	0xCC, 0xCC, 0xCC, 0xFC, 0xCC, 0xCC, 0xCC, 0x00,	/* 48 */
	0x78, 0x30, 0x30, 0x30, 0x30, 0x30, 0x78, 0x00,	/* 49 */
	0x1E, 0x0C, 0x0C, 0x0C, 0xCC, 0xCC, 0x78, 0x00,	/* 4A */
	0xE6, 0x66, 0x6C, 0x78, 0x6C, 0x66, 0xE6, 0x00,	/* 4B */
	0xF0, 0x60, 0x60, 0x60, 0x62, 0x66, 0xFE, 0x00,	/* 4C */
	0xC6, 0xEE, 0xFE, 0xFE, 0xD6, 0xC6, 0xC6, 0x00,	/* 4D */
	0xC6, 0xE6, 0xF6, 0xDE, 0xCE, 0xC6, 0xC6, 0x00,	/* 4E */
	0x38, 0x6C, 0xC6, 0xC6, 0xC6, 0x6C, 0x38, 0x00,	/* 4F */
	0xFC, 0x66, 0x66, 0x7C, 0x60, 0x60, 0xF0, 0x00,	/* 50 */
	0x78, 0xCC, 0xCC, 0xCC, 0xDC, 0x78, 0x1C, 0x00,	/* 51 */
	0xFC, 0x66, 0x66, 0x7C, 0x6C, 0x66, 0xE6, 0x00,	/* 52 */
	0x78, 0xCC, 0xE0, 0x70, 0x1C, 0xCC, 0x78, 0x00,	/* 53 */
	0xFC, 0xB4, 0x30, 0x30, 0x30, 0x30, 0x78, 0x00,	/* 54 */
	0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x78, 0x00,	/* 55 */
	0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x78, 0x30, 0x00,	/* 56 */
	0xC6, 0xC6, 0xC6, 0xD6, 0xFE, 0xEE, 0xC6, 0x00,	/* 57 */
	0xC6, 0xC6, 0x6C, 0x38, 0x38, 0x6C, 0xC6, 0x00,	/* 58 */
	0xCC, 0xCC, 0xCC, 0x78, 0x30, 0x30, 0x78, 0x00,	/* 59 */
	0xFE, 0xC6, 0x8C, 0x18, 0x32, 0x66, 0xFE, 0x00,	/* 5A */
	0x78, 0x60, 0x60, 0x60, 0x60, 0x60, 0x78, 0x00,	/* 5B */
	0xC0, 0x60, 0x30, 0x18, 0x0C, 0x06, 0x02, 0x00,	/* 5C */
	0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x78, 0x00,	/* 5D */
	0x10, 0x38, 0x6C, 0xC6, 0x00, 0x00, 0x00, 0x00,	/* 5E */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,	/* 5F */
	0x30, 0x30, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 60 */
	0x00, 0x00, 0x78, 0x0C, 0x7C, 0xCC, 0x76, 0x00,	/* 61 */
	0xE0, 0x60, 0x60, 0x7C, 0x66, 0x66, 0xDC, 0x00,	/* 62 */
	0x00, 0x00, 0x78, 0xCC, 0xC0, 0xCC, 0x78, 0x00,	/* 63 */
	0x1C, 0x0C, 0x0C, 0x7C, 0xCC, 0xCC, 0x76, 0x00,	/* 64 */
	0x00, 0x00, 0x78, 0xCC, 0xFC, 0xC0, 0x78, 0x00,	/* 65 */
	0x38, 0x6C, 0x60, 0xF0, 0x60, 0x60, 0xF0, 0x00,	/* 66 */
	0x00, 0x00, 0x76, 0xCC, 0xCC, 0x7C, 0x0C, 0xF8,	/* 67 */
	0xE0, 0x60, 0x6C, 0x76, 0x66, 0x66, 0xE6, 0x00,	/* 68 */
	0x30, 0x00, 0x70, 0x30, 0x30, 0x30, 0x78, 0x00,	/* 69 */
	0x0C, 0x00, 0x0C, 0x0C, 0x0C, 0xCC, 0xCC, 0x78,	/* 6A */
	0xE0, 0x60, 0x66, 0x6C, 0x78, 0x6C, 0xE6, 0x00,	/* 6B */
	0x70, 0x30, 0x30, 0x30, 0x30, 0x30, 0x78, 0x00,	/* 6C */
	0x00, 0x00, 0xCC, 0xFE, 0xFE, 0xD6, 0xC6, 0x00,	/* 6D */
	0x00, 0x00, 0xF8, 0xCC, 0xCC, 0xCC, 0xCC, 0x00,	/* 6E */
	0x00, 0x00, 0x78, 0xCC, 0xCC, 0xCC, 0x78, 0x00,	/* 6F */
	0x00, 0x00, 0xDC, 0x66, 0x66, 0x7C, 0x60, 0xF0,	/* 70 */
	0x00, 0x00, 0x76, 0xCC, 0xCC, 0x7C, 0x0C, 0x1E,	/* 71 */
	0x00, 0x00, 0xDC, 0x76, 0x66, 0x60, 0xF0, 0x00,	/* 72 */
	0x00, 0x00, 0x7C, 0xC0, 0x78, 0x0C, 0xF8, 0x00,	/* 73 */
	0x10, 0x30, 0x7C, 0x30, 0x30, 0x34, 0x18, 0x00,	/* 74 */
	0x00, 0x00, 0xCC, 0xCC, 0xCC, 0xCC, 0x76, 0x00,	/* 75 */
	0x00, 0x00, 0xCC, 0xCC, 0xCC, 0x78, 0x30, 0x00,	/* 76 */
	0x00, 0x00, 0xC6, 0xD6, 0xFE, 0xFE, 0x6C, 0x00,	/* 77 */
	0x00, 0x00, 0xC6, 0x6C, 0x38, 0x6C, 0xC6, 0x00,	/* 78 */
	0x00, 0x00, 0xCC, 0xCC, 0xCC, 0x7C, 0x0C, 0xF8,	/* 79 */
	0x00, 0x00, 0xFC, 0x98, 0x30, 0x64, 0xFC, 0x00,	/* 7A */
	0x1C, 0x30, 0x30, 0xE0, 0x30, 0x30, 0x1C, 0x00,	/* 7B */
	0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x18, 0x00,	/* 7C */
	0xE0, 0x30, 0x30, 0x1C, 0x30, 0x30, 0xE0, 0x00,	/* 7D */
	0x76, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 7E */
	0x00, 0x10, 0x38, 0x6C, 0xC6, 0xC6, 0xFE, 0x00,	/* 7F */
};
