/*
	Copyright 1988, 1989, 1990, 1991 Chris Lewis
		All Rights Reserved

    See the LICENSE file for a full description of restrictions under which
    this software is provided.

    Ascii-to-postscript converter.  Understands char-backspace-char
    as bold and char-backspace-underline as italic.

    This is compiled twice - once as standalone, and once as part of
    psxlate.
 */

#ifndef	lint
static char SCCSid[] =
    "@(#)asc2ps.c: 2.5 Copyright 91/05/25 21:27:18 Chris Lewis";
#endif

#ifndef	STANDALONE
#include "defs.h"
#else

/*	Configuration section for STANDALONE version of asc2ps (when compiled
	without the rest of psroff 3.0).
 */

#define	NODECMD	"uuname -l"	/* returns your uucp node name, use
				   "echo your-machine-name" if you don't
				   have uuname */
					
#undef	strchr	index		/* define if you don't have strchr() */

#include <stdio.h>
#include <ctype.h>
#include <string.h>		/* change to strings.h if necessary */

/*	Dinna touch from here on */
#define	ALONE
#define	max(a,b)	((a) > (b) ? (a) : (b))

#endif

double height = 11.0;
double width = 8.5;
/*
	12 pitch is 10 point
	10 pitch is 12 point
	16.666 pitch is 120 / 16.6666 = 7.2
*/

#define	POINTPORT	12
#define	POINTLAND	7.2

double pointsize = POINTPORT;

#define	MAXLEN	4096

char _a1[MAXLEN];
char _a2[MAXLEN];
char _a3[MAXLEN];

char *outbufs[3] = {_a1, _a2, _a3};

#define	LPP	66

#define	HMARG	.25
#define	VMARG	.5
#define	RES	72
#define	PORTRAIT	0
#define	LANDSCAPE	1

char *pstrailer = "\004";

int	orient = PORTRAIT;

int	curfont = -1;

char *fontchange[] = {
    "Mainfont setfont",
    "Boldfont setfont",
    "Mainfont setfont"
};

int pagecnt;
int italic;

#define	BUFLEN 4096

#ifndef	ALONE

extern FILE *tempfile;

struct pagedesc {
    unsigned long start;
    unsigned long end;
} pageidx[MAXPAGE], prolog, epilog;

asc2ps(buffer)
register char *buffer; {
    doprolog();
    sendfile(stdin, buffer);
    doepilog();
}

#else

#define	tempfile stdout

char *progname;

main(argc, argv)
int argc; char **argv; {
    register int c, rc = 0;
    extern int errno;
    extern char *sys_errlist[];
    extern int optind;
    extern char *optarg;
    char buffer[BUFLEN];

    progname = argv[0];

    while((c = getopt(argc, argv, "plPLis:")) != EOF)
	switch(c) {
	    case 'l':
		orient = LANDSCAPE;
		height = 8.5;
		width = 11.0;
		pointsize = POINTLAND;
		break;
	    case 'i':
		italic = 1;
		break;
	    case 'L':
		orient = LANDSCAPE;
		height = 8.5;
		width = 14.0;
		pointsize = POINTLAND;
		break;
	    case 'p':
		orient = PORTRAIT;
		height = 11.0;
		width = 8.5;
		pointsize = POINTPORT;
		break;
	    case 'P':
		orient = PORTRAIT;
		height = 14.0;
		width = 8.5;
		pointsize = POINTPORT;
		break;
	    case 's':
		pointsize = atoi(optarg);
		if (pointsize <= 0) {
		    fprintf(stderr, "%s: invalid pointsize %s\n",
			progname, optarg);
		    exit(1);
		}
		break;
	    default:
		fprintf(stderr, "usage: %s [-l|-L|-p|-P]\n", progname);
		exit(1);
    }

    if (optind != argc) {
	for (c = optind; c < argc; c++) {
	    if (access(argv[c], 4)) {
		fprintf(stderr, "%s: Cannot access %s (%s)\n", progname,
		    argv[c], sys_errlist[errno]);
		rc = 1;
	    }
	}
	if (rc)
	    exit(rc);
    }

    if (italic)
	fontchange[2] = "Italfont setfont";

    doprolog();

    if (optind == argc)
	sendfile(stdin, buffer);
    else {
	register FILE *f;
	for (c = optind; c < argc; c++) {
	    if ((f = fopen(argv[c], "r")) == NULL) {
		fprintf(stderr, "%s: huh?  file %s won't open\n",
		    progname, argv[c]);
		exit(1);
	    }
	    sendfile(f, buffer);
	    fclose(f);
	}
    }

    doepilog();

    exit(0);
}
#endif

char nodename[25];

getnodename() {
    FILE *uuname;
    if ((uuname = popen(NODECMD, "r")) == NULL)
	strcpy(nodename, "<noname>");
    else {
	fscanf(uuname, "%s", nodename);
	pclose(uuname);
    }
}

doprolog() {
    extern char *ctime();
    extern char *getlogin();
    extern char *strchr();
    long curtime;
    register char *tp;

    time(&curtime);
    tp = ctime(&curtime);
    *(strchr(tp, '\n')) = '\0';

#ifndef	ALONE
    fseek(tempfile, 0L, 0);
    prolog.start = 0;
#endif

    fprintf(tempfile, "%%!PS-Adobe-1.0\n");
    fprintf(tempfile, "%%%%Title: (stdin)\n");
    fprintf(tempfile, "%%%%Creator: %s %s %s\n", getlogin(), "asc2ps",
	"2.3 91/03/26");
    fprintf(tempfile, "%%%%CreationDate: %s\n", tp);
    fprintf(tempfile, "%%%%For: %s\n", getlogin());
    fprintf(tempfile, "%%%%Pages: (atend)\n");
    fprintf(tempfile,
	"%%%%DocumentFonts: Courier Courier-Oblique Courier-Bold\n");
    fprintf(tempfile, "%%%%EndComments\n");
    getnodename();
    fprintf(tempfile, "(%s@%s %s %s %s\\n) print\n", getlogin(), nodename, tp,
	"asc2ps", "2.3 91/03/26");
    fprintf(tempfile, "/GlobalSave save def\n");
    fprintf(tempfile, "/Mainfont /Courier findfont %.3f scalefont def\n",
	pointsize);
    fprintf(tempfile, "/Boldfont /Courier-Bold findfont %.3f scalefont def\n",
	pointsize);
    fprintf(tempfile,
	"/Italfont /Courier-Oblique findfont %.3f scalefont def\n", pointsize);
    fprintf(tempfile, "/DPS? systemdict /viewclip known def\n");
    fprintf(tempfile, "/ShowPage {\n");
    fprintf(tempfile, "    DPS? {\n");
    fprintf(tempfile,
	"\t(Select other window and hit enter to continue...)%s\n",
	"waitprompt");
    fprintf(tempfile, "    } if\n");
    fprintf(tempfile, "\n");
    fprintf(tempfile, "    showpage\n");
    fprintf(tempfile, "} def\n");
    fprintf(tempfile, "\n");
    fprintf(tempfile, "/waitprompt {\n");
    fprintf(tempfile, "    /Times-Bold findfont 20 scalefont setfont\n");
    fprintf(tempfile, "    0 0 moveto show\n");
    fprintf(tempfile, "    (%%stdin) (r) file\n");
    fprintf(tempfile, "    20 string readline\n");
    fprintf(tempfile, "    pop pop\n");
    fprintf(tempfile, "} def\n");
    fprintf(tempfile, "%%%%EndProlog\n");
#ifndef	ALONE
    prolog.end = ftell(tempfile);
#endif
}

doepilog() {

#ifndef	ALONE
    epilog.start = ftell(tempfile) + 1;
#endif

    fprintf(tempfile, "%%%%Trailer\n");
    /* If in display postscript */
    fprintf(tempfile, "DPS? { (^D to exit\\n) print } if\n");
    fprintf(tempfile, "GlobalSave restore\n");
    fprintf(tempfile, "%%%%Pages: %d\n", pagecnt);

#ifndef	ALONE
    epilog.end = ftell(tempfile);
#endif

#if defined(ALONE) && !defined(NOCONTROLD)
    fputs(pstrailer, tempfile);
#endif
}

sendfile(f, buffer)
register FILE *f;
register char *buffer; {
    register int linecnt = 0;
    register double initypos = (height - VMARG) * RES;
    register double curypos;
    register double curxpos = HMARG * RES;
    register double yincrement = RES * ((height - 2 * VMARG) / LPP);
    int i;
    register int t;
    curypos = initypos;

#ifdef	ALONE
    if (!fgets(buffer, BUFLEN, f))
	return;
#endif

    do {
	register char *p;

	t = strlen(buffer);
	if (buffer[t-1] == '\n')
	    buffer[t-1] = '\0';

	linecnt++;

	if (linecnt > LPP || buffer[0] == '\f') {
	    if (buffer[0] == '\f')
		strcpy(buffer, buffer+1);
	    linecnt = 1;
	    curypos = initypos;
	    pageend();
	}

	if (linecnt == 1)
	    pagestart();

	process(buffer);

	for (i = 0; i < 3; i++) {
	    if (outbufs[i][0]) {
		if (i != curfont) {
		    fprintf(tempfile, "%s\n", fontchange[i]);
		    curfont = i;
		}
		fprintf(tempfile, "%.2f %.2f moveto\n", curxpos, curypos);
		putline(outbufs[i]);
	    }
	}
	curypos -= yincrement;
    } while (fgets(buffer, BUFLEN, f));

    if (linecnt != 0) {
	pageend();
    }
}

#define	NORMAL	0
#define	BOLD	1
#define	UNDERLINE	2

process(buffer, bufs)
char *buffer, *bufs[3]; {
    int maxpos[3];

    register int linepos = 0;
    register int i, len;

    for (i = 0; i < 3; i++) {
	for (len = 0; len < MAXLEN-1; len++)
	    outbufs[i][len] = ' ';
	outbufs[i][MAXLEN-1] = '\0';
	maxpos[i] = 0;
    }

    while(*buffer) {
	switch(*buffer) {
	    case '\r':
		linepos = 0;
		break;
	    case '\b':
		if (linepos) --linepos;
		break;
	    case ' ':
		linepos++;
		break;
	    case '\t':
		linepos += 8;
		linepos &= ~7;
		break;
	    default:
		if (linepos >= MAXLEN - 2) {
		    fprintf(stderr, "%s: line too long\n", progname);
		    exit(1);
		}
		if	(outbufs[NORMAL][linepos] == *buffer) {
		    outbufs[BOLD][linepos] = *buffer;
		    maxpos[BOLD] = max(maxpos[BOLD], linepos+1);
		} else if (*buffer == '_' &&
		    outbufs[NORMAL][linepos] != ' ' ||
		    outbufs[NORMAL][linepos] == '_') {

		    if (*buffer != '_')
			outbufs[NORMAL][linepos] = *buffer;

		    outbufs[UNDERLINE][linepos] = '_';

		    maxpos[UNDERLINE] = max(maxpos[UNDERLINE], linepos+1);
		} else {
		    outbufs[NORMAL][linepos] = *buffer;
		    maxpos[NORMAL] = max(maxpos[NORMAL], linepos+1);
		}
		linepos++;
		break;
	}
	buffer++;
    }
    for (i = 0; i < 3; i++) {
	outbufs[i][maxpos[i]] = '\0';
    }
    for (i = 0; outbufs[BOLD][i]; i++)
	if (outbufs[BOLD][i] != ' ')
	    outbufs[NORMAL][i] = ' ';

    if (italic)
	for (i = 0; outbufs[UNDERLINE][i]; i++)
	    if (outbufs[UNDERLINE][i] != ' ') {
		outbufs[UNDERLINE][i] = outbufs[NORMAL][i];
		outbufs[NORMAL][i] == ' ';
	    }

    len = strlen(outbufs[NORMAL]);
    for (i = len-1; i >= 0; i--)
	if (outbufs[NORMAL][i] != ' ')
	    break;
	else
	    outbufs[NORMAL][i] = '\0';

}

pagestart() {

#ifndef	ALONE
    pageidx[pagecnt].start = ftell(tempfile) + 1;
#endif

    fprintf(tempfile, "%%%%Page: %d %d\n", pagecnt+1, pagecnt+1);
    fprintf(tempfile, "/Pagesave save def\n");
    switch (orient) {
        case LANDSCAPE:
	    fprintf(tempfile, "90 rotate\n");
	    fprintf(tempfile, "0 -%.2f translate\n", height * RES);
	    break;
	case PORTRAIT:
	    break;
    }
    if (curfont != -1)
	fprintf(tempfile, "%s\n", fontchange[curfont]);
}

pageend() {
    fprintf(tempfile, "ShowPage\n");
    fprintf(tempfile, "Pagesave restore\n");
#ifndef	ALONE
    pageidx[pagecnt].end = ftell(tempfile);
#endif
    pagecnt++;
}

putline(s)
register char *s; {
    putc('(', tempfile);
    while(*s) {
	switch(*s) {
	    case '\\':
	    case '(':
	    case ')':
		putc('\\', tempfile);
	    default:
		putc(*s, tempfile);
	}
	s++;
    }
    fprintf(tempfile, ") show\n");
}
