.TH RLAB 1  "5 July 1993" "Version 0.90 beta" "USER COMMANDS"
.\" strings
.ds ex \fIexpr\fR
.SH NAME
RLaB \- matrix oriented, interactive programming environment

.SH SYNOPSIS
.B rlab
[\-\fBdlnpqr]
[file(s)]
[\-]
.SH DESCRIPTION
.B rlab
is an interpreter for the RLaB Programming Language/Environment. 
The RLaB language is useful for matrix or array oriented numerical
analyses. RLaB is especially useful for prototyping and experimenting 
with algorithms.

.B rlab
also provides a convenient
interface to many of the LAPACK,
FFTPACK, and RANLIB subroutines. 

.SH OPTIONS

.TP
\-\fBd
causes a readable form of the internal stack machine's compiled program
to be output to stderr. This option should be used in conjunction with
`-qln' options. This option is not intended for general use.
.TP
\-\fBl
prevents loading of the rlab library of rfiles.
.TP
\-\fBn
prevents line number and file name information from being used in the
internal stack machine codes. This option should only be used with the
`-dlnq'. This option is not intended for general use.
.TP
\-\fBp
prevents rlab from using the specified pager for all output.
.TP
\-\fBq
prevents loading of the startup file
.TP
\-\fBr
prevents usage of the GNU readline library for 
command line editing. 
.TP
\fBfile(s)
are loaded and executed by rlab after the `.rlab' file, and after the
library files.
.TP
\-\fB
forces rlab to go interactive after all the files on the command line
have been executed.

.SH ENVIRONMENT

.B rlab
checks the values of several environment variables upon
startup, and uses them to overide the compiled in defaults. If a
particular environment variable has not been set, the default value is
used.

.B RLAB_RC0
Startup rfile.

.B RLAB_HELP_DIR
The principle directory of help files.

.B RLAB_LIB_DIR
The directory of rfiles to load on startup.

.B RLAB_PAGER
The pager to use for paging help 
files to the screen. usually more(1).

.B RLAB_SEARCH_PATH
The set of directories to search when attempting to load rfiles.

.SH EXECUTION
.B rlab 
is normally executed from a shell command line. Upon startup
.B rlab 
.nf
.sp
Processes the command line options and files.

Executes the `.rlab' file.

Executes any `.r' files in the library directory.

Executes any files specified on the command line.

Goes into interactive mode if no files are specified on the 
command line, or if the `-' option is used.
.sp
.fi
.B rlab
can also be invoked by using the `#!' convention employed by exec(2).
A 
.B rlab
script that begins with a line of the form:
.nf
.sp
	#! pathname [arg]
.sp
.fi
where \fIpathname\fR is the full pathname to the
.B rlab
executable, and \fIarg\fR is optional argument(s). Note that if the
`-' option is not specified
.B rlab
will not go interactive after the script has been executed.

.SH DOCUMENTATION
.B rlab
has an on-line help system, which can be accessed by typing `help'. A
tutorial and a reference manual are currently being worked on.

This man-page was not intended to provide a description of
the language, or rlab's features. Please refer to the manuals, or the
on-line help.

.SH BUGS
Paged output gets hosed after an `out of memory' message. 

.B rlab
implements fprintf(), printf() and sprintf() using the 
C library functions, fprintf, printf and sprintf, so 
.B rlab
inherits any bugs or limitations of the library functions.

Using the load() function on the same line as another expression may
cause the other expression to be ignored. For example:

.nf
.sp
	load ("test.r"); a = 100
.sp
.fi

Will result in the second expression being ignored. This is caused by
the original syntax being used with the new parser/machine capability.
What happens: the tokens for the second expression get wiped out when
the parser is called to start parsing the statements in test.r. The
workaround is simple; don't put calls to load() on the same line as
other expressions. This bug will be fixed in one or two releases.

Send bug reports to: ians@eskimo.com. 

Bug reports should include the rlab version number, a short rfile that
exercises the bug, and a description of the host operating system and
hardware. 

.SH AUTHORS
Ian Searle (ians@eskimo.com)

Phillip Musumeci is the author of the RLaB Tutorial (Not Available Yet)

Brad Hards is the author of the RLaB Reference Manual (Not Available Yet)

Mike Brennan has contributed some code from mawk.

.SH SEE ALSO
.I sh
(1)
.I more
(1)
.I exec
(2)
.PP

