//-------------------------------------------------------------------//

//  Syntax:	toeplitz ( C )
//		toeplitz ( C , R )

//  Description:

//  The toeplitz function returns a non-symmetric Toeplitz matrix
//  having C as its first column and R as its first row. `toeplitz(C)'
//  is a symmetric (or Hermitian) Toeplitz matrix.   

//  See also hankel.r
//-------------------------------------------------------------------//

// dependencies

rfile flipud

toeplitz = function ( c_ , r_ ) 
{
  local(c, r, nc, h, j, nr);

  if (class(c_) != "num") { error ("toeplitz: Inputs must be numeric"); }

  c = c_[:];
  nc = length (c);

  if (!exist (r_)) {
    r = c;
  else
    if (class(r_) != "num") { error ("toeplitz: Inputs must be numeric"); }
    if (length (c_) != length (r_)) 
    {
      error ("toeplitz: Inputs must have the same length");
    }
    r = r_[:];
    if (c[1] != r[1]) 
    {
      error ("toeplitz: First element of row must match first element of column");
    }
  }

  r = flipud (r);
  h = zeros (nc, nc);
  h[;1] = c;
  for (j in 2:nc) 
  {
    h[;j] = [r[nc-j+1:nc-1]; c[1:nc-j+1]];
  }
  return h;
};
