//-------------------------------------------------------------------//

//  Syntax:	save ( )
//		save ( FILE )

//  Description:

//  The save function writes the contents of all the workspace
//  variables to a file. The default file, if none is specified is
//  "SAVE".
//

//-------------------------------------------------------------------//

save = function ( FILE )
{
  local (i);

  if (!exist (FILE))
  {
    FILE = "SAVE";
  }
  for (i in members ($$))
  {
    if (class ($$.[i]) != "function")
    {
      writeb (FILE, $$.[i]);
    }
  }
  close (FILE);
};
