//-------------------------------------------------------------------//
//  intersection

//  Syntax:	intersection ( A , B )

//  Description:

//  Intersection finds the intersection-set of the two vector sets A,
//  and B.

//  See Also: complement, set, union
//-------------------------------------------------------------------//

intersection = function ( A , B )
{
  local (Int, a, b, i, j, tmp)

  if(A.nr == 0 || B.nr == 0) {
    return [];
  }

  if (min (size (A)) != 1) {
    error ("intersection: 1st arg must be a vector");
  }

  if (min (size (B)) != 1) {
    error ("intersection: 2st arg must be a vector");
  }

  a = set (A); b = set (B);
  j = 1;
  for (i in 1:b.n)
  {
    tmp = find (b[i] == a);
    if (tmp.n > 0) 
    {
      Int[j] = b[i];
      j++;
    }
  }
  return Int
};
