//-------------------------------------------------------------------//

//  Syntax:	eval ( S )

//  Description:

//  The eval function evaluates the expression contained in the string
//  argument S. Eval does not return the value of expression. Instead,
//  the expression, or statement is evaluated in a global context. Any
//  assignments, or variable modifications will effect the global
//  symbol table only.

//  Eval, since it evaluates S on the fly, does not have any knowledge
//  of function arguments, or local variables. Thus if you use eval
//  within another function, you must be careful not to reference
//  function arguments or local variables (however, you may use them
//  to construct eval's argument). An example of this type of misuse
//  is presented below.

//  > x = function ( s, a )
//    {
//      eval (s);
//    }
//  >
//  > x ("2*a", 3)
//  ./rlab: a, UNDEFINED
//  near line 2, file: /usr/local/lib/rlab/rlib/eval.r

//  The above example would work if the undefined variable `a' were
//  not referenced. For example we could do:

//  > x ("y = sqrt (3)", NOOP);
//   y =
//       1.73

//  Usually, most things that you would need an eval function for (in
//  another language) can be done with strings, of lists in RLaB.
//-------------------------------------------------------------------//

eval = function ( S )
{
  local (tmpf, tmps);

  if (!exist (S)) { return 0; }
  if (class (S) != "string")
  {
    error ("eval: requires string argument");
  }

  tmpf = tmp_file ();
  fprintf (tmpf, "%s\n", S[1]);
  close (tmpf);
  load (tmpf);
  system ("rm -f " + tmpf);
};
