// house_qr.r
// Given A, with M >= N, the following function finds Householder
// matrices H1,...Hn, such that if Q = H1*...Hn, then Q'*A = R is
// upper triangular.

// House.qr returns a MxN matrix, with the upper triangular part 
// containing [R]

house_qr = function ( A )
{
  local (a, j, n, m, v);

  a = A;
  m = size(A)[1]; n = size(A)[2];
  v = zeros(m,1);

  for(j in 1:n)
  {
    v[j:m] = house.v( a[j:m;j] );
    a[j:m;j:n] = house.row( a[j:m;j:n], v[j:m] );
    if (j < m) 
    {
      a[ (j+1):m;j ] = v[(j+1):m];
    }
  }
  return a
};
