 

 

 

 





 

 






typedef signed char INT8;
typedef unsigned char UINT8;
typedef signed short INT16;
typedef unsigned short UINT16;
typedef signed long INT32;
typedef unsigned long UINT32;

typedef UINT8 BYTE;
typedef UINT16 WORD;
typedef UINT32 DWORD;






























extern BYTE *memory;
extern char *progname;

void init_cpu();
void execute();
void exit_emu();










 
 




 




 






 






 




 




 





 









 





 




 

 




 

 





 

 










 












 




 









 

 












 












 











 










 










 














 






 










 










 












 


















 










 






 






 








 




 






 






 






 







 





























 




 

typedef	long		__off_t;



 




 

typedef	char	      *	__va_list;



 




 

 



 




 

 






typedef	unsigned	__size_t;









 


typedef	__size_t	size_t;








 




 

 













 




 









 












 
typedef long		fpos_t;		 

 
typedef struct	FILE {
	int		_cc;		 
	unsigned char	*_cp;		 
	struct _FILE2	*_f2p;		 
	char		_ff1;		 
	char		_fd;		 
	char		_ff2;		 
	char		_mode;		 
}	FILE;
 
typedef	struct	_FILE2 {
	int		(*_gt)();	 
	int		(*_pt)();	 
	unsigned char	*_bp;		 
	unsigned char	*_dp;		 
	unsigned char	*_ep;		 
	char		*_nm;		 
	int		_uc;		 
}	_FILE2;

 






 
extern	FILE	_iob[3];
extern	FILE	*_fp[60];




 




 



 




 







 







 



int		remove		();
int		rename		();
FILE	      *	tmpfile		();
char	      *	tmpnam		();
int		fclose		();
int		fflush		();
FILE	      *	fopen		();
FILE	      *	freopen		();
void		setbuf		();
int		setvbuf		();
int		fprintf		()
;
int		fscanf		()
;
int		printf		()
;
int		scanf		()
;
int		sprintf		()
;
int		sscanf		()
;
int		vfprintf	();
int		vprintf		();
int		vsprintf	();
int		fgetc		();
char	      *	fgets		();
int		fputc		();
int		fputs		();
int		getc		();
int		getchar		();
char	      *	gets		();
int		putc		();
int		putchar		();
int		puts		();
int		ungetc		();
size_t		fread		();
size_t		fwrite		();
int		fgetpos		();
int		fseek		();
int		fsetpos		();
__off_t		ftell		();
void		rewind		();
void		clearerr	();
int		feof		();
int		ferror		();
void		perror		();

char	      *	ctermid		();



FILE	      *	fdopen		();
int		fileno		();



FILE	      *	popen		();
int		pclose		();






 








 





 

 







extern int mono;

void init_vga();
void vga_off();



 

 





 

 







void init_bios();
void init_timer();
void bios_off();
void set_int();

void disable();
void enable();

void put_scancode();

BYTE read_port60();

void loc();

char *set_boot_file();
char *set_boot_type();



 

 





 

 







































 





































 













extern WORD wregs[8];	     
extern BYTE *bregs[16];      
extern unsigned sregs[4];    

extern unsigned ip;	      

     
extern BYTE CF, PF, ZF, TF, IF, DF;

     
extern unsigned AF, OF, SF;

extern BYTE *c_cs,*c_ds,*c_es,*c_ss,*c_stack;

extern volatile int int_pending;
extern volatile int int_blocked;



 

 





 

 





void new_screen();
void refresh();
void update_display();
void displaychar();
void move_cursor();
void set_cursor_height();
void init_hardware();
void finish_hardware();
void copy_text();

void vga_interrupt();

char *set_update_rate();
char *set_cursor_rate();



 




void start_X();
void end_X();
void process_Xevents();
void flush_X();

void copy();
void draw_char();
void draw_line();
void clear_screen();
void window_size();

void new_cursor();
void put_cursor();
void unput_cursor();

extern int graphics,blink;


 




 

 










int port60_buffer_ok();
void put_scancode();
void init_timer();

void disable();
void enable();

void starttimer();
void stoptimer();

BYTE read_port();
void write_port();








static BYTE *data_segment;    
static BYTE *screen_mem;      



static struct
{
    int cs, ce;
    int sx, sy;
    int colours;
    int pages;
    int base;
    int text;
} defaults[] = 
{
    { 6, 7, 40, 25, 16, 8, 0xb800, (!0) },    
    { 6, 7, 40, 25, 16, 8, 0xb800, (!0) },    
    { 6, 7, 80, 25, 16, 8, 0xb800, (!0) },    
    { 6, 7, 80, 25, 16, 8, 0xb800, (!0) },    
    { 0, 0, 320, 200, 4, 4, 0xb800, 0 },  
    { 0, 0, 320, 200, 4, 4, 0xb800, 0 },  
    { 0, 0, 640, 200, 2, 4, 0xb800, 0 },  
    { 11, 12, 80, 25, 2, 8, 0xb000, (!0) },   
    { 0, 0, 0, 0, 0, 0, 0, 0 },           
    { 0, 0, 0, 0, 0, 0, 0, 0 },           
    { 0, 0, 0, 0, 0, 0, 0, 0 },           
    { 0, 0, 0, 0, 0, 0, 0, 0 },           
    { 0, 0, 0, 0, 0, 0, 0, 0 },           
    { 0, 0, 320, 200, 16, 8, 0xa000, 0 }, 
    { 0, 0, 640, 200, 16, 4, 0xa000, 0 }, 
    { 0, 0, 640, 350, 2, 2, 0xa000, 0 },  
    { 0, 0, 640, 350, 16, 2, 0xa000, 0 }, 
    { 0, 0, 640, 480, 2, 1, 0xa000, 0 },  
    { 0, 0, 640, 480, 16, 1, 0xa000, 0 }, 
    { 0, 0, 320, 200, 256, 1, 0xa000, 0 }, 
};

int mono;                     

 


























static int cur_emulate = (!0);
static int pages;             




static BYTE functionality[] = 
{
    0xff,                
    0x00,                
    0x00,                
    0,0,0,0,             
    0x04,                
    0x01,                
    0x01,                
    0x04+0x08+0x16,      
    0x04+0x08,           
    0,0,                 
    0x00,                
    0x00,                
};


 BYTE *get_offset(page)
# 1060 
int page;
{
    return &screen_mem[((*(WORD *)((data_segment)+(WORD)(0x4c)))* page) + (2 * (((BYTE)(data_segment)[(WORD)(0x50+(page << 1))])+
                                                  ((BYTE)(data_segment)[(WORD)(0x51+(page << 1))])*(*(WORD *)((data_segment)+(WORD)(0x4a)))))];
}


 void clearscr(x1,y1,x2,y2,attr)
# 1067 
int x1;
# 1067 
int y1;
# 1067 
int x2;
# 1067 
int y2;
# 1067 
int attr;
{
    BYTE *scr = &screen_mem[(*(WORD *)((data_segment)+(WORD)(0x4e)))];
    int x,y;
    unsigned width = (*(WORD *)((data_segment)+(WORD)(0x4a)));

    for (y = y1; y <= y2; y++)
    {
        for (x = x1; x <= x2; x++)
        {
            scr[2*(x+y*width)] = ' ';
            scr[2*(x+y*width)+1] = (BYTE)attr;
        }
    }
    update_display();
}


 void scroll(x1,y1,x2,y2,num,attr)
# 1085 
int x1;
# 1085 
int y1;
# 1085 
int x2;
# 1085 
int y2;
# 1085 
int num;
# 1085 
int attr;
{
    int x,y;
    unsigned width = (*(WORD *)((data_segment)+(WORD)(0x4a)));
    BYTE *scr;

    if (x1 > x2 || y1 > y2)
        return;

    scr = &screen_mem[(*(WORD *)((data_segment)+(WORD)(0x4e)))];

    if (num == 0 || y2-y1 < abs(num))
    {
        clearscr(x1,y1,x2,y2,attr);
        return;
    }

    if (num > 0)
    {
        disable();     
        for (y = y1; y <= y2-num; y++)
            for (x = x1; x <= x2; x++)
            {
                scr[2*(x+y*width)] = scr[2*(x+(y+num)*width)];
                scr[2*(x+y*width)+1] = scr[2*(x+(y+num)*width)+1];
            }
        y = y2-num+1;
        copy_text(x1,y1+num,x2,y2,x1,y1);
        enable();
    }
    else
    {
        num = -num;
        disable();     
        for (y = y2-num; y >= y1; y--)
            for (x = x1; x <= x2; x++)
            {
                scr[2*(x+(y+num)*width)] = scr[2*(x+y*width)];
                scr[2*(x+(y+num)*width)+1] = scr[2*(x+y*width)+1];
            }
        y = y1;
        copy_text(x1,y1,x2,y2-num,x1,y1+num);
        enable();     
    }
    clearscr(x1,y,x2,y+num-1,attr);
}


void set_cursor_type(start,end)
# 1133 
unsigned start;
# 1133 
unsigned end;
{
    if (start == 0x20)
        set_cursor_height(0,-1);
    else
    {
        start &= 0x1f;
        end &= 0x1f;

        ((data_segment)[(WORD)(0x61)] = (BYTE)(start));
        ((data_segment)[(WORD)(0x60)] = (BYTE)(end));
        if (cur_emulate && ((BYTE)(data_segment)[(WORD)(0x49)])<= 3 && start <= 8 && end <= 8)
        {
            start = ((*(WORD *)((data_segment)+(WORD)(0x85)))*start)/8;
            end = ((*(WORD *)((data_segment)+(WORD)(0x85)))*end)/8;
        }
        set_cursor_height(start,end);
    }
}


 void set_mode(mode)
# 1154 
int mode;
{
    if (mode < (sizeof defaults/sizeof defaults[0]))
    {
        if (!mono || (defaults[mode].colours <= 2 && mono))
        {
            int i;

            if (!defaults[mode].text)
                return;
            ((data_segment)[(WORD)(0x49)] = (BYTE)(mode));
            (*(WORD *)((data_segment)+(WORD)(0x4a))= (WORD)(defaults[mode].sx));
            ((data_segment)[(WORD)(0x84)] = (BYTE)(defaults[mode].sy-1));
            (*(WORD *)((data_segment)+(WORD)(0x4c))= (WORD)(defaults[mode].sx * defaults[mode].sy * 2));
            ((data_segment)[(WORD)(0x62)] = (BYTE)(0));
            (*(WORD *)((data_segment)+(WORD)(0x4e))= (WORD)(0));
            if (mode == 0x7)
                (*(WORD *)((data_segment)+(WORD)(0x63))= (WORD)(0x3b4));
            else
                (*(WORD *)((data_segment)+(WORD)(0x63))= (WORD)(0x3d4));
            pages = defaults[mode].pages;
            for (i = 0; i < pages; i++)
            {
                ((data_segment)[(WORD)(0x50+(i << 1))] = (BYTE)(0));
                ((data_segment)[(WORD)(0x51+(i << 1))] = (BYTE)(0));
            }
            (*(WORD *)((data_segment)+(WORD)(0x85))= (WORD)(16));
            set_cursor_type(defaults[mode].cs,defaults[mode].ce);
            move_cursor(0,0);
            screen_mem = &memory[defaults[mode].base << 4];
            new_screen((*(WORD *)((data_segment)+(WORD)(0x4a))),((BYTE)(data_segment)[(WORD)(0x84)])+1,screen_mem);
        }
    }
}


 void display_message()
{
    static char message1[] =
        "PC Emulator v1.01alpha (C) 1994 University of Bristol";
    static char message2[] =
        "Please report comments, bugs etc to hedley@cs.bris.ac.uk";
    BYTE *mem = get_offset(0);
    int i;

    disable();

    for (i = 0; i < sizeof message1-1; i++)
        mem[i<<1] = message1[i];

    for (i = 0; i < sizeof message2-1; i++)
        mem[(i+80)<<1] = message2[i];

    ((data_segment)[(WORD)(0x50+(0 << 1))] = (BYTE)(0));
    ((data_segment)[(WORD)(0x51+(0 << 1))] = (BYTE)(4));
    move_cursor(((BYTE)(data_segment)[(WORD)(0x50+(0 << 1))]),((BYTE)(data_segment)[(WORD)(0x51+(0 << 1))]));
    enable();

}


 void fill_in_functionality()
{
    WORD tmp = (WORD)(wregs[7]);
    (*(WORD *)((c_es)+(WORD)(tmp))= (WORD)(0x2000));
    tmp += 2;
    (*(WORD *)((c_es)+(WORD)(tmp))= (WORD)(0xf000));
    tmp += 2;
    ((c_es)[(WORD)(tmp)] = (BYTE)(((BYTE)(data_segment)[(WORD)(0x49)])));
    tmp++;
    (*(WORD *)((c_es)+(WORD)(tmp))= (WORD)((*(WORD *)((data_segment)+(WORD)(0x4a)))));
    tmp += 2;
    (*(WORD *)((c_es)+(WORD)(tmp))= (WORD)((*(WORD *)((data_segment)+(WORD)(0x4c)))));
    tmp += 2;
    (*(WORD *)((c_es)+(WORD)(tmp))= (WORD)((*(WORD *)((data_segment)+(WORD)(0x4c)))* ((BYTE)(data_segment)[(WORD)(0x62)])));
    tmp += 2;
    
    ((c_es)[(WORD)(tmp)] = (BYTE)(((BYTE)(data_segment)[(WORD)(0x51+(0 << 1))])));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(((BYTE)(data_segment)[(WORD)(0x50+(0 << 1))])));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(((BYTE)(data_segment)[(WORD)(0x51+(1 << 1))])));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(((BYTE)(data_segment)[(WORD)(0x50+(1 << 1))])));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(((BYTE)(data_segment)[(WORD)(0x51+(2 << 1))])));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(((BYTE)(data_segment)[(WORD)(0x50+(2 << 1))])));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(((BYTE)(data_segment)[(WORD)(0x51+(3 << 1))])));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(((BYTE)(data_segment)[(WORD)(0x50+(3 << 1))])));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(((BYTE)(data_segment)[(WORD)(0x51+(4 << 1))])));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(((BYTE)(data_segment)[(WORD)(0x50+(4 << 1))])));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(((BYTE)(data_segment)[(WORD)(0x51+(5 << 1))])));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(((BYTE)(data_segment)[(WORD)(0x50+(5 << 1))])));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(((BYTE)(data_segment)[(WORD)(0x51+(6 << 1))])));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(((BYTE)(data_segment)[(WORD)(0x50+(6 << 1))])));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(((BYTE)(data_segment)[(WORD)(0x51+(7 << 1))])));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(((BYTE)(data_segment)[(WORD)(0x50+(7 << 1))])));
    tmp++;
    
    ((c_es)[(WORD)(tmp)] = (BYTE)(((BYTE)(data_segment)[(WORD)(0x61)])));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(((BYTE)(data_segment)[(WORD)(0x60)])));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(((BYTE)(data_segment)[(WORD)(0x62)])));
    tmp++;
    
    (*(WORD *)((c_es)+(WORD)(tmp))= (WORD)((*(WORD *)((data_segment)+(WORD)(0x63)))));
    tmp += 2;
    
    ((c_es)[(WORD)(tmp)] = (BYTE)(0));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(0));
    tmp++;
 
    ((c_es)[(WORD)(tmp)] = (BYTE)(((BYTE)(data_segment)[(WORD)(0x84)])+1));
    tmp++;
    (*(WORD *)((c_es)+(WORD)(tmp))= (WORD)((*(WORD *)((data_segment)+(WORD)(0x85)))));
    tmp += 2;
    ((c_es)[(WORD)(tmp)] = (BYTE)(mono ? 7 : 8));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(0));
    tmp++;
    (*(WORD *)((c_es)+(WORD)(tmp))= (WORD)(mono ? 0 : 256));
    tmp += 2;
    ((c_es)[(WORD)(tmp)] = (BYTE)(defaults[((BYTE)(data_segment)[(WORD)(0x49)])].pages));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(0x02));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(0));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(0));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(mono ? 4 : 0));
    tmp++;
    (*(WORD *)((c_es)+(WORD)(tmp))= (WORD)(0));
    tmp += 2;
    ((c_es)[(WORD)(tmp)] = (BYTE)(0));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(3));
    tmp++;
    ((c_es)[(WORD)(tmp)] = (BYTE)(1));
}


 void int_video()
{
    unsigned page, al;
    unsigned height, width;
    
    ;

    ;
    page = *bregs[7];
    al = *bregs[0];
    height = ((BYTE)(data_segment)[(WORD)(0x84)]);
    width = (*(WORD *)((data_segment)+(WORD)(0x4a)))-1;

    switch(*bregs[4])
    {
    case 0:      
        set_mode(al & 0x7f);
        if ((al & 0x80)== 0)
            clearscr(0,0,width,height,0x07);
        break;
    case 1:      
        set_cursor_type(*bregs[5],*bregs[1]);
        break;
    case 2:      
        if (page < pages)
        {
            ((data_segment)[(WORD)(0x50+(page << 1))] = (BYTE)(*bregs[2]));
            ((data_segment)[(WORD)(0x51+(page << 1))] = (BYTE)(*bregs[6]));
            move_cursor(((BYTE)(data_segment)[(WORD)(0x50+(page << 1))]),((BYTE)(data_segment)[(WORD)(0x51+(page << 1))]));
        }
        break;
    case 3:      
        if (page < pages)
        {
            *bregs[5] = ((BYTE)(data_segment)[(WORD)(0x61)]);
            *bregs[1] = ((BYTE)(data_segment)[(WORD)(0x60)]);
            *bregs[2] = ((BYTE)(data_segment)[(WORD)(0x50+(page << 1))]);
            *bregs[6] = ((BYTE)(data_segment)[(WORD)(0x51+(page << 1))]);
        }
        break;
    case 4:      
        *bregs[4] = 0;
        wregs[3] = wregs[1] = wregs[2] = 0;
        break;
    case 5:      
        if (al < pages)
        {
            ((data_segment)[(WORD)(0x62)] = (BYTE)(al));
            (*(WORD *)((data_segment)+(WORD)(0x4e))= (WORD)(al*(*(WORD *)((data_segment)+(WORD)(0x4c)))));
            new_screen(width+1,height+1,&screen_mem[(*(WORD *)((data_segment)+(WORD)(0x4c)))*(al)]);
            update_display();
        }
        break;
    case 6:      
        scroll(*bregs[1],*bregs[5],*bregs[2],*bregs[6],al,*bregs[7]);
        break;
    case 7:      
        scroll(*bregs[1],*bregs[5],*bregs[2],*bregs[6],-al,*bregs[7]);
        break;
    case 8:      
        if (page < pages)
        {
            BYTE *pos = get_offset(page);
            
            *bregs[0] = *pos++;
            *bregs[4] = *pos;
        }
        break;
    case 9:      
        if (page < pages)
        {
            BYTE *pos = get_offset(page);
            unsigned i, count;
            
            count = (WORD)(wregs[1]);
            for (i = count; i > 0; i--)
            {
                *pos++ = al;
                *pos++ = *bregs[3];
            }
            if (count > 1)
                update_display();
            else
                if (count == 1)
                    displaychar();
        }
        break;
    case 0x0a:   
        if (page < pages)
        {
            BYTE *pos = get_offset(page);
            unsigned i, count;

            count = (WORD)(wregs[1]);
            for (i = count; i > 0; i--)
                *pos++ = al;

            if (count > 1)
                update_display();
            else
                if (count == 1)
                    displaychar();
        }
        break;

    case 0x0b:   
        break;
    case 0x0e:   
        if (page < pages)
        {
            BYTE *pos = get_offset(page);
            int x,y;

            x = ((BYTE)(data_segment)[(WORD)(0x50+(page << 1))]);
            y = ((BYTE)(data_segment)[(WORD)(0x51+(page << 1))]);
            switch(al)
            {
            case 0x0a:   
                y++;
                break;
            case 0x0d:   
                x = 0;
                break;
            case 0x8:    
                x--;
                break;
            case 0x7:    
                fprintf((&_iob[2]),"\007");
                fflush((&_iob[2]));
                break;
            default:
                *pos = al;
                x++;
                displaychar();
            }
            if (x > width)
            {
                x = 0;
                y++;
            }
            if (x < 0)
            {
                x = width;
                y--;
            }
            if (y > height)
            {
                BYTE attr;
                y = height;
                attr = screen_mem[(*(WORD *)((data_segment)+(WORD)(0x4c)))*(page+1) -1];
                scroll(0,0,width,y,1,attr);
            }
            if (y < 0)
            {
                y = 0;
                scroll(0,0,width,height,-1,7);
            }
            ((data_segment)[(WORD)(0x50+(page << 1))] = (BYTE)(x));
            ((data_segment)[(WORD)(0x51+(page << 1))] = (BYTE)(y));
            move_cursor(x,y);
        }
        break;
    case 0x0f:   
        *bregs[0] = ((BYTE)(data_segment)[(WORD)(0x49)]);
        *bregs[4] = width+1;
        *bregs[7] = ((BYTE)(data_segment)[(WORD)(0x62)]);
        break;
    case 0x10:   
        break;
    case 0x11:   
        switch(*bregs[0])
        {
        case 0x02:       
        case 0x12:
            height = 49;
            ((data_segment)[(WORD)(0x84)] = (BYTE)(height));
            (*(WORD *)((data_segment)+(WORD)(0x4c))= (WORD)((width+1)* (height+1)* 2));
            new_screen(width+1,height+1,screen_mem);
            clearscr(0,0,width,height,0x07);
            break;
        case 0x30:       
            switch(*bregs[7])
            {
            default:
                wregs[1] = (WORD)(16);
                *bregs[2] = height;
                sregs[0] = 0xf000;
                c_es = (&memory[sregs[0] << 4]);
                wregs[5] = (WORD)(0);
            }
            break;
        default:
            printf("Unimplemented int 0x10 function 0x11 sub-function %02X\n",*bregs[0]);

            break;
        }
        break;
    case 0x12:   
        switch(*bregs[3])
        {
        case 0x10:       
            *bregs[7] = mono;
            *bregs[3] = 3;
            wregs[1] = (WORD)(0);
            break;
        case 0x30:       
            *bregs[0] = 0x12;
            break;
        case 0x34:       
            cur_emulate = *bregs[0] == 0;
            *bregs[0] = 0x12;
            break;
        default:
            printf("Unimplemented int 10 function 0x12 sub-function 0x%02X\n",*bregs[3]);

            break;
        }
        break;
    case 0x1a:   
        if (*bregs[0] == 0)
        {
            *bregs[3] = mono ? 7 : 8; 
            *bregs[7] = 0;
            *bregs[0] = 0x1a;
        }
        break;
    case 0x1b:   
        fill_in_functionality();
        *bregs[0] = 0x1b;
        break;
    case 0x30:   
    case 0x4f:   
    case 0x6f:   
    case 0xcc:   
    case 0xef:   
    case 0xfa:   
    case 0xfe:   
    case 0xff:   
        break;
    default:
        printf("Unimplemented int 10 function: %02X. AL = %02X  BL = %02X\n",
*bregs[4],*bregs[0],*bregs[3]);

        break;
    }
}

void init_vga()
{
    int mode = mono ? 7 : 3;
    static BYTE afterint[] =
    {
        0xfb, 0xca, 0x02, 0x00
    };

    init_hardware();

    screen_mem = &memory[defaults[mode].base << 4];
    data_segment = &memory[0x00400];

    memcpy(&memory[0xf0000+0x2000],functionality,sizeof functionality);

    set_mode(mode);
    clearscr(0,0,(*(WORD *)((data_segment)+(WORD)(0x4a)))-1,((BYTE)(data_segment)[(WORD)(0x84)]),0x07);
    set_int(0x10,0,0,int_video,afterint,sizeof afterint);
    display_message();
}

void vga_off()
{
    finish_hardware();
}
