 

 

 

 





 

 






typedef signed char INT8;
typedef unsigned char UINT8;
typedef signed short INT16;
typedef unsigned short UINT16;
typedef signed long INT32;
typedef unsigned long UINT32;

typedef UINT8 BYTE;
typedef UINT16 WORD;
typedef UINT32 DWORD;






























extern BYTE *memory;
extern char *progname;

void init_cpu();
void execute();
void exit_emu();










 
 




 




 






 






 




 




 





 









 





 




 

 




 

 





 

 










 












 




 









 

 












 












 











 










 










 














 






 










 










 












 


















 










 






 






 








 




 






 






 






 







 





























 




 

typedef	long		__off_t;



 




 

typedef	char	      *	__va_list;



 




 

 



 




 

 






typedef	unsigned	__size_t;









 


typedef	__size_t	size_t;








 




 

 













 




 









 












 
typedef long		fpos_t;		 

 
typedef struct	FILE {
	int		_cc;		 
	unsigned char	*_cp;		 
	struct _FILE2	*_f2p;		 
	char		_ff1;		 
	char		_fd;		 
	char		_ff2;		 
	char		_mode;		 
}	FILE;
 
typedef	struct	_FILE2 {
	int		(*_gt)();	 
	int		(*_pt)();	 
	unsigned char	*_bp;		 
	unsigned char	*_dp;		 
	unsigned char	*_ep;		 
	char		*_nm;		 
	int		_uc;		 
}	_FILE2;

 






 
extern	FILE	_iob[3];
extern	FILE	*_fp[60];




 




 



 




 







 







 



int		remove		();
int		rename		();
FILE	      *	tmpfile		();
char	      *	tmpnam		();
int		fclose		();
int		fflush		();
FILE	      *	fopen		();
FILE	      *	freopen		();
void		setbuf		();
int		setvbuf		();
int		fprintf		()
;
int		fscanf		()
;
int		printf		()
;
int		scanf		()
;
int		sprintf		()
;
int		sscanf		()
;
int		vfprintf	();
int		vprintf		();
int		vsprintf	();
int		fgetc		();
char	      *	fgets		();
int		fputc		();
int		fputs		();
int		getc		();
int		getchar		();
char	      *	gets		();
int		putc		();
int		putchar		();
int		puts		();
int		ungetc		();
size_t		fread		();
size_t		fwrite		();
int		fgetpos		();
int		fseek		();
int		fsetpos		();
__off_t		ftell		();
void		rewind		();
void		clearerr	();
int		feof		();
int		ferror		();
void		perror		();

char	      *	ctermid		();



FILE	      *	fdopen		();
int		fileno		();



FILE	      *	popen		();
int		pclose		();






 








 




 




 



 



 



 




 

 



 




 

 






typedef	long		__time_t;









typedef	__time_t	time_t;






 




 

 



 




 

 






typedef	long		__clock_t;








typedef __clock_t	clock_t;





 




 

 














 




 

struct tm {
	int	tm_sec;
	int	tm_min;
	int	tm_hour;
	int	tm_mday;
	int	tm_mon;
	int	tm_year;
	int	tm_wday;
	int	tm_yday;
	int	tm_isdst;
};






clock_t		clock		();
double		difftime	();
time_t		mktime		();
time_t		time		();
char	      *	asctime		();
char	      *	ctime		();
struct tm     *	gmtime		();
struct tm     *	localtime	();
__size_t	strftime	();





extern	char	      *	tzname[2];



extern	long		timezone;






 




 



 



 




 

 









typedef struct timeval {
	__time_t	tv_sec;
	long		tv_usec;
} __timestruc_t;






 

 



 



 




typedef __timestruc_t	timestruc_t;






 




 



 



 




 

typedef	long		__pid_t;



 



 



 




 



 




 

 




















































 


















 











 




  

 



 




 






 




 











 











 






  











  









 


























 



 












 




 









 









 

 




 

typedef	void	__sighand_t	();


 

typedef	unsigned long		__sigmask_t;



typedef	struct {
	__sigmask_t	_sigbits [4];
} n_sigset_t;



typedef	struct {
	__sigmask_t	_sigbits [1];
} o_sigset_t;




typedef struct {
	__sigmask_t	_sigbits [(((31)- 1U + ((4 * 8U)))/ ((4 * 8U)))];
} __sigset_t;






 

enum {
	__SA_ONSTACK	= 1,
	__SA_RESETHAND	= 2,
	__SA_RESTART	= 4,
	__SA_SIGINFO	= 8,
	__SA_NODEFER	= 16
};
typedef	unsigned short	__sigactfl_t;


 

enum {
	__SF_NOCLDWAIT	= 1,
	__SF_NOCLDSTOP	= 2
};

typedef	unsigned short	__sigmiscfl_t;


 

















 








































 











typedef	o_sigset_t	sigset_t;

struct sigaction {
	__sighand_t   *	sa_handler;
	sigset_t	sa_mask;
	int		sa_flags;
};





 










typedef	long	sig_atomic_t;




__sighand_t   *	signal		();
int		raise		();

__sighand_t   *	sigset		();
int		sighold		();
int		sigignore	();
int		sigrelse	();
int		sigpause	();



int		kill		();
int		sigaction	();
int		sigaddset	();
int		sigdelset	();
int		sigemptyset	();
int		sigfillset	();
int		sigismember	();
int		sigpending	();
int		sigprocmask	();
int		sigsuspend	();



 
















 




 

 










int port60_buffer_ok();
void put_scancode();
void init_timer();

void disable();
void enable();

void starttimer();
void stoptimer();

BYTE read_port();
void write_port();



 

 





 

 







































 





































 













extern WORD wregs[8];	     
extern BYTE *bregs[16];      
extern unsigned sregs[4];    

extern unsigned ip;	      

     
extern BYTE CF, PF, ZF, TF, IF, DF;

     
extern unsigned AF, OF, SF;

extern BYTE *c_cs,*c_ds,*c_es,*c_ss,*c_stack;

extern volatile int int_pending;
extern volatile int int_blocked;



 

 





 

 





void new_screen();
void refresh();
void update_display();
void displaychar();
void move_cursor();
void set_cursor_height();
void init_hardware();
void finish_hardware();
void copy_text();

void vga_interrupt();

char *set_update_rate();
char *set_cursor_rate();






static double ticks_per_second = (1193180.0/65536.0);
 

static volatile int disable_int;
static volatile int timer_blocked = 1;



static BYTE port60buffer[5];
static int port60start, port60end;

static unsigned PIC_inservice;
static unsigned PIC_irq;
static unsigned PIC_mask = ~(1|2);

static unsigned timer_tmp;

static unsigned VGA_status;

static void PIC_interrupt()
{
    if (PIC_inservice)
    {
        ;
        return;
    }

    if (PIC_irq & ~PIC_mask & 1)
    {
        ;
        PIC_inservice = 1;
        PIC_irq &= ~1;
        if (IF)
            int_pending = 8;
        else
        {
            ;
            int_blocked = 8;
        }
    }
    else if (PIC_irq & ~PIC_mask & 2)
    {
        ;
        PIC_inservice = 2;
        PIC_irq &= ~2;
        if (IF)
            int_pending = 9;
        else
        {
            ;
            int_blocked = 9;
        }
    }
}


 void PIC_flagint(interrupt)
# 1663 
unsigned interrupt;
{
    disable();
    ;
    PIC_irq |= interrupt;
    enable();
}


void PIC_EOI()
{
    disable();

    if (PIC_inservice & 2)
    {
        if (++port60start >= 5)
            port60start = 0;

        if (port60start != port60end)
            PIC_irq |= 2;
    }


    PIC_inservice = 0;
	PIC_interrupt();
    enable();
}


int port60_buffer_ok(count)
# 1692 
int count;
{
    int tmp = port60end;

    for (; count > 0; count--)
    {
        if (++tmp >= 5)
            tmp = 0;

        if (tmp == port60start)
            return 0;
    }

    return (!0);
}


void put_scancode(code,count)
# 1709 
BYTE *code;
# 1709 
int count;
{
    for (; count > 0; count--)
    {
        port60buffer[port60end] = *code++;

        if (++port60end >= 5)
            port60end = 0;
    }

    PIC_flagint(2);

    
}


 BYTE read_port60()
{
    BYTE ret;
    static BYTE lastread = 0;

    disable();

    if (port60start == port60end)
        ret = lastread;
    else
        lastread = ret = port60buffer[port60start];
        
    enable();

    return ret;
}





void timer_handler(sig)
# 1746 
int sig;
{


    static  int8_counter = 1;




    if (disable_int)
    {
        ;
        timer_blocked++;
        return;
    }

    disable();

    vga_interrupt();

    timer_tmp++;

    if (--int8_counter == 0)
    {
        PIC_flagint(1);

        int8_counter = 1;

    }

    PIC_interrupt();

    enable();
    init_timer();
    return;
}






void init_timer()
{
 
    sigset(14,timer_handler);
    alarm (1 );
     
}


void stoptimer()
{
 
    alarm(0);
    sigset(14,((__sighand_t *)1));
}


void starttimer()
{
    init_timer();
}


void disable()
{
    if (disable_int == 0)
        timer_blocked = 0;
    disable_int++;
}


void enable()
{
    if (disable_int > 0)
        disable_int--;

    if (disable_int == 0)
        while (timer_blocked > 0)
        {
            timer_blocked--;
            timer_handler(14);
        }
}


static int PIT_toggle = 1;

BYTE read_port(port)
# 1835 
unsigned port;
{
    BYTE val;
    static unsigned timer_tmp;

    switch(port)
    {
    case 0x21:
        val = PIC_mask;
        break;
    case 0x40:
    case 0x41:
    case 0x42:
        disable();
        if ((PIT_toggle = !PIT_toggle)== 0)
            val = timer_tmp & 0xff;
        else
        {
            val = (timer_tmp & 0xff00) >> 8;
            timer_tmp++;
        }
        enable();
        break;
    case 0x60:
        val = read_port60();
        break;
    case 0x61:
        val = 0xd0;
        break;
    case 0x3da:
        val = VGA_status;
        VGA_status ^= 0x9;
        break;
    default:
        val = 0;
        break;
    }
    
    ;
    return val;
}


void write_port(port,value)
# 1878 
unsigned port;
# 1878 
BYTE value;
{
    switch(port)
    {
    case 0x20:
        if (value == 0x20)
        {
            PIC_EOI();
            return;
        }
        break;
    case 0x21:
        disable();
        PIC_mask = value;
        enable();
        break;
    case 0x43:
        PIT_toggle = 1;
        break;
    default:
        break;
    }
    ;

}


