 

 

 

 





 

 






typedef signed char INT8;
typedef unsigned char UINT8;
typedef signed short INT16;
typedef unsigned short UINT16;
typedef signed long INT32;
typedef unsigned long UINT32;

typedef UINT8 BYTE;
typedef UINT16 WORD;
typedef UINT32 DWORD;






























extern BYTE *memory;
extern char *progname;

void init_cpu();
void execute();
void exit_emu();










 
 




 




 






 






 




 




 





 









 





 




 

 




 

 





 

 










 












 




 









 

 












 












 











 










 










 














 






 










 










 












 


















 










 






 






 








 




 






 






 






 







 





























 




 

typedef	long		__off_t;



 




 

typedef	char	      *	__va_list;



 




 

 



 




 

 






typedef	unsigned	__size_t;









 


typedef	__size_t	size_t;








 




 

 













 




 









 












 
typedef long		fpos_t;		 

 
typedef struct	FILE {
	int		_cc;		 
	unsigned char	*_cp;		 
	struct _FILE2	*_f2p;		 
	char		_ff1;		 
	char		_fd;		 
	char		_ff2;		 
	char		_mode;		 
}	FILE;
 
typedef	struct	_FILE2 {
	int		(*_gt)();	 
	int		(*_pt)();	 
	unsigned char	*_bp;		 
	unsigned char	*_dp;		 
	unsigned char	*_ep;		 
	char		*_nm;		 
	int		_uc;		 
}	_FILE2;

 






 
extern	FILE	_iob[3];
extern	FILE	*_fp[60];




 




 



 




 







 







 



int		remove		();
int		rename		();
FILE	      *	tmpfile		();
char	      *	tmpnam		();
int		fclose		();
int		fflush		();
FILE	      *	fopen		();
FILE	      *	freopen		();
void		setbuf		();
int		setvbuf		();
int		fprintf		()
;
int		fscanf		()
;
int		printf		()
;
int		scanf		()
;
int		sprintf		()
;
int		sscanf		()
;
int		vfprintf	();
int		vprintf		();
int		vsprintf	();
int		fgetc		();
char	      *	fgets		();
int		fputc		();
int		fputs		();
int		getc		();
int		getchar		();
char	      *	gets		();
int		putc		();
int		putchar		();
int		puts		();
int		ungetc		();
size_t		fread		();
size_t		fwrite		();
int		fgetpos		();
int		fseek		();
int		fsetpos		();
__off_t		ftell		();
void		rewind		();
void		clearerr	();
int		feof		();
int		ferror		();
void		perror		();

char	      *	ctermid		();



FILE	      *	fdopen		();
int		fileno		();



FILE	      *	popen		();
int		pclose		();






 








 





 

 




 

 





 

 







































 





































 













extern WORD wregs[8];	     
extern BYTE *bregs[16];      
extern unsigned sregs[4];    

extern unsigned ip;	      

     
extern BYTE CF, PF, ZF, TF, IF, DF;

     
extern unsigned AF, OF, SF;

extern BYTE *c_cs,*c_ds,*c_es,*c_ss,*c_stack;

extern volatile int int_pending;
extern volatile int int_blocked;



 

 




static  void i_add_br8();
static  void i_add_wr16();
static  void i_add_r8b();
static  void i_add_r16w();
static  void i_add_ald8();
static  void i_add_axd16();
static  void i_push_es();
static  void i_pop_es();
static  void i_or_br8();
static  void i_or_r8b();
static  void i_or_wr16();
static  void i_or_r16w();
static  void i_or_ald8();
static  void i_or_axd16();
static  void i_push_cs();
static  void i_adc_br8();
static  void i_adc_wr16();
static  void i_adc_r8b();
static  void i_adc_r16w();
static  void i_adc_ald8();
static  void i_adc_axd16();
static  void i_push_ss();
static  void i_pop_ss();
static  void i_sbb_br8();
static  void i_sbb_wr16();
static  void i_sbb_r8b();
static  void i_sbb_r16w();
static  void i_sbb_ald8();
static  void i_sbb_axd16();
static  void i_push_ds();
static  void i_pop_ds();
static  void i_and_br8();
static  void i_and_r8b();
static  void i_and_wr16();
static  void i_and_r16w();
static  void i_and_ald8();
static  void i_and_axd16();
static  void i_es();
static  void i_daa();
static  void i_sub_br8();
static  void i_sub_wr16();
static  void i_sub_r8b();
static  void i_sub_r16w();
static  void i_sub_ald8();
static  void i_sub_axd16();
static  void i_cs();
static  void i_xor_br8();
static  void i_xor_r8b();
static  void i_xor_wr16();
static  void i_xor_r16w();
static  void i_xor_ald8();
static  void i_xor_axd16();
static  void i_ss();
static  void i_cmp_br8();
static  void i_cmp_wr16();
static  void i_cmp_r8b();
static  void i_cmp_r16w();
static  void i_cmp_ald8();
static  void i_cmp_axd16();
static  void i_ds();
static  void i_inc_ax();
static  void i_inc_cx();
static  void i_inc_dx();
static  void i_inc_bx();
static  void i_inc_sp();
static  void i_inc_bp();
static  void i_inc_si();
static  void i_inc_di();
static  void i_dec_ax();
static  void i_dec_cx();
static  void i_dec_dx();
static  void i_dec_bx();
static  void i_dec_sp();
static  void i_dec_bp();
static  void i_dec_si();
static  void i_dec_di();
static  void i_push_ax();
static  void i_push_cx();
static  void i_push_dx();
static  void i_push_bx();
static  void i_push_sp();
static  void i_push_bp();
static  void i_push_si();
static  void i_push_di();
static  void i_pop_ax();
static  void i_pop_cx();
static  void i_pop_dx();
static  void i_pop_bx();
static  void i_pop_sp();
static  void i_pop_bp();
static  void i_pop_si();
static  void i_pop_di();
static  void i_jo();
static  void i_jno();
static  void i_jb();
static  void i_jnb();
static  void i_jz();
static  void i_jnz();
static  void i_jbe();
static  void i_jnbe();
static  void i_js();
static  void i_jns();
static  void i_jp();
static  void i_jnp();
static  void i_jl();
static  void i_jnl();
static  void i_jle();
static  void i_jnle();
static  void i_80pre();
static  void i_81pre();
static  void i_83pre();
static  void i_test_br8();
static  void i_test_wr16();
static  void i_xchg_br8();
static  void i_xchg_wr16();
static  void i_mov_br8();
static  void i_mov_r8b();
static  void i_mov_wr16();
static  void i_mov_r16w();
static  void i_mov_wsreg();
static  void i_lea();
static  void i_mov_sregw();
static  void i_notdone();
static  void i_popw();
static  void i_nop();
static  void i_xchg_axcx();
static  void i_xchg_axdx();
static  void i_xchg_axbx();
static  void i_xchg_axsp();
static  void i_xchg_axbp();
static  void i_xchg_axsi();
static  void i_xchg_axdi();
static  void i_cbw();
static  void i_cwd();
static  void i_call_far();
static  void i_pushf();
static  void i_popf();
static  void i_sahf();
static  void i_lahf();
static  void i_mov_aldisp();
static  void i_mov_axdisp();
static  void i_mov_dispal();
static  void i_mov_dispax();
static  void i_movsb();
static  void i_movsw();
static  void i_cmpsb();
static  void i_cmpsw();
static  void i_test_ald8();
static  void i_test_axd16();
static  void i_stosb();
static  void i_stosw();
static  void i_lodsb();
static  void i_lodsw();
static  void i_scasb();
static  void i_scasw();
static  void i_mov_ald8();
static  void i_mov_cld8();
static  void i_mov_dld8();
static  void i_mov_bld8();
static  void i_mov_ahd8();
static  void i_mov_chd8();
static  void i_mov_dhd8();
static  void i_mov_bhd8();
static  void i_mov_axd16();
static  void i_mov_cxd16();
static  void i_mov_dxd16();
static  void i_mov_bxd16();
static  void i_mov_spd16();
static  void i_mov_bpd16();
static  void i_mov_sid16();
static  void i_mov_did16();
static  void i_ret_d16();
static  void i_ret();
static  void i_les_dw();
static  void i_lds_dw();
static  void i_mov_bd8();
static  void i_mov_wd16();
static  void i_retf_d16();
static  void i_retf();
static  void i_int3();
static  void i_int();
static  void i_into();
static  void i_iret();
static  void i_d0pre();
static  void i_d1pre();
static  void i_d2pre();
static  void i_d3pre();
static  void i_aam();
static  void i_aad();
static  void i_xlat();
static  void i_escape();
static  void i_loopne();
static  void i_loope();
static  void i_loop();
static  void i_jcxz();
static  void i_inal();
static  void i_inax();
static  void i_outal();
static  void i_outax();
static  void i_call_d16();
static  void i_jmp_d16();
static  void i_jmp_far();
static  void i_jmp_d8();
static  void i_inaldx();
static  void i_inaxdx();
static  void i_outdxal();
static  void i_outdxax();
static  void i_lock();
static  void i_repne();
static  void i_repe();
static  void i_cmc();
static  void i_f6pre();
static  void i_f7pre();
static  void i_clc();
static  void i_stc();
static  void i_cli();
static  void i_sti();
static  void i_cld();
static  void i_std();
static  void i_fepre();
static  void i_ffpre();

static  void i_wait();
static  void i_gobios();

void (*instruction[256])()=
{
    i_add_br8,           
    i_add_wr16,          
    i_add_r8b,           
    i_add_r16w,          
    i_add_ald8,          
    i_add_axd16,         
    i_push_es,           
    i_pop_es,            
    i_or_br8,            
    i_or_wr16,           
    i_or_r8b,            
    i_or_r16w,           
    i_or_ald8,           
    i_or_axd16,          
    i_push_cs,           
    i_notdone,
    i_adc_br8,           
    i_adc_wr16,          
    i_adc_r8b,           
    i_adc_r16w,          
    i_adc_ald8,          
    i_adc_axd16,         
    i_push_ss,           
    i_pop_ss,            
    i_sbb_br8,           
    i_sbb_wr16,          
    i_sbb_r8b,           
    i_sbb_r16w,          
    i_sbb_ald8,          
    i_sbb_axd16,         
    i_push_ds,           
    i_pop_ds,            
    i_and_br8,           
    i_and_wr16,          
    i_and_r8b,           
    i_and_r16w,          
    i_and_ald8,          
    i_and_axd16,         
    i_es,                
    i_daa,               
    i_sub_br8,           
    i_sub_wr16,          
    i_sub_r8b,           
    i_sub_r16w,          
    i_sub_ald8,          
    i_sub_axd16,         
    i_cs,                
    i_notdone,
    i_xor_br8,           
    i_xor_wr16,          
    i_xor_r8b,           
    i_xor_r16w,          
    i_xor_ald8,          
    i_xor_axd16,         
    i_ss,                
    i_notdone,
    i_cmp_br8,           
    i_cmp_wr16,          
    i_cmp_r8b,           
    i_cmp_r16w,          
    i_cmp_ald8,          
    i_cmp_axd16,         
    i_ds,                
    i_notdone,
    i_inc_ax,            
    i_inc_cx,            
    i_inc_dx,            
    i_inc_bx,            
    i_inc_sp,            
    i_inc_bp,            
    i_inc_si,            
    i_inc_di,            
    i_dec_ax,            
    i_dec_cx,            
    i_dec_dx,            
    i_dec_bx,            
    i_dec_sp,            
    i_dec_bp,            
    i_dec_si,            
    i_dec_di,            
    i_push_ax,           
    i_push_cx,           
    i_push_dx,           
    i_push_bx,           
    i_push_sp,           
    i_push_bp,           
    i_push_si,           
    i_push_di,           
    i_pop_ax,            
    i_pop_cx,            
    i_pop_dx,            
    i_pop_bx,            
    i_pop_sp,            
    i_pop_bp,            
    i_pop_si,            
    i_pop_di,            
    i_notdone,
    i_notdone,
    i_notdone,
    i_notdone,
    i_notdone,
    i_notdone,
    i_notdone,
    i_notdone,
    i_notdone,
    i_notdone,
    i_notdone,
    i_notdone,
    i_notdone,
    i_notdone,
    i_notdone,
    i_notdone,
    i_jo,                
    i_jno,               
    i_jb,                
    i_jnb,               
    i_jz,                
    i_jnz,               
    i_jbe,               
    i_jnbe,              
    i_js,                
    i_jns,               
    i_jp,                
    i_jnp,               
    i_jl,                
    i_jnl,               
    i_jle,               
    i_jnle,              
    i_80pre,             
    i_81pre,             
    i_notdone,
    i_83pre,             
    i_test_br8,          
    i_test_wr16,         
    i_xchg_br8,          
    i_xchg_wr16,         
    i_mov_br8,           
    i_mov_wr16,          
    i_mov_r8b,           
    i_mov_r16w,          
    i_mov_wsreg,         
    i_lea,               
    i_mov_sregw,         
    i_popw,              
    i_nop,               
    i_xchg_axcx,         
    i_xchg_axdx,         
    i_xchg_axbx,         
    i_xchg_axsp,         
    i_xchg_axbp,         
    i_xchg_axsi,         
    i_xchg_axdi,         
    i_cbw,               
    i_cwd,               
    i_call_far,          
    i_wait,              
    i_pushf,             
    i_popf,              
    i_sahf,              
    i_lahf,              
    i_mov_aldisp,        
    i_mov_axdisp,        
    i_mov_dispal,        
    i_mov_dispax,        
    i_movsb,             
    i_movsw,             
    i_cmpsb,             
    i_cmpsw,             
    i_test_ald8,         
    i_test_axd16,        
    i_stosb,             
    i_stosw,             
    i_lodsb,             
    i_lodsw,             
    i_scasb,             
    i_scasw,             
    i_mov_ald8,          
    i_mov_cld8,          
    i_mov_dld8,          
    i_mov_bld8,          
    i_mov_ahd8,          
    i_mov_chd8,          
    i_mov_dhd8,          
    i_mov_bhd8,          
    i_mov_axd16,         
    i_mov_cxd16,         
    i_mov_dxd16,         
    i_mov_bxd16,         
    i_mov_spd16,         
    i_mov_bpd16,         
    i_mov_sid16,         
    i_mov_did16,         
    i_notdone,
    i_notdone,
    i_ret_d16,           
    i_ret,               
    i_les_dw,            
    i_lds_dw,            
    i_mov_bd8,           
    i_mov_wd16,          
    i_notdone,
    i_notdone,
    i_retf_d16,          
    i_retf,              
    i_int3,              
    i_int,               
    i_into,              
    i_iret,              
    i_d0pre,             
    i_d1pre,             
    i_d2pre,             
    i_d3pre,             
    i_aam,               
    i_aad,               
    i_notdone,
    i_xlat,              
    i_escape,            
    i_escape,            
    i_escape,            
    i_escape,            
    i_escape,            
    i_escape,            
    i_escape,            
    i_escape,            
    i_loopne,            
    i_loope,             
    i_loop,              
    i_jcxz,              
    i_inal,              
    i_inax,              
    i_outal,             
    i_outax,             
    i_call_d16,          
    i_jmp_d16,           
    i_jmp_far,           
    i_jmp_d8,            
    i_inaldx,            
    i_inaxdx,            
    i_outdxal,           
    i_outdxax,           
    i_lock,              
    i_gobios,            
    i_repne,             
    i_repe,              
    i_notdone,
    i_cmc,               
    i_f6pre,             
    i_f7pre,             
    i_clc,               
    i_stc,               
    i_cli,               
    i_sti,               
    i_cld,               
    i_std,               
    i_fepre,             
    i_ffpre              
};



 




 

 










int port60_buffer_ok();
void put_scancode();
void init_timer();

void disable();
void enable();

void starttimer();
void stoptimer();

BYTE read_port();
void write_port();








WORD wregs[8];	      
BYTE *bregs[16];      
unsigned sregs[4];    

unsigned ip;	      


     

BYTE CF, PF, ZF, TF, IF, DF;

     

unsigned AF, OF, SF;


static UINT8 parity_table[256];
static BYTE *ModRMRegB[256];
static WORD *ModRMRegW[256];

     
BYTE *c_cs,*c_ds,*c_es,*c_ss,*c_stack;

volatile int int_pending;    
volatile int int_blocked;    

static struct
{
    BYTE **segment;
    WORD *reg1;
    WORD *reg2;
    int offset;
    int offset16;
    int pad[3];	 
} ModRMRM[256];

static WORD zero_word = 0;

static WORD *ModRMRMWRegs[256];
static BYTE *ModRMRMBRegs[256];

void trap();














































void init_cpu()
{
    unsigned int i,j,c;
    
    for (i = 0; i < 4; i++)
    {
        wregs[i] = 0;
        sregs[i] = 0x70;
    }
    for (; i < 8; i++)
        wregs[i] = 0;
    
    wregs[4] = 0;
    ip = 0x100;
    
    for (i = 0;i < 256; i++)
    {
        for (j = i,c = 0; j > 0; j >>= 1)
            if (j & 1) c++;
        
        parity_table[i] = !(c & 1);
    }
    
    CF = PF = AF = ZF = SF = TF = IF = DF = OF = 0;
    
    bregs[0] = (BYTE *)&wregs[0];
    bregs[4] = (BYTE *)&wregs[0]+1;
    bregs[1] = (BYTE *)&wregs[1];
    bregs[5] = (BYTE *)&wregs[1]+1;
    bregs[2] = (BYTE *)&wregs[2];
    bregs[6] = (BYTE *)&wregs[2]+1;
    bregs[3] = (BYTE *)&wregs[3];
    bregs[7] = (BYTE *)&wregs[3]+1;
    
    bregs[8] = (BYTE *)&wregs[4];
    bregs[9] = (BYTE *)&wregs[4]+1;
    bregs[10] = (BYTE *)&wregs[5];
    bregs[11] = (BYTE *)&wregs[5]+1;
    bregs[12] = (BYTE *)&wregs[6];
    bregs[13] = (BYTE *)&wregs[6]+1;
    bregs[14] = (BYTE *)&wregs[7];
    bregs[15] = (BYTE *)&wregs[7]+1;
    
    for (i = 0; i < 256; i++)
    {
        ModRMRegB[i] = bregs[(i & 0x38) >> 3];
        ModRMRegW[i] = &wregs[(i & 0x38) >> 3];
    }
    
    for (i = 0; i < 0x40; i++)
    {
        switch (i & 7)
        {
        case 0:
            ModRMRM[i].segment = &c_ds;
            ModRMRM[i].reg1 = &wregs[3];
            ModRMRM[i].reg2 = &wregs[6];
            ModRMRM[i].offset = ModRMRM[i].offset16 = 0;
            break;
        case 1:
            ModRMRM[i].segment = &c_ds;
            ModRMRM[i].reg1 = &wregs[3];
            ModRMRM[i].reg2 = &wregs[7];
            ModRMRM[i].offset = ModRMRM[i].offset16 = 0;
            break;
        case 2:
            ModRMRM[i].segment = &c_ss;
            ModRMRM[i].reg1 = &wregs[5];
            ModRMRM[i].reg2 = &wregs[6];
            ModRMRM[i].offset = ModRMRM[i].offset16 = 0;
            break;
        case 3:
            ModRMRM[i].segment = &c_ss;
            ModRMRM[i].reg1 = &wregs[5];
            ModRMRM[i].reg2 = &wregs[7];
            ModRMRM[i].offset = ModRMRM[i].offset16 = 0;
            break;
        case 4:
            ModRMRM[i].segment = &c_ds;
            ModRMRM[i].reg1 = &zero_word;
            ModRMRM[i].reg2 = &wregs[6];
            ModRMRM[i].offset = ModRMRM[i].offset16 = 0;
            break;
        case 5:
            ModRMRM[i].segment = &c_ds;
            ModRMRM[i].reg1 = &zero_word;
            ModRMRM[i].reg2 = &wregs[7];
            ModRMRM[i].offset = ModRMRM[i].offset16 = 0;
            break;
        case 6:
            ModRMRM[i].segment = &c_ds;
            ModRMRM[i].reg1 = &zero_word;
            ModRMRM[i].reg2 = &zero_word;
            ModRMRM[i].offset = 1;
            ModRMRM[i].offset16 = 1;
            break;
        default:
            ModRMRM[i].segment = &c_ds;
            ModRMRM[i].reg1 = &wregs[3];
            ModRMRM[i].reg2 = &zero_word;
            ModRMRM[i].offset = ModRMRM[i].offset16 = 0;
            break;
        }
    }
    
    for (i = 0x40; i < 0x80; i++)
    {
        switch (i & 7)
        {
        case 0:
            ModRMRM[i].segment = &c_ds;
            ModRMRM[i].reg1 = &wregs[3];
            ModRMRM[i].reg2 = &wregs[6];
            ModRMRM[i].offset = 1;
            ModRMRM[i].offset16 = 0;
            break;
        case 1:
            ModRMRM[i].segment = &c_ds;
            ModRMRM[i].reg1 = &wregs[3];
            ModRMRM[i].reg2 = &wregs[7];
            ModRMRM[i].offset = 1;
            ModRMRM[i].offset16 = 0;
            break;
        case 2:
            ModRMRM[i].segment = &c_ss;
            ModRMRM[i].reg1 = &wregs[5];
            ModRMRM[i].reg2 = &wregs[6];
            ModRMRM[i].offset = 1;
            ModRMRM[i].offset16 = 0;
            break;
        case 3:
            ModRMRM[i].segment = &c_ss;
            ModRMRM[i].reg1 = &wregs[5];
            ModRMRM[i].reg2 = &wregs[7];
            ModRMRM[i].offset = 1;
            ModRMRM[i].offset16 = 0;
            break;
        case 4:
            ModRMRM[i].segment = &c_ds;
            ModRMRM[i].reg1 = &zero_word;
            ModRMRM[i].reg2 = &wregs[6];
            ModRMRM[i].offset = 1;
            ModRMRM[i].offset16 = 0;
            break;
        case 5:
            ModRMRM[i].segment = &c_ds;
            ModRMRM[i].reg1 = &zero_word;
            ModRMRM[i].reg2 = &wregs[7];
            ModRMRM[i].offset = 1;
            ModRMRM[i].offset16 = 0;
            break;
        case 6:
            ModRMRM[i].segment = &c_ss;
            ModRMRM[i].reg1 = &wregs[5];
            ModRMRM[i].reg2 = &zero_word;
            ModRMRM[i].offset = 1;
            ModRMRM[i].offset16 = 0;
            break;
        default:
            ModRMRM[i].segment = &c_ds;
            ModRMRM[i].reg1 = &wregs[3];
            ModRMRM[i].reg2 = &zero_word;
            ModRMRM[i].offset = 1;
            ModRMRM[i].offset16 = 0;
            break;
        }
    }
    
    for (i = 0x80; i < 0xc0; i++)
    {
        switch (i & 7)
        {
        case 0:
            ModRMRM[i].segment = &c_ds;
            ModRMRM[i].reg1 = &wregs[3];
            ModRMRM[i].reg2 = &wregs[6];
            ModRMRM[i].offset = 1;
            ModRMRM[i].offset16 = 1;
            break;
        case 1:
            ModRMRM[i].segment = &c_ds;
            ModRMRM[i].reg1 = &wregs[3];
            ModRMRM[i].reg2 = &wregs[7];
            ModRMRM[i].offset = 1;
            ModRMRM[i].offset16 = 1;
            break;
        case 2:
            ModRMRM[i].segment = &c_ss;
            ModRMRM[i].reg1 = &wregs[5];
            ModRMRM[i].reg2 = &wregs[6];
            ModRMRM[i].offset = 1;
            ModRMRM[i].offset16 = 1;
            break;
        case 3:
            ModRMRM[i].segment = &c_ss;
            ModRMRM[i].reg1 = &wregs[5];
            ModRMRM[i].reg2 = &wregs[7];
            ModRMRM[i].offset = 1;
            ModRMRM[i].offset16 = 1;
            break;
        case 4:
            ModRMRM[i].segment = &c_ds;
            ModRMRM[i].reg1 = &zero_word;
            ModRMRM[i].reg2 = &wregs[6];
            ModRMRM[i].offset = 1;
            ModRMRM[i].offset16 = 1;
            break;
        case 5:
            ModRMRM[i].segment = &c_ds;
            ModRMRM[i].reg1 = &zero_word;
            ModRMRM[i].reg2 = &wregs[7];
            ModRMRM[i].offset = 1;
            ModRMRM[i].offset16 = 1;
            break;
        case 6:
            ModRMRM[i].segment = &c_ss;
            ModRMRM[i].reg1 = &wregs[5];
            ModRMRM[i].reg2 = &zero_word;
            ModRMRM[i].offset = 1;
            ModRMRM[i].offset16 = 1;
            break;
        default:
            ModRMRM[i].segment = &c_ds;
            ModRMRM[i].reg1 = &wregs[3];
            ModRMRM[i].reg2 = &zero_word;
            ModRMRM[i].offset = 1;
            ModRMRM[i].offset16 = 1;
            break;
        }
    }
    
    for (i = 0xc0; i < 0x100; i++)
    {
        ModRMRMWRegs[i] = &wregs[i & 7];
        ModRMRMBRegs[i] = bregs[i & 7];
    }
}




void interrupt(int_num)
# 1691 
unsigned int_num;
{
    unsigned dest_seg, dest_off,tmp1;

    i_pushf();
    dest_off = (*(WORD *)((memory)+(WORD)(int_num*4)));
    dest_seg = (*(WORD *)((memory)+(WORD)(int_num*4+2)));

    tmp1 = (WORD)((*(&wregs[4]))-2);

    (*(WORD *)((c_stack)+(WORD)(tmp1))= (WORD)(sregs[1]));
    tmp1 = (WORD)(tmp1-2);
    (*(WORD *)((c_stack)+(WORD)(tmp1))= (WORD)(ip));
    (*(&wregs[4])= (tmp1));

    ip = (WORD)dest_off;
    sregs[1] = (WORD)dest_seg;
    c_cs = (&memory[sregs[1] << 4]);

    TF = IF = 0;     

}


void external_int()
{
    disable();


    ;
    interrupt(int_pending);
    int_pending = 0;

    enable();
}





WORD *GetModRMRMW(ModRM)
# 1731 
unsigned ModRM;
{
      unsigned dest; 

    if (ModRM >= 0xc0)
        return ModRMRMWRegs[ModRM];

    dest = 0;

    if (ModRMRM[ModRM].offset)
    {
        dest = (WORD)((INT16)((INT8)((c_cs)[(ip)++])));
        if (ModRMRM[ModRM].offset16)
            dest = (((c_cs)[(ip)++])<< 8) + (BYTE)dest;
    }
    
    return (WORD *)(*ModRMRM[ModRM].segment +
                    (WORD)((*(ModRMRM[ModRM].reg1))+
                           (*(ModRMRM[ModRM].reg2))+ dest));
}


BYTE *GetModRMRMB(ModRM)
# 1753 
unsigned ModRM;
{
      unsigned dest;
    
    if (ModRM >= 0xc0)
        return ModRMRMBRegs[ModRM];

    dest = 0;

    if (ModRMRM[ModRM].offset)
    {
        dest = (WORD)((INT16)((INT8)((c_cs)[(ip)++])));
        if (ModRMRM[ModRM].offset16)
            dest = (((c_cs)[(ip)++])<< 8) + (BYTE)dest;
    }
    
    return (*ModRMRM[ModRM].segment +
            (WORD)((*(ModRMRM[ModRM].reg1))+
                   (*(ModRMRM[ModRM].reg2))+ dest));
}


 void i_add_br8()
{
     

    unsigned ModRM = (unsigned)((c_cs)[(ip)++]);
      unsigned src = (unsigned)*(ModRMRegB[ModRM]);
    BYTE *dest = GetModRMRMB(ModRM);
      unsigned tmp = (unsigned) *dest;
      unsigned tmp2 = tmp;
    
    tmp += src;
    
    (CF = (BYTE)(tmp)< (BYTE)(tmp2));
    (OF = ((tmp)^ (src))& ((tmp)^ (tmp2))& 0x80);
    (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
    (ZF = !(BYTE)(tmp));
    (SF = (tmp)& 0x80);
    (PF = parity_table[(BYTE)(tmp)]);

    *dest = (BYTE)tmp;
}


 void i_add_wr16()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
    WORD *src = (ModRMRegW[ModRM]);
    WORD *dest = GetModRMRMW(ModRM);
      unsigned tmp1 = (unsigned)(*(dest));
      unsigned tmp2 = (unsigned)(*(src));
      unsigned tmp3;

    tmp3 = tmp1+tmp2;

    (CF = (WORD)(tmp3)< (WORD)(tmp1));
    (OF = ((tmp3)^ (tmp2))& ((tmp3)^ (tmp1))& 0x8000);
    (AF = ((tmp3)^ ((tmp2)^ (tmp1)))& 0x10);
    (ZF = !(WORD)(tmp3));
    (SF = (tmp3)& 0x8000);
    (PF = parity_table[(BYTE)(tmp3)]);

    (*(dest)= (tmp3));
}


 void i_add_r8b()
{
     

    unsigned ModRM = (unsigned)((c_cs)[(ip)++]);
      unsigned src = (unsigned)*GetModRMRMB(ModRM);
    BYTE *dest = (ModRMRegB[ModRM]);
      unsigned tmp = (unsigned) *dest;
      unsigned tmp2 = tmp;

    tmp += src;

    (CF = (BYTE)(tmp)< (BYTE)(tmp2));
    (OF = ((tmp)^ (src))& ((tmp)^ (tmp2))& 0x80);
    (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
    (ZF = !(BYTE)(tmp));
    (SF = (tmp)& 0x80);
    (PF = parity_table[(BYTE)(tmp)]);

    *dest = (BYTE)tmp;

}


 void i_add_r16w()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
    WORD *dest = (ModRMRegW[ModRM]);
    WORD *src = GetModRMRMW(ModRM);
      unsigned tmp1 = (unsigned)(*(dest));
      unsigned tmp2 = (unsigned)(*(src));
      unsigned tmp3;

    tmp3 = tmp1 + tmp2;

    (CF = (WORD)(tmp3)< (WORD)(tmp1));
    (OF = ((tmp3)^ (tmp2))& ((tmp3)^ (tmp1))& 0x8000);
    (AF = ((tmp3)^ ((tmp2)^ (tmp1)))& 0x10);
    (ZF = !(WORD)(tmp3));
    (SF = (tmp3)& 0x8000);
    (PF = parity_table[(BYTE)(tmp3)]);

    (*(dest)= (tmp3));
}


 void i_add_ald8()
{
     

      unsigned src = (unsigned)((c_cs)[(ip)++]);
      unsigned tmp = (unsigned)*bregs[0];
      unsigned tmp2 = tmp;

    tmp2 += src;

    (CF = (BYTE)(tmp2)< (BYTE)(tmp));
    (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x80);
    (AF = ((tmp2)^ ((src)^ (tmp)))& 0x10);
    (ZF = !(BYTE)(tmp2));
    (SF = (tmp2)& 0x80);
    (PF = parity_table[(BYTE)(tmp2)]);

    *bregs[0] = (BYTE)tmp2;
}


 void i_add_axd16()
{
     

      unsigned src;
      unsigned tmp = (*(&wregs[0]));
      unsigned tmp2 = tmp;

    src = ((c_cs)[(ip)++]);
    src += ((c_cs)[(ip)++]) << 8;

    tmp2 += src;

    (CF = (WORD)(tmp2)< (WORD)(tmp));
    (OF = ((tmp2)^ (tmp))& ((tmp2)^ (src))& 0x8000);
    (AF = ((tmp2)^ ((tmp)^ (src)))& 0x10);
    (ZF = !(WORD)(tmp2));
    (SF = (tmp2)& 0x8000);
    (PF = parity_table[(BYTE)(tmp2)]);

    (*(&wregs[0])= (tmp2));
}


 void i_push_es()
{
     

    { unsigned tmp = (WORD)((*(&wregs[4]))-2); (*(&wregs[4])= (tmp)); (*(WORD *)((c_stack)+(WORD)(tmp))= (WORD)(sregs[0])); };
}


 void i_pop_es()
{
     
    { unsigned tmp = (*(&wregs[4])); sregs[0] = (*(WORD *)((c_stack)+(WORD)(tmp))); c_es = (&memory[sregs[0] << 4]); tmp += 2; (*(&wregs[4])= (tmp)); };
}

     

void i_or_br8()
# 1931 
{ { unsigned ModRM = (unsigned)((c_cs)[(ip)++]); unsigned src = (unsigned)*(ModRMRegB[ModRM]); BYTE *dest = GetModRMRMB(ModRM); unsigned tmp = (unsigned) *dest; tmp |= src; CF = OF = AF = 0; (ZF = !(BYTE)(tmp)); (SF = (tmp)& 0x80); (PF = parity_table[(BYTE)(tmp)]); *dest = (BYTE)tmp; }; } void i_or_wr16()
# 1931 
{ { unsigned ModRM = ((c_cs)[(ip)++]); WORD *src = (ModRMRegW[ModRM]); WORD *dest = GetModRMRMW(ModRM); unsigned tmp1 = (unsigned)(*(src)); unsigned tmp2 = (unsigned)(*(dest)); unsigned tmp3 = tmp1 | tmp2; CF = OF = AF = 0; (ZF = !(WORD)(tmp3)); (SF = (tmp3)& 0x8000); (PF = parity_table[(BYTE)(tmp3)]); (*(dest)= (tmp3)); }; } void i_or_r8b()
# 1931 
{ { unsigned ModRM = (unsigned)((c_cs)[(ip)++]); unsigned src = (unsigned)*GetModRMRMB(ModRM); BYTE *dest = (ModRMRegB[ModRM]); unsigned tmp = (unsigned) *dest; tmp |= src; CF = OF = AF = 0; (ZF = !(BYTE)(tmp)); (SF = (tmp)& 0x80); (PF = parity_table[(BYTE)(tmp)]); *dest = (BYTE)tmp; }; } void i_or_r16w()
# 1931 
{ { unsigned ModRM = ((c_cs)[(ip)++]); WORD *dest = (ModRMRegW[ModRM]); WORD *src = GetModRMRMW(ModRM); unsigned tmp1 = (unsigned)(*(src)); unsigned tmp2 = (unsigned)(*(dest)); unsigned tmp3 = tmp1 | tmp2; CF = OF = AF = 0; (ZF = !(WORD)(tmp3)); (SF = (tmp3)& 0x8000); (PF = parity_table[(BYTE)(tmp3)]); (*(dest)= (tmp3)); }; } void i_or_ald8()
# 1931 
{ { unsigned tmp = *bregs[0]; tmp |= (unsigned)((c_cs)[(ip)++]); CF = OF = AF = 0; (ZF = !(BYTE)(tmp)); (SF = (tmp)& 0x80); (PF = parity_table[(BYTE)(tmp)]); *bregs[0] = (BYTE)tmp; }; } void i_or_axd16()
# 1931 
{ { unsigned src; unsigned tmp = (*(&wregs[0])); src = ((c_cs)[(ip)++]); src += ((c_cs)[(ip)++]) << 8; tmp |= src; CF = OF = AF = 0; (ZF = !(WORD)(tmp)); (SF = (tmp)& 0x8000); (PF = parity_table[(BYTE)(tmp)]); (*(&wregs[0])= (tmp)); }; }


 void i_push_cs()
{
     

    { unsigned tmp = (WORD)((*(&wregs[4]))-2); (*(&wregs[4])= (tmp)); (*(WORD *)((c_stack)+(WORD)(tmp))= (WORD)(sregs[1])); };
}


 void i_adc_br8()
{
     

    unsigned ModRM = (unsigned)((c_cs)[(ip)++]);
      unsigned src = (unsigned)*(ModRMRegB[ModRM])+CF;
    BYTE *dest = GetModRMRMB(ModRM);
      unsigned tmp = (unsigned) *dest;
      unsigned tmp2 = tmp;

    tmp += src;

    CF = tmp >> 8;

 
    (OF = ((tmp)^ (src))& ((tmp)^ (tmp2))& 0x80);
    (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
    (ZF = !(BYTE)(tmp));
    (SF = (tmp)& 0x80);
    (PF = parity_table[(BYTE)(tmp)]);

    *dest = (BYTE)tmp;
}


 void i_adc_wr16()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
    WORD *src = (ModRMRegW[ModRM]);
    WORD *dest = GetModRMRMW(ModRM);
      unsigned tmp1 = (unsigned)(*(dest));
      unsigned tmp2 = (unsigned)(*(src))+CF;
      unsigned tmp3;

    tmp3 = tmp1+tmp2;

    CF = tmp3 >> 16;
 
    (OF = ((tmp3)^ (tmp2))& ((tmp3)^ (tmp1))& 0x8000);
    (AF = ((tmp3)^ ((tmp2)^ (tmp1)))& 0x10);
    (ZF = !(WORD)(tmp3));
    (SF = (tmp3)& 0x8000);
    (PF = parity_table[(BYTE)(tmp3)]);

    (*(dest)= (tmp3));

}


 void i_adc_r8b()
{
     

    unsigned ModRM = (unsigned)((c_cs)[(ip)++]);
      unsigned src = (unsigned)*GetModRMRMB(ModRM)+CF;
    BYTE *dest = (ModRMRegB[ModRM]);
      unsigned tmp = (unsigned) *dest;
      unsigned tmp2 = tmp;

    tmp += src;

    CF = tmp >> 8;

 
    (OF = ((tmp)^ (src))& ((tmp)^ (tmp2))& 0x80);
    (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
    (ZF = !(BYTE)(tmp));
    (SF = (tmp)& 0x80);
    (PF = parity_table[(BYTE)(tmp)]);

    *dest = (BYTE)tmp;
}


 void i_adc_r16w()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
    WORD *dest = (ModRMRegW[ModRM]);
    WORD *src = GetModRMRMW(ModRM);
      unsigned tmp1 = (unsigned)(*(dest));
      unsigned tmp2 = (unsigned)(*(src))+CF;
      unsigned tmp3;

    tmp3 = tmp1+tmp2;

    CF = tmp3 >> 16;

 
    (OF = ((tmp3)^ (tmp2))& ((tmp3)^ (tmp1))& 0x8000);
    (AF = ((tmp3)^ ((tmp2)^ (tmp1)))& 0x10);
    (ZF = !(WORD)(tmp3));
    (SF = (tmp3)& 0x8000);
    (PF = parity_table[(BYTE)(tmp3)]);

    (*(dest)= (tmp3));

}


 void i_adc_ald8()
{
     

      unsigned src = (unsigned)((c_cs)[(ip)++])+CF;
      unsigned tmp = (unsigned)*bregs[0];
      unsigned tmp2 = tmp;

    tmp2 += src;

    CF = tmp2 >> 8;

 
    (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x80);
    (AF = ((tmp2)^ ((src)^ (tmp)))& 0x10);
    (ZF = !(BYTE)(tmp2));
    (SF = (tmp2)& 0x80);
    (PF = parity_table[(BYTE)(tmp2)]);

    *bregs[0] = (BYTE)tmp2;
}


 void i_adc_axd16()
{
     

      unsigned src;
      unsigned tmp = (*(&wregs[0]));
      unsigned tmp2 = tmp;

    src = ((c_cs)[(ip)++]);
    src += (((c_cs)[(ip)++])<< 8)+CF;

    tmp2 += src;

    CF = tmp2 >> 16;

 
    (OF = ((tmp2)^ (tmp))& ((tmp2)^ (src))& 0x8000);
    (AF = ((tmp2)^ ((tmp)^ (src)))& 0x10);
    (ZF = !(WORD)(tmp2));
    (SF = (tmp2)& 0x8000);
    (PF = parity_table[(BYTE)(tmp2)]);

    (*(&wregs[0])= (tmp2));
}


 void i_push_ss()
{
     

    { unsigned tmp = (WORD)((*(&wregs[4]))-2); (*(&wregs[4])= (tmp)); (*(WORD *)((c_stack)+(WORD)(tmp))= (WORD)(sregs[2])); };
}


 void i_pop_ss()
{
     

    static int multiple = 0;

    { unsigned tmp = (*(&wregs[4])); sregs[2] = (*(WORD *)((c_stack)+(WORD)(tmp))); c_ss = (&memory[sregs[2] << 4]); tmp += 2; (*(&wregs[4])= (tmp)); };
    c_stack = c_ss;
    
    if (multiple == 0)	 
    {
        multiple = 1;
 
        instruction[((c_cs)[(ip)++])]();
        multiple = 0;
    }
}


 void i_sbb_br8()
{
     

    unsigned ModRM = (unsigned)((c_cs)[(ip)++]);
      unsigned src = (unsigned)*(ModRMRegB[ModRM])+CF;
    BYTE *dest = GetModRMRMB(ModRM);
      unsigned tmp = (unsigned) *dest;
      unsigned tmp2 = tmp;

    tmp -= src;

    CF = (tmp & 0x100) == 0x100;

 
    (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x80);
    (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
    (ZF = !(BYTE)(tmp));
    (SF = (tmp)& 0x80);
    (PF = parity_table[(BYTE)(tmp)]);

    *dest = (BYTE)tmp;
}


 void i_sbb_wr16()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
    WORD *src = (ModRMRegW[ModRM]);
    WORD *dest = GetModRMRMW(ModRM);
      unsigned tmp1 = (*(dest));
      unsigned tmp2 = (*(src))+CF;
      unsigned tmp3;

    tmp3 = tmp1-tmp2;

    CF = (tmp3 & 0x10000) == 0x10000;

 
    (OF = ((tmp1)^ (tmp2))& ((tmp1)^ (tmp3))& 0x8000);
    (AF = ((tmp3)^ ((tmp2)^ (tmp1)))& 0x10);
    (ZF = !(WORD)(tmp3));
    (SF = (tmp3)& 0x8000);
    (PF = parity_table[(BYTE)(tmp3)]);

    (*(dest)= (tmp3));
}


 void i_sbb_r8b()
{
     

    unsigned ModRM = (unsigned)((c_cs)[(ip)++]);
      unsigned src = (unsigned)*GetModRMRMB(ModRM)+CF;
    BYTE *dest = (ModRMRegB[ModRM]);
      unsigned tmp = (unsigned) *dest;
      unsigned tmp2 = tmp;

    tmp -= src;

    CF = (tmp & 0x100) == 0x100;

 
    (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x80);
    (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
    (ZF = !(BYTE)(tmp));
    (SF = (tmp)& 0x80);
    (PF = parity_table[(BYTE)(tmp)]);

    *dest = (BYTE)tmp;

}


 void i_sbb_r16w()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
    WORD *dest = (ModRMRegW[ModRM]);
    WORD *src = GetModRMRMW(ModRM);
      unsigned tmp1 = (*(dest));
      unsigned tmp2 = (*(src))+CF;
      unsigned tmp3;

    tmp3 = tmp1-tmp2;

    CF = (tmp3 & 0x10000) == 0x10000;

 
    (OF = ((tmp1)^ (tmp2))& ((tmp1)^ (tmp3))& 0x8000);
    (AF = ((tmp3)^ ((tmp2)^ (tmp1)))& 0x10);
    (ZF = !(WORD)(tmp3));
    (SF = (tmp3)& 0x8000);
    (PF = parity_table[(BYTE)(tmp3)]);

    (*(dest)= (tmp3));
}


 void i_sbb_ald8()
{
     

      unsigned src = ((c_cs)[(ip)++])+CF;
      unsigned tmp = *bregs[0];
      unsigned tmp1 = tmp;

    tmp1 -= src;

    CF = (tmp1 & 0x100) == 0x100;

 
    (OF = ((tmp)^ (src))& ((tmp)^ (tmp1))& 0x80);
    (AF = ((tmp1)^ ((src)^ (tmp)))& 0x10);
    (ZF = !(BYTE)(tmp1));
    (SF = (tmp1)& 0x80);
    (PF = parity_table[(BYTE)(tmp1)]);

    *bregs[0] = (BYTE)tmp1;
}


 void i_sbb_axd16()
{
     

      unsigned src;
      unsigned tmp = (*(&wregs[0]));
      unsigned tmp2 = tmp;

    src = ((c_cs)[(ip)++]);
    src += (((c_cs)[(ip)++])<< 8)+CF;

    tmp2 -= src;

    CF = (tmp2 & 0x10000) == 0x10000;

 
    (OF = ((tmp)^ (src))& ((tmp)^ (tmp2))& 0x8000);
    (AF = ((tmp2)^ ((tmp)^ (src)))& 0x10);
    (ZF = !(WORD)(tmp2));
    (SF = (tmp2)& 0x8000);
    (PF = parity_table[(BYTE)(tmp2)]);

    (*(&wregs[0])= (tmp2));
}


 void i_push_ds()
{
     

    { unsigned tmp = (WORD)((*(&wregs[4]))-2); (*(&wregs[4])= (tmp)); (*(WORD *)((c_stack)+(WORD)(tmp))= (WORD)(sregs[3])); };
}


 void i_pop_ds()
{
     
    { unsigned tmp = (*(&wregs[4])); sregs[3] = (*(WORD *)((c_stack)+(WORD)(tmp))); c_ds = (&memory[sregs[3] << 4]); tmp += 2; (*(&wregs[4])= (tmp)); };
}

     

void i_and_br8()
# 2289 
{ { unsigned ModRM = (unsigned)((c_cs)[(ip)++]); unsigned src = (unsigned)*(ModRMRegB[ModRM]); BYTE *dest = GetModRMRMB(ModRM); unsigned tmp = (unsigned) *dest; tmp &= src; CF = OF = AF = 0; (ZF = !(BYTE)(tmp)); (SF = (tmp)& 0x80); (PF = parity_table[(BYTE)(tmp)]); *dest = (BYTE)tmp; }; } void i_and_wr16()
# 2289 
{ { unsigned ModRM = ((c_cs)[(ip)++]); WORD *src = (ModRMRegW[ModRM]); WORD *dest = GetModRMRMW(ModRM); unsigned tmp1 = (unsigned)(*(src)); unsigned tmp2 = (unsigned)(*(dest)); unsigned tmp3 = tmp1 & tmp2; CF = OF = AF = 0; (ZF = !(WORD)(tmp3)); (SF = (tmp3)& 0x8000); (PF = parity_table[(BYTE)(tmp3)]); (*(dest)= (tmp3)); }; } void i_and_r8b()
# 2289 
{ { unsigned ModRM = (unsigned)((c_cs)[(ip)++]); unsigned src = (unsigned)*GetModRMRMB(ModRM); BYTE *dest = (ModRMRegB[ModRM]); unsigned tmp = (unsigned) *dest; tmp &= src; CF = OF = AF = 0; (ZF = !(BYTE)(tmp)); (SF = (tmp)& 0x80); (PF = parity_table[(BYTE)(tmp)]); *dest = (BYTE)tmp; }; } void i_and_r16w()
# 2289 
{ { unsigned ModRM = ((c_cs)[(ip)++]); WORD *dest = (ModRMRegW[ModRM]); WORD *src = GetModRMRMW(ModRM); unsigned tmp1 = (unsigned)(*(src)); unsigned tmp2 = (unsigned)(*(dest)); unsigned tmp3 = tmp1 & tmp2; CF = OF = AF = 0; (ZF = !(WORD)(tmp3)); (SF = (tmp3)& 0x8000); (PF = parity_table[(BYTE)(tmp3)]); (*(dest)= (tmp3)); }; } void i_and_ald8()
# 2289 
{ { unsigned tmp = *bregs[0]; tmp &= (unsigned)((c_cs)[(ip)++]); CF = OF = AF = 0; (ZF = !(BYTE)(tmp)); (SF = (tmp)& 0x80); (PF = parity_table[(BYTE)(tmp)]); *bregs[0] = (BYTE)tmp; }; } void i_and_axd16()
# 2289 
{ { unsigned src; unsigned tmp = (*(&wregs[0])); src = ((c_cs)[(ip)++]); src += ((c_cs)[(ip)++]) << 8; tmp &= src; CF = OF = AF = 0; (ZF = !(WORD)(tmp)); (SF = (tmp)& 0x8000); (PF = parity_table[(BYTE)(tmp)]); (*(&wregs[0])= (tmp)); }; }


 void i_es()
{
     

    c_ds = c_ss = c_es;

    instruction[((c_cs)[(ip)++])]();

    c_ds = (&memory[sregs[3] << 4]);
    c_ss = (&memory[sregs[2] << 4]);
}

 void i_daa()
{
    if (AF || ((*bregs[0] & 0xf)> 9))
    {
        *bregs[0] += 6;
        AF = 1;
    }
    else
        AF = 0;

    if (CF || (*bregs[0] > 0x9f))
    {
        *bregs[0] += 0x60;
        CF = 1;
    }
    else
        CF = 0;

    (PF = parity_table[(BYTE)(*bregs[0])]);
    (SF = (*bregs[0])& 0x80);
    (ZF = !(BYTE)(*bregs[0]));
}

 void i_sub_br8()
{
     

    unsigned ModRM = (unsigned)((c_cs)[(ip)++]);
      unsigned src = (unsigned)*(ModRMRegB[ModRM]);
    BYTE *dest = GetModRMRMB(ModRM);
      unsigned tmp = (unsigned) *dest;
      unsigned tmp2 = tmp;

    tmp -= src;

    (CF = (BYTE)(tmp)> (BYTE)(tmp2));
    (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x80);
    (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
    (ZF = !(BYTE)(tmp));
    (SF = (tmp)& 0x80);
    (PF = parity_table[(BYTE)(tmp)]);

    *dest = (BYTE)tmp;

}


 void i_sub_wr16()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
    WORD *src = (ModRMRegW[ModRM]);
    WORD *dest = GetModRMRMW(ModRM);
      unsigned tmp1 = (*(dest));
      unsigned tmp2 = (*(src));
      unsigned tmp3;

    tmp3 = tmp1-tmp2;

    (CF = (WORD)(tmp2)> (WORD)(tmp1));
    (OF = ((tmp1)^ (tmp2))& ((tmp1)^ (tmp3))& 0x8000);
    (AF = ((tmp3)^ ((tmp2)^ (tmp1)))& 0x10);
    (ZF = !(WORD)(tmp3));
    (SF = (tmp3)& 0x8000);
    (PF = parity_table[(BYTE)(tmp3)]);

    (*(dest)= (tmp3));
}


 void i_sub_r8b()
{
     

    unsigned ModRM = (unsigned)((c_cs)[(ip)++]);
    BYTE *dest = (ModRMRegB[ModRM]);
      unsigned src = *GetModRMRMB(ModRM);
      unsigned tmp = *dest;
      unsigned tmp2 = tmp;

    tmp -= src;

    (CF = (BYTE)(tmp)> (BYTE)(tmp2));
    (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x80);
    (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
    (ZF = !(BYTE)(tmp));
    (SF = (tmp)& 0x80);
    (PF = parity_table[(BYTE)(tmp)]);

    *dest = (BYTE)tmp;
}


 void i_sub_r16w()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
    WORD *dest = (ModRMRegW[ModRM]);
    WORD *src = GetModRMRMW(ModRM);
      unsigned tmp1 = (*(dest));
      unsigned tmp2 = (*(src));
      unsigned tmp3;

    tmp3 = tmp1-tmp2;

    (CF = (WORD)(tmp2)> (WORD)(tmp1));
    (OF = ((tmp1)^ (tmp2))& ((tmp1)^ (tmp3))& 0x8000);
    (AF = ((tmp3)^ ((tmp2)^ (tmp1)))& 0x10);
    (ZF = !(WORD)(tmp3));
    (SF = (tmp3)& 0x8000);
    (PF = parity_table[(BYTE)(tmp3)]);

    (*(dest)= (tmp3));
}


 void i_sub_ald8()
{
     

      unsigned src = ((c_cs)[(ip)++]);
      unsigned tmp = *bregs[0];
      unsigned tmp1 = tmp;

    tmp1 -= src;

    (CF = (BYTE)(src)> (BYTE)(tmp));
    (OF = ((tmp)^ (src))& ((tmp)^ (tmp1))& 0x80);
    (AF = ((tmp1)^ ((src)^ (tmp)))& 0x10);
    (ZF = !(BYTE)(tmp1));
    (SF = (tmp1)& 0x80);
    (PF = parity_table[(BYTE)(tmp1)]);

    *bregs[0] = (unsigned) tmp1;
}


 void i_sub_axd16()
{
     

      unsigned src;
      unsigned tmp = (*(&wregs[0]));
      unsigned tmp2 = tmp;

    src = ((c_cs)[(ip)++]);
    src += (((c_cs)[(ip)++])<< 8);

    tmp2 -= src;

    (CF = (WORD)(src)> (WORD)(tmp));
    (OF = ((tmp)^ (src))& ((tmp)^ (tmp2))& 0x8000);
    (AF = ((tmp2)^ ((tmp)^ (src)))& 0x10);
    (ZF = !(WORD)(tmp2));
    (SF = (tmp2)& 0x8000);
    (PF = parity_table[(BYTE)(tmp2)]);

    (*(&wregs[0])= (tmp2));
}


 void i_cs()
{
     

    c_ds = c_ss = c_cs;

    instruction[((c_cs)[(ip)++])]();

    c_ds = (&memory[sregs[3] << 4]);
    c_ss = (&memory[sregs[2] << 4]);
}


     

void i_xor_br8()
# 2482 
{ { unsigned ModRM = (unsigned)((c_cs)[(ip)++]); unsigned src = (unsigned)*(ModRMRegB[ModRM]); BYTE *dest = GetModRMRMB(ModRM); unsigned tmp = (unsigned) *dest; tmp ^= src; CF = OF = AF = 0; (ZF = !(BYTE)(tmp)); (SF = (tmp)& 0x80); (PF = parity_table[(BYTE)(tmp)]); *dest = (BYTE)tmp; }; } void i_xor_wr16()
# 2482 
{ { unsigned ModRM = ((c_cs)[(ip)++]); WORD *src = (ModRMRegW[ModRM]); WORD *dest = GetModRMRMW(ModRM); unsigned tmp1 = (unsigned)(*(src)); unsigned tmp2 = (unsigned)(*(dest)); unsigned tmp3 = tmp1 ^ tmp2; CF = OF = AF = 0; (ZF = !(WORD)(tmp3)); (SF = (tmp3)& 0x8000); (PF = parity_table[(BYTE)(tmp3)]); (*(dest)= (tmp3)); }; } void i_xor_r8b()
# 2482 
{ { unsigned ModRM = (unsigned)((c_cs)[(ip)++]); unsigned src = (unsigned)*GetModRMRMB(ModRM); BYTE *dest = (ModRMRegB[ModRM]); unsigned tmp = (unsigned) *dest; tmp ^= src; CF = OF = AF = 0; (ZF = !(BYTE)(tmp)); (SF = (tmp)& 0x80); (PF = parity_table[(BYTE)(tmp)]); *dest = (BYTE)tmp; }; } void i_xor_r16w()
# 2482 
{ { unsigned ModRM = ((c_cs)[(ip)++]); WORD *dest = (ModRMRegW[ModRM]); WORD *src = GetModRMRMW(ModRM); unsigned tmp1 = (unsigned)(*(src)); unsigned tmp2 = (unsigned)(*(dest)); unsigned tmp3 = tmp1 ^ tmp2; CF = OF = AF = 0; (ZF = !(WORD)(tmp3)); (SF = (tmp3)& 0x8000); (PF = parity_table[(BYTE)(tmp3)]); (*(dest)= (tmp3)); }; } void i_xor_ald8()
# 2482 
{ { unsigned tmp = *bregs[0]; tmp ^= (unsigned)((c_cs)[(ip)++]); CF = OF = AF = 0; (ZF = !(BYTE)(tmp)); (SF = (tmp)& 0x80); (PF = parity_table[(BYTE)(tmp)]); *bregs[0] = (BYTE)tmp; }; } void i_xor_axd16()
# 2482 
{ { unsigned src; unsigned tmp = (*(&wregs[0])); src = ((c_cs)[(ip)++]); src += ((c_cs)[(ip)++]) << 8; tmp ^= src; CF = OF = AF = 0; (ZF = !(WORD)(tmp)); (SF = (tmp)& 0x8000); (PF = parity_table[(BYTE)(tmp)]); (*(&wregs[0])= (tmp)); }; }


 void i_ss()
{
     

    c_ds = c_ss;

    instruction[((c_cs)[(ip)++])]();

    c_ds = (&memory[sregs[3] << 4]);
}


 void i_cmp_br8()
{
     

    unsigned ModRM = (unsigned)((c_cs)[(ip)++]);
      unsigned src = (unsigned)*(ModRMRegB[ModRM]);
      unsigned tmp = *GetModRMRMB(ModRM);
      unsigned tmp2 = tmp;

    tmp -= src;

    (CF = (BYTE)(tmp)> (BYTE)(tmp2));
    (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x80);
    (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
    (ZF = !(BYTE)(tmp));
    (SF = (tmp)& 0x80);
    (PF = parity_table[(BYTE)(tmp)]);
}


 void i_cmp_wr16()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
    WORD *src = (ModRMRegW[ModRM]);
    WORD *dest = GetModRMRMW(ModRM);
      unsigned tmp1 = (*(dest));
      unsigned tmp2 = (*(src));
      unsigned tmp3;

    tmp3 = tmp1-tmp2;

    (CF = (WORD)(tmp2)> (WORD)(tmp1));
    (OF = ((tmp1)^ (tmp2))& ((tmp1)^ (tmp3))& 0x8000);
    (AF = ((tmp3)^ ((tmp2)^ (tmp1)))& 0x10);
    (ZF = !(WORD)(tmp3));
    (SF = (tmp3)& 0x8000);
    (PF = parity_table[(BYTE)(tmp3)]);
}


 void i_cmp_r8b()
{
     

    unsigned ModRM = (unsigned)((c_cs)[(ip)++]);
      unsigned tmp = (unsigned)*(ModRMRegB[ModRM]);
      unsigned src = *GetModRMRMB(ModRM);
      unsigned tmp2 = tmp;

    tmp -= src;

    (CF = (BYTE)(tmp)> (BYTE)(tmp2));
    (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x80);
    (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
    (ZF = !(BYTE)(tmp));
    (SF = (tmp)& 0x80);
    (PF = parity_table[(BYTE)(tmp)]);
}

 void i_cmp_r16w()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
    WORD *dest = (ModRMRegW[ModRM]);
    WORD *src = GetModRMRMW(ModRM);
      unsigned tmp1 = (*(dest));
      unsigned tmp2 = (*(src));
      unsigned tmp3;

    tmp3 = tmp1-tmp2;

    (CF = (WORD)(tmp2)> (WORD)(tmp1));
    (OF = ((tmp1)^ (tmp2))& ((tmp1)^ (tmp3))& 0x8000);
    (AF = ((tmp3)^ ((tmp2)^ (tmp1)))& 0x10);
    (ZF = !(WORD)(tmp3));
    (SF = (tmp3)& 0x8000);
    (PF = parity_table[(BYTE)(tmp3)]);
}


 void i_cmp_ald8()
{
     

      unsigned src = ((c_cs)[(ip)++]);
      unsigned tmp = *bregs[0];
      unsigned tmp1 = tmp;

    tmp1 -= src;

    (CF = (BYTE)(src)> (BYTE)(tmp));
    (OF = ((tmp)^ (src))& ((tmp)^ (tmp1))& 0x80);
    (AF = ((tmp1)^ ((src)^ (tmp)))& 0x10);
    (ZF = !(BYTE)(tmp1));
    (SF = (tmp1)& 0x80);
    (PF = parity_table[(BYTE)(tmp1)]);
}


 void i_cmp_axd16()
{
     

      unsigned src;
      unsigned tmp = (*(&wregs[0]));
      unsigned tmp2 = tmp;

    src = ((c_cs)[(ip)++]);
    src += (((c_cs)[(ip)++])<< 8);

    tmp2 -= src;

    (CF = (WORD)(src)> (WORD)(tmp));
    (OF = ((tmp)^ (src))& ((tmp)^ (tmp2))& 0x8000);
    (AF = ((tmp2)^ ((tmp)^ (src)))& 0x10);
    (ZF = !(WORD)(tmp2));
    (SF = (tmp2)& 0x8000);
    (PF = parity_table[(BYTE)(tmp2)]);
}


 void i_ds()
{
     

    c_ss = c_ds;

    instruction[((c_cs)[(ip)++])]();

    c_ss = (&memory[sregs[2] << 4]);
}


 void i_inc_ax()
{
     
    { unsigned tmp = (unsigned)(*(&wregs[0])); unsigned tmp1 = tmp+1; (OF = ((tmp1)^ (tmp))& ((tmp1)^ (1))& 0x8000); (AF = ((tmp1)^ ((tmp)^ (1)))& 0x10); (ZF = !(WORD)(tmp1)); (SF = (tmp1)& 0x8000); (PF = parity_table[(BYTE)(tmp1)]); (*(&wregs[0])= (tmp1)); };
}


 void i_inc_cx()
{
     
    { unsigned tmp = (unsigned)(*(&wregs[1])); unsigned tmp1 = tmp+1; (OF = ((tmp1)^ (tmp))& ((tmp1)^ (1))& 0x8000); (AF = ((tmp1)^ ((tmp)^ (1)))& 0x10); (ZF = !(WORD)(tmp1)); (SF = (tmp1)& 0x8000); (PF = parity_table[(BYTE)(tmp1)]); (*(&wregs[1])= (tmp1)); };
}


 void i_inc_dx()
{
     
    { unsigned tmp = (unsigned)(*(&wregs[2])); unsigned tmp1 = tmp+1; (OF = ((tmp1)^ (tmp))& ((tmp1)^ (1))& 0x8000); (AF = ((tmp1)^ ((tmp)^ (1)))& 0x10); (ZF = !(WORD)(tmp1)); (SF = (tmp1)& 0x8000); (PF = parity_table[(BYTE)(tmp1)]); (*(&wregs[2])= (tmp1)); };
}


 void i_inc_bx()
{
     
    { unsigned tmp = (unsigned)(*(&wregs[3])); unsigned tmp1 = tmp+1; (OF = ((tmp1)^ (tmp))& ((tmp1)^ (1))& 0x8000); (AF = ((tmp1)^ ((tmp)^ (1)))& 0x10); (ZF = !(WORD)(tmp1)); (SF = (tmp1)& 0x8000); (PF = parity_table[(BYTE)(tmp1)]); (*(&wregs[3])= (tmp1)); };
}


 void i_inc_sp()
{
     
    { unsigned tmp = (unsigned)(*(&wregs[4])); unsigned tmp1 = tmp+1; (OF = ((tmp1)^ (tmp))& ((tmp1)^ (1))& 0x8000); (AF = ((tmp1)^ ((tmp)^ (1)))& 0x10); (ZF = !(WORD)(tmp1)); (SF = (tmp1)& 0x8000); (PF = parity_table[(BYTE)(tmp1)]); (*(&wregs[4])= (tmp1)); };
}


 void i_inc_bp()
{
     
    { unsigned tmp = (unsigned)(*(&wregs[5])); unsigned tmp1 = tmp+1; (OF = ((tmp1)^ (tmp))& ((tmp1)^ (1))& 0x8000); (AF = ((tmp1)^ ((tmp)^ (1)))& 0x10); (ZF = !(WORD)(tmp1)); (SF = (tmp1)& 0x8000); (PF = parity_table[(BYTE)(tmp1)]); (*(&wregs[5])= (tmp1)); };
}


 void i_inc_si()
{
     
    { unsigned tmp = (unsigned)(*(&wregs[6])); unsigned tmp1 = tmp+1; (OF = ((tmp1)^ (tmp))& ((tmp1)^ (1))& 0x8000); (AF = ((tmp1)^ ((tmp)^ (1)))& 0x10); (ZF = !(WORD)(tmp1)); (SF = (tmp1)& 0x8000); (PF = parity_table[(BYTE)(tmp1)]); (*(&wregs[6])= (tmp1)); };
}


 void i_inc_di()
{
     
    { unsigned tmp = (unsigned)(*(&wregs[7])); unsigned tmp1 = tmp+1; (OF = ((tmp1)^ (tmp))& ((tmp1)^ (1))& 0x8000); (AF = ((tmp1)^ ((tmp)^ (1)))& 0x10); (ZF = !(WORD)(tmp1)); (SF = (tmp1)& 0x8000); (PF = parity_table[(BYTE)(tmp1)]); (*(&wregs[7])= (tmp1)); };
}


 void i_dec_ax()
{
     
    { unsigned tmp = (unsigned)(*(&wregs[0])); unsigned tmp1 = tmp-1; (OF = ((tmp)^ (1))& ((tmp)^ (tmp1))& 0x8000); (AF = ((tmp1)^ ((tmp)^ (1)))& 0x10); (ZF = !(WORD)(tmp1)); (SF = (tmp1)& 0x8000); (PF = parity_table[(BYTE)(tmp1)]); (*(&wregs[0])= (tmp1)); };
}


 void i_dec_cx()
{
     
    { unsigned tmp = (unsigned)(*(&wregs[1])); unsigned tmp1 = tmp-1; (OF = ((tmp)^ (1))& ((tmp)^ (tmp1))& 0x8000); (AF = ((tmp1)^ ((tmp)^ (1)))& 0x10); (ZF = !(WORD)(tmp1)); (SF = (tmp1)& 0x8000); (PF = parity_table[(BYTE)(tmp1)]); (*(&wregs[1])= (tmp1)); };
}


 void i_dec_dx()
{
     
    { unsigned tmp = (unsigned)(*(&wregs[2])); unsigned tmp1 = tmp-1; (OF = ((tmp)^ (1))& ((tmp)^ (tmp1))& 0x8000); (AF = ((tmp1)^ ((tmp)^ (1)))& 0x10); (ZF = !(WORD)(tmp1)); (SF = (tmp1)& 0x8000); (PF = parity_table[(BYTE)(tmp1)]); (*(&wregs[2])= (tmp1)); };
}


 void i_dec_bx()
{
     
    { unsigned tmp = (unsigned)(*(&wregs[3])); unsigned tmp1 = tmp-1; (OF = ((tmp)^ (1))& ((tmp)^ (tmp1))& 0x8000); (AF = ((tmp1)^ ((tmp)^ (1)))& 0x10); (ZF = !(WORD)(tmp1)); (SF = (tmp1)& 0x8000); (PF = parity_table[(BYTE)(tmp1)]); (*(&wregs[3])= (tmp1)); };
}


 void i_dec_sp()
{
     
    { unsigned tmp = (unsigned)(*(&wregs[4])); unsigned tmp1 = tmp-1; (OF = ((tmp)^ (1))& ((tmp)^ (tmp1))& 0x8000); (AF = ((tmp1)^ ((tmp)^ (1)))& 0x10); (ZF = !(WORD)(tmp1)); (SF = (tmp1)& 0x8000); (PF = parity_table[(BYTE)(tmp1)]); (*(&wregs[4])= (tmp1)); };
}


 void i_dec_bp()
{
     
    { unsigned tmp = (unsigned)(*(&wregs[5])); unsigned tmp1 = tmp-1; (OF = ((tmp)^ (1))& ((tmp)^ (tmp1))& 0x8000); (AF = ((tmp1)^ ((tmp)^ (1)))& 0x10); (ZF = !(WORD)(tmp1)); (SF = (tmp1)& 0x8000); (PF = parity_table[(BYTE)(tmp1)]); (*(&wregs[5])= (tmp1)); };
}


 void i_dec_si()
{
     
    { unsigned tmp = (unsigned)(*(&wregs[6])); unsigned tmp1 = tmp-1; (OF = ((tmp)^ (1))& ((tmp)^ (tmp1))& 0x8000); (AF = ((tmp1)^ ((tmp)^ (1)))& 0x10); (ZF = !(WORD)(tmp1)); (SF = (tmp1)& 0x8000); (PF = parity_table[(BYTE)(tmp1)]); (*(&wregs[6])= (tmp1)); };
}


 void i_dec_di()
{
     
    { unsigned tmp = (unsigned)(*(&wregs[7])); unsigned tmp1 = tmp-1; (OF = ((tmp)^ (1))& ((tmp)^ (tmp1))& 0x8000); (AF = ((tmp1)^ ((tmp)^ (1)))& 0x10); (ZF = !(WORD)(tmp1)); (SF = (tmp1)& 0x8000); (PF = parity_table[(BYTE)(tmp1)]); (*(&wregs[7])= (tmp1)); };
}


 void i_push_ax()
{
     
    { unsigned tmp1 = (WORD)((*(&wregs[4]))-2); WORD tmp2; (*(&wregs[4])= (tmp1)); tmp2 = (*(&wregs[0])); (*(WORD *)((c_stack)+(WORD)(tmp1))= (WORD)(tmp2)); };
}


 void i_push_cx()
{
     
    { unsigned tmp1 = (WORD)((*(&wregs[4]))-2); WORD tmp2; (*(&wregs[4])= (tmp1)); tmp2 = (*(&wregs[1])); (*(WORD *)((c_stack)+(WORD)(tmp1))= (WORD)(tmp2)); };
}


 void i_push_dx()
{
     
    { unsigned tmp1 = (WORD)((*(&wregs[4]))-2); WORD tmp2; (*(&wregs[4])= (tmp1)); tmp2 = (*(&wregs[2])); (*(WORD *)((c_stack)+(WORD)(tmp1))= (WORD)(tmp2)); };
}


 void i_push_bx()
{
     
    { unsigned tmp1 = (WORD)((*(&wregs[4]))-2); WORD tmp2; (*(&wregs[4])= (tmp1)); tmp2 = (*(&wregs[3])); (*(WORD *)((c_stack)+(WORD)(tmp1))= (WORD)(tmp2)); };
}


 void i_push_sp()
{
     
    { unsigned tmp1 = (WORD)((*(&wregs[4]))-2); WORD tmp2; (*(&wregs[4])= (tmp1)); tmp2 = (*(&wregs[4])); (*(WORD *)((c_stack)+(WORD)(tmp1))= (WORD)(tmp2)); };
}


 void i_push_bp()
{
     
    { unsigned tmp1 = (WORD)((*(&wregs[4]))-2); WORD tmp2; (*(&wregs[4])= (tmp1)); tmp2 = (*(&wregs[5])); (*(WORD *)((c_stack)+(WORD)(tmp1))= (WORD)(tmp2)); };
}



 void i_push_si()
{
     
    { unsigned tmp1 = (WORD)((*(&wregs[4]))-2); WORD tmp2; (*(&wregs[4])= (tmp1)); tmp2 = (*(&wregs[6])); (*(WORD *)((c_stack)+(WORD)(tmp1))= (WORD)(tmp2)); };
}


 void i_push_di()
{
     
    { unsigned tmp1 = (WORD)((*(&wregs[4]))-2); WORD tmp2; (*(&wregs[4])= (tmp1)); tmp2 = (*(&wregs[7])); (*(WORD *)((c_stack)+(WORD)(tmp1))= (WORD)(tmp2)); };
}


 void i_pop_ax()
{
     
    { unsigned tmp = (*(&wregs[4])); WORD tmp2 = (*(WORD *)((c_stack)+(WORD)(tmp))); tmp += 2; (*(&wregs[4])= (tmp)); (*(&wregs[0])= (tmp2)); };
}


 void i_pop_cx()
{
     
    { unsigned tmp = (*(&wregs[4])); WORD tmp2 = (*(WORD *)((c_stack)+(WORD)(tmp))); tmp += 2; (*(&wregs[4])= (tmp)); (*(&wregs[1])= (tmp2)); };
}


 void i_pop_dx()
{
     
    { unsigned tmp = (*(&wregs[4])); WORD tmp2 = (*(WORD *)((c_stack)+(WORD)(tmp))); tmp += 2; (*(&wregs[4])= (tmp)); (*(&wregs[2])= (tmp2)); };
}


 void i_pop_bx()
{
     
    { unsigned tmp = (*(&wregs[4])); WORD tmp2 = (*(WORD *)((c_stack)+(WORD)(tmp))); tmp += 2; (*(&wregs[4])= (tmp)); (*(&wregs[3])= (tmp2)); };
}


 void i_pop_sp()
{
     
    { unsigned tmp = (*(&wregs[4])); WORD tmp2 = (*(WORD *)((c_stack)+(WORD)(tmp))); tmp += 2; (*(&wregs[4])= (tmp)); (*(&wregs[4])= (tmp2)); };
}


 void i_pop_bp()
{
     
    { unsigned tmp = (*(&wregs[4])); WORD tmp2 = (*(WORD *)((c_stack)+(WORD)(tmp))); tmp += 2; (*(&wregs[4])= (tmp)); (*(&wregs[5])= (tmp2)); };
}


 void i_pop_si()
{
     
    { unsigned tmp = (*(&wregs[4])); WORD tmp2 = (*(WORD *)((c_stack)+(WORD)(tmp))); tmp += 2; (*(&wregs[4])= (tmp)); (*(&wregs[6])= (tmp2)); };
}


 void i_pop_di()
{
     
    { unsigned tmp = (*(&wregs[4])); WORD tmp2 = (*(WORD *)((c_stack)+(WORD)(tmp))); tmp += 2; (*(&wregs[4])= (tmp)); (*(&wregs[7])= (tmp2)); };
}

     

void i_jo()
# 2859 
{ int tmp = (int)((INT8)((c_cs)[(ip)++])); if (OF) ip = (WORD)(ip+tmp); }                  
void i_jno()
# 2860 
{ int tmp = (int)((INT8)((c_cs)[(ip)++])); if (!OF) ip = (WORD)(ip+tmp); }                
void i_jb()
# 2861 
{ int tmp = (int)((INT8)((c_cs)[(ip)++])); if (CF) ip = (WORD)(ip+tmp); }                  
void i_jnb()
# 2862 
{ int tmp = (int)((INT8)((c_cs)[(ip)++])); if (!CF) ip = (WORD)(ip+tmp); }                
void i_jz()
# 2863 
{ int tmp = (int)((INT8)((c_cs)[(ip)++])); if (ZF) ip = (WORD)(ip+tmp); }                  
void i_jnz()
# 2864 
{ int tmp = (int)((INT8)((c_cs)[(ip)++])); if (!ZF) ip = (WORD)(ip+tmp); }                
void i_jbe()
# 2865 
{ int tmp = (int)((INT8)((c_cs)[(ip)++])); if (CF || ZF) ip = (WORD)(ip+tmp); }           
void i_jnbe()
# 2866 
{ int tmp = (int)((INT8)((c_cs)[(ip)++])); if (!(CF || ZF)) ip = (WORD)(ip+tmp); }       
void i_js()
# 2867 
{ int tmp = (int)((INT8)((c_cs)[(ip)++])); if (SF) ip = (WORD)(ip+tmp); }                  
void i_jns()
# 2868 
{ int tmp = (int)((INT8)((c_cs)[(ip)++])); if (!SF) ip = (WORD)(ip+tmp); }                
void i_jp()
# 2869 
{ int tmp = (int)((INT8)((c_cs)[(ip)++])); if (PF) ip = (WORD)(ip+tmp); }                  
void i_jnp()
# 2870 
{ int tmp = (int)((INT8)((c_cs)[(ip)++])); if (!PF) ip = (WORD)(ip+tmp); }                
void i_jl()
# 2871 
{ int tmp = (int)((INT8)((c_cs)[(ip)++])); if ((!(!SF)!=!(!OF))&&!ZF) ip = (WORD)(ip+tmp); }     
void i_jnl()
# 2872 
{ int tmp = (int)((INT8)((c_cs)[(ip)++])); if (ZF||(!(!SF)== !(!OF))) ip = (WORD)(ip+tmp); }  
void i_jle()
# 2873 
{ int tmp = (int)((INT8)((c_cs)[(ip)++])); if (ZF||(!(!SF)!= !(!OF))) ip = (WORD)(ip+tmp); }  
void i_jnle()
# 2874 
{ int tmp = (int)((INT8)((c_cs)[(ip)++])); if ((!(!SF)==!(!OF))&&!ZF) ip = (WORD)(ip+tmp); }   


 void i_80pre()
{
     
    unsigned ModRM = ((c_cs)[(ip)++]);
    BYTE *dest = GetModRMRMB(ModRM);
      unsigned src = ((c_cs)[(ip)++]);
      unsigned tmp = *dest;
      unsigned tmp2;
    
    
    switch (ModRM & 0x38)
    {
    case 0x00:   
        tmp2 = src + tmp;
        
        (CF = (BYTE)(tmp2)< (BYTE)(tmp));
        (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x80);
        (AF = ((tmp2)^ ((src)^ (tmp)))& 0x10);
        (ZF = !(BYTE)(tmp2));
        (SF = (tmp2)& 0x80);
        (PF = parity_table[(BYTE)(tmp2)]);
        
        *dest = (BYTE)tmp2;
        break;
    case 0x08:   
        tmp |= src;
        
        CF = OF = AF = 0;
        
        (ZF = !(BYTE)(tmp));
        (SF = (tmp)& 0x80);
        (PF = parity_table[(BYTE)(tmp)]);
        
        *dest = (BYTE)tmp;
        break;
    case 0x10:   
        src += CF;
        tmp2 = src + tmp;
        
        CF = tmp2 >> 8;
 
        (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x80);
        (AF = ((tmp2)^ ((src)^ (tmp)))& 0x10);
        (ZF = !(BYTE)(tmp2));
        (SF = (tmp2)& 0x80);
        (PF = parity_table[(BYTE)(tmp2)]);
        
        *dest = (BYTE)tmp2;
        break;
    case 0x18:   
        src += CF;
        tmp2 = tmp;
        tmp -= src;
        
        CF = (tmp & 0x100) == 0x100;

 
        (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x80);
        (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
        (ZF = !(BYTE)(tmp));
        (SF = (tmp)& 0x80);
        (PF = parity_table[(BYTE)(tmp)]);
        
        *dest = (BYTE)tmp;
        break;
    case 0x20:   
        tmp &= src;
        
        CF = OF = AF = 0;
        
        (ZF = !(BYTE)(tmp));
        (SF = (tmp)& 0x80);
        (PF = parity_table[(BYTE)(tmp)]);
        
        *dest = (BYTE)tmp;
        break;
    case 0x28:   
        tmp2 = tmp;
        tmp -= src;
        
        (CF = (BYTE)(tmp)> (BYTE)(tmp2));
        (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x80);
        (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
        (ZF = !(BYTE)(tmp));
        (SF = (tmp)& 0x80);
        (PF = parity_table[(BYTE)(tmp)]);
        
        *dest = (BYTE)tmp;
        break;
    case 0x30:   
        tmp ^= src;
        
        CF = OF = AF = 0;
        
        (ZF = !(BYTE)(tmp));
        (SF = (tmp)& 0x80);
        (PF = parity_table[(BYTE)(tmp)]);
        
        *dest = (BYTE)tmp;
        break;
    case 0x38:   
        tmp2 = tmp;
        tmp -= src;
        
        (CF = (BYTE)(tmp)> (BYTE)(tmp2));
        (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x80);
        (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
        (ZF = !(BYTE)(tmp));
        (SF = (tmp)& 0x80);
        (PF = parity_table[(BYTE)(tmp)]);
        
        break;
    }
}


 void i_81pre()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
    WORD *dest = GetModRMRMW(ModRM);
      unsigned src = ((c_cs)[(ip)++]);
      unsigned tmp = (*(dest));
      unsigned tmp2;

    src += ((c_cs)[(ip)++]) << 8;

    switch (ModRM & 0x38)
    {
    case 0x00:   
        tmp2 = src + tmp;
        
        (CF = (WORD)(tmp2)< (WORD)(tmp));
        (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x8000);
        (AF = ((tmp2)^ ((src)^ (tmp)))& 0x10);
        (ZF = !(WORD)(tmp2));
        (SF = (tmp2)& 0x8000);
        (PF = parity_table[(BYTE)(tmp2)]);
        
        (*(dest)= (tmp2));
        break;
    case 0x08:   
        tmp |= src;
        
        CF = OF = AF = 0;
        
        (ZF = !(WORD)(tmp));
        (SF = (tmp)& 0x8000);
        (PF = parity_table[(BYTE)(tmp)]);
        
        (*(dest)= (tmp));
        break;
    case 0x10:   
        src += CF;
        tmp2 = src + tmp;
        
        CF = tmp2 >> 16;
 
        (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x8000);
        (AF = ((tmp2)^ ((src)^ (tmp)))& 0x10);
        (ZF = !(WORD)(tmp2));
        (SF = (tmp2)& 0x8000);
        (PF = parity_table[(BYTE)(tmp2)]);
        
        (*(dest)= (tmp2));
        break;
    case 0x18:   
        src += CF;
        tmp2 = tmp;
        tmp -= src;
        
        CF = (tmp & 0x10000) == 0x10000;

 
        (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x8000);
        (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
        (ZF = !(WORD)(tmp));
        (SF = (tmp)& 0x8000);
        (PF = parity_table[(BYTE)(tmp)]);
        
        (*(dest)= (tmp));
        break;
    case 0x20:   
        tmp &= src;
        
        CF = OF = AF = 0;
        
        (ZF = !(WORD)(tmp));
        (SF = (tmp)& 0x8000);
        (PF = parity_table[(BYTE)(tmp)]);
        
        (*(dest)= (tmp));
        break;
    case 0x28:   
        tmp2 = tmp;
        tmp -= src;
        
        (CF = (WORD)(tmp)> (WORD)(tmp2));
        (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x8000);
        (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
        (ZF = !(WORD)(tmp));
        (SF = (tmp)& 0x8000);
        (PF = parity_table[(BYTE)(tmp)]);
        
        (*(dest)= (tmp));
        break;
    case 0x30:   
        tmp ^= src;
        
        CF = OF = AF = 0;
        
        (ZF = !(WORD)(tmp));
        (SF = (tmp)& 0x8000);
        (PF = parity_table[(BYTE)(tmp)]);
        
        (*(dest)= (tmp));
        break;
    case 0x38:   
        tmp2 = tmp;
        tmp -= src;
        
        (CF = (WORD)(tmp)> (WORD)(tmp2));
        (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x8000);
        (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
        (ZF = !(WORD)(tmp));
        (SF = (tmp)& 0x8000);
        (PF = parity_table[(BYTE)(tmp)]);
        
        break;
    }
}


 void i_83pre()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
    WORD *dest = GetModRMRMW(ModRM);
      unsigned src = (WORD)((INT16)((INT8)((c_cs)[(ip)++])));
      unsigned tmp = (*(dest));
      unsigned tmp2;
    
    switch (ModRM & 0x38)
    {
    case 0x00:   
        tmp2 = src + tmp;
        
        (CF = (WORD)(tmp2)< (WORD)(tmp));
        (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x8000);
        (AF = ((tmp2)^ ((src)^ (tmp)))& 0x10);
        (ZF = !(WORD)(tmp2));
        (SF = (tmp2)& 0x8000);
        (PF = parity_table[(BYTE)(tmp2)]);
        
        (*(dest)= (tmp2));
        break;
    case 0x08:   
        tmp |= src;
        
        CF = OF = AF = 0;
        
        (ZF = !(WORD)(tmp));
        (SF = (tmp)& 0x8000);
        (PF = parity_table[(BYTE)(tmp)]);
        
        (*(dest)= (tmp));
        break;
    case 0x10:   
        src += CF;
        tmp2 = src + tmp;
        
        CF = tmp2 >> 16;

 
        (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x8000);
        (AF = ((tmp2)^ ((src)^ (tmp)))& 0x10);
        (ZF = !(WORD)(tmp2));
        (SF = (tmp2)& 0x8000);
        (PF = parity_table[(BYTE)(tmp2)]);
        
        (*(dest)= (tmp2));
        break;
    case 0x18:   
        src += CF;
        tmp2 = tmp;
        tmp -= src;
        
        CF = (tmp & 0x10000) == 0x10000;

 
        (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x8000);
        (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
        (ZF = !(WORD)(tmp));
        (SF = (tmp)& 0x8000);
        (PF = parity_table[(BYTE)(tmp)]);
        
        (*(dest)= (tmp));
        break;
    case 0x20:   
        tmp &= src;
        
        CF = OF = AF = 0;
        
        (ZF = !(WORD)(tmp));
        (SF = (tmp)& 0x8000);
        (PF = parity_table[(BYTE)(tmp)]);
        
        (*(dest)= (tmp));
        break;
    case 0x28:   
        tmp2 = tmp;
        tmp -= src;
        
        (CF = (WORD)(tmp)> (WORD)(tmp2));
        (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x8000);
        (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
        (ZF = !(WORD)(tmp));
        (SF = (tmp)& 0x8000);
        (PF = parity_table[(BYTE)(tmp)]);
        
        (*(dest)= (tmp));
        break;
    case 0x30:   
        tmp ^= src;
        
        CF = OF = AF = 0;
        
        (ZF = !(WORD)(tmp));
        (SF = (tmp)& 0x8000);
        (PF = parity_table[(BYTE)(tmp)]);
        
        (*(dest)= (tmp));
        break;
        
    case 0x38:   
        tmp2 = tmp;
        tmp -= src;
        
        (CF = (WORD)(tmp)> (WORD)(tmp2));
        (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x8000);
        (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
        (ZF = !(WORD)(tmp));
        (SF = (tmp)& 0x8000);
        (PF = parity_table[(BYTE)(tmp)]);
        
        break;
    }
}


 void i_test_br8()
{
     

    unsigned ModRM = (unsigned)((c_cs)[(ip)++]);
      unsigned src = (unsigned)*(ModRMRegB[ModRM]);
    BYTE *dest = GetModRMRMB(ModRM);
      unsigned tmp = (unsigned) *dest;
    tmp &= src;
    CF = OF = AF = 0;
    (ZF = !(BYTE)(tmp));
    (SF = (tmp)& 0x80);
    (PF = parity_table[(BYTE)(tmp)]);
}


 void i_test_wr16()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
    WORD *src = (ModRMRegW[ModRM]);
    WORD *dest = GetModRMRMW(ModRM);
      unsigned tmp1 = (unsigned)(*(src));
      unsigned tmp2 = (unsigned)(*(dest));
      unsigned tmp3 = tmp1 & tmp2;
    CF = OF = AF = 0;
    (ZF = !(WORD)(tmp3));
    (SF = (tmp3)& 0x8000);
    (PF = parity_table[(BYTE)(tmp3)]);
}


 void i_xchg_br8()
{
     

    unsigned ModRM = (unsigned)((c_cs)[(ip)++]);
      BYTE *src = (ModRMRegB[ModRM]);
      BYTE *dest = GetModRMRMB(ModRM);
    BYTE tmp;

    tmp = *src;
    *src = *dest;
    *dest = tmp;
}


 void i_xchg_wr16()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
      BYTE *src = (BYTE *)(ModRMRegW[ModRM]);
      BYTE *dest = (BYTE *)GetModRMRMW(ModRM);
    BYTE tmp1,tmp2;

    tmp1 = src[0];
    tmp2 = src[1];
    src[0] = dest[0];
    src[1] = dest[1];
    dest[0] = tmp1;
    dest[1] = tmp2;

}


 void i_mov_br8()
{
     

      unsigned ModRM = ((c_cs)[(ip)++]);
      BYTE src = *(ModRMRegB[ModRM]);
      BYTE *dest = GetModRMRMB(ModRM);

    *dest = src;
}


 void i_mov_wr16()
{
     

      unsigned ModRM = ((c_cs)[(ip)++]);
      WORD *src = (ModRMRegW[ModRM]);
      WORD *dest = GetModRMRMW(ModRM);

    (*dest = *src);
}


 void i_mov_r8b()
{
     

      unsigned ModRM = ((c_cs)[(ip)++]);
      BYTE *dest = (ModRMRegB[ModRM]);
      BYTE src = *GetModRMRMB(ModRM);

    *dest = src;
}


 void i_mov_r16w()
{
     

      unsigned ModRM = ((c_cs)[(ip)++]);
      WORD *dest = (ModRMRegW[ModRM]);
      WORD *src = GetModRMRMW(ModRM);

    (*dest = *src);
}


 void i_mov_wsreg()
{
     

      unsigned ModRM = ((c_cs)[(ip)++]);
      WORD *dest = GetModRMRMW(ModRM);

    (*(dest)= (sregs[(ModRM & 0x38)>> 3]));
}


 void i_lea()
{
     

      unsigned ModRM = ((c_cs)[(ip)++]);
      unsigned src = 0;
      WORD *dest = (ModRMRegW[ModRM]);

    if (ModRMRM[ModRM].offset)
    {
        src = (WORD)((INT16)((INT8)((c_cs)[(ip)++])));
        if (ModRMRM[ModRM].offset16)
            src = (((c_cs)[(ip)++])<< 8) + (BYTE)(src);
    }

    src += (*(ModRMRM[ModRM].reg1))+(*(ModRMRM[ModRM].reg2));        
    (*(dest)= (src));
}


 void i_mov_sregw()
{
     
    
    static int multiple = 0;
      unsigned ModRM = ((c_cs)[(ip)++]);
      WORD *src = GetModRMRMW(ModRM);
    
    switch (ModRM & 0x38)
    {
    case 0x00:	 
        sregs[0] = (*(src));
        c_es = (&memory[sregs[0] << 4]);
        break;
    case 0x18:	 
        sregs[3] = (*(src));
        c_ds = (&memory[sregs[3] << 4]);
        break;
    case 0x10:	 
        sregs[2] = (*(src));
        c_stack = c_ss = (&memory[sregs[2] << 4]);
        
        if (multiple == 0)  
        {
            multiple = 1;
 
            instruction[((c_cs)[(ip)++])]();
            multiple = 0;
        }
        
        break;
    case 0x08:	 
        break;
        
    }
}


 void i_popw()
{
     
    
    unsigned ModRM = ((c_cs)[(ip)++]);
      WORD *dest = GetModRMRMW(ModRM);
      unsigned tmp = (*(&wregs[4]));
    WORD tmp2 = (*(WORD *)((c_stack)+(WORD)(tmp)));
    tmp += 2;
    (*(&wregs[4])= (tmp));
    (*(dest)= (tmp2));
}


 void i_nop()
{
     
}


 void i_xchg_axcx()
{
     
    { unsigned tmp; tmp = wregs[1]; wregs[1] = wregs[0]; wregs[0] = tmp; };
}


 void i_xchg_axdx()
{
     
    { unsigned tmp; tmp = wregs[2]; wregs[2] = wregs[0]; wregs[0] = tmp; };
}


 void i_xchg_axbx()
{
     
    { unsigned tmp; tmp = wregs[3]; wregs[3] = wregs[0]; wregs[0] = tmp; };
}


 void i_xchg_axsp()
{
     
    { unsigned tmp; tmp = wregs[4]; wregs[4] = wregs[0]; wregs[0] = tmp; };
}


 void i_xchg_axbp()
{
     
    { unsigned tmp; tmp = wregs[5]; wregs[5] = wregs[0]; wregs[0] = tmp; };
}


 void i_xchg_axsi()
{
     
    { unsigned tmp; tmp = wregs[6]; wregs[6] = wregs[0]; wregs[0] = tmp; };
}


 void i_xchg_axdi()
{
     
    { unsigned tmp; tmp = wregs[7]; wregs[7] = wregs[0]; wregs[0] = tmp; };
}

 void i_cbw()
{
     

    *bregs[4] = (*bregs[0] & 0x80) ? 0xff : 0;
}
        
 void i_cwd()
{
     

    wregs[2] = (*bregs[4] & 0x80) ? (WORD)(0xffff) : (WORD)(0);
}


 void i_call_far()
{
      unsigned tmp, tmp1, tmp2;

    tmp = ((c_cs)[(ip)++]);
    tmp += ((c_cs)[(ip)++]) << 8;

    tmp2 = ((c_cs)[(ip)++]);
    tmp2 += ((c_cs)[(ip)++]) << 8;

    tmp1 = (WORD)((*(&wregs[4]))-2);

    (*(WORD *)((c_stack)+(WORD)(tmp1))= (WORD)(sregs[1]));
    tmp1 = (WORD)(tmp1-2);
    (*(WORD *)((c_stack)+(WORD)(tmp1))= (WORD)(ip));

    (*(&wregs[4])= (tmp1));

    ip = (WORD)tmp;
    sregs[1] = (WORD)tmp2;
    c_cs = (&memory[sregs[1] << 4]);
}


 void i_wait()
{
     
    
    return;
}


 void i_pushf()
{
     

      unsigned tmp1 = ((*(&wregs[4]))-2);
    WORD tmp2 = (WORD)(CF | (PF << 2)| (!(!AF)<< 4)| (ZF << 6)| (!(!SF)<< 7)| (TF << 8)| (IF << 9)| (DF << 10)| (!(!OF)<< 11)) | 0xf000;

    (*(WORD *)((c_stack)+(WORD)(tmp1))= (WORD)(tmp2));
    (*(&wregs[4])= (tmp1));
}


 void i_popf()
{
     

      unsigned tmp = (*(&wregs[4]));
    unsigned tmp2 = (unsigned)(*(WORD *)((c_stack)+(WORD)(tmp)));

    { CF = (tmp2) & 1; PF = ((tmp2)& 4) == 4; AF = (tmp2) & 16; ZF = ((tmp2)& 64) == 64; SF = (tmp2) & 128; TF = ((tmp2)& 256) == 256; IF = ((tmp2)& 512) == 512; DF = ((tmp2)& 1024) == 1024; OF = (tmp2) & 2048; };
    tmp += 2;
    (*(&wregs[4])= (tmp));
    
    if (IF && int_blocked)
    {
        int_pending = int_blocked;
        int_blocked = 0;
        ;
    }
    if (TF) trap();
}


 void i_sahf()
{
     

    unsigned tmp = ((WORD)(CF | (PF << 2)| (!(!AF)<< 4)| (ZF << 6)| (!(!SF)<< 7)| (TF << 8)| (IF << 9)| (DF << 10)| (!(!OF)<< 11))& 0xff00) | (*bregs[4] & 0xd5);

    { CF = (tmp) & 1; PF = ((tmp)& 4) == 4; AF = (tmp) & 16; ZF = ((tmp)& 64) == 64; SF = (tmp) & 128; TF = ((tmp)& 256) == 256; IF = ((tmp)& 512) == 512; DF = ((tmp)& 1024) == 1024; OF = (tmp) & 2048; };
}


 void i_lahf()
{
     

    *bregs[4] = (WORD)(CF | (PF << 2)| (!(!AF)<< 4)| (ZF << 6)| (!(!SF)<< 7)| (TF << 8)| (IF << 9)| (DF << 10)| (!(!OF)<< 11)) & 0xff;
}

 void i_mov_aldisp()
{
     

      unsigned addr;

    addr = ((c_cs)[(ip)++]);
    addr += ((c_cs)[(ip)++]) << 8;

    *bregs[0] = ((BYTE)(c_ds)[(WORD)(addr)]);
}


 void i_mov_axdisp()
{
     

      unsigned addr;

    addr = ((c_cs)[(ip)++]);
    addr += ((c_cs)[(ip)++]) << 8;

    *bregs[0] = ((BYTE)(c_ds)[(WORD)(addr)]);
    *bregs[4] = ((BYTE)(c_ds)[(WORD)(addr+1)]);
}


 void i_mov_dispal()
{
     

      unsigned addr;

    addr = ((c_cs)[(ip)++]);
    addr += ((c_cs)[(ip)++]) << 8;

    ((c_ds)[(WORD)(addr)] = (BYTE)(*bregs[0]));
}


 void i_mov_dispax()
{
     

      unsigned addr;

    addr = ((c_cs)[(ip)++]);
    addr += ((c_cs)[(ip)++]) << 8;

    ((c_ds)[(WORD)(addr)] = (BYTE)(*bregs[0]));
    ((c_ds)[(WORD)(addr+1)] = (BYTE)(*bregs[4]));
}


 void i_movsb()
{
     

      unsigned di = (*(&wregs[7]));
      unsigned si = (*(&wregs[6]));

    BYTE tmp = ((BYTE)(c_ds)[(WORD)(si)]);

    ((c_es)[(WORD)(di)] = (BYTE)(tmp));

    di += -2*DF +1;
    si += -2*DF +1;

    (*(&wregs[7])= (di));
    (*(&wregs[6])= (si));
}


 void i_movsw()
{
     

      unsigned di = (*(&wregs[7]));
      unsigned si = (*(&wregs[6]));
    
    WORD tmp = (*(WORD *)((c_ds)+(WORD)(si)));

    (*(WORD *)((c_es)+(WORD)(di))= (WORD)(tmp));

    di += -4*DF +2;
    si += -4*DF +2;

    (*(&wregs[7])= (di));
    (*(&wregs[6])= (si));
}


 void i_cmpsb()
{
     

    unsigned di = (*(&wregs[7]));
    unsigned si = (*(&wregs[6]));
    unsigned src = ((BYTE)(c_es)[(WORD)(di)]);
    unsigned tmp = ((BYTE)(c_ds)[(WORD)(si)]);
    unsigned tmp2 = tmp;
    
    tmp -= src;

    (CF = (BYTE)(tmp)> (BYTE)(tmp2));
    (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x80);
    (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
    (ZF = !(BYTE)(tmp));
    (SF = (tmp)& 0x80);
    (PF = parity_table[(BYTE)(tmp)]);

    di += -2*DF +1;
    si += -2*DF +1;

    (*(&wregs[7])= (di));
    (*(&wregs[6])= (si));
}


 void i_cmpsw()
{
     

    unsigned di = (*(&wregs[7]));
    unsigned si = (*(&wregs[6]));
    unsigned src = (*(WORD *)((c_es)+(WORD)(di)));
    unsigned tmp = (*(WORD *)((c_ds)+(WORD)(si)));
    unsigned tmp2 = tmp;
    
    tmp -= src;

    (CF = (WORD)(tmp)> (WORD)(tmp2));
    (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x8000);
    (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
    (ZF = !(WORD)(tmp));
    (SF = (tmp)& 0x8000);
    (PF = parity_table[(BYTE)(tmp)]);

    di += -4*DF +2;
    si += -4*DF +2;

    (*(&wregs[7])= (di));
    (*(&wregs[6])= (si));
}


 void i_test_ald8()
{
     

      unsigned tmp1 = (unsigned)*bregs[0];
      unsigned tmp2 = (unsigned) ((c_cs)[(ip)++]);

    tmp1 &= tmp2;
    CF = OF = AF = 0;
    (ZF = !(BYTE)(tmp1));
    (SF = (tmp1)& 0x80);
    (PF = parity_table[(BYTE)(tmp1)]);
}


 void i_test_axd16()
{
     

      unsigned tmp1 = (unsigned)(*(&wregs[0]));
      unsigned tmp2;
    
    tmp2 = (unsigned) ((c_cs)[(ip)++]);
    tmp2 += ((c_cs)[(ip)++]) << 8;

    tmp1 &= tmp2;
    CF = OF = AF = 0;
    (ZF = !(WORD)(tmp1));
    (SF = (tmp1)& 0x8000);
    (PF = parity_table[(BYTE)(tmp1)]);
}

 void i_stosb()
{
     

      unsigned di = (*(&wregs[7]));

    ((c_es)[(WORD)(di)] = (BYTE)(*bregs[0]));
    di += -2*DF +1;
    (*(&wregs[7])= (di));
}

 void i_stosw()
{
     

      unsigned di = (*(&wregs[7]));

    ((c_es)[(WORD)(di)] = (BYTE)(*bregs[0]));
    ((c_es)[(WORD)(di+1)] = (BYTE)(*bregs[4]));
    di += -4*DF +2;;
    (*(&wregs[7])= (di));
}

 void i_lodsb()
{
     

      unsigned si = (*(&wregs[6]));

    *bregs[0] = ((BYTE)(c_ds)[(WORD)(si)]);
    si += -2*DF +1;
    (*(&wregs[6])= (si));
}

 void i_lodsw()
{
     

      unsigned si = (*(&wregs[6]));
      unsigned tmp = (*(WORD *)((c_ds)+(WORD)(si)));

    si +=  -4*DF+2;
    (*(&wregs[6])= (si));
    (*(&wregs[0])= (tmp));
}
    
 void i_scasb()
{
     

    unsigned di = (*(&wregs[7]));
    unsigned src = ((BYTE)(c_es)[(WORD)(di)]);
    unsigned tmp = *bregs[0];
    unsigned tmp2 = tmp;
    
    tmp -= src;

    (CF = (BYTE)(tmp)> (BYTE)(tmp2));
    (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x80);
    (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
    (ZF = !(BYTE)(tmp));
    (SF = (tmp)& 0x80);
    (PF = parity_table[(BYTE)(tmp)]);

    di += -2*DF +1;

    (*(&wregs[7])= (di));
}


 void i_scasw()
{
     

    unsigned di = (*(&wregs[7]));
    unsigned src = (*(WORD *)((c_es)+(WORD)(di)));
    unsigned tmp = (*(&wregs[0]));
    unsigned tmp2 = tmp;
    
    tmp -= src;

    (CF = (WORD)(tmp)> (WORD)(tmp2));
    (OF = ((tmp2)^ (src))& ((tmp2)^ (tmp))& 0x8000);
    (AF = ((tmp)^ ((src)^ (tmp2)))& 0x10);
    (ZF = !(WORD)(tmp));
    (SF = (tmp)& 0x8000);
    (PF = parity_table[(BYTE)(tmp)]);

    di += -4*DF +2;

    (*(&wregs[7])= (di));
}

 void i_mov_ald8()
{
     

    *bregs[0] = ((c_cs)[(ip)++]);
}


 void i_mov_cld8()
{
     

    *bregs[1] = ((c_cs)[(ip)++]);
}


 void i_mov_dld8()
{
     

    *bregs[2] = ((c_cs)[(ip)++]);
}


 void i_mov_bld8()
{
     

    *bregs[3] = ((c_cs)[(ip)++]);
}


 void i_mov_ahd8()
{
     

    *bregs[4] = ((c_cs)[(ip)++]);
}


 void i_mov_chd8()
{
     

    *bregs[5] = ((c_cs)[(ip)++]);
}


 void i_mov_dhd8()
{
     

    *bregs[6] = ((c_cs)[(ip)++]);
}


 void i_mov_bhd8()
{
     

    *bregs[7] = ((c_cs)[(ip)++]);
}


 void i_mov_axd16()
{
     

    *bregs[0] = ((c_cs)[(ip)++]);
    *bregs[4] = ((c_cs)[(ip)++]);
}


 void i_mov_cxd16()
{
     

    *bregs[1] = ((c_cs)[(ip)++]);
    *bregs[5] = ((c_cs)[(ip)++]);
}


 void i_mov_dxd16()
{
     

    *bregs[2] = ((c_cs)[(ip)++]);
    *bregs[6] = ((c_cs)[(ip)++]);
}


 void i_mov_bxd16()
{
     

    *bregs[3] = ((c_cs)[(ip)++]);
    *bregs[7] = ((c_cs)[(ip)++]);
}


 void i_mov_spd16()
{
     

    *bregs[8] = ((c_cs)[(ip)++]);
    *bregs[9] = ((c_cs)[(ip)++]);
}


 void i_mov_bpd16()
{
     

    *bregs[10] = ((c_cs)[(ip)++]);
    *bregs[11] = ((c_cs)[(ip)++]);
}


 void i_mov_sid16()
{
     

    *bregs[12] = ((c_cs)[(ip)++]);
    *bregs[13] = ((c_cs)[(ip)++]);
}


 void i_mov_did16()
{
     

    *bregs[14] = ((c_cs)[(ip)++]);
    *bregs[15] = ((c_cs)[(ip)++]);
}


 void i_ret_d16()
{
     

      unsigned tmp = (*(&wregs[4]));
      unsigned count;

    count = ((c_cs)[(ip)++]);
    count += ((c_cs)[(ip)++]) << 8;

    ip = (*(WORD *)((c_stack)+(WORD)(tmp)));
    tmp += count+2;
    (*(&wregs[4])= (tmp));
}


 void i_ret()
{
     

      unsigned tmp = (*(&wregs[4]));
    ip = (*(WORD *)((c_stack)+(WORD)(tmp)));
    tmp += 2;
    (*(&wregs[4])= (tmp));
}


 void i_les_dw()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
      WORD *dest = (ModRMRegW[ModRM]);
      WORD *src = GetModRMRMW(ModRM);
    WORD tmp = (*(src));

    (*(dest)= (tmp));
    src += 1;
    sregs[0] = (*(src));
    c_es = (&memory[sregs[0] << 4]);
}


 void i_lds_dw()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
      WORD *dest = (ModRMRegW[ModRM]);
      WORD *src = GetModRMRMW(ModRM);
    WORD tmp = (*(src));

    (*(dest)= (tmp));
    src += 1;
    sregs[3] = (*(src));
    c_ds = (&memory[sregs[3] << 4]);
}

 void i_mov_bd8()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
      BYTE *dest = GetModRMRMB(ModRM);

    *dest = ((c_cs)[(ip)++]);
}


 void i_mov_wd16()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
      BYTE *dest = (BYTE *)GetModRMRMW(ModRM);

    *dest++ = ((c_cs)[(ip)++]);
    *dest = ((c_cs)[(ip)++]);
}


 void i_retf_d16()
{
     

      unsigned tmp = (*(&wregs[4]));
      unsigned count;

    count = ((c_cs)[(ip)++]);
    count += ((c_cs)[(ip)++]) << 8;

    ip = (*(WORD *)((c_stack)+(WORD)(tmp)));
    tmp = (WORD)(tmp+2);
    sregs[1] = (*(WORD *)((c_stack)+(WORD)(tmp)));
    c_cs = (&memory[sregs[1] << 4]);
    tmp += count+2;
    (*(&wregs[4])= (tmp));
}


 void i_retf()
{
     

      unsigned tmp = (*(&wregs[4]));
    ip = (*(WORD *)((c_stack)+(WORD)(tmp)));
    tmp = (WORD)(tmp+2);
    sregs[1] = (*(WORD *)((c_stack)+(WORD)(tmp)));
    c_cs = (&memory[sregs[1] << 4]);
    tmp += 2;
    (*(&wregs[4])= (tmp));
}


 void i_int3()
{
     

    interrupt(3);
}


 void i_int()
{
     

    unsigned int_num = ((c_cs)[(ip)++]);

    interrupt(int_num);
}


 void i_into()
{
     

    if (OF)
        interrupt(4);
}


 void i_iret()
{
     

      unsigned tmp = (*(&wregs[4]));
    ip = (*(WORD *)((c_stack)+(WORD)(tmp)));
    tmp = (WORD)(tmp+2);
    sregs[1] = (*(WORD *)((c_stack)+(WORD)(tmp)));
    c_cs = (&memory[sregs[1] << 4]);
    tmp += 2;
    (*(&wregs[4])= (tmp));

    i_popf();

}    


 void i_d0pre()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
      BYTE *dest = GetModRMRMB(ModRM);
      unsigned tmp = *dest;
      unsigned tmp2 = tmp;

    switch (ModRM & 0x38)
    {
    case 0x00:   
        CF = (tmp & 0x80) != 0;
        *dest = (tmp << 1) + CF;
        OF = !(!(tmp & 0x40)) != CF;
        break;
    case 0x08:   
        CF = (tmp & 0x01) != 0;
        *dest = (tmp >> 1) + (CF << 7);
        OF = !(!(tmp & 0x80)) != CF;
        break;
    case 0x10:   
        OF = (tmp ^ (tmp << 1)) & 0x80;
        *dest = (tmp << 1) + CF;
        CF = (tmp & 0x80) != 0;
        break;
    case 0x18:   
        *dest = (tmp >> 1) + (CF << 7);
        OF = !(!(tmp & 0x80)) != CF;
        CF = (tmp & 0x01) != 0;
        break;
    case 0x20:   
    case 0x30:
        tmp += tmp;
        
        (CF = (BYTE)(tmp)< (BYTE)(tmp2));
        (OF = ((tmp)^ (tmp2))& ((tmp)^ (tmp2))& 0x80);
        AF = 1;
        (ZF = !(BYTE)(tmp));
        (SF = (tmp)& 0x80);
        (PF = parity_table[(BYTE)(tmp)]);
        
        *dest = (BYTE)tmp;
        break;
    case 0x28:   
        CF = (tmp & 0x01) != 0;
        OF = tmp & 0x80;
        
        tmp2 = tmp >> 1;
        
        (SF = (tmp2)& 0x80);
        (PF = parity_table[(BYTE)(tmp2)]);
        (ZF = !(BYTE)(tmp2));
        AF = 1;
        *dest = (BYTE)tmp2;
        break;
    case 0x38:   
        CF = (tmp & 0x01) != 0;
        OF = 0;
        
        tmp2 = (tmp >> 1) | (tmp & 0x80);
        
        (SF = (tmp2)& 0x80);
        (PF = parity_table[(BYTE)(tmp2)]);
        (ZF = !(BYTE)(tmp2));
        AF = 1;
        *dest = (BYTE)tmp2;
        break;
    }
}


 void i_d1pre()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
      WORD *dest = GetModRMRMW(ModRM);
      unsigned tmp = (*(dest));
      unsigned tmp2 = tmp;

    switch (ModRM & 0x38)
    {
    case 0x00:   
        CF = (tmp & 0x8000) != 0;
        tmp2 = (tmp << 1) + CF;
        OF = !(!(tmp & 0x4000)) != CF;
        (*(dest)= (tmp2));
        break;
    case 0x08:   
        CF = (tmp & 0x01) != 0;
        tmp2 = (tmp >> 1) + ((unsigned)CF << 15);
        OF = !(!(tmp & 0x8000)) != CF;
        (*(dest)= (tmp2));
        break;
    case 0x10:   
        tmp2 = (tmp << 1) + CF;
        OF = (tmp ^ (tmp << 1)) & 0x8000;
        CF = (tmp & 0x8000) != 0;
        (*(dest)= (tmp2));
        break;
    case 0x18:   
        tmp2 = (tmp >> 1) + ((unsigned)CF << 15);
        OF = !(!(tmp & 0x8000)) != CF;
        CF = (tmp & 0x01) != 0;
        (*(dest)= (tmp2));
        break;
    case 0x20:   
    case 0x30:
        tmp += tmp;
        
        (CF = (WORD)(tmp)< (WORD)(tmp2));
        (OF = ((tmp)^ (tmp2))& ((tmp)^ (tmp2))& 0x8000);
        AF = 1;
        (ZF = !(WORD)(tmp));
        (SF = (tmp)& 0x8000);
        (PF = parity_table[(BYTE)(tmp)]);
        
        (*(dest)= (tmp));
        break;
    case 0x28:   
        CF = (tmp & 0x01) != 0;
        OF = tmp & 0x8000;
        
        tmp2 = tmp >> 1;
        
        (SF = (tmp2)& 0x8000);
        (PF = parity_table[(BYTE)(tmp2)]);
        (ZF = !(WORD)(tmp2));
        AF = 1;
        (*(dest)= (tmp2));
        break;
    case 0x38:   
        CF = (tmp & 0x01) != 0;
        OF = 0;
        
        tmp2 = (tmp >> 1) | (tmp & 0x8000);
        
        (SF = (tmp2)& 0x8000);
        (PF = parity_table[(BYTE)(tmp2)]);
        (ZF = !(WORD)(tmp2));
        AF = 1;
        (*(dest)= (tmp2));
        break;
    }
}


 void i_d2pre()
{
     

    unsigned ModRM;
      BYTE *dest;
      unsigned tmp;
      unsigned tmp2;
    unsigned count;

    if (*bregs[1] == 1)
    {
        i_d0pre();
        ;
        return;
    }

    ModRM = ((c_cs)[(ip)++]);
    dest = GetModRMRMB(ModRM);
    tmp = (unsigned)*dest;
    count = (unsigned)*bregs[1];

    switch (ModRM & 0x38)
    {
    case 0x00:   
        for (; count > 0; count--)
        {
            CF = (tmp & 0x80) != 0;
            tmp = (tmp << 1) + CF;
        }
        *dest = (BYTE)tmp;
        break;
    case 0x08:   
        for (; count > 0; count--)
        {
            CF = (tmp & 0x01) != 0;
            tmp = (tmp >> 1) + (CF << 7);
        }
        *dest = (BYTE)tmp;
        break;
    case 0x10:   
        for (; count > 0; count--)
        {
            tmp2 = CF;
            CF = (tmp & 0x80) != 0;
            tmp = (tmp << 1) + tmp2;
        }
        *dest = (BYTE)tmp;
        break;
    case 0x18:   
        for (; count > 0; count--)
        {
            tmp2 = (tmp >> 1) + (CF << 7);
            CF = (tmp & 0x01) != 0;
            tmp = tmp2;
        }
        *dest = (BYTE)tmp;
        break;
    case 0x20:
    case 0x30:   
        if (count >= 9)
        {
            CF = 0;              
            tmp = 0;
        }
        else
        {
            CF = ((tmp << (count-1))& 0x80) != 0;
            tmp <<= count;
        }
        
        AF = 1;
        (ZF = !(BYTE)(tmp));
        (SF = (tmp)& 0x80);
        (PF = parity_table[(BYTE)(tmp)]);
        
        *dest = (BYTE)tmp;
        break;
    case 0x28:   
        if (count >= 9)
        {
            CF = 0;              
            tmp = 0;
        }
        else
        {
            CF = ((tmp >> (count-1))& 0x1) != 0;
            tmp >>= count;
        }
        
        (SF = (tmp)& 0x80);
        (PF = parity_table[(BYTE)(tmp)]);
        (ZF = !(BYTE)(tmp));
        AF = 1;
        *dest = (BYTE)tmp;
        break;
    case 0x38:   
        tmp2 = tmp & 0x80;
        CF = (((INT8)tmp >> (count-1))& 0x01) != 0;        
        for (; count > 0; count--)
            tmp = (tmp >> 1) | tmp2;
        
        (SF = (tmp)& 0x80);
        (PF = parity_table[(BYTE)(tmp)]);
        (ZF = !(BYTE)(tmp));
        AF = 1;
        *dest = (BYTE)tmp;
        break;
    }
}


 void i_d3pre()
{
     

    unsigned ModRM;
      WORD *dest;
      unsigned tmp;
      unsigned tmp2;
    unsigned count;

    if (*bregs[1] == 1)
    {
        i_d1pre();
        return;
    }

    ModRM = ((c_cs)[(ip)++]);
    dest = GetModRMRMW(ModRM);
    tmp = (*(dest));
    count = (unsigned)*bregs[1];

    switch (ModRM & 0x38)
    {
    case 0x00:   
        for (; count > 0; count--)
        {
            CF = (tmp & 0x8000) != 0;
            tmp = (tmp << 1) + CF;
        }
        (*(dest)= (tmp));
        break;
    case 0x08:   
        for (; count > 0; count--)
        {
            CF = (tmp & 0x01) != 0;
            tmp = (tmp >> 1) + (CF << 15);
        }
        (*(dest)= (tmp));
        break;
    case 0x10:   
        for (; count > 0; count--)
        {
            tmp2 = CF;
            CF = (tmp & 0x8000) != 0;
            tmp = (tmp << 1) + tmp2;
        }
        (*(dest)= (tmp));
        break;
    case 0x18:   
        for (; count > 0; count--)
        {
            tmp2 = (tmp >> 1) + (CF << 15);
            CF = (tmp & 0x01) != 0;
            tmp = tmp2;
        }
        (*(dest)= (tmp));
        break;
    case 0x20:
    case 0x30:   
        if (count >= 17)
        {
            CF = 0;              
            tmp = 0;
        }
        else
        {
            CF = ((tmp << (count-1))& 0x8000) != 0;
            tmp <<= count;
        }
        
        AF = 1;
        (ZF = !(WORD)(tmp));
        (SF = (tmp)& 0x8000);
        (PF = parity_table[(BYTE)(tmp)]);
        
        (*(dest)= (tmp));
        break;
    case 0x28:   
        if (count >= 17)
        {
            CF = 0;              
            tmp = 0;
        }
        else
        {
            CF = ((tmp >> (count-1))& 0x1) != 0;
            tmp >>= count;
        }
        
        (SF = (tmp)& 0x8000);
        (PF = parity_table[(BYTE)(tmp)]);
        (ZF = !(WORD)(tmp));
        AF = 1;
        (*(dest)= (tmp));
        break;
    case 0x38:   
        tmp2 = tmp & 0x8000;
        CF = (((INT16)tmp >> (count-1))& 0x01) != 0;        
        for (; count > 0; count--)
            tmp = (tmp >> 1) | tmp2;
        
        (SF = (tmp)& 0x8000);
        (PF = parity_table[(BYTE)(tmp)]);
        (ZF = !(WORD)(tmp));
        AF = 1;
        (*(dest)= (tmp));
        break;
    }
}

 void i_aam()
{
     
    unsigned mult = ((c_cs)[(ip)++]);

	if (mult == 0)
        interrupt(0);
    else
    {
        *bregs[4] = *bregs[0] / mult;
        *bregs[0] %= mult;

        (PF = parity_table[(BYTE)(*bregs[0])]);
        (ZF = !(WORD)(wregs[0]));
        (SF = (*bregs[4])& 0x80);
    }
}


 void i_aad()
{
     
    unsigned mult = ((c_cs)[(ip)++]);

    *bregs[0] = *bregs[4] * mult + *bregs[0];
    *bregs[4] = 0;

    (PF = parity_table[(BYTE)(*bregs[0])]);
    (ZF = !(BYTE)(*bregs[0]));
    SF = 0;
}

 void i_xlat()
{
     

    unsigned dest = (*(&wregs[3]))+*bregs[0];
    
    *bregs[0] = ((BYTE)(c_ds)[(WORD)(dest)]);
}

 void i_escape()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
    GetModRMRMB(ModRM);
}

 void i_loopne()
{
     

      int disp = (int)((INT8)((c_cs)[(ip)++]));
      unsigned tmp = (*(&wregs[1]))-1;

    (*(&wregs[1])= (tmp));

    if (!ZF && tmp) ip = (WORD)(ip+disp);
}

 void i_loope()
{
     

      int disp = (int)((INT8)((c_cs)[(ip)++]));
      unsigned tmp = (*(&wregs[1]))-1;

    (*(&wregs[1])= (tmp));

    if (ZF && tmp) ip = (WORD)(ip+disp);
}

 void i_loop()
{
     

      int disp = (int)((INT8)((c_cs)[(ip)++]));
      unsigned tmp = (*(&wregs[1]))-1;

    (*(&wregs[1])= (tmp));

    if (tmp) ip = (WORD)(ip+disp);
}

 void i_jcxz()
{
     

      int disp = (int)((INT8)((c_cs)[(ip)++]));
    
    if (wregs[1] == 0)
        ip = (WORD)(ip+disp);
}

 void i_inal()
{
     

    unsigned port = ((c_cs)[(ip)++]);

    *bregs[0] = read_port(port);
}

 void i_inax()
{
     

    unsigned port = ((c_cs)[(ip)++]);

    *bregs[0] = read_port(port);
    *bregs[4] = read_port(port+1);
}
    
 void i_outal()
{
     

    unsigned port = ((c_cs)[(ip)++]);

    write_port(port,*bregs[0]);
}

 void i_outax()
{
     

    unsigned port = ((c_cs)[(ip)++]);

    write_port(port,*bregs[0]);
    write_port(port+1,*bregs[4]);
}

 void i_call_d16()
{
     

      unsigned tmp;
      unsigned tmp1 = (WORD)((*(&wregs[4]))-2);

    tmp = ((c_cs)[(ip)++]);
    tmp += ((c_cs)[(ip)++]) << 8;

    (*(WORD *)((c_stack)+(WORD)(tmp1))= (WORD)(ip));
    (*(&wregs[4])= (tmp1));

    ip = (WORD)(ip+(INT16)tmp);
}


 void i_jmp_d16()
{
     

      int tmp = ((c_cs)[(ip)++]);
    tmp += ((c_cs)[(ip)++]) << 8;

    ip = (WORD)(ip+(INT16)tmp);
}


 void i_jmp_far()
{
     

      unsigned tmp,tmp1;

    tmp = ((c_cs)[(ip)++]);
    tmp += ((c_cs)[(ip)++]) << 8;

    tmp1 = ((c_cs)[(ip)++]);
    tmp1 += ((c_cs)[(ip)++]) << 8;

    sregs[1] = (WORD)tmp1;
    c_cs = (&memory[sregs[1] << 4]);
    ip = (WORD)tmp;
}


 void i_jmp_d8()
{
     
      int tmp = (int)((INT8)((c_cs)[(ip)++]));
    ip = (WORD)(ip+tmp);
}


 void i_inaldx()
{
     

    *bregs[0] = read_port((*(&wregs[2])));
}

 void i_inaxdx()
{
     

    unsigned port = (*(&wregs[2]));

    *bregs[0] = read_port(port);
    *bregs[4] = read_port(port+1);
}

 void i_outdxal()
{
     

    write_port((*(&wregs[2])),*bregs[0]);
}

 void i_outdxax()
{
     
    unsigned port = (*(&wregs[2]));

    write_port(port,*bregs[0]);
    write_port(port+1,*bregs[4]);
}

 void i_lock()
{
     
}

 void i_gobios()
{
     

    void (*routine)();
    unsigned dest;
    
    if (((c_cs)[(ip)++])!= 0xf1)
        i_notdone();

    dest = ((c_cs)[(ip)++]);	 
    dest += (((c_cs)[(ip)++])<< 8);
    dest += (((c_cs)[(ip)++])<< 16);
    dest += (((c_cs)[(ip)++])<< 24);

    routine = (void (*)())dest;

    routine();
}


void rep(flagval)
# 4759 
int flagval;
{
     

    unsigned next = ((c_cs)[(ip)++]);
    unsigned count = (*(&wregs[1]));

    switch(next)
    {
    case 0x26:   
        c_ss = c_ds = c_es;
        rep(flagval);
        c_ds = (&memory[sregs[3] << 4]);
        c_ss = (&memory[sregs[2] << 4]);
        break;
    case 0x2e:   
        c_ss = c_ds = c_cs;
        rep(flagval);
        c_ds = (&memory[sregs[3] << 4]);
        c_ss = (&memory[sregs[2] << 4]);
        break;
    case 0x36:   
        c_ds = c_ss;
        rep(flagval);
        c_ds = (&memory[sregs[3] << 4]);
        break;
    case 0x3e:   
        c_ss = c_ds;
        rep(flagval);
        c_ss = (&memory[sregs[2] << 4]);
        break;
    case 0xa4:   
        for (; count > 0; count--)
            i_movsb();
        (*(&wregs[1])= (count));
        break;
    case 0xa5:   
        for (; count > 0; count--)
            i_movsw();
        (*(&wregs[1])= (count));
        break;
    case 0xa6:   
        for (ZF = flagval; (ZF == flagval)&& (count > 0); count--)
            i_cmpsb();
        (*(&wregs[1])= (count));
        break;
    case 0xa7:   
        for (ZF = flagval; (ZF == flagval)&& (count > 0); count--)
            i_cmpsw();
        (*(&wregs[1])= (count));
        break;
    case 0xaa:   
        for (; count > 0; count--)
            i_stosb();
        (*(&wregs[1])= (count));
        break;
    case 0xab:   
        for (; count > 0; count--)
            i_stosw();
        (*(&wregs[1])= (count));
        break;
    case 0xac:   
        for (; count > 0; count--)
            i_lodsb();
        (*(&wregs[1])= (count));
        break;
    case 0xad:   
        for (; count > 0; count--)
            i_lodsw();
        (*(&wregs[1])= (count));
        break;
    case 0xae:   
        for (ZF = flagval; (ZF == flagval)&& (count > 0); count--)
            i_scasb();
        (*(&wregs[1])= (count));
        break;
    case 0xaf:   
        for (ZF = flagval; (ZF == flagval)&& (count > 0); count--)
            i_scasw();
        (*(&wregs[1])= (count));
        break;
    default:
        instruction[next]();
    }
}
            

 void i_repne()
{
     

    rep(0);
}


 void i_repe()
{
     

    rep(1);
}


 void i_cmc()
{
     

    CF = !CF;
}


 void i_f6pre()
{
	 
    unsigned ModRM = ((c_cs)[(ip)++]);
      BYTE *byte = GetModRMRMB(ModRM);
      unsigned tmp = (unsigned)*byte;
      unsigned tmp2;
    
    
    switch (ModRM & 0x38)
    {
    case 0x00:	 
    case 0x08:   
        tmp &= ((c_cs)[(ip)++]);
        
        CF = OF = AF = 0;
        (ZF = !(BYTE)(tmp));
        (SF = (tmp)& 0x80);
        (PF = parity_table[(BYTE)(tmp)]);
        break;
        
    case 0x10:	 
        *byte = ~tmp;
        break;
        
    case 0x18:	 
        tmp2 = tmp;
        tmp = -tmp;
        
        CF = (int)tmp2 > 0;
        
        (AF = ((tmp)^ ((0)^ (tmp2)))& 0x10);
        (ZF = !(BYTE)(tmp));
        (SF = (tmp)& 0x80);
        (PF = parity_table[(BYTE)(tmp)]);
        
        *byte = tmp;
        break;
    case 0x20:	 
	{
	    UINT16 result;
	    tmp2 = *bregs[0];
        
	    (SF = (tmp2)& 0x80);
	    (PF = parity_table[(BYTE)(tmp2)]);
        
	    result = (UINT16)tmp2*tmp;
	    (*(&wregs[0])= ((WORD)result));

	    (ZF = !(WORD)(wregs[0]));
	    CF = OF = (*bregs[4] != 0);
	}
        break;
    case 0x28:	 
	{
	    INT16 result;
        
	    tmp2 = (unsigned)*bregs[0];
        
	    (SF = (tmp2)& 0x80);
	    (PF = parity_table[(BYTE)(tmp2)]);
        
	    result = (INT16)((INT8)tmp2)*(INT16)((INT8)tmp);
	    (*(&wregs[0])= ((WORD)result));
        
	    (ZF = !(WORD)(wregs[0]));
        
	    OF = (result >> 7 != 0) && (result >> 7 != -1);
	    CF = !(!OF);
	}
        break;
    case 0x30:	 
	{
	    UINT16 result;
        
	    result = (*(&wregs[0]));
        
	    if (tmp)
	    {
            if ((result / tmp)> 0xff)
            {
                interrupt(0);
                break;
            }
            else
            {
                *bregs[4] = result % tmp;
                *bregs[0] = result / tmp;
            }
            
	    }
	    else
	    {
            interrupt(0);
            break;
	    }
	}
        break;
    case 0x38:	 
	{
	    INT16 result;
        
	    result = (*(&wregs[0]));
        
	    if (tmp)
	    {
            tmp2 = result % (INT16)((INT8)tmp);
            
            if ((result /= (INT16)((INT8)tmp))> 0xff)
            {
                interrupt(0);
                break;
            }
            else
            {
                *bregs[0] = result;
                *bregs[4] = tmp2;
            }
	    }
	    else
	    {
            interrupt(0);
            break;
	    }
	}
        break;
    }
}


 void i_f7pre()
{
	 
    unsigned ModRM = ((c_cs)[(ip)++]);
    WORD *wrd = GetModRMRMW(ModRM);
      unsigned tmp = (*(wrd));
      unsigned tmp2;
    
    
    switch (ModRM & 0x38)
    {
    case 0x00:	 
    case 0x08:   
        tmp2 = ((c_cs)[(ip)++]);
        tmp2 += ((c_cs)[(ip)++]) << 8;
        
        tmp &= tmp2;
        
        CF = OF = AF = 0;
        (ZF = !(WORD)(tmp));
        (SF = (tmp)& 0x8000);
        (PF = parity_table[(BYTE)(tmp)]);
        break;
        
    case 0x10:	 
        tmp = ~tmp;
        (*(wrd)= (tmp));
        break;
        
    case 0x18:	 
        tmp2 = tmp;
        tmp = -tmp;
        
        CF = (int)tmp2 > 0;
        
        (AF = ((tmp)^ ((0)^ (tmp2)))& 0x10);
        (ZF = !(WORD)(tmp));
        (SF = (tmp)& 0x8000);
        (PF = parity_table[(BYTE)(tmp)]);
        
        (*(wrd)= (tmp));
        break;
    case 0x20:	 
	{
	    UINT32 result;
	    tmp2 = (*(&wregs[0]));
        
	    (SF = (tmp2)& 0x8000);
	    (PF = parity_table[(BYTE)(tmp2)]);

	    result = (UINT32)tmp2*tmp;
	    (*(&wregs[0])= ((WORD)result));
        result >>= 16;
	    (*(&wregs[2])= (result));

	    (ZF = !(WORD)(wregs[0] | wregs[2]));
	    CF = OF = (wregs[2] != (WORD)(0));
	}
        break;
        
    case 0x28:	 
	{
	    INT32 result;
        
	    tmp2 = (*(&wregs[0]));
        
	    (SF = (tmp2)& 0x8000);
	    (PF = parity_table[(BYTE)(tmp2)]);
        
	    result = (INT32)((INT16)tmp2)*(INT32)((INT16)tmp);
        OF = (result >> 15 != 0) && (result >> 15 != -1);

	    (*(&wregs[0])= ((WORD)result));
        result = (WORD)(result >> 16);
	    (*(&wregs[2])= (result));

	    (ZF = !(WORD)(wregs[0] | wregs[2]));
        
        CF = !(!OF);
	}
        break;
    case 0x30:	 
	{
	    UINT32 result;
        
	    result = ((*(&wregs[2]))<< 16) + (*(&wregs[0]));
        
	    if (tmp)
	    {
            tmp2 = result % tmp;
            if ((result / tmp)> 0xffff)
            {
                interrupt(0);
                break;
            }
            else
            {
                (*(&wregs[2])= (tmp2));
                result /= tmp;
                (*(&wregs[0])= (result));
            }
	    }
	    else
	    {
            interrupt(0);
            break;
	    }
	}
        break;
    case 0x38:	 
	{
	    INT32 result;
        
	    result = ((*(&wregs[2]))<< 16) + (*(&wregs[0]));
        
	    if (tmp)
	    {
            tmp2 = result % (INT32)((INT16)tmp);
            
            if ((result /= (INT32)((INT16)tmp))> 0xffff)
            {
                interrupt(0);
                break;
            }
            else
            {
                (*(&wregs[0])= (result));
                (*(&wregs[2])= (tmp2));
            }
	    }
	    else
	    {
            interrupt(0);
            break;
	    }
	}
        break;
    }
}


 void i_clc()
{
     

    CF = 0;
}


 void i_stc()
{
	 

	CF = 1;
}


 void i_cli()
{
     

    IF = 0;
}


 void i_sti()
{
     

    IF = 1;

    if (int_blocked)
    {
        int_pending = int_blocked;
        int_blocked = 0;
        ;
    }
}


 void i_cld()
{
     

    DF = 0;
}


 void i_std()
{
     

    DF = 1;
}


 void i_fepre()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
      BYTE *dest = GetModRMRMB(ModRM);
      unsigned tmp = *dest;
      unsigned tmp1;
    
    if ((ModRM & 0x38)== 0)
    {
        tmp1 = tmp+1;
        (OF = ((tmp1)^ (tmp))& ((tmp1)^ (1))& 0x80);
    }
    else
    {
        tmp1 = tmp-1;
        (OF = ((tmp)^ (1))& ((tmp)^ (tmp1))& 0x80);
    }
    
    (AF = ((tmp1)^ ((tmp)^ (1)))& 0x10);
    (ZF = !(BYTE)(tmp1));
    (SF = (tmp1)& 0x80);
    (PF = parity_table[(BYTE)(tmp1)]);
    
    *dest = (BYTE)tmp1;
}


 void i_ffpre()
{
     

    unsigned ModRM = ((c_cs)[(ip)++]);
      WORD *dest = GetModRMRMW(ModRM);
      unsigned tmp;
      unsigned tmp1;

    switch(ModRM & 0x38)
    {
    case 0x00:   
        tmp = (*(dest));
        tmp1 = tmp+1;
        
        (OF = ((tmp1)^ (tmp))& ((tmp1)^ (1))& 0x8000);
        (AF = ((tmp1)^ ((tmp)^ (1)))& 0x10);
        (ZF = !(WORD)(tmp1));
        (SF = (tmp1)& 0x8000);
        (PF = parity_table[(BYTE)(tmp1)]);
        
        (*(dest)= ((WORD)tmp1));
        break;
        
    case 0x08:   
        tmp = (*(dest));
        tmp1 = tmp-1;
        
        (OF = ((tmp)^ (1))& ((tmp)^ (tmp1))& 0x8000);
        (AF = ((tmp1)^ ((tmp)^ (1)))& 0x10);
        (ZF = !(WORD)(tmp1));
        (SF = (tmp1)& 0x8000);
        (PF = parity_table[(BYTE)(tmp1)]);
        
        (*(dest)= ((WORD)tmp1));
        break;
        
    case 0x10:   
        tmp = (*(dest));
        tmp1 = (WORD)((*(&wregs[4]))-2);
        
        (*(WORD *)((c_stack)+(WORD)(tmp1))= (WORD)(ip));
        (*(&wregs[4])= (tmp1));
        
        ip = (WORD)tmp;
        break;
        
    case 0x18:   
        tmp1 = (WORD)((*(&wregs[4]))-2);
        
        (*(WORD *)((c_stack)+(WORD)(tmp1))= (WORD)(sregs[1]));
        tmp1 = (WORD)(tmp1-2);
        (*(WORD *)((c_stack)+(WORD)(tmp1))= (WORD)(ip));
        (*(&wregs[4])= (tmp1));
        
        ip = (*(dest));
        dest++;
        sregs[1] = (*(dest));
        c_cs = (&memory[sregs[1] << 4]);
        break;
        
    case 0x20:   
        ip = (*(dest));
        break;
        
    case 0x28:   
        ip = (*(dest));
        dest++;
        sregs[1] = (*(dest));
        c_cs = (&memory[sregs[1] << 4]);
        break;
        
    case 0x30:   
        tmp1 = (WORD)((*(&wregs[4]))-2);
        tmp = (*(dest));
        
        (*(WORD *)((c_stack)+(WORD)(tmp1))= (WORD)(tmp));
        (*(&wregs[4])= (tmp1));
        break;
    }
}


void i_notdone()
{
    fprintf((&_iob[2]),"Error: Unimplemented opcode %02X at cs:ip = %04X:%04X\n",
c_cs[ip-1],sregs[1],ip-1);
    exit(1);
}


void trap()
{
    instruction[((c_cs)[(ip)++])]();
    interrupt(1);
}


void execute()
{
    c_cs = (&memory[sregs[1] << 4]);
    c_ds = (&memory[sregs[3] << 4]);
    c_es = (&memory[sregs[0] << 4]);
    c_stack = c_ss = (&memory[sregs[2] << 4]);
    
    for(;;)
    {
        if (int_pending)
            external_int();




   
        switch(((c_cs)[(ip)++]))
        {
        case 0x00:    i_add_br8(); break;
        case 0x01:    i_add_wr16(); break;
        case 0x02:    i_add_r8b(); break;
        case 0x03:    i_add_r16w(); break;
        case 0x04:    i_add_ald8(); break;
        case 0x05:    i_add_axd16(); break;
        case 0x06:    i_push_es(); break;
        case 0x07:    i_pop_es(); break;
        case 0x08:    i_or_br8(); break;
        case 0x09:    i_or_wr16(); break;
        case 0x0a:    i_or_r8b(); break;
        case 0x0b:    i_or_r16w(); break;
        case 0x0c:    i_or_ald8(); break;
        case 0x0d:    i_or_axd16(); break;
        case 0x0e:    i_push_cs(); break;
        case 0x0f:    i_notdone(); break;
        case 0x10:    i_adc_br8(); break;
        case 0x11:    i_adc_wr16(); break;
        case 0x12:    i_adc_r8b(); break;
        case 0x13:    i_adc_r16w(); break;
        case 0x14:    i_adc_ald8(); break;
        case 0x15:    i_adc_axd16(); break;
        case 0x16:    i_push_ss(); break;
        case 0x17:    i_pop_ss(); break;
        case 0x18:    i_sbb_br8(); break;
        case 0x19:    i_sbb_wr16(); break;
        case 0x1a:    i_sbb_r8b(); break;
        case 0x1b:    i_sbb_r16w(); break;
        case 0x1c:    i_sbb_ald8(); break;
        case 0x1d:    i_sbb_axd16(); break;
        case 0x1e:    i_push_ds(); break;
        case 0x1f:    i_pop_ds(); break;
        case 0x20:    i_and_br8(); break;
        case 0x21:    i_and_wr16(); break;
        case 0x22:    i_and_r8b(); break;
        case 0x23:    i_and_r16w(); break;
        case 0x24:    i_and_ald8(); break;
        case 0x25:    i_and_axd16(); break;
        case 0x26:    i_es(); break;
        case 0x27:    i_daa(); break;
        case 0x28:    i_sub_br8(); break;
        case 0x29:    i_sub_wr16(); break;
        case 0x2a:    i_sub_r8b(); break;
        case 0x2b:    i_sub_r16w(); break;
        case 0x2c:    i_sub_ald8(); break;
        case 0x2d:    i_sub_axd16(); break;
        case 0x2e:    i_cs(); break;
        case 0x2f:    i_notdone(); break;
        case 0x30:    i_xor_br8(); break;
        case 0x31:    i_xor_wr16(); break;
        case 0x32:    i_xor_r8b(); break;
        case 0x33:    i_xor_r16w(); break;
        case 0x34:    i_xor_ald8(); break;
        case 0x35:    i_xor_axd16(); break;
        case 0x36:    i_ss(); break;
        case 0x37:    i_notdone(); break;
        case 0x38:    i_cmp_br8(); break;
        case 0x39:    i_cmp_wr16(); break;
        case 0x3a:    i_cmp_r8b(); break;
        case 0x3b:    i_cmp_r16w(); break;
        case 0x3c:    i_cmp_ald8(); break;
        case 0x3d:    i_cmp_axd16(); break;
        case 0x3e:    i_ds(); break;
        case 0x3f:    i_notdone(); break;
        case 0x40:    i_inc_ax(); break;
        case 0x41:    i_inc_cx(); break;
        case 0x42:    i_inc_dx(); break;
        case 0x43:    i_inc_bx(); break;
        case 0x44:    i_inc_sp(); break;
        case 0x45:    i_inc_bp(); break;
        case 0x46:    i_inc_si(); break;
        case 0x47:    i_inc_di(); break;
        case 0x48:    i_dec_ax(); break;
        case 0x49:    i_dec_cx(); break;
        case 0x4a:    i_dec_dx(); break;
        case 0x4b:    i_dec_bx(); break;
        case 0x4c:    i_dec_sp(); break;
        case 0x4d:    i_dec_bp(); break;
        case 0x4e:    i_dec_si(); break;
        case 0x4f:    i_dec_di(); break;
        case 0x50:    i_push_ax(); break;
        case 0x51:    i_push_cx(); break;
        case 0x52:    i_push_dx(); break;
        case 0x53:    i_push_bx(); break;
        case 0x54:    i_push_sp(); break;
        case 0x55:    i_push_bp(); break;
        case 0x56:    i_push_si(); break;
        case 0x57:    i_push_di(); break;
        case 0x58:    i_pop_ax(); break;
        case 0x59:    i_pop_cx(); break;
        case 0x5a:    i_pop_dx(); break;
        case 0x5b:    i_pop_bx(); break;
        case 0x5c:    i_pop_sp(); break;
        case 0x5d:    i_pop_bp(); break;
        case 0x5e:    i_pop_si(); break;
        case 0x5f:    i_pop_di(); break;
        case 0x60:    i_notdone(); break;
        case 0x61:    i_notdone(); break;
        case 0x62:    i_notdone(); break;
        case 0x63:    i_notdone(); break;
        case 0x64:    i_notdone(); break;
        case 0x65:    i_notdone(); break;
        case 0x66:    i_notdone(); break;
        case 0x67:    i_notdone(); break;
        case 0x68:    i_notdone(); break;
        case 0x69:    i_notdone(); break;
        case 0x6a:    i_notdone(); break;
        case 0x6b:    i_notdone(); break;
        case 0x6c:    i_notdone(); break;
        case 0x6d:    i_notdone(); break;
        case 0x6e:    i_notdone(); break;
        case 0x6f:    i_notdone(); break;
        case 0x70:    i_jo(); break;
        case 0x71:    i_jno(); break;
        case 0x72:    i_jb(); break;
        case 0x73:    i_jnb(); break;
        case 0x74:    i_jz(); break;
        case 0x75:    i_jnz(); break;
        case 0x76:    i_jbe(); break;
        case 0x77:    i_jnbe(); break;
        case 0x78:    i_js(); break;
        case 0x79:    i_jns(); break;
        case 0x7a:    i_jp(); break;
        case 0x7b:    i_jnp(); break;
        case 0x7c:    i_jl(); break;
        case 0x7d:    i_jnl(); break;
        case 0x7e:    i_jle(); break;
        case 0x7f:    i_jnle(); break;
        case 0x80:    i_80pre(); break;
        case 0x81:    i_81pre(); break;
        case 0x82:    i_notdone(); break;
        case 0x83:    i_83pre(); break;
        case 0x84:    i_test_br8(); break;
        case 0x85:    i_test_wr16(); break;
        case 0x86:    i_xchg_br8(); break;
        case 0x87:    i_xchg_wr16(); break;
        case 0x88:    i_mov_br8(); break;
        case 0x89:    i_mov_wr16(); break;
        case 0x8a:    i_mov_r8b(); break;
        case 0x8b:    i_mov_r16w(); break;
        case 0x8c:    i_mov_wsreg(); break;
        case 0x8d:    i_lea(); break;
        case 0x8e:    i_mov_sregw(); break;
        case 0x8f:    i_popw(); break;
        case 0x90:    i_nop(); break;
        case 0x91:    i_xchg_axcx(); break;
        case 0x92:    i_xchg_axdx(); break;
        case 0x93:    i_xchg_axbx(); break;
        case 0x94:    i_xchg_axsp(); break;
        case 0x95:    i_xchg_axbp(); break;
        case 0x96:    i_xchg_axsi(); break;
        case 0x97:    i_xchg_axdi(); break;
        case 0x98:    i_cbw(); break;
        case 0x99:    i_cwd(); break;
        case 0x9a:    i_call_far(); break;
        case 0x9b:    i_wait(); break;
        case 0x9c:    i_pushf(); break;
        case 0x9d:    i_popf(); break;
        case 0x9e:    i_sahf(); break;
        case 0x9f:    i_lahf(); break;
        case 0xa0:    i_mov_aldisp(); break;
        case 0xa1:    i_mov_axdisp(); break;
        case 0xa2:    i_mov_dispal(); break;
        case 0xa3:    i_mov_dispax(); break;
        case 0xa4:    i_movsb(); break;
        case 0xa5:    i_movsw(); break;
        case 0xa6:    i_cmpsb(); break;
        case 0xa7:    i_cmpsw(); break;
        case 0xa8:    i_test_ald8(); break;
        case 0xa9:    i_test_axd16(); break;
        case 0xaa:    i_stosb(); break;
        case 0xab:    i_stosw(); break;
        case 0xac:    i_lodsb(); break;
        case 0xad:    i_lodsw(); break;
        case 0xae:    i_scasb(); break;
        case 0xaf:    i_scasw(); break;
        case 0xb0:    i_mov_ald8(); break;
        case 0xb1:    i_mov_cld8(); break;
        case 0xb2:    i_mov_dld8(); break;
        case 0xb3:    i_mov_bld8(); break;
        case 0xb4:    i_mov_ahd8(); break;
        case 0xb5:    i_mov_chd8(); break;
        case 0xb6:    i_mov_dhd8(); break;
        case 0xb7:    i_mov_bhd8(); break;
        case 0xb8:    i_mov_axd16(); break;
        case 0xb9:    i_mov_cxd16(); break;
        case 0xba:    i_mov_dxd16(); break;
        case 0xbb:    i_mov_bxd16(); break;
        case 0xbc:    i_mov_spd16(); break;
        case 0xbd:    i_mov_bpd16(); break;
        case 0xbe:    i_mov_sid16(); break;
        case 0xbf:    i_mov_did16(); break;
        case 0xc0:    i_notdone(); break;
        case 0xc1:    i_notdone(); break;
        case 0xc2:    i_ret_d16(); break;
        case 0xc3:    i_ret(); break;
        case 0xc4:    i_les_dw(); break;
        case 0xc5:    i_lds_dw(); break;
        case 0xc6:    i_mov_bd8(); break;
        case 0xc7:    i_mov_wd16(); break;
        case 0xc8:    i_notdone(); break;
        case 0xc9:    i_notdone(); break;
        case 0xca:    i_retf_d16(); break;
        case 0xcb:    i_retf(); break;
        case 0xcc:    i_int3(); break;
        case 0xcd:    i_int(); break;
        case 0xce:    i_into(); break;
        case 0xcf:    i_iret(); break;
        case 0xd0:    i_d0pre(); break;
        case 0xd1:    i_d1pre(); break;
        case 0xd2:    i_d2pre(); break;
        case 0xd3:    i_d3pre(); break;
        case 0xd4:    i_aam(); break;
        case 0xd5:    i_aad(); break;
        case 0xd6:    i_notdone(); break;
        case 0xd7:    i_xlat(); break;
        case 0xd8:    i_escape(); break;
        case 0xd9:    i_escape(); break;
        case 0xda:    i_escape(); break;
        case 0xdb:    i_escape(); break;
        case 0xdc:    i_escape(); break;
        case 0xdd:    i_escape(); break;
        case 0xde:    i_escape(); break;
        case 0xdf:    i_escape(); break;
        case 0xe0:    i_loopne(); break;
        case 0xe1:    i_loope(); break;
        case 0xe2:    i_loop(); break;
        case 0xe3:    i_jcxz(); break;
        case 0xe4:    i_inal(); break;
        case 0xe5:    i_inax(); break;
        case 0xe6:    i_outal(); break;
        case 0xe7:    i_outax(); break;
        case 0xe8:    i_call_d16(); break;
        case 0xe9:    i_jmp_d16(); break;
        case 0xea:    i_jmp_far(); break;
        case 0xeb:    i_jmp_d8(); break;
        case 0xec:    i_inaldx(); break;
        case 0xed:    i_inaxdx(); break;
        case 0xee:    i_outdxal(); break;
        case 0xef:    i_outdxax(); break;
        case 0xf0:    i_lock(); break;
        case 0xf1:    i_gobios(); break;
        case 0xf2:    i_repne(); break;
        case 0xf3:    i_repe(); break;
        case 0xf4:    i_notdone(); break;
        case 0xf5:    i_cmc(); break;
        case 0xf6:    i_f6pre(); break;
        case 0xf7:    i_f7pre(); break;
        case 0xf8:    i_clc(); break;
        case 0xf9:    i_stc(); break;
        case 0xfa:    i_cli(); break;
        case 0xfb:    i_sti(); break;
        case 0xfc:    i_cld(); break;
        case 0xfd:    i_std(); break;
        case 0xfe:    i_fepre(); break;
        case 0xff:    i_ffpre(); break;
        };

    }
}

