/****************************************************************************
 * This module is all new
 * by Rob Nation (nation@rocket.sanders.lockheed.com 
 ****************************************************************************/
/***********************************************************************
 *
 * fvwm menu code
 *
 ***********************************************************************/

#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <X11/Xos.h>
#include "fvwm.h"
#include "menus.h"
#include "misc.h"
#include "parse.h"
#include "screen.h"

extern XEvent Event;

extern int menu_on,move_on;

#ifndef NO_PAGER
extern Window Pager_w;
#endif

#ifdef __STDC__
void DrawPartitionLines(int MaxW,int MaxH, int width, int height);
FvwmWindow *FindCounterpart(Window target);
#else
void DrawPartitionLines();
FvwmWindow *FindCounterpart();
#endif

/****************************************************************************
 * Cause the pager window to be re-drawn
 *
 * Trying to get clever - re-draw the pager by causing an expose event,
 * the really redraw only when an expose arrives. Advantage is that the
 * number of re-draws will be minimized
 ***************************************************************************/
void RedrawPager()
{
#ifndef NO_PAGER
  int width, height;

  XGetGeometry(dpy, Pager_w, &JunkRoot, &JunkX, &JunkY,
	       &width, &height, &JunkBW,  &JunkDepth);
  XClearArea(dpy,Pager_w, 0, 0, width,height,True);
#endif
}

void ReallyRedrawPager()
{
#ifndef NO_PAGER
  int width,height,ww,wh;
  int wx,wy;
  int  x,y,x1,x2,y1,y2,X,Y;
  FvwmWindow *t;
  int MaxH,MaxW;

  if(Pager_w == 0)
    return;

  flush_expose (Pager_w);

  XGetGeometry(dpy, Pager_w, &JunkRoot, &X, &Y,
	       &width, &height, &JunkBW,  &JunkDepth);
  MaxW = Scr.VxMax + Scr.MyDisplayWidth;
  MaxH = Scr.VyMax + Scr.MyDisplayHeight;

  ShowCurrentPort();
  XClearWindow(dpy,Pager_w);
  for (t = Scr.FvwmRoot.next; t != NULL; t = t->next)
    {
      if(!(t->flags & STICKY)&&(!(t->flags & ICON)||(!Scr.SuppressIcons)))
	{
	  if(t->flags & ICON)
	    {	      
	      /* show the icon loc */
	      wx = (t->icon_x_loc + Scr.Vx)*width/MaxW;;
	      wy = (t->icon_y_loc + Scr.Vy)*height/MaxH;
	      ww = t->icon_w_width*width/MaxW;
	      wh = (t->icon_w_height+t->icon_p_height)*height/MaxH;
	    }
	  else 
	    {
	      /* show the actual window */
	      wx = (t->frame_x + Scr.Vx)*width/MaxW;
	      wy = (t->frame_y + Scr.Vy)*height/MaxH;
	      ww = t->frame_width*width/MaxW;
	      wh = t->frame_height*height/MaxH;
	    }
	  if(ww<2)ww=2;
	  if(wh<2)wh=2;
	  XMoveResizeWindow(dpy, t->pager_view, wx, wy, ww, wh);
	  XClearWindow(dpy,t->pager_view);
	}
      else
	{
	  /* window is sticky - make sure that the pager_view window is not 
	   * visible */
	  XMoveResizeWindow(dpy, t->pager_view, -10, -10, 5, 5);
	}
    }
  DrawPartitionLines(MaxW,MaxH,width,height);
  ShowCurrentPort();
#endif
}

#ifndef NO_PAGER
#ifdef __STDC__
void DrawPartitionLines(int MaxW,int MaxH, int width, int height)
#else
void DrawPartitionLines(MaxW, MaxH, width, height)
int MaxW, MaxH, width, height;
#endif
{
  int y, y1, y2, x, x1, x2;

  x = Scr.MyDisplayWidth;
  y1 = 0;
  y2 = height;
  while(x < MaxW)
    {
      x1 = x*width/MaxW;
      XDrawLine(dpy,Pager_w,Scr.NormalGC,x1,y1,x1,y2);
      x += Scr.MyDisplayWidth;
    }

  y = Scr.MyDisplayHeight;
  x1 = 0;
  x2 = width;
  while(y < MaxH)
    {
      y1 = y*height/MaxH;
      XDrawLine(dpy,Pager_w,Scr.NormalGC,x1,y1,x2,y1);
      y += Scr.MyDisplayHeight;
    }
}
#endif

void ShowCurrentPort()
{
#ifndef NO_PAGER
  int x1,y1,x2,y2,X,Y;
  int width,height;

  if(Pager_w == (Window)0)
    return;

  XGetGeometry(dpy, Pager_w, &JunkRoot, &X, &Y,
	       &width, &height, &JunkBW,  &JunkDepth);
  x1 = Scr.Vx * width/(Scr.VxMax+Scr.MyDisplayWidth)+2;
  y1 = Scr.Vy * height/(Scr.VyMax+Scr.MyDisplayHeight)+2;
  if(x1==2)x1=1;
  if(y1==2)y1=1;
  x2 = (Scr.Vx+Scr.MyDisplayWidth) * width/(Scr.VxMax+Scr.MyDisplayWidth) -2;
  y2 = (Scr.Vy+Scr.MyDisplayHeight) * height/(Scr.VyMax+Scr.MyDisplayHeight)-2;
  XDrawLine(dpy,Pager_w,Scr.DrawGC,x1,y1,x1,y2);
  XDrawLine(dpy,Pager_w,Scr.DrawGC,x1,y2,x2,y2);
  XDrawLine(dpy,Pager_w,Scr.DrawGC,x2,y2,x2,y1);
  XDrawLine(dpy,Pager_w,Scr.DrawGC,x2,y1,x1,y1);
  return;
#endif

}

#ifdef __STDC__
void SwitchPages(Bool align, Bool ChangeFocus)
#else
void SwitchPages(align, ChangeFocus)
Bool align;
Bool ChangeFocus;
#endif
{
#ifndef NO_PAGER
  int x,y,width,height,X,Y;
  FvwmWindow *tmp_win;
  Window dumwin;

  if(Pager_w == 0)
    return;
  XTranslateCoordinates (dpy, Event.xbutton.window, Pager_w,
			 Event.xbutton.x, Event.xbutton.y, &x, &y, &dumwin);

  XGetGeometry(dpy, Pager_w, &JunkRoot, &X, &Y,
	       &width, &height, &JunkBW,  &JunkDepth);
  x = x * (Scr.VxMax+Scr.MyDisplayWidth)/width;
  y = y * (Scr.VyMax+Scr.MyDisplayHeight)/height;
  if(align)
    {
      x = (x/Scr.MyDisplayWidth)*Scr.MyDisplayWidth;
      y = (y/Scr.MyDisplayHeight)*Scr.MyDisplayHeight;
    }
  MoveViewport(x,y,True);
  
  if((ChangeFocus)&&(Scr.ClickToFocus))
    {
      tmp_win = FindCounterpart(Event.xbutton.subwindow);
      if(tmp_win)
	{
	  RaiseWindow(tmp_win);
	  SetBorder(tmp_win,True,False,True);	
	}
    }
#endif

}


#ifdef __STDC__
void RaiseWindow(FvwmWindow *t)
#else
void RaiseWindow(t)
FvwmWindow *t;
#endif
{
  ShowCurrentPort();
  XRaiseWindow(dpy,t->lead_w);

#ifndef NO_PAGER
  if((Pager_w)&& !(t->flags & STICKY))
    XRaiseWindow(dpy,t->pager_view);
#endif

  if ((t->flags & ICON)&&(!Scr.SuppressIcons))
    {
      XRaiseWindow(dpy, t->icon_w);
      XRaiseWindow(dpy, t->icon_pixmap_w);
    }
  ShowCurrentPort();
  Scr.LastWindowRaised = t;
}


#ifdef __STDC__
void LowerWindow(FvwmWindow *t)
#else
void LowerWindow(t)
FvwmWindow *t;
#endif
{
  ShowCurrentPort();
  XLowerWindow(dpy,t->lead_w);

#ifndef NO_PAGER
  if((Pager_w)&& !(t->flags & STICKY))
    XLowerWindow(dpy,t->pager_view);
#endif

  if((t->flags & ICON)&&(!Scr.SuppressIcons))
    {
      XLowerWindow(dpy, t->icon_w);
      XLowerWindow(dpy, t->icon_pixmap_w);
    }
  ShowCurrentPort();
  Scr.LastWindowRaised = (FvwmWindow *)0;
}


void PagerMoveWindow()
{
#ifndef NO_PAGER
  FvwmWindow *t,*tmp_win;
  int width, height,Xoff,Yoff,x,y,MaxW,MaxH,xl,yt;
  Window target;
  Bool done,finished = False;

  target = Event.xbutton.subwindow;
  tmp_win = FindCounterpart(target);

  if(tmp_win == NULL)
    return;


  MaxW = Scr.VxMax + Scr.MyDisplayWidth;
  MaxH = Scr.VyMax + Scr.MyDisplayHeight;

  XGetGeometry(dpy, Pager_w, &JunkRoot, &JunkX, &JunkY,
	       &width, &height, &JunkBW,  &JunkDepth);

  XQueryPointer(dpy, target, &JunkRoot, &JunkChild,
		&JunkX, &JunkY,	&Xoff, &Yoff, &JunkMask);

  XQueryPointer(dpy, Pager_w, &JunkRoot, &JunkChild,
		&JunkX, &JunkY, &xl, &yt, &JunkMask);
  if(xl<0)xl=0;
  if(yt<0)yt=0;
  if(xl>width)xl=width;
  if(yt>height)yt=height;
  xl -= Xoff;
  yt -= Yoff;
  ShowCurrentPort();
  while (!finished)
    {
      /* block until there is an interesting event */
      XMaskEvent(dpy, ButtonPressMask | ButtonReleaseMask | KeyPressMask |
		 PointerMotionMask | ButtonMotionMask |
		 VisibilityChangeMask, &Event);
      if (Event.type == MotionNotify) 
	/* discard any extra motion events before a logical release */
	while(XCheckMaskEvent(dpy, PointerMotionMask | ButtonMotionMask |
			      ButtonRelease, &Event))
	  if(Event.type == ButtonRelease) break;

      done = FALSE;

      /* Handle a limited number of key press events to allow mouseless
       * operation */
      if(Event.type == KeyPress)
	Keyboard_shortcuts(&Event,ButtonRelease);
      switch(Event.type)
	{
	case ButtonPress:
	case KeyPress:
	  /* throw away enter and leave events until release */
	  done = TRUE;
	  break;
	case ButtonRelease:
	  XQueryPointer(dpy, Pager_w, &JunkRoot, &JunkChild,
			&JunkX, &JunkY, &xl, &yt, &JunkMask);
	  if(xl<0)xl=0;
	  if(yt<0)yt=0;
	  if(xl>width)xl=width;
	  if(yt>height)yt=height;
	  xl -= Xoff;
	  yt -= Yoff;
	  done = TRUE;
	  finished = TRUE;
	  break;

	case MotionNotify:
	  XQueryPointer(dpy, Pager_w, &JunkRoot, &JunkChild,
			&JunkX, &JunkY, &xl, &yt, &JunkMask);
	  if(xl<0)xl=0;
	  if(yt<0)yt=0;
	  if(xl>width)xl=width;
	  if(yt>height)yt=height;

	  /* redraw the rubberband */
	  xl -= Xoff;
	  yt -= Yoff;

	  done = TRUE;
	  break;

	default:
	  break;
	}
      if(!done)
	{
	  MoveOutline(Scr.Root,0,0,0,0);
	  DispatchEvent();
	}
      XMoveWindow(dpy, target,xl, yt);
      DrawPartitionLines(MaxW,MaxH,width,height);
    }

  x = xl*MaxW/width - Scr.Vx;
  y = yt*MaxH/height - Scr.Vy;

  if((tmp_win->flags & ICON)&&(!Scr.SuppressIcons))
    {
      XMoveWindow (dpy, tmp_win->icon_w, x, y);
      tmp_win->icon_x_loc = x;
      tmp_win->icon_y_loc = y;
    }
  else 
    {
      /* show the actual window */
      SetupFrame(tmp_win, x, y, tmp_win->frame_width,tmp_win->frame_height);
    }  
  ShowCurrentPort();
  RedrawPager();
#endif      
}



#ifndef NO_PAGER
#ifdef __STDC__
FvwmWindow *FindCounterpart(Window target)
#else
FvwmWindow *FindCounterpart(target)
Window target;
#endif
{
  FvwmWindow *t,*tmp_win=0;

  tmp_win = NULL;
  for (t = Scr.FvwmRoot.next; t != NULL; t = t->next)
    {
      if(t->pager_view == target)
	{
	  tmp_win = t;
	}
    }
  return tmp_win;
}
#endif
