/****************************************************************************
 * This module is mostly all new
 * by Rob Nation (nation@rocket.sanders.lockheed.com)
 * A little of it is borrowed from ctwm.
 * Copyright 1993 Robert Nation. No restrictions are placed on this code,
 * as long as the copyright notice is preserved
 ****************************************************************************/
/***********************************************************************
 *
 * fvwm menu code
 *
 ***********************************************************************/

#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <X11/Xos.h>
#ifdef XPM
#include "xpm.h"
#endif /* XPM */
#include "fvwm.h"
#include "menus.h"
#include "misc.h"
#include "parse.h"
#include "screen.h"
#ifdef SHAPE
#include <X11/extensions/shape.h>
#endif /* SHAPE */



#ifdef __STDC__
void AutoPlace(int *, int *,int,int);
#else
void AutoPlace();
#endif
/****************************************************************************
 *
 * Creates an icon window as needed
 *
 ****************************************************************************/
#ifdef __STDC__
void CreateIconWindow(FvwmWindow *tmp_win, int def_x, int def_y)
#else
void CreateIconWindow(tmp_win, def_x, def_y)
FvwmWindow *tmp_win; 
int def_x, def_y;
#endif
{
#ifndef NO_ICONS
  int final_x, final_y;
  int HotX,HotY;
  unsigned long valuemask;		/* mask for create windows */
  XSetWindowAttributes attributes;	/* attributes for create windows */
  Pixmap tmpXpm;
#ifdef XPM
  XWindowAttributes root_attr;
  XpmAttributes xpm_attributes;
#endif /* XPM */
  
  tmp_win->flags &= ~ICON_OURS;
  tmp_win->flags &= ~XPM_FLAG;
  tmp_win->flags &= ~PIXMAP_OURS;
  tmp_win->flags &= ~SHAPED_ICON;

  if(Scr.SuppressIcons)
    return;

  /* First, see if it was specified in the .fvwmrc */
  if(tmp_win->icon_bitmap_file != (char *)0)
    {
      if(XReadBitmapFile (dpy, Scr.Root,tmp_win->icon_bitmap_file,
			  &tmp_win->icon_p_width, &tmp_win->icon_p_height,
			  &tmp_win->iconPixmap,
			  &HotX, &HotY) != BitmapSuccess)
	{
#ifdef XPM
	  XGetWindowAttributes(dpy,Scr.Root,&root_attr);
	  xpm_attributes.colormap = root_attr.colormap;
	  xpm_attributes.valuemask = XpmSize | XpmReturnPixels|XpmColormap;
	  if(XpmReadFileToPixmap(dpy, Scr.Root, tmp_win->icon_bitmap_file,
				 &tmp_win->iconPixmap, &tmp_win->icon_maskPixmap, 
				 &xpm_attributes) == XpmSuccess) 
	    { 
	      tmp_win->icon_p_width = xpm_attributes.width;
	      tmp_win->icon_p_height = xpm_attributes.height;
	      tmp_win->flags |= XPM_FLAG;
	      tmp_win->flags |= PIXMAP_OURS;
#ifdef SHAPE
	      if (tmp_win->icon_maskPixmap)
		tmp_win->flags |= SHAPED_ICON;
#endif
	      
	    } 
	  else
#endif /* XPM */
	    {
	      tmp_win->iconPixmap=None;
	      tmp_win->icon_p_height = 0;
	      tmp_win->icon_p_width = 0;
	    }
	}
      else
	{
	  tmp_win->flags |= PIXMAP_OURS;
	}
    }
  /* Next, See if the app supplies its own icon window */
  else if (tmp_win->wmhints && tmp_win->wmhints->flags & IconWindowHint) 
    {
      XGetGeometry(dpy,   tmp_win->wmhints->icon_window,
		   &JunkRoot, &JunkX, &JunkY,
		   (unsigned int *)&tmp_win->icon_w_width, 
		   (unsigned int *)&tmp_win->icon_w_height, 
		   &JunkBW, &JunkDepth);
      if (tmp_win->wmhints && tmp_win->wmhints->flags & IconPositionHint)
	{
	  final_x = tmp_win->wmhints->icon_x;
	  final_y = tmp_win->wmhints->icon_y;
	}
      else
	{
	  final_x = def_x;
	  final_y = def_y;
	  if(final_x <0)
	    final_x = 0;
	  if(final_y <0)
	    final_y = 0;

	  if(final_x + tmp_win->icon_w_width >Scr.MyDisplayWidth)
	    final_x = Scr.MyDisplayWidth - tmp_win->icon_w_width;
	  if(final_y + tmp_win->icon_w_height >Scr.MyDisplayHeight)
	    final_y = Scr.MyDisplayHeight - tmp_win->icon_w_height;
	  if(Scr.AutoPlaceIcons)
	    AutoPlace(&final_x,&final_y,tmp_win->icon_w_width,
		      tmp_win->icon_w_height);
	}
      XMoveWindow(dpy, tmp_win->wmhints->icon_window, final_x,final_y);
      XMapWindow(dpy, tmp_win->wmhints->icon_window);
      tmp_win->flags &= ~ICON_OURS;
      
      /*
       * Now make the new window the icon window for this window,
       * and set it up to work as such (select for key presses
       * and button presses/releases, set up the contexts for it,
       * and define the cursor for it).
       */
      tmp_win->icon_w = tmp_win->wmhints->icon_window;
      tmp_win->icon_x_loc = final_x;
      tmp_win->icon_y_loc = final_y;
      XSelectInput (dpy, tmp_win->icon_w,
		    KeyPressMask | ButtonPressMask | ButtonReleaseMask
		    |EnterWindowMask|LeaveWindowMask);
      XSaveContext(dpy, tmp_win->icon_w, FvwmContext, (caddr_t)tmp_win);
      return;
    }
  /* now, try to get icon bitmap from the application */
  else if((tmp_win->wmhints)&&(tmp_win->wmhints->flags & IconPixmapHint))
    {
      XGetGeometry(dpy,   tmp_win->wmhints->icon_pixmap,
		   &JunkRoot, &JunkX, &JunkY,
		   (unsigned int *)&tmp_win->icon_p_width, 
		   (unsigned int *)&tmp_win->icon_p_height, 
		   &JunkBW, &JunkDepth);
      tmp_win->iconPixmap = tmp_win->wmhints->icon_pixmap;
    }
  /* no bitmap */
  else
    {
      tmp_win->icon_p_height = 0;
      tmp_win->icon_p_width = 0;
      tmp_win->iconPixmap = None;
    }

  /* figure out the icon window size */
  tmp_win->icon_t_width = XTextWidth(Scr.StdFont.font,tmp_win->icon_name, 
				     strlen(tmp_win->icon_name));
  if(tmp_win->icon_p_height >0)
    {
      tmp_win->icon_p_width += 4;
      tmp_win->icon_p_height +=4;
    }

  if(tmp_win->icon_p_width == 0)
    tmp_win->icon_p_width = tmp_win->icon_t_width+6;
  tmp_win->icon_w_width = tmp_win->icon_p_width;

  tmp_win->icon_w_height = ICON_HEIGHT;

  /* need to figure out where to put the icon window now */
  if (tmp_win->wmhints &&
      tmp_win->wmhints->flags & IconPositionHint)
    {
      final_x = tmp_win->wmhints->icon_x;
      final_y = tmp_win->wmhints->icon_y;
    }
  else
    {
      final_x = def_x;
      final_y = def_y;
      if(final_x <0)
	final_x = 0;
      if(final_y <0)
	final_y = 0;
      
      if(final_x + tmp_win->icon_w_width >=Scr.MyDisplayWidth)
	final_x = Scr.MyDisplayWidth - tmp_win->icon_w_width-1;
      if(final_y + tmp_win->icon_w_height >=Scr.MyDisplayHeight)
	final_y = Scr.MyDisplayHeight - tmp_win->icon_w_height-1;

      if(Scr.AutoPlaceIcons)
	AutoPlace(&final_x,&final_y,tmp_win->icon_p_width,
		  tmp_win->icon_w_height+tmp_win->icon_p_height);
    }
  
  /* make sure it winds up on the screen */
  if (final_x > Scr.MyDisplayWidth)
    final_x = Scr.MyDisplayWidth - tmp_win->icon_w_width-2;
  
  if (final_y > Scr.MyDisplayHeight)
    final_y = Scr.MyDisplayHeight - 
      Scr.StdFont.height - 6;

  tmp_win->icon_x_loc = final_x;
  tmp_win->icon_xl_loc = final_x;
  tmp_win->icon_y_loc = final_y;

  /* clip to fit on screen */
  attributes.background_pixel = Scr.StdColors.back;
  valuemask =  CWBorderPixel | CWCursor | CWEventMask | CWBackPixel;
  attributes.border_pixel = Scr.StdColors.fore;
  attributes.cursor = Scr.FvwmCursors[FRAME];
  attributes.event_mask = (ButtonPressMask | ButtonReleaseMask |
			   ExposureMask | KeyPressMask|EnterWindowMask |
			   LeaveWindowMask);
  tmp_win->icon_w = 
    XCreateWindow(dpy, Scr.Root, final_x, final_y+tmp_win->icon_p_height,
		  tmp_win->icon_w_width, tmp_win->icon_w_height,0,Scr.d_depth, 
		  CopyFromParent,Scr.d_visual,valuemask,&attributes);
  if((tmp_win->icon_p_width>0)&&(tmp_win->icon_p_height>0))
    tmp_win->icon_pixmap_w = 
      XCreateWindow(dpy, Scr.Root, final_x, final_y, tmp_win->icon_p_width,
		    tmp_win->icon_p_height, 0, Scr.d_depth, 
		    CopyFromParent,Scr.d_visual,valuemask,&attributes);
  else
    tmp_win->icon_pixmap_w = None;

#ifdef XPM
#ifdef SHAPE
  if (tmp_win->flags & SHAPED_ICON)
    {
      XRectangle rect;
      XShapeCombineMask(dpy, tmp_win->icon_pixmap_w, ShapeBounding,2, 2,
			tmp_win->icon_maskPixmap, ShapeSet);
    }
#endif
#endif

  XSaveContext(dpy, tmp_win->icon_w, FvwmContext, (caddr_t)tmp_win);
  if(tmp_win->icon_pixmap_w != None)
    XSaveContext(dpy, tmp_win->icon_pixmap_w, FvwmContext, (caddr_t)tmp_win);
  XDefineCursor(dpy, tmp_win->icon_w, Scr.FvwmCursors[FRAME]);
  XDefineCursor(dpy, tmp_win->icon_pixmap_w, Scr.FvwmCursors[FRAME]);
  tmp_win->flags |= ICON_OURS;
  return;
#endif
}

/****************************************************************************
 *
 * Draws the icon window
 *
 ****************************************************************************/
#ifdef __STDC__
void DrawIconWindow(FvwmWindow *Tmp_win)
#else
void DrawIconWindow(Tmp_win)
FvwmWindow *Tmp_win;
#endif
{
#ifndef NO_ICONS
  GC Shadow, Relief,Fill;

  if(!(Tmp_win->flags & ICON_OURS))
    return;

  if(Scr.SuppressIcons)
    return;

  flush_expose (Tmp_win->icon_w);
  if(Tmp_win->icon_pixmap_w != None)
    flush_expose (Tmp_win->icon_pixmap_w);

  if(Scr.Focus == Tmp_win)
    {
      if(Scr.d_depth < 2)
	Relief = Scr.HiShadowGC;
      else
	Relief = Scr.HiReliefGC;
      Shadow = Scr.HiShadowGC;
      XSetWindowBackground(dpy,Tmp_win->icon_w,Scr.HiColors.back);
      if(Tmp_win->icon_pixmap_w != None)
	XSetWindowBackground(dpy,Tmp_win->icon_pixmap_w,Scr.HiColors.back);
      Fill = Scr.HiliteGC;
      /* resize the icon name window */
      Tmp_win->icon_w_width = Tmp_win->icon_t_width+6;
      if(Tmp_win->icon_w_width < Tmp_win->icon_p_width)
	Tmp_win->icon_w_width = Tmp_win->icon_p_width;
      Tmp_win->icon_xl_loc = Tmp_win->icon_x_loc - 
	(Tmp_win->icon_w_width - Tmp_win->icon_p_width)/2;
    }
  else
    {
      if(Scr.d_depth < 2)
	Relief = Scr.StdShadowGC;
      else
	Relief = Scr.StdReliefGC;
      Shadow = Scr.StdShadowGC;
      XSetWindowBackground(dpy,Tmp_win->icon_w,Scr.StdColors.back);
      if(Tmp_win->icon_pixmap_w != None)
	XSetWindowBackground(dpy,Tmp_win->icon_pixmap_w,Scr.StdColors.back);
      Fill = Scr.NormalGC;
      /* resize the icon name window */
      Tmp_win->icon_w_width = Tmp_win->icon_p_width;
      Tmp_win->icon_xl_loc = Tmp_win->icon_x_loc;
    }
  XMoveResizeWindow(dpy, Tmp_win->icon_w, Tmp_win->icon_xl_loc,
		    Tmp_win->icon_y_loc+Tmp_win->icon_p_height,
		    Tmp_win->icon_w_width,ICON_HEIGHT);
  
  XClearWindow(dpy,Tmp_win->icon_w);
  if(Tmp_win->icon_pixmap_w != None)
    XClearWindow(dpy,Tmp_win->icon_pixmap_w);

  if((Tmp_win->iconPixmap != None)&&(!(Tmp_win->flags & SHAPED_ICON)))
    RelieveWindow(Tmp_win->icon_pixmap_w,0,0,Tmp_win->icon_p_width,
		  Tmp_win->icon_p_height, NULL,
		  Relief,Shadow);  

  /* need to locate the icon pixmap */
  if(Tmp_win->flags & XPM_FLAG)
    {
      XCopyArea(dpy,Tmp_win->iconPixmap,Tmp_win->icon_pixmap_w,Scr.NormalGC,0,
		0,Tmp_win->icon_p_width-4, Tmp_win->icon_p_height-4,2,2);
    }
  else if(Tmp_win->iconPixmap != None)
    {
      XCopyPlane(dpy, Tmp_win->iconPixmap, Tmp_win->icon_pixmap_w, Fill, 0, 0, 
		 Tmp_win->icon_p_width-4, Tmp_win->icon_p_height-4, 2, 2, 1);
    }
  
  /* write the icon label */
  XDrawString (dpy, Tmp_win->icon_w, Scr.NormalGC,
	       (Tmp_win->icon_w_width - Tmp_win->icon_t_width)/2,
	       Tmp_win->icon_w_height-Scr.StdFont.height+Scr.StdFont.y-3,
	       Tmp_win->icon_name, strlen(Tmp_win->icon_name));
  RelieveWindow(Tmp_win->icon_w,0,0,Tmp_win->icon_w_width,
		ICON_HEIGHT,NULL,Relief,Shadow);

#endif  
}

/***********************************************************************
 *
 *  Procedure:
 *	RedoIconName - procedure to re-position the icon window and name
 *
 ************************************************************************/
#ifdef __STDC__
void RedoIconName(FvwmWindow *Tmp_win)
#else
void RedoIconName(Tmp_win)
FvwmWindow *Tmp_win;
#endif
{
#ifndef NO_ICONS
  if(Scr.SuppressIcons)
    return;

  if (Tmp_win->icon_w == (int)NULL)
    return;
  
  Tmp_win->icon_t_width = XTextWidth(Scr.StdFont.font,Tmp_win->icon_name, 
				     strlen(Tmp_win->icon_name));
  /* clear the icon window, and trigger a re-draw via an expose event */
  if (Tmp_win->flags & ICON)
    XClearArea(dpy, Tmp_win->icon_w, 0, 0, 0, 0, True);
  return;
#endif
}



  
/***********************************************************************
 *
 *  Procedure:
 *	AutoPlace - Find a home for an icon
 *
 ************************************************************************/
#ifdef __STDC__
void AutoPlace(int *final_x, int *final_y,int width,int height)
#else
void AutoPlace(final_x, final_y, width, height)
int *final_x, *final_y;
int width, height;
#endif
{
#ifndef NO_ICONS
  /* Search down the right side of the display, avoiding places where 
   * icons live, or active windows are open, then go accross the bottom
   * If no home is found, put it at the default location */
  int test_x, test_y;
  FvwmWindow *test_window;
  Bool loc_ok;

  /* first check the right side of the screen */
  test_x = Scr.MyDisplayWidth - width;
  test_y = 0;
  loc_ok = False;
  while((test_y <(Scr.MyDisplayHeight-height))&&(!loc_ok))
    {
      loc_ok = True;
      test_window = Scr.FvwmRoot.next;
      while((test_window != (FvwmWindow *)0)&&(loc_ok == True))
	{
	  if(test_window->icon_w)
	    {
	      if((test_window->icon_x_loc < (test_x+width))&&
		 ((test_window->icon_x_loc+test_window->icon_p_width)>test_x)
		 &&(test_window->icon_y_loc-3 < (test_y+height))&&
		 ((test_window->icon_y_loc+test_window->icon_w_height
		   +test_window->icon_p_height+3)>test_y))
		{
		  loc_ok = False;
		}
	    }
	  if(!(test_window->flags & ICON))
	    {
	      /* window is not iconified */
	      if((test_window->frame_x < (test_x+width))&&
		 ((test_window->frame_x+test_window->frame_width)>test_x)
		 &&(test_window->frame_y-3 < (test_y+height))&&
		 ((test_window->frame_y+test_window->frame_height+3)>test_y))
		{
		  loc_ok = False;
		}
	    }
	  test_window = test_window->next;
	}
      test_y +=3;
    }
  
  /* next check the bottom side of the screen */
  test_y -=3;
  if(!loc_ok)
    {
      test_y = Scr.MyDisplayHeight - height;
      loc_ok = False;
      test_x = Scr.MyDisplayWidth - width;
      while((test_x >0)&&(!loc_ok))
	{
	  loc_ok = True;
	  test_window = Scr.FvwmRoot.next;
	  while((test_window != (FvwmWindow *)0)&&(loc_ok == True))
	    {
	      if(test_window->icon_w)
		{
		  if((test_window->icon_x_loc-3 < (test_x+width))&&
		     ((test_window->icon_x_loc+test_window->icon_p_width+5)>test_x)
		     &&(test_window->icon_y_loc < (test_y+height))&&
		     ((test_window->icon_y_loc+test_window->icon_w_height
		       + test_window->icon_p_height)>test_y))
		    {
		      loc_ok = False;
		    }
		}
	      if(!(test_window->flags & ICON))
		{
		  /* window is not iconified */
		  if((test_window->frame_x-3 < (test_x+width))&&
		     ((test_window->frame_x+test_window->frame_width+5)>test_x)
		     &&(test_window->frame_y < (test_y+height))&&
		     ((test_window->frame_y+test_window->frame_height)>test_y))
		    {
		      loc_ok = False;
		    }
		}
	      test_window = test_window->next;
	    }
	  test_x -=3;
	}
      test_x +=3;
    }
  if(loc_ok == False)
    return;
  *final_x = test_x;
  *final_y = test_y;
#endif
}

