/**************************************************************
 * Split the tmpl file in LaTeX and help files depending on flag.
 * It support the binary syntax @ifhelp, @else, @endif
 * as well as @iftex, @else, @endif in the input file.
 *
 * Martin-D. Lacasse 1992
 *
 **************************************************************/

#include <stdio.h>
#include <string.h>

#define MAXLVL 2  /* Keep it simple! */

int main(int argc, char **argv)
{

	FILE *fpin[MAXLVL], *fpout=stderr;
	char bufline[1024];
	char filename[256];
	int lineno[MAXLVL];
	int inhelp = 1;
	int intex = 1;
	int tex = 0;
	int help = 0;
	int fplvl = 0;
	int total = 0;
	char *ci, *co;

	if (argc != 3) {
		fprintf(stderr, "Usage: %s [-tex|help] infile\n", argv[0]);
		exit(1);
	}
	co = bufline;
	ci = argv[2];
	while (*ci != '.' && *ci) 
		*co++ = *ci++;
	*co = '\0';
	if ((fpin[fplvl] = fopen(argv[2], "r")) == NULL) {
		fprintf(stderr, "%s: %s: File not found\n", argv[0], argv[2]);
		exit(1);
	}
	if (strcmp(argv[1], "-tex") == 0) {
		sprintf(filename, "%s.tex", bufline);
		if ((fpout = fopen(filename, "w")) == NULL) {
			fprintf(stderr, "%s: Permission denied.\n", filename);
			exit(1);
		}
		tex = 1;
	}
	else if (strcmp(argv[1], "-help") == 0) {
		sprintf(filename, "%s.help", bufline);
		if ((fpout = fopen(filename, "w")) == NULL) {
			fprintf(stderr, "%s: Permission denied.\n", filename);
			exit(1);
		}
		help = 1;
	}
	else {
		fprintf(stderr, "Usage: %s [-tex|help] infile\n", argv[0]);
		exit(1);
	}
		
	fplvl = 0;
	lineno[fplvl] = 0;
	while (fplvl >= 0) {
		if (fgets(bufline, 1023, fpin[fplvl]) == NULL) {
			fclose(fpin[fplvl]);
			if (fplvl) {
				fprintf(stderr, "%d lines.\n", lineno[fplvl]);
				total += lineno[fplvl];
			}
			else {
				fprintf(stderr, "%s: %d lines.\n", argv[2], lineno[0]);
				total += lineno[fplvl];
				fprintf(stderr, "Total: %d lines.\n", total);
			}
			fplvl--;
			continue;
		}
		lineno[fplvl]++;
		if (bufline[0] == '@') {
			if (strncmp(bufline+1, "ifhelp", 6) == 0) {
				inhelp = 1; intex = 0;
			}
			else if (strncmp(bufline+1, "iftex", 5) == 0) {
				inhelp = 0; intex = 1;
			}
			else if (strncmp(bufline+1, "else", 4) == 0) {
				inhelp = !inhelp; intex = !intex;
			}
			else if (strncmp(bufline+1, "endif", 5) == 0) {
				inhelp = 1; intex = 1;
			}
			else if (strncmp(bufline+1, "include", 7) == 0) {
				if ((tex && intex) || (help && inhelp)) {
					if (++fplvl > MAXLVL-1) {
						fprintf(stderr, "Error: Level %d: Line %d: %s.\n",
						fplvl, lineno[fplvl-1], "Too many @include");
						exit(1);
					}
					lineno[fplvl] = 0;
					sscanf(bufline+8, "%s", filename);
					if ((fpin[fplvl] = fopen(filename, "r")) == NULL) {
						fprintf(stderr,
						"%s: %s: File not found\n", argv[0], filename);
						exit(1);
					}
					fprintf(stderr, "%s: ", filename);
				}
				continue;
			}
			else {
				fprintf(stderr, "Error: Line %d: %s.\n", lineno, bufline);
				exit(1);
			}
			continue;
		}
		if ((tex && intex) || (help && inhelp))
			fputs(bufline, fpout);
	}
	if (!(intex * inhelp)) {
		fprintf(stderr, "Exiting with an open if statement.\n");
		exit(1);
	}
	exit(0);
}

