/*
 * 4.2bsd getwd simulation for Sys V.3
 */

#include <stdio.h>

#define SYSV3

#define MAXWD 1024	     /* limited by 4.2 getwd(2) */

#ifdef SYSV3

char *getcwd();

char *
getwd(path)
char *path;
{
    return(getcwd(path,MAXWD));
}

#else

/*
 * 4.2bsd getwd simulation for Sys V.2
 */

#include <stdio.h>

#define MAXWD 1024	     /* limited by 4.2 getwd(2) */

char *
getwd(path)
char *path;
{
     char *nlp;
     FILE *fp;
     FILE *popen();
     char *strrchr();

	putenv("IFS= \t\n");
     fp = popen("PATH=/bin:/usr/bin pwd", "r");
     if (fp == NULL)
	     return 0;
     if (fgets(path, MAXWD, fp) == NULL) {
	     (void) pclose(fp);
	     return 0;
     }
     if ((nlp = strrchr(path, '\n')) != NULL)
	     *nlp = '\0';
     (void) pclose(fp);
     return path;
}
#endif

