#! /bin/sh
#
# This is a shell archive.  Save this into a file, edit it
# and delete all lines above this comment.  Then give this
# file to sh by executing the command "sh file".  The files
# will be extracted into the current directory owned by
# you with default permissions.
#
# The files contained herein are:
#
# -r--r--r--  1 hyc          2254 Aug  1 14:35 tmclock.c
# -rw-r--r--  1 hyc          5964 Aug  1 15:10 patch2
#
echo 'x - tmclock.c'
if test -f tmclock.c; then echo 'shar: not overwriting tmclock.c'; else
sed 's/^X//' << '________This_Is_The_END________' > tmclock.c
X/*
X * Stolen from Jef Poskanzer's tws time library, which was stolen from
X * Marshall Rose's MH Message Handling system...
X *
X * tmclock() will convert time from a tm struct back to a clock value.
X * tmjuliandate() converts a tm struct to its julian day number.
X * tmsubdayclock() takes hours, minutes, and seconds from a tm struct
X * and returns the number of seconds since midnight of that day. (?)
X *  -- Howard Chu, August 1 1988      hyc@umix.cc.umich.edu, umix!hyc
X */
X
X/* $Header: tmclock.c,v 1.2 88/08/01 14:34:38 hyc Exp $ */
X
X/* Julian day number of the Unix* clock's origin, 01 Jan 1970. */
X#define JD1970 2440587L
X#define	CENTURY	19
X#if	BSD
X#include <sys/time.h>
Xint	daylight;
Xlong	timezone;
X#else
X#include <time.h>
X#endif
X
Xlong
Xtmjuliandate( tm )
Xstruct tm *tm;
X    {
X    register int mday, mon, year;
X    register long a, b;
X    double jd;
X
X    if ( (mday = tm -> tm_mday) < 1 || mday > 31 ||
X	    (mon = tm -> tm_mon + 1) < 1 || mon > 12 ||
X	    (year = tm -> tm_year) < 1 || year > 10000 )
X	return ( -1L );
X    if ( year < 100 )
X	year += CENTURY * 100;
X
X    if ( mon == 1 || mon == 2 )
X	{
X	--year;
X	mon += 12;
X	}
X    if ( year < 1583 )
X	return ( -1L );
X    a = year / 100;
X    b = 2 - a + a / 4;
X    b += (long) ( (double) year * 365.25 );
X    b += (long) ( 30.6001 * ( (double) mon + 1.0 ) );
X    jd = mday + b + 1720994.5;
X    return ( (long) jd );
X    }
X
X
Xlong
Xtmsubdayclock( tm )
Xstruct tm *tm;
X    {
X    register int sec, min, hour;
X    register long result;
X#if	BSD
X    {
X       struct timeval tp;
X       struct timezone tzp;
X
X       gettimeofday(&tp, &tzp);
X       daylight=tzp.tz_dsttime;
X       timezone=tzp.tz_minuteswest*(-60);
X    }
X#endif
X    if ( (sec = tm -> tm_sec) < 0 || sec > 59 ||
X	    (min = tm -> tm_min) < 0 || min > 59 ||
X	    (hour = tm -> tm_hour) < 0 || hour > 23 )
X	return ( -1L );
X
X    result = ( hour * 60 + min ) * 60 + sec;
X    result -= timezone;
X    if ( daylight )
X	result -= 60 * 60;
X
X    return ( result );
X    }
X
X
Xlong
Xtmclock( tm )
Xstruct tm *tm;
X    {
X    register long jd, sdc, result;
X
X    if ( ( jd = tmjuliandate( tm ) ) == -1L )
X	return ( -1L );
X    if ( ( sdc = tmsubdayclock( tm ) ) == -1L )
X	return ( -1L );
X
X    result = ( jd - JD1970 ) * 24 * 60 * 60 + sdc;
X
X    return ( result );
X    }
________This_Is_The_END________
if test `wc -c < tmclock.c` -ne     2254; then
	echo 'shar: tmclock.c was damaged during transit (should have been     2254 bytes)'
fi
fi		; : end of overwriting check
echo 'x - patch2'
if test -f patch2; then echo 'shar: not overwriting patch2'; else
sed 's/^X//' << '________This_Is_The_END________' > patch2
X*** /tmp/,RCSt1a06989	Mon Aug  1 14:27:21 1988
X--- Makefile	Mon Aug  1 14:27:42 1988
X***************
X*** 21,36 ****
X  #PROG = .ttp
X  PROG =
X  
X! # TWSLIB is only needed on Unix systems. Likewise for TWHEAD.
X! #TWSLIB =
X! #TWHEAD =
X! TWSLIB = libtws.a
X! TWHEAD = tws.h
X  
X  # For MWC 3.0 on the Atari ST, use:
X  #CFLAGS = -VCOMPAC -VPEEP
X! CFLAGS = -O
X  
X  OBJS = arc.o arcadd.o arccode.o arccvt.o arcdata.o arcdel.o arcdos.o \
X  arcext.o arcio.o arclst.o arclzw.o arcmatch.o arcpack.o arcrun.o \
X  arcsq.o arcsqs.o arcsvc.o arctst.o arcunp.o arcusq.o arcmisc.o
X--- 21,45 ----
X  #PROG = .ttp
X  PROG =
X  
X! # SYSTEM defines your operating system:
X! # MSDOS for IBM PCs or other MSDOS machines
X! # GEMDOS for Atari ST (Predefined by MWC, so you don't need to define it.)
X! # BSD for Berkeley Unix
X! # SYSV for AT&T System V Unix
X! # (MTS for Michigan Terminal System, which requires a different makefile)
X! # (MTS also requires one of USEGFINFO or USECATSCAN for directory search)
X! SYSTEM = -DBSD=1
X  
X  # For MWC 3.0 on the Atari ST, use:
X  #CFLAGS = -VCOMPAC -VPEEP
X! CFLAGS = -O $(SYSTEM)
X  
X+ # GNU's gcc is very nice, if you've got it. Otherwise just cc.
X+ CC = cc
X+ 
X+ # tmclock is only needed on Unix systems...
X+ TMCLOCK = tmclock.o
X+ 
X  OBJS = arc.o arcadd.o arccode.o arccvt.o arcdata.o arcdel.o arcdos.o \
X  arcext.o arcio.o arclst.o arclzw.o arcmatch.o arcpack.o arcrun.o \
X  arcsq.o arcsqs.o arcsvc.o arctst.o arcunp.o arcusq.o arcmisc.o
X***************
X*** 37,50 ****
X  
X  MOBJ = marc.o arcdata.o arcdos.o arcio.o arcmatch.o arcmisc.o
X  
X! arc$(PROG):	$(OBJS) $(TWSLIB)
X! 	$(CC) -o arc$(PROG) $(OBJS) $(TWSLIB)
X  
X! marc$(PROG):	$(MOBJ) $(TWSLIB)
X! 	$(CC) -o marc$(PROG) $(MOBJ) $(TWSLIB)
X  
X  clean:
X! 	-rm *.o arc$(PROG) marc$(PROG) $(TWSLIB)
X  
X  arc.o:	$(SRCDIR)arc.c	$(HEADER)
X  	$(CC) $(CFLAGS) -c $(SRCDIR)arc.c
X--- 46,59 ----
X  
X  MOBJ = marc.o arcdata.o arcdos.o arcio.o arcmatch.o arcmisc.o
X  
X! arc$(PROG):	$(OBJS) $(TMCLOCK)
X! 	$(CC) -o arc$(PROG) $(OBJS) $(TMCLOCK)
X  
X! marc$(PROG):	$(MOBJ) $(TMCLOCK)
X! 	$(CC) -o marc$(PROG) $(MOBJ) $(TMCLOCK)
X  
X  clean:
X! 	-rm *.o arc$(PROG) marc$(PROG)
X  
X  arc.o:	$(SRCDIR)arc.c	$(HEADER)
X  	$(CC) $(CFLAGS) -c $(SRCDIR)arc.c
X***************
X*** 93,97 ****
X  arcusq.o:	$(SRCDIR)arcusq.c	$(HEADER)
X  	$(CC) $(CFLAGS) -c $(SRCDIR)arcusq.c
X  
X! libtws.a:
X! 	make -f Make.tws libtws.a
X--- 102,106 ----
X  arcusq.o:	$(SRCDIR)arcusq.c	$(HEADER)
X  	$(CC) $(CFLAGS) -c $(SRCDIR)arcusq.c
X  
X! tmclock.o:	$(SRCDIR)tmclock.c
X! 	$(CC) $(CFLAGS) -c $(SRCDIR)tmclock.c
X*** /tmp/,RCSt1a07213	Mon Aug  1 14:41:30 1988
X--- arc.h	Mon Aug  1 14:35:45 1988
X***************
X*** 1,21 ****
X  /*
X!  * $Header: arc.h,v 1.9 88/07/31 18:43:18 hyc Exp $
X   */
X  
X! #undef	MSDOS
X! #undef	GEMDOS		/* This amusing garbage is to get all my */
X! #undef	DOS		/* define's past some compilers, which */
X! #undef	BSD		/* apparently define some of these themselves */
X! #undef	SYSV
X  #undef	UNIX
X- #undef	MTS
X  
X- #define	MSDOS	0		/* MSDOS machine */
X- #define	GEMDOS	0		/* Atari, GEMDOS */
X- #define	BSD	1		/* BSD4.2 or 4.3 */
X- #define	SYSV	0		/* Also uses BSD */
X- #define	MTS	0		/* MTS or 370(?) */
X- 
X  /*
X   * Assumptions:
X   * char = 8 bits
X--- 1,10 ----
X  /*
X!  * $Header: arc.h,v 1.10 88/08/01 14:28:29 hyc Exp $
X   */
X  
X! #undef	DOS	/* Just in case... */
X  #undef	UNIX
X  
X  /*
X   * Assumptions:
X   * char = 8 bits
X***************
X*** 45,52 ****
X  #endif
X  
X  #if	MTS
X- #define	USEGFINFO	0	/* define this to use GFINFO for directory */
X- #define	USECATSCAN	1	/* scanning, else use CATSCAN/FILEINFO... */
X  #define	CUTOFF	sepchr[0]
X  #endif
X  
X--- 34,39 ----
X*** /tmp/,RCSt1a07263	Mon Aug  1 14:46:27 1988
X--- marc.c	Mon Aug  1 14:20:13 1988
X***************
X*** 1,5 ****
X  /*
X!  * $Header: marc.c,v 1.4 88/07/31 19:49:35 hyc Exp $
X   */
X  
X  /*  MARC - Archive merge utility
X--- 1,5 ----
X  /*
X!  * $Header: marc.c,v 1.5 88/08/01 14:19:19 hyc Exp $
X   */
X  
X  /*  MARC - Archive merge utility
X***************
X*** 105,111 ****
X  			arctemp[n] = CUTOFF;
X  	}
X  #if	UNIX
X! 	else	strcpy(arctemp, "/tmp/";
X  #endif
X  #if	!MSDOS
X  	{
X--- 105,111 ----
X  			arctemp[n] = CUTOFF;
X  	}
X  #if	UNIX
X! 	else	strcpy(arctemp, "/tmp/");
X  #endif
X  #if	!MSDOS
X  	{
X*** /tmp/,RCSt1a07425	Mon Aug  1 15:09:17 1988
X--- arcdos.c	Mon Aug  1 15:08:18 1988
X***************
X*** 1,5 ****
X  /*
X!  * $Header: arcdos.c,v 1.6 88/07/31 18:48:09 hyc Exp $
X   */
X  
X  /*
X--- 1,5 ----
X  /*
X!  * $Header: arcdos.c,v 1.8 88/08/01 15:07:15 hyc Exp $
X   */
X  
X  /*
X***************
X*** 30,44 ****
X  #if	UNIX
X  #include <sys/types.h>
X  #include <sys/stat.h>
X! #include <sys/time.h>
X! #include "tws.h"
X! #endif
X  
X! #if	SYSV
X! #include <sys/times.h>
X! struct timeval {
X! 	long tv_sec;
X! 	long tv_usec;
X  };
X  #endif
X  
X--- 30,40 ----
X  #if	UNIX
X  #include <sys/types.h>
X  #include <sys/stat.h>
X! #include <time.h>
X  
X! struct timeval {	/* man page said <sys/types.h>, but it */
X! 	long tv_sec;	/* really seems to be in <sys/time.h>, */
X! 	long tv_usec;	/* but why bother... */
X  };
X  #endif
X  
X***************
X*** 168,186 ****
X  	Fclose(fd);
X  #endif
X  #if	UNIX
X! 	struct tws      tms;
X  	struct timeval  tvp[2];
X  	int	utimes();
X! 	twscopy(&tms, dtwstime());
X! 	tms.tw_sec = (time & 31) * 2;
X! 	tms.tw_min = (time >> 5) & 63;
X! 	tms.tw_hour = (time >> 11);
X! 	tms.tw_mday = date & 31;
X! 	tms.tw_mon = ((date >> 5) & 15) - 1;
X! 	tms.tw_year = (date >> 9) + 80;
X! 	tms.tw_clock = 0L;
X! 	tms.tw_flags = TW_NULL;
X! 	tvp[0].tv_sec = twclock(&tms);
X  	tvp[1].tv_sec = tvp[0].tv_sec;
X  	tvp[0].tv_usec = tvp[1].tv_usec = 0;
X  	utimes(f, tvp);
X--- 164,179 ----
X  	Fclose(fd);
X  #endif
X  #if	UNIX
X! 	struct tm	tm;
X  	struct timeval  tvp[2];
X  	int	utimes();
X! 	tm.tm_sec = (time & 31) * 2;
X! 	tm.tm_min = (time >> 5) & 63;
X! 	tm.tm_hour = (time >> 11);
X! 	tm.tm_mday = date & 31;
X! 	tm.tm_mon = ((date >> 5) & 15) - 1;
X! 	tm.tm_year = (date >> 9) + 80;
X! 	tvp[0].tv_sec = tmclock(&tm);
X  	tvp[1].tv_sec = tvp[0].tv_sec;
X  	tvp[0].tv_usec = tvp[1].tv_usec = 0;
X  	utimes(f, tvp);
________This_Is_The_END________
if test `wc -c < patch2` -ne     5964; then
	echo 'shar: patch2 was damaged during transit (should have been     5964 bytes)'
fi
fi		; : end of overwriting check
exit 0
--
