#! /bin/sh
#
# This is a shell archive.  Save this into a file, edit it
# and delete all lines above this comment.  Then give this
# file to sh by executing the command "sh file".  The files
# will be extracted into the current directory owned by
# you with default permissions.
#
# The files contained herein are:
#
# -rw-r--r--  1 hyc         54144 Jun 13 05:26 Arc521.doc
# -rw-r--r--  1 hyc          7232 Jun 12 19:31 arc.1
#
echo 'x - Arc521.doc'
if test -f Arc521.doc; then echo 'shar: not overwriting Arc521.doc'; else
sed 's/^X//' << '________This_Is_The_END________' > Arc521.doc
X
X
X
X
X
X
X
X
X
X
X
X
X                          ARC
X
X                 File Archive Utility
X                     Version 5.20
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X                 (C)COPYRIGHT 1985,86
X                          by
X          System Enhancement Associates, Inc.
X                  ALL RIGHTS RESERVED
X
X
X
X
X
XThis document describes version 5.20 of the ARC file
Xutility, which was created by System Enhancement
XAssociates, Inc. in October of 1986.
X
X
X       TABLE OF CONTENTS
X
X
X
XSection                                           Page
X
X
XIntroduction  ....................................   1
XUsing ARC  .......................................   3
XARC commands  ....................................   5
X    Adding files  ................................   5
X    Extracting files  ............................   7
X    Deleting files  ..............................   8
X    Listing archive entries  .....................   8
X    Running files  ...............................  10
X    Printing files  ..............................  11
X    Testing an archive  ..........................  11
X    Converting an archive  .......................  12
XARC options  .....................................  13
X    Suppressing compression  .....................  13
X    Backup retention  ............................  14
X    Message suppression  .........................  15
X    Encryption/Decryption  .......................  17
XRAMdisk support  .................................  18
XMARC  ............................................  19
XARCE  ............................................  20
XVersion numbers  .................................  21
XCommon questions and answers  ....................  22
XMaintenance contracts  ...........................  24
XRevision history  ................................  25
X    Changes in version 3  ........................  25
X    Changes in version 4  ........................  25
X    Changes in version 4.1  ......................  26
X    Changes in version 4.3  ......................  26
X    Changes in version 4.4  ......................  27
X    Changes in version 4.5  ......................  27
X    Changes in version 5.0  ......................  28
X    Changes in version 5.1  ......................  29
X    Changes in version 5.2  ......................  30
XProgram history and credits  .....................  31
XBulletin boards  .................................  33
XSite licenses  ...................................  34
X
X
X
X
X
X
X
X
X
X
X
X
X
X         INTRODUCTION
X
X
X
XARC is the copyrighted property of System Enhancement
XAssociates, Inc.  You are granted a limited license to
Xuse ARC, and to copy it and distribute it, provided
Xthat the following conditions are met:
X
X1) No fee may be charged for such copying and
X   distribution.
X
X2) ARC may ONLY be distributed in its original,
X   unmodified state.
X
X3) ARC may *not* be distributed, in whole or in part, as
X   part of any commercial product or service without
X   the express written permission of System
X   Enhancement Associates.
X
X
XContributions for the use of this program will be
Xappreciated, and should be sent to:
X
X          System Enhancement Associates, Inc.
X             21 New Street, Wayne NJ 07470
X
XYou may not use this product in a commercial
Xenvironment or a governmental organization without
Xpaying a license fee of $35.  Site licenses and
Xcommercial distribution licenses are available.  A
Xprogram disk and printed documentation are available
Xfor $50.  See the order form enclosed with this manual
Xfor more details.
X
X
X
XARC is user supported software.  This means that you
Xmay copy it freely and give the copies away to anyone
Xyou wish, at no cost.  They are in turn requested to
Xsend in a contribution if they decide to use it.
X
XThe user supported software concept (often referred to
Xas "shareware") is an attempt to provide software at low
Xcost.  The cost of offering a new product by
Xconventional means is staggering, and hence dissuades
Xmany independent authors and small companies from
Xdeveloping and promoting their ideas.  User supported
Xsoftware is an attempt to develop a new marketing
Xchannel, where products can be introduced at low cost.
X
X
X
X
XARC                                              Page 1
XIf user supported software works, then everyone will
Xbenefit.  The user will benefit by receiving quality
Xproducts at low cost, and by being able to "test
Xdrive" software thoroughly before purchasing it.  The
Xauthor benefits by being able to enter the commercial
Xsoftware arena without first needing large sources of
Xventure capital.
X
XBut it can only work with your support.  We're not
Xjust talking about ARC here, but about all user
Xsupported software.  If you obtain a user supported
Xprogram from a friend or colleague, and are still
Xusing it after a couple of weeks, then it is obviously
Xworth something to you, and a contribution should be
Xsent.
X
X
X
XAnd now, back to ARC:
X
XARC is used to create and maintain file archives.  An
Xarchive is a group of files collected together into
Xone file in such a way that the individual files may
Xbe recovered intact.
X
XARC is different from other archive and library
Xutilities in that it automatically compresses the
Xfiles being archived, so that the resulting archive
Xtakes up a minimum amount of space.
X
XWhen ARC is used to add a file to an archive it
Xanalyzes the file to determine which of three storage
Xmethods will result in the greatest savings.  These
Xthree methods are:
X
X1) No compression; the file is stored as is.
X
X2) Repeated-character compression; repeated sequences
X   of the same byte value are collapsed into a three-
X   byte code sequence.
X
X3) Dynamic Lempel-Zev compression;  the file is stored
X   as a series of variable size bit codes which
X   represent character strings, and which are created
X   "on the fly".
X
XNote that since one of the three methods involves no
Xcompression at all, the resulting archive entry will
Xnever be larger than the original file.
X
X
X
X
X
XARC                                              Page 2
X           USING ARC
X
X
X
XARC is invoked with a command of the following format:
X
X    ARC <x> <arcname> [<template> . . .]
X
XWhere:
X
X    <x> is an ARC command letter (see below), in
X    either upper or lower case.
X
X    <arcname> is the name of the archive to act on,
X    with or without an extension.  If no extension is
X    supplied, then ".ARC" is assumed.  The archive
X    name may include path and drive specifiers.
X
X    <template> is one or more file name templates.
X    The "wildcard" characters "*" and "?" may be used.
X    A file name template may include a path or drive
X    specifier, though it isn't always meaningful.
X
X
XIf ARC is invoked with no arguments (by typing "ARC",
Xand pressing "enter"), then a brief command summary is
Xdisplayed.
X
X
X
XFollowing is a brief summary of the available ARC
Xcommands:
X
X    a   = add files to archive
X    m   = move files to archive
X    u   = update files in archive
X    f   = freshen files in archive
X    d   = delete files from archive
X    x,e = extract files from archive
X    r   = run files from archive
X    p   = copy files from archive to standard output
X    l   = list files in archive
X    v   = verbose listing of files in archive
X    t   = test archive integrity
X    c   = convert entry to new packing method
X
X
X
X
X
X
X
X
X
XARC                                              Page 3
XFollowing is a brief summary of the available ARC
Xoptions, which may alter how a command works:
X
X    b   = retain backup copy of archive
X    s   = suppress compression (store only)
X    w   = suppress warning messages
X    n   = suppress notes and comments
X    o   = overwrite existing files when extracting
X    g   = encode or decode archive entry
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
XARC                                              Page 4
X         ARC COMMANDS
X
X
X
XThis section describes each of the commands.  ARC will
Xaccept any one command at a time.  If no commands are
Xgiven, then a brief command list is displayed.
X
X
X
XADDING FILES
X
XFiles are added to an archive using the "A" (Add), "M"
X(Move), "U" (Update), or "F" (Freshen) commands.  Add
Xalways adds the file.  Move differs from Add in that
Xthe source file is deleted once it has been added to
Xthe archive.
X
XUpdate differs from Add in that the file is only added
Xif it is not already in the archive, or if it is newer
Xthat the corresponding entry in the archive.
X
XFreshen is similar to Update, except that new files
Xare not added to the archive; only files already in
Xthe archive are updated.
X
X
XFor example, if you wish to add a file named
X"TEST.DAT" to an archive named "MY.ARC", you would use
Xa command of the form:
X
X    ARC a my test.dat
X
XIf you wanted to add all files with a ".C" extension,
Xand all files named "STUFF" to an archive named
X"JUNK.ARC", you could type:
X
X    ARC a junk *.c stuff.*
X
XIf you wanted to move all files in your current
Xdirectory into an archive named "SUM.ARC", you could
Xuse a command of the form:
X
X    ARC m sum *.*
X
XIf you have an archive named "TEXT.ARC", and you
Xwanted to add to it all of your files with an
Xextension of ".TXT" which have been created or changed
Xsince they were last archived, then you would type:
X
X    ARC u text *.txt
X
X
X
XARC                                              Page 5
XIf you have a bunch of files in your current
Xdirectory, with backup copies being stored in an
Xarchive named "SAFE.ARC", then if you wanted to make
Xsure that every file in the archive is the latest
Xversion of that file, you would type:
X
X    ARC f safe
X
X
XA word about Update and Freshen:  These are similar in
Xthat they look at the date and time of last change on
Xthe file, and only add it if the file has been changed
Xsince it was last archived.  They differ in that
XUpdate will add new files, while Freshen will not.
X
XIn other words, Update looks for the files on disk,
Xand adds them if they are new or have changed, while
XFreshen looks in the archive, and tries to update the
Xfiles which are already there.
X
X
XArchive entries are always maintained in alphabetic
Xorder.  Archive entries may not have duplicate names.
XIf you add a file to an archive that already contains
Xa file by that name, then the existing entry in the
Xarchive is replaced.  Also, the archive itself and its
Xbackup will not be added.
X
XYou may also add a file which is in a directory other
Xthan your current directory.  For example, it is
Xperfectly legal to type:
X
X    ARC a junk c:\dustbin\stuff.txt
X
XYou cannot add two files with the same name.  In other
Xwords, if you have a file named "C:\DUSTBIN\STUFF.TXT"
Xand another file named "C:\BUCKET\STUFF.TXT", then
Xtyping:
X
X    arc a junk c:\dustbin\*.* c:\bucket\*.*
X
Xwill not work.
X
X
XARC does not save the path name.  In other words, if
Xyou specify a drive and/or path when adding a file,
Xonly the actual file name is stored in the archive.
X
X
X
X
X
X
X
XARC                                              Page 6
XARC will never add an archive to itself, nor will it
Xadd the temporary copy or a backup copy of the
Xarchive.
X
X
XAn interesting note:  It has been brought to our
Xattention that BASIC programs compress to a smaller
Xsize when they are *not* tokenized.  If you are more
Xconcerned with space than speed, you may wish to
Xconvert your BASIC programs to ASCII form before
Xadding them to an archive.  Your BASIC manual should
Xgive instructions on how to do this.
X
X
X
XEXTRACTING FILES
X
XArchive entries are extracted with the "E" (Extract)
Xand "X" (eXtract) commands.  For example, if you had
Xan archive named "JUNK.ARC", and you wanted all files
Xin it with an extension of ".TXT" or ".DOC" to be
Xrecreated on your disk, you could type:
X
X    ARC x junk *.txt *.doc
X
XIf you wanted to extract all of the files in an
Xarchive named "JUNK.ARC", you could simply type:
X
X    ARC x junk
X
XWhatever method of file compression was used in
Xstoring the files is reversed, and uncompressed copies
Xare created in the current directory.
X
XYou can also specify a path name, in which case the
Xdecompressed copy is placed in the specified
Xdirectory.  For example, if you had an archive named
X"JUNK.ARC", and you wanted all files in it with an
Xextension of ".TXT" to be placed in the directory
X"C:\WASTE\LAND", then you could type:
X
X    ARC x junk c:\waste\land\*.txt
X
XIf you wanted to put the file "TRASH.TXT" on your A:
Xdrive, and the file "LITTER.TXT" on your B: drive, you
Xcould type:
X
X    ARC x junk a:trash.txt b:litter.txt
X
X
X
X
X
X
XARC                                              Page 7
XIf you give more than one path for a file, then only
Xthe first one is used.  For example, if you typed:
X
X    ARC x junk a:trash.txt b:trash.txt
X
Xthen TRASH.TXT will be placed on your A: drive.
X
X
X
XDELETING FILES
X
XArchive entries are deleted with the "D" (Delete)
Xcommand.  For example, if you had an archive named
X"JUNK.ARC", and you wished to delete all entries in it
Xwith a filename extension of ".C", you could type:
X
X    ARC d junk *.c
X
X
X
XLISTING ARCHIVE ENTRIES
X
XYou can obtain a list of the contents of an archive by
Xusing the "L" (List) command or the "V" (Verbose list)
Xcommand.  For example, to see what is in an archive
Xnamed "JUNK.ARC", you could type:
X
X    ARC l junk
X
XIf you are only interested in files with an extension
Xof ".DOC", then you could type:
X
X    ARC l junk *.doc
X
X
XARC prints a short listing of an archive's contents
Xlike this:
X
X    Name          Length    Date
X    ============  ========  =========
X    ALPHA.TXT         6784  16 May 85
X    BRAVO.TXT         2432  16 May 85
X    COCO.TXT           256  16 May 85
X            ====  ========
X    Total      3      9472
X
X
X"Name" is simply the name of the file.
X
X
X
X
X
X
XARC                                              Page 8
X"Length" is the unpacked file length.  In other words,
Xit is the number of bytes of disk space which the file
Xwould take up if it were extracted.
X
X"Date" is the date on which the file had last been
Xmodified, as of the time when it was added to the
Xarchive.
X
X"Total" is pretty obvious, I think.
X
X
XARC prints a verbose listing of an archive's contents
Xlike this:
X
XName          Length    Stowage    SF   Size now  Date       Time    CRC
X============  ========  ========  ====  ========  =========  ======  ====
XALPHA.TXT         6784  Crunched   35%      4413  16 May 85  11:53a  8708
XBRAVO.TXT         2432  Crunched   41%      1438  16 May 85  11:53a  5BD6
XCOCO.TXT           256   Packed     5%       244  16 May 85  11:53a  3AFB
X        ====  ========            ====  ========
XTotal      3      9472             27%      6095
X
X
X"Name", "Length", and "Date" are the same as for a
Xshort listing.
X
X"Stowage" is the compression method used.  The
Xfollowing compression methods are currently known:
X
X       --          No compression.
X
X     Packed        Runs of repeated byte values are
X                   collapsed.
X
X    Crunched       Lempel-Zev compression technique
X                   employed.
X
X    Squeezed       Huffman encoding compression
X                   technique, as employed by an
X                   earlier version of ARC.
X
X"SF" is the stowage factor.  In other words, it is the
Xpercentage of the file length which was saved by
Xcompression.  The total stowage factor is the stowage
Xfactor for the archive as a whole, not counting
Xarchive overhead.
X
X"Size now" is the number of bytes the file is
Xoccupying while in the archive.
X
X
X
X
X
XARC                                              Page 9
X"Time" is the time of last modification, and is
Xassociated with the date of last modification.
X
X"CRC" is the CRC check value which has been stored
Xwith the file.  Another CRC value will be calculated
Xwhen the file is extracted or tested to ensure data
Xintegrity.  There is no especially good reason for
Xdisplaying this value.
X
X
X
XRUNNING FILES
X
XArchive entries may be run without being extracted by
Xuse of the "R" (Run) command.  For example, if you had
Xan archive named "JUNK.ARC" which contained a file
Xnamed "LEMON.COM", which you wished to run, you could
Xtype:
X
X    ARC r junk lemon
X
XYou can run any file from an archive which has an
Xextension of ".COM", ".EXE", ".BAT", or ".BAS".  You
Xdo not have to specify the extension, but all matching
Xfiles are run if you do not.  In other words, if you
Xhad an archive named "JUNK.ARC" which contained the
Xfiles "LEMON.COM", "LEMON.EXE", and "LEMON.BAS", and
Xyou typed:
X
X    ARC r junk lemon
X
XThen all three programs will be run.  You can avoid
Xthis by specifying an extension in this case.
X
XYou can give arguments to the program you are running
Xby appending them to the command line.  For example,
Xif you have an archive named "JUNK.ARC" which contains
Xa program named "LEMON.COM", and you wanted to run it
Xgiving it the argument "JUICE", you would type:
X
X    ARC r junk lemon juice
X
XYou will need a fair amount of memory to run a program
Xfrom an archive.  It probably cannot be done with less
Xthan 256k.
X
X
X
X
X
X
X
X
X
XARC                                             Page 10
XIn practice, the file to be run is extracted, run, and
Xthen deleted.  In other words, the above example is
Xequivalent to:
X
X    ARC x junk lemon.com
X    lemon juice
X    erase lemon.com
X
XIf you have an archive which contains a program that
Xyou will be running often, then you should probably
Xextract the program from the archive and use it
Xnormally.
X
X
X
XPRINTING FILES
X
XArchive entries may be examined with the "P" (Print)
Xcommand.  This works the same as the Extract command,
Xexcept that the files are not created on disk.
XInstead, the contents of the files are written to
Xstandard output.  For example, if you wanted to see
Xthe contents of every ".TXT" file in an archive named
X"JUNK.ARC", but didn't want them saved on disk, you
Xcould type:
X
X    ARC p junk *.txt
X
XIf you wanted them to be printed on your printer
Xinstead of on your screen, you could type:
X
X    ARC p junk *.txt >prn
X
X
X
XTESTING AN ARCHIVE
X
XThe integrity of an archive may be tested by use of
Xthe "T" (Test) command.  This checks to make sure that
Xall of the file headers are properly placed, and that
Xall of the files are in good shape.
X
XThis can be very useful for critical archives, where
Xdata integrity must be assured.  When an archive is
Xtested, all of the entries in the archive are unpacked
X(without saving them anywhere) so that a CRC check
Xvalue may be calculated and compared with the recorded
XCRC value.
X
X
X
X
X
X
XARC                                             Page 11
XFor example, if you just received an archive named
X"JUNK.ARC" over a phone line, and you want to make
Xsure that you received it properly, you could type:
X
X    ARC t junk
X
XIt defeats the purpose of the T command to combine it
Xwith N or W.
X
X
X
XCONVERTING AN ARCHIVE
X
XThe "C" (Convert) command is used to convert an
Xarchive entry to take advantage of newer compression
Xtechniques.  This is occasionally desirable when a new
Xversion of ARC is released.  Please refer to the
Xrevision history section for details on when new
Xcompression methods were implemented.
X
XFor example, if you had an archive named "JUNK.ARC",
Xand you wanted to make sure that all files with an
Xextension of ".DOC" were encoded using the very latest
Xmethods, you could type:
X
X    ARC c junk *.doc
X
XOr if you wanted to convert every file in the archive,
Xyou could type:
X
X    ARC c junk
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
XARC                                             Page 12
X          ARC OPTIONS
X
X
X
XThis section describes the options which are available
Xto modify how ARC works.  Any of these options can be
Xcombined with any of the commands, though the result
Xmay not always be something you'd want to do.
X
X
X
XSUPPRESSING COMPRESSION
X
XThe "S" (Suppress compression) option can be combined
Xwith any command that updates archive entries.  These
Xinclude Add, Move, Update, Freshen, and Convert.  The
Xeffect of the S option is to prevent any compression
Xtechniques from being employed.  This is intended to
Xallow you to add a few files at a time to an archive
Xquickly, and then later convert the archive to
Xcompress everything at once.
X
XFor example, over the course of a day you might give
Xeach of the following commands:
X
X    ARC as junk *.txt
X    ARC as junk *.mac
X    ARC as junk *.doc
X
XAt the end of the day, when you have finished adding
Xthings to the archive, you could have all of the
Xarchive entries compressed at once by typing:
X
X    ARC c junk
X
XYou could also decompress the archive by typing:
X
X    ARC cs junk
X
Xthough I can't imagine why you'd want to.
X
X
X
X
X
X
X
X
X
X
X
X
X
X
XARC                                             Page 13
XBACKUP RETENTION
X
XWhen ARC changes an archive (during an Add, Move,
XUpdate, Freshen, Delete, or Convert) it creates a new
Xarchive with the same name, but with an extension of
X".$$$".  For example, if you add a file to an archive
Xnamed STUFF.ARC, then ARC will create a new archive
Xnamed STUFF.$$$.  ARC will read from your existing
Xarchive and write out the new archive with any changes
Xto the ".$$$" copy.
X
XNormally when ARC is finished it deletes the original
Xand renames the new archive to the original name (ie.
XSTUFF.ARC goes away, and STUFF.$$$ becomes the new
XSTUFF.ARC).  Among other things, this means that if
Xanything goes wrong and ARC is unable to finish, then
Xyour original archive will still be intact.
X
X
XIn some circumstances you may wish to retain the
Xoriginal version of the archive as a backup copy.  You
Xcan do this easily by using the Backup option.  Add
Xthe letter "B" to your command, and ARC will rename
Xyour original archive to have an extension of ".BAK"
Xinstead of deleting it.
X
X
XIn other words, if you wanted to add "WASTE.TXT" to an
Xarchive named "JUNK.ARC", but wanted to keep a backup
Xcopy, then you would type:
X
X    ARC ab junk waste.txt
X
XYour original archive would become "JUNK.BAK", while
X"JUNK.ARC" would contain the new "WASTE.TXT" file.
X
X
XIf you keep a backup of an archive which already has a
Xbackup, then the older backup copy is deleted.
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
XARC                                             Page 14
XMESSAGE SUPPRESSION
X
XARC prints three types of messages: warnings,
Xcomments, and errors.
X
XWarnings are messages about suspected error
Xconditions, such as when a file to be extracted
Xalready exists, or when an extracted file fails the
XCRC error check.  Warnings may be suppressed by use of
Xthe "W" (Warn) command.  You should use this command
Xsparingly.  In fact, you should probably not use this
Xcommand at all.
X
XComments (or notes) are informative messages, such as
Xnaming each file as it is added to the archive.
XComments and notes may be suppressed by use of the "N"
X(Note) command.
X
XErrors are actual system problems, such as running out
Xof disk space.  You cannot suppress errors.
X
X
XFor example, suppose you extracted all files with an
Xextension of ".BAS" from an archive named "JUNK.ARC"
XThen, after making some changes which you decide not
Xto keep, you decide that you want to extract them all
Xagain, but you don't want to be asked to confirm every
Xone.  In this case, you could type:
X
X    ARC xw junk *.bas
X
XOr, if you are going to add a hundred files with an
Xextension of ".MSG" to an archive named "TRASH.ARC",
Xand you don't want ARC to list them as it adds them,
Xyou could type:
X
X    ARC an trash *.msg
X
XOr, if you want to extract the entire contents of an
Xarchive named "JUNK.ARC", and you don't want to hear
Xanything, then type:
X
X    ARC xnw junk
X
X
XA special case is provided when extracting files from
Xan archive.  One of the various warnings that can
Xoccur is when a file being extracted already exists on
Xdisk.  Normally, ARC will stop and ask you if you want
Xto overwrite the file.  This can be suppressed with
Xthe "W" command, but that will also suppress any
X
X
X
XARC                                             Page 15
Xwarnings about other things, like failed CRC checks
Xand such.
X
XThe "O" (Overwrite) option suppresses *only* the warning
Xthat the file already exists.  For example, in our
Xearlier case of extracting all the ".BAS" files from
X"JUNK.ARC", a much safer way to do it is to type:
X
X    ARC xo junk *.BAS
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
XARC                                             Page 16
XENCRYPTION/DECRYPTION
X
XArchive entries may be encrypted and decrypted by
Xusing the "G" (Garble) option.  The Garble option
Xtakes the remainder of the command string as the
Xpassword to use, so it must be the *last* option.
X
X
XFor example, if you wanted to add a file named
X"WASTE.TXT" to an archive named "JUNK.ARC", and you
Xwanted to encrypt it using the password "DEBRIS", then
Xyou would type:
X
X    ARC agdebris junk waste.txt
X
XLater on, when you want to extract it again, you would
Xtype:
X
X    ARC xgdebris junk waste.txt
X
XThe password you supply is used to encrypt (or
Xdecrypt) the archive entry by performing an exclusive
XOR between each byte of the packed data and each byte
Xof the password.  The password can be any length, and
Xeach of its bytes is used in rotation.  The password
Xis converted to uppercase before it is used, so it is
X*not* case sensitive.  Since the encryption is performed
Xon the packed data, it has no effect on stowage
Xfactors.
X
XThis is not a particularly sophisticated means of
Xencryption, and it is theoretically possible to crack.
XStill, since it is performed on the packed data, the
Xresult should be quite sufficient for casual use.
X
X
XYou can, if you wish, use different passwords for
Xdifferent files in an archive, but we advise against
Xit.  If you are going to encrypt an archive, we
Xsuggest you use the same password for every file, and
Xgive the password whenever you do anything at all with
Xthe archive.  It is possible to list the entries in an
Xencrypted archive using the "L" and "V" commands
Xwithout giving the password, but nothing else will
Xwork properly.
X
X
XWe advise that you use this option sparingly, if at
Xall.  If you should forget or mistype your password,
Xit is highly unlikely that you will ever recover your
Xdata.
X
X
X
XARC                                             Page 17
X        RAMDISK SUPPORT
X
X
X
XIf you have a RAMdisk, or other high-speed storage,
Xthen you can speed up ARC somewhat by telling it to
Xput its temporary files on the RAMdisk.  You do this
Xby setting the ARCTEMP environment string with the MS-
XDOS SET command.  For example, if drive B: is your
XRAMdisk, then you would type:
X
X    set ARCTEMP=B:
X
XRefer to the MS-DOS manual for more details about the
XSET command.  You need only set the ARCTEMP string
Xonce, and ARC will use it from then on until you
Xchange its value or reboot your system.
X
X
XIf ARC does not find an environment string named
XARCTEMP, then it looks for one named TEMP to use
Xinstead.  Several packages already use the TEMP string
Xfor exactly this purpose.  If you have need of an
Xenvironment string named TEMP for something else, then
Xyou should be sure to define ARCTEMP.
X
X
XThere are a limited number of temporary files created
Xby ARC.  The Convert command uses a file named
X"$ARCTEMP.CVT" to hold each file as it is being
Xconverted.  The Run command also creates a temporary
Xfile, which has the name "$ARCTEMP", and whose
Xextension matches that of the file being run.
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
XARC                                             Page 18
X             MARC
X
X
X
XMARC is a separate program which is used to merge
Xarchives created by ARC.  MARC moves files from one
Xarchive to another without unpacking them.
X
X
XMARC is used as follows:
X
X    MARC <target> <source> [<template> . . .]
X
XWhere:
X
X    <target> is the name of the archive to add files
X    to.
X
X    <source> is the name of the archive to read files
X    from.
X
X    <template> is one or more file name templates.
X    The wildcard characters "*" and "?" may be used.
X    If no template is supplied, then all of the files
X    in <source> are added to <target>.
X
XIt is not necessary for the target to exist.  If it
Xdoes not exist, then it is created.  Thus, MARC can be
Xused as an "extractor" as well as a "merger".
X
X
XFor example, if you wanted to create an archive named
X"JUNK.ARC", which is to contain all of the files with
Xan extension of ".TXT" which are currently contained
Xin another archive named "WASTE.ARC", then you could
Xtype:
X
X    MARC junk waste *.txt
X
XIf you wanted to create an archive named "JUNK.ARC",
Xwhich is to contain all of the files currently in the
Xarchives "WASTE.ARC" and "TRASH.ARC", you could type:
X
X    MARC junk waste
X    MARC junk trash
X
X
XIf MARC is invoked with no arguments, then it gives
Xbrief directions in its use.
X
X
X
X
X
XARC                                             Page 19
X             ARCE
X
X
X
XARCE is a program which is used to extract files from
Xan archive.  It will *only* extract files, and it will
X*not* extract encrypted files.  It doesn't do anything
Xthat ARC can't do, but it is highly optimized for the
Xsole purpose of archive extraction, so it is very
Xsmall and very fast.
X
XARCE is used in a fashion very similar to the "ARC E"
Xcommand (hence the name).  The first argument is the
Xname of the archive to extract files from, and may
Xinclude a drive and path specifier.  Up to sixteen
Xadditional arguments can be supplied, which specify
Xthe files to extract.  The wildcard characters "*" and
X"?" are allowed, as with ARC.  If no files are named,
Xthen all files are extracted from the archive.  If the
Xfile being extracted already exists, you are asked
Xwhether or not you want to overwrite it.  You can use
Xthe "/R" option to bypass this.
X
XFor example, if you had an archive named "WASTE.ARC"
Xthat you wanted to extract everything from, then you
Xcould type:
X
X    ARCE waste
X
XOr if you just wanted to extract the files with a
Xfilename extension of ".ASM", you could type:
X
X    ARCE waste *.asm
X
XIf you already have a few files from the archive that
Xyou want replaced, then you could type:
X
X    ARCE waste *.asm /R
X
XIf you run ARCE with no arguments at all, then it will
Xgive you a brief reminder of how to use it.
X
X
XNOTICE:NOTICE: ARCE is the copyrighted property of Vernon D.
X        Buerg and Wayne Chin.  It is included on the
X        ARC program disk as a service to ARC users.
X
X        Vernon D. Buerg
X        456 Lakeshire Drive
X        Daly City, CA  94015
X        RBBS: (415) 994-2944
X
X
X
XARC                                             Page 20
X        VERSION NUMBERS
X
X
X
XThere seems to be some confusion about our version
Xnumbering scheme.  All of our version numbers are
Xgiven as a number with two decimal places.
X
XThe units indicate a major revision, such as adding a
Xnew packing algorithm.
X
XThe first decimal place (tenths) indicates a minor
Xrevision that is not essential, but which may be
Xdesired.
X
XThe second decimal place (hundredths) indicates a
Xtrivial revision that will probably only be desired by
Xspecific individuals or by die-hard "latest version"
Xfanatics.
X
XARC also displays its date and time of last edit.  A
Xchange of the date and time without a corresponding
Xchange in version number indicates a truly trivial
Xchange, such as fixing a spelling error.
X
X
XTo sum up: If the units change, then you should get
Xthe newer version as soon as you can.  If the tenths
Xchange, then you may want to get the newer version,
Xbut there's no hurry.  If anything else changes, then
Xyou probably shouldn't bother.
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
XARC                                             Page 21
X COMMON QUESTIONS AND ANSWERS
X
X
X
XHere are some of the more common questions we've
Xreceived about ARC, along with their answers:
X
X
XQ: Why does ARC run out of room if I make an archive
X   bigger than about 180k?
X
XA: Because you are working on a floppy disk.  ARC
X   creates a copy of your archive, incorporating any
X   new files as it goes.  When it is done, it deletes
X   the original and renames the new one.  There are a
X   number of reasons for doing it this way, one being
X   that your original archive is still intact if
X   anything happens while ARC is running.
X
X   You can save some space by using drive specifiers
X   and having the archive and the files to add on
X   separate disks, but you still won't be able to make
X   an archive larger than about 180k.  If you need to
X   make a larger archive, and if you have a fixed
X   disk, then you can create the archive on the fixed
X   disk and then copy it to the floppy.
X
X
XQ: I've seen an ARC.COM and an ARC.EXE.  Which one is
X   the right one?
X
XA: ARC.EXE.  One or more people have been running ARC
X   through a utility that converts an ".EXE" file to a
X   ".COM" file.  But this utility is designed to save
X   space, not speed.  On ARC it saves about 250 bytes,
X   and makes no measurable difference in program
X   speed.  We've decided that the savings are not
X   worth the extra step in development in this case.
X
X
XQ: How can I get the latest version of ARC?
X
XA: ARC updates are distributed through normal
X   shareware channels, and by FidoNet.  We also ship a
X   program update disk on every order of $50 or more.
X   Also, please refer to the next section for
X   information about our maintenance contracts.
X
X
X
X
X
X
X
XARC                                             Page 22
XQ: Can I use ARC to distribute my public domain or
X   shareware program?
X
XA: Yes, of course.
X
X
XQ: Can I use ARC to distribute my commercial software
X   package?
X
XA: Yes, provided that you obtain a commercial
X   distribution license from us.  Please contact us
X   for details.
X
X
XQ: I'm a commercial user.  Why should I pay for
X   shareware that others get for free?
X
XA: Because you cannot credibly plead poverty.
X              ___   Shareware, all shareware, is an attempt to develop
X   a new marketing channel to the benefit of everyone.
X   You can still "test drive" shareware for a short
X   period, but if you decide to use it in your
X   business, then you should pay for it.
X
X
XQ: Why not allow me to select which method of
X   compression I want ARC to use?
X
XA: It would needlessly complicate ARC, both internally
X   and in use.  The exact nature of the compression
X   methods used are complex, and quite different.  The
X   only sure way to tell which will be best in any
X   given case is to analyze the data, as ARC does.
X   The method chosen may not always be what you
X   expect.
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
XARC                                             Page 23
X     MAINTENANCE CONTRACTS
X
X
X
XRegistered users of ARC receive 90 days of telephone
Xsupport at no extra charge.  If you wish, you can
Xextend this by pruchasing a maintenance contract.
X
XA maintenance contract costs $50 per year and entitles
Xyou to unlimited telephone support, as well as free
Xupdates to ARC as they come out.
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
XARC                                             Page 24
X       REVISION HISTORY
X
X
X
XCHANGES IN VERSION 3
X
XThe function used to calculate the CRC check value in
Xprevious versions has been found to be in error.  It
Xhas been replaced with the proper function.  ARC will
Xstill read archives created with earlier versions of
XARC, but it will report a warning that the CRC value
Xis in error.  All archives created prior to version
X3.0 should be unpacked and repacked with the latest
Xversion of ARC.
X
X
XTransmitting a file with XMODEM protocol rounds the
Xsize up to the next multiple of 128 bytes, adding
Xgarbage to the end of the file.  This used to confuse
XARC, causing it to think that the end of the archive
Xwas invalidly formatted.  This has been corrected in
Xversion 3.01.  Older archives may still be read, but
XARC may report them to be improperly formatted.  All
Xfiles can be extracted, and no data is lost.  In
Xaddition, ARC will automatically correct the problem
Xwhen it is encountered.
X
X
X
XCHANGES IN VERSION 4
X
XARC is adding another data compression technique in
Xthis version.  We have been looking for some technique
Xthat could improve on Huffman squeezing in at least a
Xfew cases.  So far, Lempel-Zev compression seems to be
Xfulfilling our fondest hopes, often achieving
Xcompression rates as much as 20% better than
Xsqueezing, and sometimes even better.  Huffman
Xsqueezing depends on some bytes being more "popular"
Xthan others, taking the file as a whole.  Lempel-Zev
Xcompression is instead looking for strings of bytes
Xwhich are repeated at various points (such as an end
Xof line followed by spaces for indentation).  Lempel-
XZev compression is therefore looking for repetition at
Xa more "macro" level, often achieving impressive
Xpacking rates.
X
XIn the typical case a file is added to an archive once
Xand then extracted many times, so the increased time
Xfor an update should more than pay for itself in
Xincreased disk space and reduced transmission time.
X
X
X
XARC                                             Page 25
XCHANGES IN VERSION 4.1
X
XLempel-Zev coding has been improved somewhat by
Xperforming non-repeat compression on the data before
Xit is coded (as was already done with Huffman
Xsqueezing).  This has the two fold advantage of (a)
Xreducing to some extent the amount of data to be
Xencoded, and (b) increasing the time it takes for the
Xstring table to fill up.  Performance gains are small,
Xbut noticeable.
X
XThe primary changes are in internal organization.  ARC
Xis now much "cleaner" inside.  In addition to the
Xaesthetic benefits to the author, this should make
Xlife easier for the hackers out there.  There is also
Xa slight, but not noticeable, improvement in overall
Xspeed when doing an update.
X
X
X
XCHANGES IN VERSION 4.3
X
XVersion 4.3 adds the much-demanded feature of using
Xpathnames when adding files to an archive.
X
XVersion 4.3 is also using a slightly different
Xapproach when adding a file to an archive.  The end
Xresult is twofold:
X
X1) Slightly more disk space is required on the drive
X   containing the archive.  This should only be
X   noticeable to those creating very large archives on
X   a floppy based system.
X
X2) A 30% reduction in packing time has been achieved
X   in most cases.  This should be noticeable to
X   everyone.
X
XAs always, version 4.3 is still fully upwards
Xcompatible, and is backwards compatible as far as
Xversion 4.1.
X
X
X
X
X
X
X
X
X
X
X
X
X
XARC                                             Page 26
XCHANGES IN VERSION 4.4
X
XThe temporary file introduced in version 4.3
Xoccasionally caused problems for people who had not
Xadded a FILES= statement to their CONFIG.SYS file.
XThis has now been corrected.  Also, support of the
XARCTEMP environment string was added to allow placing
Xof the temporary file on a RAMdisk.
X
XA bug was reported in the Run command, which has been
Xfixed.  From the nature of the bug, and the extreme
Xtime required before the bug was reported, it is
Xdeduced that the Run command is probably the least
Xused feature of ARC.
X
XThe Update command was changed.  It is no longer a
Xstraight synonym for Add.  Instead, Update now only
Xadds a file if it is newer than the version already in
Xthe archive, as shown by the MS-DOS date/time stamp.
X
X
X
XCHANGES IN VERSION 4.5
X
XThe Convert command was not making use of RAMdisk
Xsupport.  Now it is.
X
XThe Freshen command was added.  Our first choice for a
Xname was Refresh, but we already had a Run command.
XAssuming that you have an archive which already
Xcontains everything you want in it (for software
Xdistribution, perhaps), then Freshen would be used to
Xupdate the archive.  It was pointed out to us that ARC
Xalready knows what is in the archive, so it should be
Xable to look on disk for newer versions.  Now it can.
X
XThe Suppress compression option was added by popular
Xdemand.  It allows files to be added quickly to an
Xarchive, since the files are not analyzed or
Xcompressed, but merely stored straight.  The intent is
Xto allow users to build an archive "in pieces", and
Xthen compress all of the entries at once with the
XConvert command.  The conversion is much faster if you
Xtake advantage of RAMdisk support.
X
XA minor bug was detected in our handling of date/time
Xstamps which occasionally resulted in stamping an
Xarchive with the wrong date and time.  This has been
Xcorrected.
X
X
X
X
X
XARC                                             Page 27
XCHANGES IN VERSION 5.0
X
XThe Move command used to delete the files as it went.
XIt now waits until it is finished updating the
Xarchive, and deletes them all at once.  (You *did* know
Xthat Move is just an Add where the file gets deleted,
Xdidn't you?)  This, along with the changes made in
Xversion 4.5, means that it is now much safer to
Xinterrupt ARC while it is working.
X
XThe Print command no longer prints the name of each
Xfile.  Instead, it prints a formfeed after each file.
X
XThe Run command now supports BASICA programs.  Also,
Xthe filename extension is no longer required on the
XRun command.
X
XThe Garble option was added.  It provides a convenient
Xmeans of low level data security for the casual user.
XUse it sparingly, if at all.
X
XARC no longer tests for the presence of $ARCTEMP.CRN
Xbefore creating a new one.  If you interrupt ARC a
Xlot, you'll find this much more convenient.  If you
Xhappen to have a file named $ARCTEMP.CRN which you
Xwant to keep, too bad.
X
XImproved error recovery was added when reading an
Xarchive.  ARC now has a good chance of recovering the
Xdata from a corrupted archive (the corrupted entry is
Xstill lost, of course).
X
XPath support has been added for all commands, though
Xit doesn't do anything on most of them.  For example,
Xthere isn't much we can do with a path in the List
Xcommand.  But many users will be glad to know that a
Xpath can be used when extracting a file, and specifies
Xwhere the file is to be placed.
X
XSupport for the TEMP environment string was added.  If
XARC doesn't find an environment string named ARCTEMP,
Xthen it looks for one named TEMP to use instead.
XSeveral packages already use the TEMP string for
Xexactly this purpose.  With any luck, maybe we can get
Xa standard going.
X
X
X
X
X
X
X
X
X
XARC                                             Page 28
XARC is now using a different variation of Lempel-Zev
Xcoding, courtesy of Kent Williams, who found it on
XUSENET and adapted it to the IBM PC.  The new method
Xdiffers from the old in several respects.  The most
Xsignificant differences are:
X
X1) Where our previous implementation used a fixed code
X   size of twelve bits, the new one starts with a code
X   size of nine bits and increases it as it needs to.
X
X2) The earlier method tended to "choke" on large files
X   when its string table filled up.  The new method
X   has a rather ingenious scheme its authors call
X   "adaptive reset."  When it notices that its string
X   table has filled, and its compression ratio is
X   starting to suffer, it clears the table and starts
X   defining new strings.
X
XOur benchmarks show an improvement in compression on
Xthe order of 10% when crunching is used.
XAdditionally, ARC 5.0 is on the order of 23% faster at
Xadding a file when crunching is used, or 13% faster
Xwhen squeezing is used.  Extracting a file crunched
Xwith the new method is 27% faster than it is with the
Xold method.  Extraction of any other type of file
X(including those crunched with the older method) is no
Xfaster than before.  These figures are based on our
Xown benchmark tests; your results may vary.
X
XThe previous implementation of Lempel-Zev coding is no
Xlonger used to pack files.  The "V" (Verbose listing)
Xcommand distinguishes between the two by referring to
Xthe older method as "crunched" (with a lower-case
X"c"), and the newer method as "Crunched" (with a
Xcapital "C").
X
XARC 5.0 can still read archives created by earlier
Xversions of ARC, but once again it creates archives
Xwhich older versions cannot read.
X
X
X
XCHANGES IN VERSION 5.1
X
XRick Moore discovered that ARC was occasionally adding
Xan archive to itself.  This would only happen when the
Xarchive is in the same directory as the files being
Xadded, and its name comes last.  This bug has been
Xfixed, though it is still possible to fool ARC into
Xadding an archive to itself by getting tricky with
Xpath names.
X
X
X
XARC                                             Page 29
XDana Montgomery found the upper limit on how many
Xfiles can be added to an archive.  There's always been
Xan upper limit, but it depends on memory, and used to
Xbe larger than anyone could possibly want (knock on
Xwood).  However, the added memory requirements in
Xversion 5.0 lowered this limit into the realm of
Xpossibility, somewhere around 300 files.  We change
Xsome things around, and effectively, there is no
Xlonger a limit on how many files you can add at once.
XARC will add the files in batches of as many as it can
Xhandle at one time.
X
XWe've also introduced a new packaging method for ARC
Xand its documentation, since we are in the unique
Xposition of being unable to use ARC for this purpose.
XWe've created a program called ARC51.COM which, when
Xexecuted, attempts to create the ARC program and
Xmanual.  You must be in the same directory as
XARC51.COM when you run it.
X
X
X
XCHANGES IN VERSION 5.2
X
XWe've made some changes to Lempel-Zev coding to
Xfurther improve its compression ability on "poor fit"
Xfiles (mainly .EXE and .COM files).  The result is
Xthat crunching now works better than squeezing on
Xalmost all files, and comes close on most of the rest
X(within 5%, by our benchmarks).  Accordingly, we have
Xdropped Huffman encoding in this version.  Our
Xbenchmarks show a speed improvement of around 14% when
Xadding a file to an archive.
X
XA low-level file copy routine was implemented to speed
Xup bulk data moves.  Deleting or adding a file to a
Xlarge existing archive is now much faster.
X
XThe Run command has been modified to allow passing
Xcommand line arguments to the program being run.
X
XThe temporary file introduced in version 4.3 has been
Xeliminated.  Crunched output generated in the analysis
Xphase is now placed directly in the output archive,
Xand is rewritten if crunching turns out not to be the
Xbest choice.  This can, in rare circumstances, cause
Xan archive to be slightly larger than it should be,
Xbut it also makes ARC considerably faster at adding
Xfiles to an archive.
X
X
X
X
X
XARC                                             Page 30
X  PROGRAM HISTORY AND CREDITS
X
X
X
XIn its short life thus far, ARC has astounded us with
Xits popularity.  We first wrote it in March of 1985
Xbecause we wanted an archive utility that used a
Xdistributive directory approach, since this has
Xcertain advantages over the then popular central
Xdirectory approach.  We added automatic squeezing in
Xversion 2 at the prompting of a friend.  In version
X2.1 we added the code to test for the best compression
Xmethod.  In less than a year we found that our humble
Xlittle program had spread across the country, and
Xseems to have become a new institution.
X
XWe are thankful for the support and appreciation we
Xhave received.  We hope that you find this program of
Xuse.
X
X
XIf we have achieved greatness, it is because we have
Xstood upon the shoulders of giants.  Nothing is
Xcreated as a thing unto itself, and ARC is no
Xexception.  Therefore, we would like to give credit to
Xthe following people, without whose efforts ARC could
Xnot exist:
X
X
XBrian W. Kernighan and P. J. Plauger, whose book
X"Software Tools" provided many of the ideas behind the
Xdistributive directory approach used by ARC.
X
XDick Greenlaw, who wrote the public domain SQ and USQ
Xprograms, in which the Huffman squeezing algorithm was
Xfirst developed.
X
XRobert J. Beilstein, who adapted SQ and USQ to
XComputer Innovations C86 (the language we use), thus
Xproviding us with important parts of our squeezing
Xlogic.
X
XKent Williams, who graciously allowed us to use his
XLZWCOM and LZWUNC programs as a basis for our Lempel-
XZev compression logic, and who continues to make
Xvaluable contributions.
X
XDavid Schwaderer, whose article in the April 1985
Xissue of PC Tech Journal provided us with the logic
Xfor calculating the CRC 16 bit polynomial.
X
X
X
X
XARC                                             Page 31
XTerry A. Welch, whose article "A Technique for High
XPerformance Data Compression", IEEE Computer Vol 17 No
X6 (June 1984) seems to have started all the research
Xon Lempel-Zev coding.
X
XSpencer W. Thomas, Jim McKie, Steve Davies, Ken
XTurkowski, James A.  Woods, and Joe Orost, who are the
Xauthors of the UNIX compress utility.
X
XAlex Jacobs, who in June of 1985 sent us the very
Xfirst shareware contribution we ever received.
X
X
XAnd many, many others whom we could not identify.
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
XARC                                             Page 32
X        BULLETIN BOARDS
X
X
X
XARC is distributed mainly through shareware channels.
XAmong other things, this means that ARC is available
Xfrom many bulletin board systems.  In fact, the system
Xoperators (sysops) of many bulletin boards have taken
Xto storing almost all of their downloadable files in
Xarchives to save themselves disk space and to save
Xtheir users time.
X
XThis also makes things more convenient for the
Xbulletin board users, since one archive may contain
Xseveral programs, any related data files, and the
Xdocumentation.  Many shareware authors have taken to
Xdistributing their software in archives to help ensure
Xthat the users receive everything.
X
XObviously, we can't do that with ARC.  As a result,
Xmany of our users have ARC, but don't have the manual.
XMost of our customer support calls come from people
Xwho have never seen the manual, and in many cases
Xdidn't even know that one exists!
X
XTo solve this problem we developed what is in essence
Xa self-unpacking archive.  We distribute this as
X"ARCxxx.COM", where "xxx" is the current version
Xnumber.  For example, ARC version 5.20 would be
Xdistributed as "ARC520.COM".  This program, when run,
Xunpacks itself into a copy of ARC plus its
Xdocumentation.
X
XNow that we've gone to all that work, we'd really
Xappreciate it if you would use this program when you
Xdistribute ARC.
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
XARC                                             Page 33
X         SITE LICENSES
X
X
X
XCorporate users may wish to obtain a site license for
Xthe use of ARC.  Please use the order form in this
Xmanual to order a site license.  Site licenses are
Xgranted as of when we receive your payment.  License
Xfees vary depending on the number of computers on
Xwhich ARC will be used, as follows:
X
X     1 to  9 machines  $35 each
X    10 to 24 machines  $25 each
X    25 to 49 machines  $20 each
X    50 to 99 machines  $15 each
X    over  99 machines  $1500 one time fee
X
X
X
XEnclosed is a site license agreement, which should be
Xsigned and sent with your payment when ordering a
Xcommercial site license.
X
X
XA commercial site license does not include additional
Xcopies of the ARC program disk and the ARC manual.
XInstead, you make your own copies of the disk and
Xmanual as you need them.  If you wish, you can order
Xadditional program disks and manuals from us.
X
XAdditional program disks cost $10 each.  Additional
Xmanuals cost $20 each.  If you wish, you can order
Xprogram sets for $40 each.  A "program set" is a
Xprogram disk and manual enclosed in a vinyl binder.
XThere is a $50 minimum on all orders.
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
X
XARC                                             Page 34
X             SITE LICENSE APPLICATION
X
X
X
XThe use of ARC in a commercial environment or government organization
Xis granted under the following terms:
X
X1.  Payment of the license fee must be made to System Enhancement
X    Associates, Inc.  The fee is based on the number of computers
X    which will be used to run ARC, as follows:
X
X          1 to  9 machines  $35 each
X         10 to 24 machines  $25 each
X         25 to 49 machines  $20 each
X         50 to 99 machines  $15 each
X         over  99 machines  $1500 one time fee
X
X2.  You may use ARC on the number of computers included in the license
X    fee.  If you have paid the fee for over 99 machines, then you may
X    use ARC on any number of computers within your organization.
X
X3.  You may make copies of the program and documentation, in their
X    original,  unmodified form,  without restriction.  You may
X    distribute these copies without restriction.
X
X4.  If these copies are distributed outside of your organization,  you
X    have no obligation to control the use of those copies which are
X    outside of your organization.
X
X5.  You may make copies of the program documentation, in both its
X    printed form and machine readable form, without restriction.
X
X6.  You may use all future versions of ARC under this license.
X
X7.  You may *not* modify the program or charge a fee for copying or
X    distributing the program or its documentation.
X
X8.  It is your responsibility to make the necessary copies and to
X    deliver them to the computers which they will be used on.  If you
X    wish, you can order additional ARC program disks and manuals.
X
X9.  We are not responsible for *anything* that may happen or not happen
X    if you use ARC.  You're on your own.
X
X
X    I agree to abide by the terms and conditions of this license.
X
X    _____________________________         __________________________
X    Signature                             Date
X
X    _____________________________
X    Name (please print or type)
X
X    _____________________________
X    Title
X
X    _____________________________
X    Company
X
X
X                   ORDER FORM
X
X
X
XCheck which items you wish to purchase:
X
X    [] Noncommercial license for the use of ARC.
X
X    [] Commercial license for the use of ARC on ___ computers (see
X       attached price schedule and terms).
X
X    [] Program disk and documentation (only on orders of $50 or more,
X       not counting maintenance contracts).
X
X    [] ____ additional program disks at $10 per disk.
X
X    [] ____ additional manuals at $20 per manual
X
X    [] ____ additional program sets (disk, manual, and binder) at $40
X       per program set.
X
X    [] One year maintenance agreement at $50 per year.
X
X    [] Payment of $_____ is enclosed (check or money order).
X
X    [] Please charge $_____ to my [] Visa or [] MasterCard:
X
X      Card number:  _______________________________
X
X      Expiration date:  ___________________________
X
X      Signature:  _________________________________
X
X    _______________________________________________
X    Name
X
X    _______________________________________________
X
X
X    _______________________________________________
X    Address
X
X    ______________________   ________  ____________
X    City                     State     Zip
X
X    _______/_______
X    FidoNet address
X
X
XSend this completed form to:
X
X                  System Enhancement Associates, Inc.
X                     21 New Street, Wayne NJ 07470
X
XFor program disk orders outside the U.S., please add an additional $5,
Xand enclose an international money order payable in U.S. currency.
X
XFor commercial site license orders, please enclose a signed copy of
Xthe site license agreement.
X
________This_Is_The_END________
if test `wc -c < Arc521.doc` -ne    54144; then
	echo 'shar: Arc521.doc was damaged during transit (should have been    54144 bytes)'
fi
fi		; : end of overwriting check
echo 'x - arc.1'
if test -f arc.1; then echo 'shar: not overwriting arc.1'; else
sed 's/^X//' << '________This_Is_The_END________' > arc.1
X.TH ARC 1L "12 Jun 1988" "Local" "LOCAL COMMANDS"
X.SH NAME
Xarc \- pc archive utility
X.SH SYNOPSIS
X.B arc
Xa|m|u|f|d|x|e|r|p|l|v|t|c [ biswnoq ] [ g\fIpassword\fR ]
X.I archive 
X[ \fIfilename\fR ...]
X.SH DESCRIPTION
X.I Arc
Xis a general archive and file compression utility, used to maintain
Xa compressed archive of files.
XAn
X.I archive
Xis a single file that combines many files, reducing storage space
Xand allowing multiple files to be handled as one.
X.I Arc
Xuses one of several compression methods for each file within the
X.IR archive ,
Xbased on whichever method yields the smallest result.
X.SH INSTRUCTIONS
XExecute
X.I arc
Xwith no arguments for fairly verbose, usable instructions.
X.SH COMMAND SWITCHES
X.TP 3
Xa
Xadd files to archive.  Copies the indicated files to the archive.
X.TP
Xm
Xmove files to archive.  Same as 'a' switch except
Xthat the files are deleted from the directory as
Xthey are moved to the archive.
X.TP
Xu
Xupdate files in archive.  This switch will replace archived
Xfiles when the named file is newer than the archived copy.
XNew files will be added automatically.
X.TP
Xf
Xfreshen files in archive.  Same as 'u' except that
Xnew files will not be added.
X.TP
Xd
Xdelete files in archive.  The named files are removed from the archive.
X.TP
Xx,e
Xextract files from archive.  The named files are extracted
Xfrom the archive and created in the current directory
Xin an uncompressed state.
X.TP
Xr
Xrun one file with arguments from archive.  Any
Xprogram may be executed directly from the archive.
XThe parameters given after the program name are passed to
Xthe program without modification.
X.TP
Xp
Xcopy files from archive to standard output.  Useful
Xwith I/O redirection. A form-feed is appended after each file,
Xto ease use with printers.
X.TP
Xl
Xlist files in archive.  Limited information listing
Xof files contained in an archive.  Displays the
Xfilename, original length, and date last modified.
XIf the 'n' option (see below) is used, only the
Xfilename is displayed.
X.TP
Xv
Xverbose listing of files in archive.  Complete
Xinformation listing of files contained in an archive.
XDisplays the filename, original length, storage method,
Xstorage factor (% savings), compressed size, date, time,
Xand CRC.
X.TP
Xt
Xtest archive integrity.  Computes CRC values for each member of
Xthe archive and compares against the previously saved value.
X.TP
Xc
Xconvert entry to new packing method.  Convert files
Xstored with older methods to newer methods that are
Xmore efficient. Also useful for files previously
Xarchived with the 's' option.
X.SH OPTIONS
X.TP 3
Xb
Xretain backup copy of archive.  Keep the original
Xarchive file and rename to .BAK.
XThis switch may be used with the
Xfollowing commands:  a, m, u, f, d, c.
X.TP
Xi
Xsuppress image mode.  This switch causes files to
Xbe treated as text files, and will translate their
Xend-of-line sequence. (Unix's '\\n' vs. '\\r\\n' used
Xon many other systems.)  The default is to perform
Xno translation when compressing or extracting files.
XThis option makes dealing with text files much nicer,
Xthough the 'tr' command can also be used. ('\\r' in
Xmakefiles and C source code is such a nuisance...)
X.TP
Xs
Xsuppress compression.  This forces new files to be
Xsaved using Method 2 (no compression).  This switch
Xmay be used with the following commands:  a, m, u, f, c.
X.TP
Xw
Xsuppress warning messages.  This switch will keep
Xwarning messages from being displayed which is the default.
XMost warnings concern the deletion or existence of
Xfiles with the same name.
X.TP
Xn
Xsuppress notes and comments.  This switch will keep
Xuseful notes from being displayed which is the default.
XMost notes indicate what stage of compression is
Xbeing run (analyze, compaction, storage).
X.TP
Xo
Xoverwrite existing files when extracting.  This switch
Xwill make existing files silently get overwritten, instead
Xof asking for confirmation, which is the default.
X.TP
Xq
Xforce Squash compression method.  This switch causes
Xthe Squash compression method to be used, instead of
XCrunch, which is the default.
X.TP
Xg
Xencrypt/decrypt archive entry.  This is used to encode
Xfiles so that others may not read them.  BE CAREFUL!
XThis must be the last parameter in the switches because
Xeverything following is part of the password.
X.SH PROGRAMMING NOTES
X.I Arc
XVersion 2 differs from version 1 in that archive entries
Xare automatically compressed when they are added to the archive,
Xmaking a separate compression step unecessary.  The nature of the
Xcompression is indicated by the header version number placed in
Xeach archive entry, as follows:
X.nf
X         1 = Old style, no compression
X         2 = New style, no compression
X         3 = Compression of repeated characters only
X         4 = Compression of repeated characters plus Huffman SQueezing
X         5 = Lempel-Zev packing of repeated strings (old style)
X         6 = Lempel-Zev packing of repeated strings (new style)
X         7 = Lempel-Zev Williams packing with improved hash function
X         8 = Dynamic Lempel-Zev packing with adaptive reset
X         9 = Squashing
X.fi
X
XType 5, Lempel-Zev packing, was added as of version 4.0
X
XType 6 is Lempel-Zev packing where runs of repeated characters
Xhave been collapsed, and was added as of version 4.1
X
XType 7 is a variation of Lempel-Zev using a different hash
Xfunction which yields speed improvements of 20-25%, and was
Xadded as of version 4.6
X
XType 8 is a different implementation of Lempel-Zev, using a
Xvariable code size and an adaptive block reset, and was added
Xas of version 5.0
X
XType 9 is another variation of Lempel-Zev, using a larger
Xhash table. This method was developed by Phil Katz, and is
Xnot supported by the "official" \fBARC\fP programs.
X
X.I Arc
Xwill look for environment variables named \fIARCTEMP\fP or
X\fITMPDIR\fP, which, if present, indicates the pathname
Xwhere temporary files should be created. This is typically
Xthe location of a RAMdisk on a microcomputer, "/tmp/" or
Xleft unset.
X
XSee the included documentation file for more details.
X.SH HISTORY
X\fIArc\fP has been in use in the CP/M and MSDOS world for many years.
XThom Henderson developed the original version, but it is important to note that
X\fIarc\fP is based on the file compression theories developed by Huffman, Welch,
XKnott, Knuth, and many other scientists. This implementation is based on
Xversion 5.21 of the MSDOS program.
X.SH BUGS
X\fIArc\fP behaves just like the PC version of the program; all functions
Xof the "usage" display are working.
XFull compatibility with PC ARC files is maintained, the price for which is
Xthat \fIarc\fP doesn't like long filenames, and can only archive files with
Xnames of up to 12 characters.
XIt will *sometimes* do The Right Thing with them, but I suggest
Xyou put long-winded filenames in a "shar" before
X.IR arc ing
Xthem.
X
XThere shouldn't be any problems, (hah!) but if you find any, please
Xsend them to me at:
X
X	hyc@umix.cc.umich.edu
X	{rutgers, uunet}!umix!hyc
X
X.SH AUTHORS
XOriginal MSDOS program by Thom Henderson
X.br
XCOPYRIGHT(C) 1985-87 by System Enhancement Associates; ALL RIGHTS RESERVED
X
XOriginal Lempel-Zev code derived from compress 4.0.
XModified to support Squashing by Dan Lanciani (ddl@harvard.edu)
XPorted from MSDOS by Howard Chu (umix!hyc),
Xwith help from John Gilmore (hoptoad!gnu), James Turner (daisy!turner)
Xand others.
________This_Is_The_END________
if test `wc -c < arc.1` -ne     7232; then
	echo 'shar: arc.1 was damaged during transit (should have been     7232 bytes)'
fi
fi		; : end of overwriting check
exit 0


