#ifdef COHERENT
#define _SUPPRESS_BSD_DEFINITIONS 1
#endif

# include "stdio.h"

static int start_cond = 0;
#define BEGIN start_cond =
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
# define Z 2
/* dtimep.lex - routines to do ``ARPA-style'' time parsing

ver  date   who remarks
--- ------- --- -------------------------------------------------------------
01B 15nov86 JP  Thouroughly hacked by Jef Poskanzer.
01A ??????? MTR Original version from the MH 6.5 distribution, courtesy
	          of Marshall Rose.

*/

#include "tws.h"
#include <ctype.h>
#include <sys/types.h>
#include <time.h>
#ifdef SYS5
#include <string.h>
#else SYS5
#include <strings.h>
#include <sys/timeb.h>
#endif SYS5

#ifdef SYS5
extern int  daylight;
extern long timezone;
extern char *tzname[];
#endif SYS5

/*
 * Table to convert month names to numeric month.  We use the
 * fact that the low order 5 bits of the sum of the 2nd & 3rd
 * characters of the name is a hash with no collisions for the 12
 * valid month names.  (The mask to 5 bits maps any combination of
 * upper and lower case into the same hash value).
 */
static int month_map[] = {
	0,
	6,	/* 1 - Jul */
	3,	/* 2 - Apr */
	5,	/* 3 - Jun */
	0,
	10,	/* 5 - Nov */
	0,
	1,	/* 7 - Feb */
	11,	/* 8 - Dec */
	0,
	0,
	0,
	0,
	0,
	0,
	0,	/*15 - Jan */
	0,
	0,
	0,
	2,	/*19 - Mar */
	0,
	8,	/*21 - Sep */
	0,
	9,	/*23 - Oct */
	0,
	0,
	4,	/*26 - May */
	0,
	7 };	/*28 - Aug */
/*
 * Same trick for day-of-week using the hash function
 *  (c1 & 7) + (c2 & 4)
 */
static int day_map[] = {
	0,
	0,
	0,
	6,	/* 3 - Sat */
	4,	/* 4 - Thu */
	0,
	5,	/* 6 - Fri */
	0,	/* 7 - Sun */
	2,	/* 8 - Tue */
	1	/* 9 - Mon */,
	0,
	3 };	/*11 - Wed */
#define SETDAY tw.tw_wday= day_map[(cp[0] & 7) + (cp[1] & 4)];\
		tw.tw_flags |= TW_SEXP;\
		cp += 2;
#define SETMONTH tw.tw_mon = month_map[(cp[0] + cp[1]) & 0x1f]; gotdate++;\
		 cp += 2;\
		 SKIPD;
#define CVT1OR2 (i=(*cp++ - '0'), isdigit(*cp)? i*10 + (*cp++ - '0') : i)
#define CVT2 ( (*cp++ - '0')*10 + (*cp++ - '0') )
#define CVT3 ( ( (*cp++ - '0')*10 + (*cp++ - '0') )*10 + (*cp++ - '0') )
#define CVT4 ( ( ( (*cp++ - '0')*10 + (*cp++ - '0') )*10 + (*cp++ - '0') )*10 + (*cp++ - '0') )
#define SKIPD while ( ! isdigit( *cp++ ) ) ; --cp;
#define ZONE(x) tw.tw_zone=(x);
#define ZONED(x) tw.tw_zone=(x); tw.tw_flags |= TW_DST;
#define LC(c) (isupper( c ) ? tolower( c ) : ( c ))
struct tws *
dparsetime( str )
char *str;
    {
    register int i;
    static struct tws tw;
    register char *cp;
    register int gotdate = 0;
#ifndef SYS5
    struct timeb	tb;
#endif not SYS5
    long clock;

    start_cond = 0;

    /* Zero out the struct. */
    bzero( (char *) &tw, sizeof tw );

    /* Set default time zone. */
#ifndef SYS5
    ftime( &tb );
    tw.tw_zone = -tb.timezone;
#else SYS5
    tzset( );
    tw.tw_zone = -(timezone / 60);
#endif SYS5

    for ( ; ; )
	switch ( cp = str, lex_string( &str, start_cond ) )
	    {
	    case -1:
		if ( ! gotdate )
			return ( NULL );
		tw.tw_flags |= TW_JUNK;
		/* fall through */
	    case 0:
		if ( tw.tw_year == 0 )
		    {
		    /* Set default year. */
		    time( &clock );
		    tw.tw_year = localtime( &clock ) -> tm_year;
		    }
		return ( &tw );

case 1:
			SETDAY;
break;
case 2:
		cp++, SETDAY;
break;
case 3:
{
#ifdef EUROPE
					tw.tw_mday = CVT1OR2; cp++;
					tw.tw_mon  = CVT1OR2 - 1; cp++;
#else EUROPE
					tw.tw_mon = CVT1OR2 - 1; cp++;
					tw.tw_mday  = CVT1OR2; cp++;
#endif EUROPE
					for ( i = 0; isdigit( *cp ); )
						i = i * 10 + (*cp++ - '0');
					tw.tw_year = i;
					gotdate++;
					}
break;
case 4:
		{
#ifdef EUROPE
					tw.tw_mday = CVT1OR2; cp++;
					tw.tw_mon  = CVT1OR2 - 1;
#else EUROPE
					tw.tw_mon = CVT1OR2 - 1; cp++;
					tw.tw_mday  = CVT1OR2;
#endif EUROPE
					gotdate++;
					}
break;
case 5:
{
					tw.tw_mday = CVT1OR2;
					while ( ! isalpha( *cp++ ) )
						;
					SETMONTH;
					for ( i = 0; isdigit( *cp ); )
						i = i * 10 + (*cp++ - '0');
					tw.tw_year = i;
					gotdate++;
					}
break;
case 6:
	{
					tw.tw_mday = CVT1OR2;
					while ( ! isalpha( *cp++ ) )
						;
					SETMONTH;
					gotdate++;
					}
break;
case 7:
{
					cp++;
					SETMONTH;
					tw.tw_mday = CVT1OR2;
					SKIPD;
					for ( i = 0; isdigit( *cp ); )
						i = i * 10 + (*cp++ - '0');
					tw.tw_year = i;
					gotdate++;
					}
break;
case 8:
		{
					cp++;
					SETMONTH;
					tw.tw_mday = CVT1OR2;
					gotdate++;
					}
break;
case 9:
		{
					tw.tw_hour = CVT1OR2; cp++;
					tw.tw_min  = CVT1OR2; cp++;
					tw.tw_sec  = CVT1OR2;
					BEGIN Z;
					}
break;
case 10:
		{
					tw.tw_hour = CVT1OR2 + 12; cp++;
					tw.tw_min  = CVT1OR2; cp++;
					tw.tw_sec  = CVT1OR2;
					BEGIN Z;
					}
break;
case 11:
		{
					tw.tw_hour = CVT1OR2; cp++;
					tw.tw_min  = CVT1OR2;
					BEGIN Z;
					}
break;
case 12:
			{
					tw.tw_hour = CVT1OR2 + 12; cp++;
					tw.tw_min  = CVT1OR2;
					BEGIN Z;
					}
break;
case 13:
		{
					tw.tw_hour = CVT1OR2;
					tw.tw_min  = CVT1OR2;
					tw.tw_sec  = CVT1OR2;
					BEGIN Z;
					}
break;
case 14:
		{
					tw.tw_hour = CVT1OR2;
					tw.tw_min  = CVT1OR2;
					BEGIN Z;
					}
break;
case 15:
			ZONE(0 * 60);
break;
case 16:
			ZONE(0 * 60);
break;
case 17:
			ZONE(2 * 60);
break;
case 18:
			ZONED(2 * 60);
break;
case 19:
			ZONE(-5 * 60);
break;
case 20:
			ZONED(-5 * 60);
break;
case 21:
			ZONE(-6 * 60);
break;
case 22:
			ZONED(-6 * 60);
break;
case 23:
			ZONE(-7 * 60);
break;
case 24:
			ZONED(-7 * 60);
break;
case 25:
			ZONE(-8 * 60);
break;
case 26:
			ZONED(-8 * 60);
break;
case 27:
			ZONE(-(3 * 60 + 30));
break;
case 28:
			ZONE(-4 * 60);
break;
case 29:
			ZONED(-4 * 60);
break;
case 30:
			ZONE(-9 * 60);
break;
case 31:
			ZONED(-9 * 60);
break;
case 32:
			ZONE(-10 * 60);
break;
case 33:
			ZONED(-10 * 60);
break;
case 34:
			ZONED(-1 * 60);
break;
case 35:
			tw.tw_zone = 60 * (('a'-1) - LC (*cp));
break;
case 36:
			tw.tw_zone = 60 * ('a' - LC (*cp));
break;
case 37:
			tw.tw_zone = 60 * (LC (*cp) - 'm');
break;
case 38:
		{
					cp++;
					tw.tw_zone = ((cp[0] * 10 + cp[1])
						     -('0' * 10   + '0'))*60
						    +((cp[2] * 10 + cp[3])
						     -('0' * 10   + '0'));
#ifdef DSTXXX
					zonehack (&tw);
#endif DSTXXX
					cp += 4;
					}
break;
case 39:
		{
					cp++;
					tw.tw_zone = (('0' * 10   + '0')
						     -(cp[0] * 10 + cp[1]))*60
						    +(('0' * 10   + '0')
						     -(cp[2] * 10 + cp[3]));
#ifdef DSTXXX
					zonehack (&tw);
#endif DSTXXX
					cp += 4;
					}
break;
case 40:
		{
					SKIPD;
					tw.tw_year = CVT4;
					}
break;
case 41:
case 42:
;
break;
default: return(0);
} return(0); }
/* end of yylex */

#ifdef DSTXXX
static
zonehack( tw )
register struct tws *tw;
    {
    register struct tm *tm;

    if ( twclock( tw ) == -1L )
	return;

    tm = localtime( &tw -> tw_clock );
    if ( tm -> tm_isdst )
	{
	tw -> tw_flags |= TW_DST;
	tw -> tw_zone -= 60;
	}
    }
#endif DSTXXX


#ifdef SYS5
/* Not all SYS5's have bzero( ). */
bzero( b, length )
char *b;
int length;
    {
    while ( length-- > 0 )
	*b++ = 0;
    }
#endif
int yyvstop[] = {
0,

42,
0,

41,
0,

42,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

35,
0,

36,
0,

36,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

37,
0,

15,
0,

4,
0,

4,
0,

11,
0,

1,
0,

1,
0,

1,
0,

1,
0,

1,
0,

1,
0,

1,
0,

29,
0,

28,
0,

34,
0,

22,
0,

21,
0,

20,
0,

19,
0,

16,
0,

33,
0,

32,
0,

18,
0,

17,
0,

24,
0,

23,
0,

27,
0,

26,
0,

25,
0,

31,
0,

30,
0,

4,
0,

4,
0,

4,
0,

14,
0,

11,
0,

11,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

1,
0,

2,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

6,
0,

14,
0,

9,
0,

11,
0,

12,
0,

6,
0,

8,
0,

40,
0,

38,
0,

39,
0,

2,
0,

3,
0,

13,
0,

9,
0,

5,
0,

8,
0,

8,
0,

1,
0,

3,
0,

3,
0,

9,
0,

10,
0,

6,
0,

5,
0,

5,
0,

5,
0,

5,
0,

7,
0,

7,
0,

7,
0,
0};
# define YYTYPE int
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,5,	1,6,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	1,5,	0,0,	0,0,	
3,20,	3,6,	5,5,	0,0,	
0,0,	1,7,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	1,8,	1,8,	1,8,	
1,9,	1,9,	1,9,	1,9,	
1,9,	1,9,	1,9,	3,20,	
0,0,	5,5,	0,0,	0,0,	
0,0,	0,0,	0,0,	3,7,	
0,0,	0,0,	3,21,	0,0,	
3,22,	0,0,	0,0,	3,8,	
3,8,	3,8,	3,9,	3,9,	
3,9,	3,9,	3,9,	3,9,	
3,9,	9,62,	9,62,	9,62,	
9,62,	9,62,	9,62,	9,62,	
9,62,	9,62,	9,62,	21,81,	
21,81,	0,0,	1,10,	0,0,	
0,0,	1,11,	0,0,	1,12,	
0,0,	0,0,	0,0,	1,13,	
0,0,	0,0,	1,14,	1,15,	
1,16,	0,0,	0,0,	0,0,	
1,17,	1,18,	0,0,	0,0,	
1,19,	0,0,	0,0,	0,0,	
3,23,	3,24,	3,25,	3,26,	
3,27,	3,28,	3,29,	3,30,	
3,31,	3,32,	3,33,	3,33,	
3,34,	3,35,	3,36,	3,37,	
3,38,	3,38,	3,39,	3,40,	
3,41,	3,38,	3,42,	3,38,	
3,43,	7,44,	10,63,	11,65,	
8,49,	15,72,	16,73,	10,64,	
7,45,	19,79,	24,97,	29,102,	
13,68,	41,112,	7,46,	7,47,	
20,20,	8,50,	7,48,	8,51,	
8,52,	8,52,	8,52,	8,52,	
8,52,	8,52,	8,52,	8,52,	
8,52,	8,52,	8,53,	12,66,	
13,69,	14,70,	17,74,	18,77,	
25,98,	27,100,	17,75,	20,20,	
22,82,	22,82,	35,72,	44,115,	
12,67,	45,116,	35,109,	14,71,	
18,78,	48,121,	55,144,	25,99,	
27,101,	23,95,	17,76,	20,80,	
20,80,	20,80,	20,80,	20,80,	
20,80,	20,80,	20,80,	20,80,	
20,80,	23,63,	47,119,	56,145,	
23,96,	8,54,	23,64,	30,103,	
8,55,	58,148,	8,56,	59,149,	
60,150,	37,110,	8,57,	47,120,	
46,117,	8,58,	8,59,	8,60,	
43,113,	32,68,	30,104,	8,61,	
32,105,	22,83,	22,84,	22,85,	
37,111,	22,86,	34,70,	22,87,	
22,88,	34,107,	22,89,	43,114,	
46,118,	22,90,	22,91,	32,106,	
22,92,	32,69,	57,146,	61,151,	
34,71,	22,93,	54,142,	49,122,	
34,108,	22,94,	49,123,	54,143,	
49,124,	63,152,	64,153,	65,154,	
49,125,	66,155,	67,156,	49,126,	
49,127,	49,128,	57,147,	68,157,	
71,162,	49,129,	50,130,	50,130,	
50,130,	50,130,	50,130,	50,130,	
50,130,	50,130,	50,130,	50,130,	
51,139,	51,139,	51,139,	51,139,	
51,139,	51,139,	51,139,	51,139,	
51,139,	51,139,	52,140,	52,140,	
52,140,	52,140,	52,140,	52,140,	
52,140,	52,140,	52,140,	52,140,	
53,141,	53,141,	53,141,	53,141,	
53,141,	53,141,	53,141,	53,141,	
53,141,	53,141,	62,49,	69,158,	
72,163,	69,159,	70,160,	73,164,	
74,165,	75,166,	76,167,	50,131,	
77,168,	70,161,	50,132,	62,50,	
50,133,	62,51,	78,169,	79,170,	
50,134,	91,109,	95,174,	50,135,	
50,136,	50,137,	96,175,	97,176,	
62,53,	50,138,	80,171,	80,171,	
80,171,	80,171,	80,171,	80,171,	
80,171,	80,171,	80,171,	80,171,	
81,172,	81,172,	81,172,	81,172,	
81,172,	81,172,	81,172,	81,172,	
81,172,	81,172,	82,173,	82,173,	
82,173,	82,173,	82,173,	82,173,	
82,173,	82,173,	82,173,	82,173,	
83,95,	98,177,	89,105,	90,107,	
99,178,	100,179,	101,180,	62,54,	
102,181,	103,182,	62,55,	104,183,	
62,56,	105,184,	106,185,	83,96,	
62,57,	89,106,	90,108,	62,58,	
62,59,	62,60,	107,186,	108,187,	
109,188,	62,61,	110,189,	111,190,	
113,191,	114,192,	115,193,	116,194,	
117,195,	118,196,	119,197,	120,198,	
121,199,	122,200,	123,202,	124,203,	
125,204,	126,206,	122,201,	127,207,	
128,208,	129,209,	130,210,	131,213,	
132,215,	133,216,	134,217,	135,219,	
131,214,	136,220,	137,221,	138,222,	
142,230,	139,210,	143,231,	144,232,	
125,205,	145,233,	146,234,	147,235,	
148,237,	147,236,	149,239,	150,240,	
151,241,	130,210,	134,218,	148,238,	
157,249,	159,161,	162,251,	163,252,	
164,253,	166,255,	167,256,	193,263,	
139,210,	194,265,	130,211,	196,267,	
199,263,	130,212,	130,212,	130,212,	
130,212,	130,212,	130,212,	130,212,	
130,212,	130,212,	130,212,	139,211,	
139,223,	139,223,	139,223,	139,223,	
139,223,	139,223,	139,223,	139,223,	
139,223,	139,223,	140,224,	140,224,	
140,224,	140,224,	140,224,	140,224,	
140,224,	140,224,	140,224,	140,224,	
141,225,	152,242,	153,242,	154,242,	
155,242,	158,242,	160,242,	161,242,	
195,263,	197,263,	200,271,	198,263,	
201,272,	202,273,	203,274,	156,247,	
204,275,	205,276,	207,280,	205,277,	
208,281,	209,282,	193,264,	141,225,	
152,242,	153,242,	154,242,	155,242,	
158,242,	160,242,	161,242,	165,247,	
168,247,	170,247,	169,247,	212,211,	
210,210,	199,270,	156,247,	141,226,	
141,226,	141,226,	141,226,	141,226,	
141,226,	141,226,	141,226,	141,226,	
141,226,	141,227,	156,247,	206,278,	
213,284,	214,285,	165,247,	168,247,	
170,247,	169,247,	206,279,	210,210,	
215,286,	216,287,	217,288,	218,289,	
220,293,	218,290,	165,247,	168,247,	
170,247,	169,247,	171,260,	171,260,	
171,260,	171,260,	171,260,	171,260,	
171,260,	171,260,	171,260,	171,260,	
219,291,	221,294,	197,268,	222,295,	
195,266,	198,269,	223,211,	219,292,	
141,228,	226,227,	228,299,	229,300,	
234,307,	236,238,	239,309,	154,245,	
160,250,	152,243,	240,310,	241,311,	
243,161,	244,313,	245,314,	141,229,	
246,315,	225,225,	156,248,	247,247,	
248,316,	155,246,	153,244,	249,317,	
250,161,	251,318,	252,319,	253,320,	
254,321,	158,161,	172,261,	172,261,	
172,261,	172,261,	172,261,	172,261,	
172,261,	172,261,	172,261,	172,261,	
225,225,	255,322,	247,247,	256,323,	
257,324,	258,325,	170,259,	259,326,	
263,330,	168,257,	224,296,	165,254,	
169,258,	173,262,	173,262,	173,262,	
173,262,	173,262,	173,262,	173,262,	
173,262,	173,262,	173,262,	211,283,	
211,283,	211,283,	211,283,	211,283,	
211,283,	211,283,	211,283,	211,283,	
211,283,	224,296,	227,298,	227,298,	
227,298,	227,298,	227,298,	227,298,	
227,298,	227,298,	227,298,	227,298,	
230,301,	264,331,	265,332,	266,333,	
267,334,	224,297,	224,297,	224,297,	
224,297,	224,297,	224,297,	224,297,	
224,297,	224,297,	224,297,	231,301,	
268,335,	269,336,	270,337,	271,338,	
273,338,	225,228,	275,343,	230,301,	
277,279,	279,338,	232,301,	278,338,	
276,338,	272,338,	280,345,	288,353,	
290,292,	274,338,	293,355,	282,338,	
225,229,	294,356,	231,301,	230,302,	
230,302,	230,302,	230,302,	230,302,	
230,302,	230,302,	230,302,	230,302,	
230,302,	232,301,	295,357,	303,238,	
304,364,	305,365,	231,302,	231,302,	
231,302,	231,302,	231,302,	231,302,	
231,302,	231,302,	231,302,	231,302,	
233,301,	232,302,	232,302,	232,302,	
232,302,	232,302,	232,302,	232,302,	
232,302,	232,302,	232,302,	260,327,	
260,327,	260,327,	260,327,	260,327,	
260,327,	260,327,	260,327,	260,327,	
260,327,	306,366,	281,338,	233,301,	
307,367,	273,341,	235,301,	308,238,	
271,339,	309,368,	278,344,	310,369,	
230,303,	296,296,	299,299,	300,300,	
311,370,	237,301,	301,301,	233,302,	
233,302,	233,302,	233,302,	233,302,	
233,302,	233,302,	233,302,	233,302,	
233,302,	235,301,	272,340,	274,342,	
238,301,	276,279,	232,305,	282,347,	
296,296,	299,299,	300,300,	231,304,	
237,301,	301,301,	313,161,	314,374,	
315,375,	235,302,	235,302,	235,302,	
235,302,	235,302,	235,302,	235,302,	
235,302,	235,302,	235,302,	238,301,	
237,302,	237,302,	237,302,	237,302,	
237,302,	237,302,	237,302,	237,302,	
237,302,	237,302,	316,376,	284,301,	
285,301,	242,242,	317,377,	238,302,	
238,302,	238,302,	238,302,	238,302,	
238,302,	238,302,	238,302,	238,302,	
238,302,	281,346,	319,378,	320,379,	
321,380,	233,306,	322,381,	324,382,	
325,383,	326,384,	284,301,	285,301,	
242,242,	261,328,	261,328,	261,328,	
261,328,	261,328,	261,328,	261,328,	
261,328,	261,328,	261,328,	284,338,	
285,338,	331,385,	301,362,	237,308,	
242,312,	242,312,	242,312,	242,312,	
242,312,	242,312,	242,312,	242,312,	
242,312,	242,312,	235,238,	262,329,	
262,329,	262,329,	262,329,	262,329,	
262,329,	262,329,	262,329,	262,329,	
262,329,	283,348,	283,348,	283,348,	
283,348,	283,348,	283,348,	283,348,	
283,348,	283,348,	283,348,	286,301,	
333,386,	287,301,	289,301,	291,301,	
292,301,	297,358,	297,358,	297,358,	
297,358,	297,358,	297,358,	297,358,	
297,358,	297,358,	297,358,	335,387,	
336,388,	337,389,	339,279,	298,359,	
340,390,	341,391,	286,301,	284,349,	
287,301,	289,301,	291,301,	292,301,	
342,392,	343,393,	344,279,	345,394,	
346,395,	312,371,	347,396,	286,338,	
285,350,	287,338,	289,338,	291,338,	
292,338,	349,292,	298,359,	302,363,	
302,363,	302,363,	302,363,	302,363,	
302,363,	302,363,	302,363,	302,363,	
302,363,	350,399,	351,400,	352,401,	
312,371,	353,402,	298,359,	298,359,	
298,359,	298,359,	298,359,	298,359,	
298,359,	298,359,	298,359,	298,359,	
312,372,	354,292,	355,403,	356,404,	
312,373,	312,373,	312,373,	312,373,	
312,373,	312,373,	312,373,	312,373,	
312,373,	312,373,	357,405,	360,406,	
361,407,	348,397,	358,358,	359,359,	
362,408,	364,238,	365,411,	286,351,	
366,412,	291,354,	338,302,	338,302,	
338,302,	338,302,	338,302,	338,302,	
338,302,	338,302,	338,302,	338,302,	
367,413,	368,414,	287,352,	298,360,	
348,397,	358,358,	359,359,	363,409,	
369,415,	370,416,	289,292,	371,371,	
372,417,	373,372,	374,418,	375,419,	
376,247,	377,161,	298,361,	378,420,	
348,398,	348,398,	348,398,	348,398,	
348,398,	348,398,	348,398,	348,398,	
348,398,	348,398,	363,409,	379,161,	
380,421,	381,422,	371,371,	372,417,	
382,423,	384,424,	385,263,	386,425,	
387,426,	389,427,	390,279,	391,428,	
392,429,	393,430,	363,410,	363,410,	
363,410,	363,410,	363,410,	363,410,	
363,410,	363,410,	363,410,	363,410,	
394,431,	395,432,	396,433,	397,397,	
398,397,	398,397,	398,397,	398,397,	
398,397,	398,397,	398,397,	398,397,	
398,397,	398,397,	399,292,	359,360,	
400,434,	401,435,	402,436,	403,437,	
404,438,	405,439,	406,406,	407,407,	
408,408,	409,409,	397,397,	411,442,	
412,443,	413,238,	359,361,	410,441,	
410,441,	410,441,	410,441,	410,441,	
410,441,	410,441,	410,441,	410,441,	
410,441,	414,444,	415,238,	416,445,	
417,417,	406,406,	407,407,	408,408,	
409,409,	422,447,	424,448,	427,449,	
428,450,	429,451,	430,279,	431,452,	
432,279,	433,453,	434,454,	435,455,	
436,292,	437,456,	438,292,	439,457,	
440,458,	445,459,	453,461,	417,417,	
457,462,	0,0,	441,409,	446,460,	
446,460,	446,460,	446,460,	446,460,	
446,460,	446,460,	446,460,	446,460,	
446,460,	458,458,	460,463,	417,446,	
417,446,	417,446,	417,446,	417,446,	
417,446,	417,446,	417,446,	417,446,	
417,446,	441,409,	463,463,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
458,458,	460,463,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	409,440,	0,0,	0,0,	
0,0,	463,463,	0,0,	0,0,	
0,0,	460,464,	460,464,	460,464,	
460,464,	460,464,	460,464,	460,464,	
460,464,	460,464,	460,464,	464,463,	
464,463,	464,463,	464,463,	464,463,	
464,463,	464,463,	464,463,	464,463,	
464,463,	0,0,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+1,	0,		0,	
yycrank+0,	yysvec+1,	0,	
yycrank+27,	0,		0,	
yycrank+0,	yysvec+3,	0,	
yycrank+29,	0,		yyvstop+1,
yycrank+0,	0,		yyvstop+3,
yycrank+47,	0,		0,	
yycrank+120,	0,		0,	
yycrank+37,	yysvec+8,	0,	
yycrank+38,	0,		0,	
yycrank+50,	0,		0,	
yycrank+78,	0,		0,	
yycrank+63,	0,		0,	
yycrank+84,	0,		0,	
yycrank+42,	0,		0,	
yycrank+55,	0,		0,	
yycrank+85,	0,		0,	
yycrank+79,	0,		0,	
yycrank+56,	0,		0,	
yycrank+155,	0,		yyvstop+5,
yycrank+47,	0,		0,	
yycrank+140,	0,		0,	
yycrank+101,	0,		yyvstop+7,
yycrank+43,	0,		yyvstop+9,
yycrank+84,	0,		yyvstop+11,
yycrank+0,	yysvec+11,	yyvstop+13,
yycrank+85,	0,		yyvstop+15,
yycrank+0,	yysvec+12,	yyvstop+17,
yycrank+50,	0,		yyvstop+19,
yycrank+119,	0,		yyvstop+21,
yycrank+0,	0,		yyvstop+23,
yycrank+136,	0,		0,	
yycrank+0,	0,		yyvstop+25,
yycrank+145,	0,		yyvstop+27,
yycrank+79,	0,		yyvstop+29,
yycrank+0,	yysvec+16,	yyvstop+31,
yycrank+125,	0,		yyvstop+33,
yycrank+0,	0,		yyvstop+35,
yycrank+0,	yysvec+17,	yyvstop+37,
yycrank+0,	yysvec+18,	yyvstop+39,
yycrank+45,	0,		yyvstop+41,
yycrank+0,	yysvec+19,	yyvstop+43,
yycrank+132,	0,		yyvstop+45,
yycrank+77,	0,		0,	
yycrank+82,	0,		0,	
yycrank+131,	0,		0,	
yycrank+110,	0,		0,	
yycrank+96,	0,		0,	
yycrank+162,	0,		0,	
yycrank+230,	0,		0,	
yycrank+240,	0,		0,	
yycrank+250,	yysvec+8,	0,	
yycrank+260,	0,		0,	
yycrank+146,	0,		0,	
yycrank+97,	0,		0,	
yycrank+114,	0,		0,	
yycrank+157,	0,		0,	
yycrank+124,	0,		0,	
yycrank+112,	0,		0,	
yycrank+125,	0,		0,	
yycrank+154,	0,		0,	
yycrank+286,	0,		0,	
yycrank+151,	0,		0,	
yycrank+163,	0,		0,	
yycrank+168,	0,		0,	
yycrank+171,	0,		0,	
yycrank+165,	0,		0,	
yycrank+165,	0,		0,	
yycrank+211,	0,		0,	
yycrank+208,	0,		0,	
yycrank+166,	0,		0,	
yycrank+202,	0,		0,	
yycrank+207,	0,		0,	
yycrank+208,	0,		0,	
yycrank+213,	0,		0,	
yycrank+216,	0,		0,	
yycrank+211,	0,		0,	
yycrank+233,	0,		0,	
yycrank+235,	0,		0,	
yycrank+298,	0,		0,	
yycrank+308,	0,		0,	
yycrank+318,	0,		0,	
yycrank+276,	0,		0,	
yycrank+0,	yysvec+24,	0,	
yycrank+0,	yysvec+25,	0,	
yycrank+0,	yysvec+27,	0,	
yycrank+0,	yysvec+29,	0,	
yycrank+0,	yysvec+30,	0,	
yycrank+278,	0,		0,	
yycrank+279,	0,		0,	
yycrank+222,	0,		0,	
yycrank+0,	yysvec+37,	0,	
yycrank+0,	yysvec+41,	0,	
yycrank+0,	yysvec+43,	0,	
yycrank+222,	0,		0,	
yycrank+226,	0,		0,	
yycrank+227,	0,		0,	
yycrank+261,	0,		0,	
yycrank+264,	0,		0,	
yycrank+265,	0,		0,	
yycrank+266,	0,		0,	
yycrank+268,	0,		0,	
yycrank+269,	0,		0,	
yycrank+271,	0,		0,	
yycrank+273,	0,		0,	
yycrank+274,	0,		0,	
yycrank+282,	0,		0,	
yycrank+283,	0,		0,	
yycrank+284,	0,		0,	
yycrank+286,	0,		0,	
yycrank+287,	0,		0,	
yycrank+0,	0,		yyvstop+47,
yycrank+288,	0,		0,	
yycrank+289,	0,		0,	
yycrank+301,	0,		0,	
yycrank+297,	0,		0,	
yycrank+292,	0,		0,	
yycrank+299,	0,		0,	
yycrank+293,	0,		0,	
yycrank+310,	0,		0,	
yycrank+312,	0,		0,	
yycrank+301,	0,		0,	
yycrank+313,	0,		0,	
yycrank+314,	0,		0,	
yycrank+319,	0,		0,	
yycrank+320,	0,		0,	
yycrank+308,	0,		0,	
yycrank+321,	0,		0,	
yycrank+320,	0,		0,	
yycrank+413,	0,		yyvstop+49,
yycrank+311,	0,		0,	
yycrank+323,	0,		0,	
yycrank+324,	0,		0,	
yycrank+329,	0,		0,	
yycrank+330,	0,		0,	
yycrank+318,	0,		0,	
yycrank+331,	0,		0,	
yycrank+330,	0,		0,	
yycrank+424,	0,		yyvstop+51,
yycrank+434,	0,		0,	
yycrank+483,	0,		yyvstop+53,
yycrank+318,	0,		0,	
yycrank+331,	0,		0,	
yycrank+336,	0,		0,	
yycrank+339,	0,		0,	
yycrank+328,	0,		0,	
yycrank+331,	0,		0,	
yycrank+326,	0,		0,	
yycrank+324,	0,		0,	
yycrank+327,	0,		0,	
yycrank+332,	0,		0,	
yycrank+484,	0,		0,	
yycrank+485,	0,		0,	
yycrank+486,	0,		0,	
yycrank+487,	0,		0,	
yycrank+498,	0,		yyvstop+55,
yycrank+331,	yysvec+153,	0,	
yycrank+488,	0,		0,	
yycrank+348,	yysvec+154,	0,	
yycrank+489,	0,		0,	
yycrank+490,	0,		0,	
yycrank+350,	yysvec+156,	yyvstop+57,
yycrank+350,	yysvec+154,	0,	
yycrank+341,	yysvec+161,	0,	
yycrank+514,	0,		yyvstop+59,
yycrank+337,	yysvec+161,	0,	
yycrank+354,	yysvec+156,	yyvstop+61,
yycrank+515,	0,		yyvstop+63,
yycrank+517,	0,		yyvstop+65,
yycrank+516,	0,		yyvstop+67,
yycrank+514,	0,		0,	
yycrank+562,	0,		0,	
yycrank+585,	0,		0,	
yycrank+0,	0,		yyvstop+69,
yycrank+0,	0,		yyvstop+71,
yycrank+0,	0,		yyvstop+73,
yycrank+0,	0,		yyvstop+75,
yycrank+0,	0,		yyvstop+77,
yycrank+0,	0,		yyvstop+79,
yycrank+0,	0,		yyvstop+81,
yycrank+0,	0,		yyvstop+83,
yycrank+0,	0,		yyvstop+85,
yycrank+0,	0,		yyvstop+87,
yycrank+0,	0,		yyvstop+89,
yycrank+0,	0,		yyvstop+91,
yycrank+0,	0,		yyvstop+93,
yycrank+0,	0,		yyvstop+95,
yycrank+0,	0,		yyvstop+97,
yycrank+0,	0,		yyvstop+99,
yycrank+0,	0,		yyvstop+101,
yycrank+0,	0,		yyvstop+103,
yycrank+0,	0,		yyvstop+105,
yycrank+414,	0,		0,	
yycrank+357,	yysvec+193,	0,	
yycrank+459,	0,		0,	
yycrank+359,	yysvec+193,	0,	
yycrank+460,	0,		0,	
yycrank+462,	0,		0,	
yycrank+419,	0,		0,	
yycrank+388,	0,		0,	
yycrank+401,	0,		0,	
yycrank+406,	0,		0,	
yycrank+408,	0,		0,	
yycrank+398,	0,		0,	
yycrank+401,	0,		0,	
yycrank+429,	0,		0,	
yycrank+392,	0,		0,	
yycrank+396,	0,		0,	
yycrank+401,	0,		0,	
yycrank+519,	0,		yyvstop+107,
yycrank+595,	0,		0,	
yycrank+482,	yysvec+210,	yyvstop+109,
yycrank+430,	0,		0,	
yycrank+442,	0,		0,	
yycrank+453,	0,		0,	
yycrank+455,	0,		0,	
yycrank+444,	0,		0,	
yycrank+447,	0,		0,	
yycrank+458,	0,		0,	
yycrank+438,	0,		0,	
yycrank+457,	0,		0,	
yycrank+463,	0,		0,	
yycrank+531,	yysvec+210,	yyvstop+111,
yycrank+621,	0,		yyvstop+113,
yycrank+588,	0,		yyvstop+115,
yycrank+523,	yysvec+225,	yyvstop+117,
yycrank+606,	0,		0,	
yycrank+473,	0,		0,	
yycrank+474,	0,		0,	
yycrank+655,	0,		yyvstop+119,
yycrank+670,	0,		yyvstop+121,
yycrank+681,	0,		yyvstop+123,
yycrank+719,	0,		yyvstop+125,
yycrank+467,	yysvec+231,	yyvstop+127,
yycrank+745,	0,		yyvstop+129,
yycrank+484,	yysvec+232,	yyvstop+131,
yycrank+756,	0,		yyvstop+133,
yycrank+771,	0,		yyvstop+135,
yycrank+485,	yysvec+232,	yyvstop+137,
yycrank+479,	yysvec+238,	yyvstop+139,
yycrank+475,	yysvec+238,	yyvstop+141,
yycrank+808,	0,		0,	
yycrank+484,	0,		0,	
yycrank+478,	0,		0,	
yycrank+485,	0,		0,	
yycrank+479,	0,		0,	
yycrank+590,	0,		yyvstop+143,
yycrank+503,	0,		0,	
yycrank+506,	0,		0,	
yycrank+500,	0,		0,	
yycrank+508,	0,		0,	
yycrank+497,	0,		0,	
yycrank+509,	0,		0,	
yycrank+494,	0,		0,	
yycrank+520,	0,		0,	
yycrank+526,	0,		0,	
yycrank+509,	0,		0,	
yycrank+525,	0,		0,	
yycrank+526,	0,		0,	
yycrank+691,	0,		0,	
yycrank+793,	0,		0,	
yycrank+819,	0,		0,	
yycrank+584,	0,		yyvstop+145,
yycrank+568,	0,		0,	
yycrank+569,	0,		0,	
yycrank+553,	0,		0,	
yycrank+571,	0,		0,	
yycrank+565,	0,		0,	
yycrank+581,	0,		0,	
yycrank+581,	0,		0,	
yycrank+651,	0,		0,	
yycrank+661,	0,		0,	
yycrank+652,	0,		0,	
yycrank+665,	0,		0,	
yycrank+569,	yysvec+272,	0,	
yycrank+660,	0,		0,	
yycrank+587,	yysvec+273,	0,	
yycrank+659,	0,		0,	
yycrank+657,	0,		0,	
yycrank+593,	yysvec+273,	0,	
yycrank+718,	0,		0,	
yycrank+667,	0,		0,	
yycrank+829,	0,		0,	
yycrank+806,	0,		yyvstop+147,
yycrank+807,	0,		yyvstop+149,
yycrank+878,	0,		yyvstop+151,
yycrank+880,	0,		yyvstop+153,
yycrank+578,	yysvec+285,	yyvstop+155,
yycrank+881,	0,		yyvstop+157,
yycrank+595,	yysvec+286,	yyvstop+159,
yycrank+882,	0,		yyvstop+161,
yycrank+883,	0,		yyvstop+163,
yycrank+597,	yysvec+286,	yyvstop+165,
yycrank+590,	yysvec+292,	yyvstop+167,
yycrank+598,	yysvec+292,	yyvstop+169,
yycrank+752,	0,		yyvstop+171,
yycrank+845,	0,		0,	
yycrank+898,	0,		yyvstop+173,
yycrank+753,	0,		yyvstop+175,
yycrank+754,	0,		yyvstop+177,
yycrank+757,	0,		yyvstop+179,
yycrank+883,	0,		0,	
yycrank+607,	0,		0,	
yycrank+601,	0,		0,	
yycrank+608,	0,		0,	
yycrank+632,	0,		0,	
yycrank+655,	0,		0,	
yycrank+651,	0,		0,	
yycrank+648,	0,		0,	
yycrank+661,	0,		0,	
yycrank+663,	0,		0,	
yycrank+912,	0,		yyvstop+181,
yycrank+674,	0,		0,	
yycrank+693,	0,		0,	
yycrank+695,	0,		0,	
yycrank+693,	0,		0,	
yycrank+704,	0,		0,	
yycrank+0,	yysvec+316,	0,	
yycrank+732,	0,		0,	
yycrank+730,	0,		0,	
yycrank+732,	0,		0,	
yycrank+725,	0,		0,	
yycrank+0,	yysvec+316,	0,	
yycrank+735,	0,		0,	
yycrank+739,	0,		0,	
yycrank+722,	0,		0,	
yycrank+0,	0,		yyvstop+183,
yycrank+0,	0,		yyvstop+185,
yycrank+0,	0,		yyvstop+187,
yycrank+0,	0,		yyvstop+189,
yycrank+732,	0,		0,	
yycrank+0,	yysvec+331,	0,	
yycrank+788,	0,		0,	
yycrank+0,	yysvec+331,	0,	
yycrank+803,	0,		0,	
yycrank+807,	0,		0,	
yycrank+790,	0,		0,	
yycrank+934,	0,		0,	
yycrank+798,	0,		0,	
yycrank+793,	0,		0,	
yycrank+800,	0,		0,	
yycrank+799,	0,		0,	
yycrank+820,	0,		0,	
yycrank+814,	0,		0,	
yycrank+810,	0,		0,	
yycrank+822,	0,		0,	
yycrank+821,	0,		0,	
yycrank+964,	0,		yyvstop+191,
yycrank+821,	0,		0,	
yycrank+826,	0,		0,	
yycrank+833,	0,		0,	
yycrank+826,	0,		0,	
yycrank+848,	0,		0,	
yycrank+853,	0,		0,	
yycrank+849,	0,		0,	
yycrank+861,	0,		0,	
yycrank+869,	0,		0,	
yycrank+965,	0,		yyvstop+193,
yycrank+966,	0,		yyvstop+195,
yycrank+862,	0,		0,	
yycrank+863,	0,		0,	
yycrank+860,	0,		0,	
yycrank+990,	0,		yyvstop+197,
yycrank+861,	0,		0,	
yycrank+880,	0,		0,	
yycrank+883,	0,		0,	
yycrank+878,	0,		0,	
yycrank+895,	0,		0,	
yycrank+899,	0,		0,	
yycrank+892,	0,		0,	
yycrank+994,	0,		yyvstop+199,
yycrank+995,	0,		0,	
yycrank+961,	yysvec+371,	yyvstop+201,
yycrank+905,	0,		0,	
yycrank+893,	0,		0,	
yycrank+964,	yysvec+247,	yyvstop+203,
yycrank+888,	0,		0,	
yycrank+910,	0,		0,	
yycrank+909,	0,		0,	
yycrank+927,	0,		0,	
yycrank+927,	0,		0,	
yycrank+931,	0,		0,	
yycrank+0,	yysvec+316,	0,	
yycrank+929,	0,		0,	
yycrank+989,	0,		0,	
yycrank+934,	0,		0,	
yycrank+935,	0,		0,	
yycrank+0,	yysvec+331,	0,	
yycrank+933,	0,		0,	
yycrank+918,	0,		0,	
yycrank+937,	0,		0,	
yycrank+939,	0,		0,	
yycrank+923,	0,		0,	
yycrank+950,	0,		0,	
yycrank+948,	0,		0,	
yycrank+941,	0,		0,	
yycrank+1042,	0,		yyvstop+205,
yycrank+1004,	yysvec+348,	yyvstop+207,
yycrank+946,	0,		0,	
yycrank+966,	0,		0,	
yycrank+968,	0,		0,	
yycrank+952,	0,		0,	
yycrank+969,	0,		0,	
yycrank+967,	0,		0,	
yycrank+960,	0,		0,	
yycrank+1061,	0,		yyvstop+209,
yycrank+1062,	0,		yyvstop+211,
yycrank+1063,	0,		yyvstop+213,
yycrank+1064,	0,		yyvstop+215,
yycrank+1031,	yysvec+363,	yyvstop+217,
yycrank+974,	0,		0,	
yycrank+962,	0,		0,	
yycrank+956,	0,		0,	
yycrank+988,	0,		0,	
yycrank+976,	0,		0,	
yycrank+993,	0,		0,	
yycrank+1083,	0,		0,	
yycrank+0,	yysvec+379,	0,	
yycrank+0,	yysvec+377,	0,	
yycrank+0,	yysvec+379,	0,	
yycrank+0,	yysvec+316,	0,	
yycrank+996,	0,		0,	
yycrank+0,	yysvec+316,	0,	
yycrank+1001,	0,		0,	
yycrank+0,	yysvec+331,	0,	
yycrank+0,	yysvec+331,	0,	
yycrank+1002,	0,		0,	
yycrank+999,	0,		0,	
yycrank+987,	0,		0,	
yycrank+981,	0,		0,	
yycrank+1002,	0,		0,	
yycrank+990,	0,		0,	
yycrank+1007,	0,		0,	
yycrank+1005,	0,		0,	
yycrank+993,	0,		0,	
yycrank+987,	0,		0,	
yycrank+1008,	0,		0,	
yycrank+996,	0,		0,	
yycrank+1013,	0,		0,	
yycrank+996,	0,		0,	
yycrank+1109,	0,		yyvstop+219,
yycrank+0,	yysvec+415,	0,	
yycrank+0,	yysvec+413,	0,	
yycrank+0,	yysvec+415,	0,	
yycrank+1012,	0,		0,	
yycrank+1071,	0,		0,	
yycrank+0,	yysvec+379,	0,	
yycrank+0,	yysvec+316,	0,	
yycrank+0,	yysvec+331,	0,	
yycrank+0,	yysvec+432,	0,	
yycrank+0,	yysvec+430,	0,	
yycrank+0,	yysvec+432,	0,	
yycrank+1013,	0,		0,	
yycrank+0,	yysvec+438,	0,	
yycrank+0,	yysvec+436,	0,	
yycrank+0,	yysvec+438,	0,	
yycrank+1015,	0,		0,	
yycrank+1120,	0,		yyvstop+221,
yycrank+0,	yysvec+415,	0,	
yycrank+1121,	0,		yyvstop+223,
yycrank+0,	yysvec+432,	0,	
yycrank+0,	yysvec+438,	0,	
yycrank+1133,	0,		yyvstop+225,
yycrank+1131,	yysvec+460,	yyvstop+227,
0,	0,	0};
struct yywork *yytop = yycrank+1188;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
'0' ,'0' ,'2' ,'3' ,'3' ,'3' ,'3' ,'3' ,
'3' ,'3' ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,'a' ,'a' ,'a' ,'a' ,'a' ,'a' ,'a' ,
'a' ,'a' ,01  ,'k' ,'k' ,'k' ,'n' ,'n' ,
'n' ,'n' ,'n' ,'n' ,'n' ,'n' ,'n' ,'n' ,
'n' ,'n' ,01  ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
#ifndef lint
static	char ncform_sccsid[] = "@(#)ncform 1.1 86/07/08 SMI"; /* from S5R2 1.2 */
#endif

