/* (lgl-
 *	The information contained herein is a trade secret of Mark Williams
 *	Company, and  is confidential information.  It is provided  under a
 *	license agreement,  and may be  copied or disclosed  only under the
 *	terms of  that agreement.  Any  reproduction or disclosure  of this
 *	material without the express written authorization of Mark Williams
 *	Company or persuant to the license agreement is unlawful.
 *
 *	COHERENT Version 4.2.10
 *	Copyright (c) 1982 - 1984
 *	An unpublished work by Mark Williams Company, Chicago.
 *	All rights reserved.
 -lgl) */

/* offsets from the base address for the read registers */
#define DATA_REG	0		/* data */
#define STATUS_REG	1		/* hardware status */

/* offset from the base address for the write registers */
#define DATA_REG	0		/* data */
#define RESET_REG	1		/* reset */
#define HCON_REG	2		/* host controller */
#define CHN_REG		3		/* channel */

/* bits in the hardware status register */
#define HW_DOOR		16		/* is 0 when the door is closed */
#define HW_STEN		4		/* is 0 when host can read drive status from data register */
#define HW_DTEN		2		/* is 0 when host can read data from data register */

/* commands */
#define MCD_STOP		0xf0	/* turn servos off and stop disc */
#define MCD_SEEK_READ		0xc0	/* turn servos on, rotate disc, search address and get data */
#define MCD_SEEK_READ_DOUBLE	0xc1	/* for double speed, FX001D drive only */
#define MCD_DATA_MODE_SET	0xa0	/* set data mode type */
#define MCD_REQUEST_VERSION	0xdc	/* get version of drive control program */
#define MCD_INACTIVITY_TIME	0x80	/* set inactivity time */
#define MCD_HOLD		0x70	/* put pick-up head to hold track status */
#define MCD_SOFT_RESET		0x60	/* initialize drive mode, move pick-up to innermost position */
#define MCD_MODE_SET		0x50	/* set drive mode */
#define MCD_REQUEST_DRIVE_STAT	0x40	/* request drive status */
#define MCD_REQUEST_SENSE	0x30	/* request sense data */
#define MCD_REQUEST_SUBQ_CODE	0x20	/* request to transfer SUBQ with drive status */
#define MCD_REQUEST_TOC_DATA	0x10	/* request to transfer TOC with drive status */
#define MCD_DRIVE_CONFIGURATION	0x90	/* set drive configuration */
#define MCD_READ_SUB_CODE	0xb0	/* read sub code */
#define MCD_REQUEST_ATTENATOR	0x8e	/* get present values of audio channel control */
#define MCD_REQUEST_DRIVE_MODE	0xc2	/* get present setting of drive mode */
#define MCD_SET_ATTENATOR	0xae	/* set audio channel control data */
#define MCD_SET_INTERLEAVE	0xc8	/* set interleave factor */
#define MCD_UPC_READ		0xa2	/* read UPC code */
#define MCD_REQUEST_MULTI_INFO	0x11	/* request hybrid disk info */
#define MCD_EJECT		0xf6	/* eject drive */

/* bits in the status returned by drive status command */
#define MCD_STATUS_DOOR		0x80	/* 1 = door open */
#define MCD_STATUS_DISC		0x40	/* 1 = disk in drive */
#define MCD_STATUS_CHANGE	0x20	/* 1 = disk was changed */
#define MCD_STATUS_SERVO	0x10	/* 1 = disk rotates and servo is on */
#define MCD_STATUS_TYPE		0x8	/* 1 = audio disk */
#define MCD_STATUS_READ_ERROR	0x4	/* 1 = read error */
#define MCD_STATUS_AUDIO	0x2	/* 1 = play back audio */
#define MCD_STATUS_CMD_ERROR	0x1	/* 1 = command error */

/* drive types returned by request version command */
#define TYPE_LU005		'M'	/* LU005 or FX001 single speed */
#define TYPE_FX001		'D'	/* FX001D double speed */

#define MAX_TRACKS		104	/* max tracks on a disk */
#define FIRST_BLK_OFFSET	150	/* offset for 1th logical block on disc */

#define TIMEOUT_STATUS		2200	/* timeout for get drive status */
#define TIMEOUT_DATA		300	/* timeout for read a block */

/* the MSF structure used by Mitsumi drives */
struct msf {
	unsigned char	min;
	unsigned char	sec;
	unsigned char	frame;
};

/* the TOC header structure used by Mitsumi drives */
struct toc_header {
	unsigned char	first;
	unsigned char	last;
	struct msf	leadout;
	struct msf	first_track;
};

/* structure of a TOC entry used by Mitsumi drives */
struct toc {
	unsigned char	ctrl_addr;
	unsigned char	track;
	unsigned char	index;
	struct msf	track_time;
	struct msf	disk_time;
};

/* structure needed for the play command */
struct play {
	struct msf	start;
	struct msf	end;
};
