////////
/
/ srlq( w0, w1, w2, w3, count ) - shift right logical a quad word.
/
/	Input:	w0..w3 form a quad word.
/		count is the number of bits
/
/	Action: Perform a shift right logical of w0..w3 by count bits.
/
/	Return:	_fpac_ contains the shifted result.
/
////////

	.globl	srlq_
	.shri

srlq_:	push	si
	push	di
	push	bp
	mov	bp,sp
	mov	ax,8(bp)
	mov	dx,10(bp)
	mov	si,12(bp)
	mov	di,14(bp)
	mov	cx,16(bp)
	jcxz	1f

0:	shr	di,$1
	rcr	si,$1
	rcr	dx,$1
	rcr	ax,$1
	loop	0b

1:	mov	_fpac_+0,ax
	mov	_fpac_+2,dx
	mov	_fpac_+4,si
	mov	_fpac_+6,di
	pop	bp
	pop	di
	pop	si
	ret
