.II "C language^tutorial"
.ds TL "The C Language"
.NH "The C Language" 1
.PP
.II "Ritchie, Dennis"
.II "Thompson, Ken"
C
is a computer language invented by Dennis Ritchie and Ken Thompson at
AT&T Bell Laboratories in the early 1970s.
In the approximately 25 years since its creation, C has become one of the
most popular computer languages in the world.
C is powerful and flexible, and it is highly portable.
It has been implemented
on practically every computer, and under practically every operating system,
in the world.
.PP
C is the ``native language'' of the \*(CO system.
\*(CO is written in C, and it includes a powerful C compiler among
its suite of language tools for your use.
You do not need to know C to use \*(CO to great advantage;
however, if you plan to program under \*(CO, you would be well
advised to become at least passably acquainted with it.
.PP
This tutorial is an introduction to the \*(CO C compiler and to the
C language itself.
The first part of this section describes how to compile programs under
\*(CO.
The second part is a brief tutorial in the C language.
.SH "Compiling C Programs under COHERENT"
.PP
.II "cc"
.II compiler
A C compiler is a program that
transforms files of C source code into machine code.
Compilation is a complex process that involves several steps;
however, \*(PN simplifies it with the command
.BR cc ,
which controls all the actions of the compiler.
.Sh "Try the Compiler"
.PP
Before we launch into a lengthy explanation of what \fBcc\fR is and what it
does, you can get a feel for it by trying it with a simple example.
To begin, type the following to create a simple C program:
.DM
	cat >hello.c
	main() {
		printf("Hello, world\en");
	}
	<ctrl-D>
.DE
This creates a simple C program called \fBhello.c\fR.
Now, compile your program by typing the following command:
.DM
	cc -V hello.c
.DE
If you typed the program correctly,
.B cc
prints something like the following on your screen:
.DM
	cc0 D2B000000201 hello.c  0x418CB8
	cc1 D2B000000201 0x418CB8 0x408CB4
	cc2a D2B000000201 0x408CB4 0x418CB8
	cc2b D2B000000201 0x418CB8 hello.o
	/bin/ld -X -o hello /lib/crts0.o hello.o /lib/libc.a -Z hello.o
.DE
What each of these messages means will be described below.
If you receive an error message, try re-typing the program, and then
re-compile it.
When compilation is successfully completed, you will now have an executable
program called \fBhello\fR.
To invoke it, type:
.DM
	hello
.DE
It should print the following on your screen:
.DM
	Hello, world
.DE
As you can see, \fBcc\fR makes it easy to transform a file of C code into
an executable program.
.Sh "Phases of Compilation"
.PP
As you noticed, \fBcc\fR printed a number of messages on your screen as it
compiled \fBhello.c\fR.
The reason you saw the messages was that compilation was performed with the
\fB\-V\fR option to \fBcc\fR; this tells \fBcc\fR to print a verbose output
that describes each of its actions.
\fBcc\fR prints numerous messages because the \*(CO C compiler
is not just one program, but a number of different programs that work together.
Each program performs a
.I phase
of compilation.
The following summarizes each phase:
.IP \fBcpp\fR 0.4i
The C preprocessor.
.II cpp
.II "C preprocessor"
This processes any of the \*(Ql#\*(Qr directives, such as
.B #include
or
.BR #ifdef ,
and expands macros.
.IP \fBcc0\fR
.II cc0
.II "parser"
The parser.
This phase parses programs.
It translates the program into a parse-tree format,
which is independent of both the language of the
source code and the microprocessor for which code will be generated.
.IP \fBcc1\fR
.II cc1
.II "code generator"
The code generator.
This phase reads the parse tree generated by
.B cc0
and translates it into machine code.
The code generation is table driven, with entries for each operator
and addressing mode.
.IP \fBcc2a\fR
.II cc2a
.II "optimizer generator"
.II optimization
The optimizer generator.
This phase optimizes the generated code.
.IP \fBcc2b\fR
.II cc2b
.II "object generator"
.II optimization
The optimizer generator.
This phase writes the object module.
.IP \fBcc3\fR
.II cc3
.II "assembly-language generator"
\*(PN also includes a fifth phase, called
.BR cc3 ,
which can be run after the object generator,
.BR cc2 .
.B cc3
generates a file of assembly language instead of a relocatable object module.
\fBcc3\fR allows you to examine the code generated by the compiler.
You did not see this phase when you compiled \fBhello.c\fR because
this phase is optional and you did not request it.
If you want \*(PN to generate assembly language, use the
.B \-S
option on the
.B cc
command line.
.PP
.II "object module"
Unless you specify the
.B \-S
option, \fBcc\fR creates an
.I "object module"
that is named after the source file being compiled.
This module has the suffix
.BR .o .
An object module is
.II "object module"
.I not
executable;
it contains only the code generated by compiling a C source file, plus
information needed to link the module with other program modules
and with the library functions.
.PP
.II linker
.II "executable program"
As the final step in its execution,
.B cc
calls the linker \fBld\fR to produce an executable program.
.Sh "Renaming Executable Files"
.II "executable files"
.PP
When \fBcc\fR compiles a source file, by default it names the executable
program after the \fIfirst\fR source file named on the \fBcc\fR command line.
If you wish, you can give the executable file a different name.
Use the
.B \-o
(output) option, followed by the desired name.
.Sh "Floating-Point Numbers"
.II "floating-point numbers"
.PP
Often, you will need to use floating-point numbers in your programs.
If you are unsure what a floating-point number is, see the Lexicon entry for
.BR float .
.PP
The routines that print floating-point numbers are large, and
most C programs do not need to print floating-point numbers;
therefore, the code to perform floating-point arithmetic is not
included in a program by default.
You must ask \fBcc\fR to include these routines with your program by using the
.B \-f
option to \fBcc\fR.
.PP
To see how this works, let's modify \fBhello.c\fR to use floating-point
numbers.
Edit \fBhello.c\fR by typing the following commands:
.DM
	ed hello.c
	2
	c
		printf("Hello, world %f\en", 123.4);
	.
	w
	q
.DE
Now, compile the program with the same command line as before:
.DM
	cc -V hello.c
.DE
When compilation has finished, type \fBhello\fR.
You'll see the following output:
.DM
	You must compile with the \-f flag
	to include printf() floating point.
	Hello, world
.DE
\*(CO is telling you that you are using
a floating-point number but that you did not compile the program to
include code to process floating-point numbers.
Now, recompile the program using the \fB\-f\fR option to \fBcc\fR:
.DM
	cc -V -f hello.c
.DE
When compilation has finished, type \fBhello\fR.
If you typed the program correctly, you will see the following:
.DM
	Hello, world 123.400000
.DE
As you can see, \fBhello\fR is now displaying the floating-point number
\fB123.4\fR for you.
For detailed information on \fBprintf()\fR, see its entry in the Lexicon;
\fBprintf()\fR is also discussed in the tutorial section below.
.Sh "Compiling Multiple Source Files"
.II "multiple source files"
.PP
Many programs are built from more than one file of C source code.
For example, the program
.BR factor ,
which is provided with \*(PN, is built from the C source files
.B factor.c
and
.BR atod.c .
To produce the executable program \fBfactor\fR, both source files
must be compiled;
the linker \fBld\fR then joins them to form an executable file.
.PP
.II factor.c
.II atod.c
To compile a program that uses more than one source file, type all
of the source files onto the
.B cc
command line.
For example, to compile \fBfactor\fR you would type the following:
.DM
	cc -o factor -f factor.c atod.c -lm
.DE
This command compiles both C source files to create the program
.BR factor .
.PP
In the above example,
.B cc
produces the non-executable object modules
.B factor.o
and
.BR atod.o ,
and then links them to produce the executable file
.BR factor .
.PP
The argument
.B \-lm
tells
.B cc
to include routines from the mathematics library
.II "mathematics library"
.II libm
when the object modules are linked.
This option must come
.I after
the names of all of the source files,
or the program will not be linked correctly.
.Sh "Linking Without Compiling"
.II "linking without compiling"
.PP
When you are writing a program that consists of several source files,
you will need to compile the program, test it, and
then change one or more of the source files.
Rather than recompile all of the source files, you can save time
by recompiling only the modified files and relinking the program.
.PP
For example, if you modify the
.B factor
program by changing the source file
.BR factor.c ,
you can recompile \fBfactor.c\fR \fIand\fR relink the
entire program with the following command:
.DM
	cc -o factor -f factor.c atod.o -lm
.DE
.II "source file"
.II "object module"
This \fBcc\fR command refers to the C source file
.B factor.c
and the
.I "object module"
.BR atod.o .
.B cc
recognizes that
.B atod.o
is an object module and simply passes it to the linker \fBld\fR
without re-compiling it.
You will find this particularly useful when your programs
consist of many source files and you need to compile only a few of them.
.PP
To simplify compiling, especially if you are developing systems
that use many source modules, you should consider using the
.B make
utility that is included with \*(PN.
For more information on
.BR make ,
see its entry in the Lexicon, or see the tutorial for
.B make
that appears later in this manual.
.Sh "Compiling Without Linking"
.II "compiling without linking"
.PP
At times, you will need to compile a source file
but not link the resulting object module to the other object modules.
You will do this, for example, to compile a module that
you wish to insert into a library.
Use \fBcc\fR's option
.B \-c
to tell
.B cc
not to link the compiled program.
This option is often used to create relocatable object
modules that can be archived into a library for later use.
.PP
For example, if you wanted just to compile
.B factor.c
without linking it, you would type:
.DM
	cc -c factor.c
.DE
To link the resulting object module with the object module
.B atod.o
and with the appropriate libraries,
type the following command:
.DM
	cc -o factor -f factor.o atod.o -lm
.DE
.Sh "Assembly-Language Files"
.II "assembly-language programs"
.PP
C makes most assembly language programming unnecessary.
However, you may wish to write small parts of your programs in
assembly language for greater speed or to access processor features that
C cannot use directly.
\*(PN includes an assembler, named
.BR as ,
which is described in detail in the Lexicon.
.PP
To compile a program that consists of the C source file
.B example.c
and the assembly-language source file
.BR example.s ,
simply use the
.B cc
command as usual:
.DM
	cc -o example example1.c example2.s
.DE
.B cc
recognizes that the suffix
.B .s
indicates an assembly-language source file, and assembles it with
.BR as ;
.II as
then it links both object modules to produce an executable file.
.Sh "Changing the Size of the Stack"
.PP
.II "stack size"
.II "altering stack size"
The \fIstack\fR is the segment of memory that holds function arguments,
local variables, and function return addresses.
\*(CO takes advantage of the 80386 microprocessor's ability to
allocate stack dynamically.
.Sh "Where To Go From Here"
.PP
This discussion of the \fBcc\fR command is by no means complete, but
it includes enough information for you to begin to compile your programs.
The Lexicon's entry for \fBcc\fR gives all of the command-line options
available with \fBcc\fR.
The Lexicon also has entries for \fBcpp\fR, the
compiler phases, and for the linker \fBld\fR, and describes them at
greater length.
All error messages generated by \fBcc\fR and by the assembler \fBas\fR
appear in the appendix to this manual.
.PP
The next section in this tutorial introduces the C programming language.
.so \*(DI/text/beginners.r
.so \*(DI/text/bibliography.r
