.ds TL "Advanced cohulip"
.ds TI COHULIP
.NH "Advanced cohulip"
.PP
Once you have mastered using
.B cohulip
to communicate with one network, you may wish to explore how to use
.B cohulip
in a more sophisticated way.
The following sections discuss various advanced topics.
We hope that find them helpful.
.SH "Sample FTP Session"
.PP
The following walks you through a sample FTP session.
.II "Wright, Randy"
It is adapted from a posting by Randy Wright.
.PP
Each line is numbered, for reference below;
normally, lines are not numbered.
Text in Roman is generated by
.B cohulip
itself.
Text in
.B bold
comes from the remote host; and text in
.I italics
is typed by the user:
.nf
.sp \n(pDu
.ta 0.3i 1.0iR 1.5iR 2.0iR 2.2iL 4.0iL 6.0iL
1	    Coherent User Level Internet Package (cohulip)
2	                   derived from
3	 Internet Protocol Package, (C) 1988 by Phil Karn, KA9Q
4	     with contributed code from many other sources
5	
6	        This version is cohulip 2.1  with options:
7	        SLIP, ETHERNET, TRACE, MXSOCKETS
8	
9	startup: [/usr/net/startup.net]
10	ne_attach: /dev/ne0 [00:00:1b:00:0e:d7]
11	net> \fIftp rwsyss\fR
12	SYN sent
13	Estab.
14	\fB220 \fRrwsyss FTP server (rwsyss 1.0 #1 Tue May 24 17:30:31 PDT 1994 i386) ready.
15	Enter user name: \fIrw\fR
16	\fB331 \fRPassword required for rw.
17	Password: 
18	\fB230 \fRUser rw logged in.
19	ftp> \fI^]\fR
20	net> \fItcp status\fR
21	conout 1, conin 0, reset out 0, runt 0, chksum err 0, bdcsts 0
22		&TCB	RcvQ	SndQ	Local socket	Remote socket	State
23		406284	0	0	stalo:1001	rwsyss.wimsey.b:ftp	Estab.  
24		405ebc	0	0	stalo:echo	0.0.0.0:0	Listen   (S)
25		40608c	0	0	stalo:telnet	0.0.0.0:0	Listen   (S)
26		405fa4	0	0	stalo:ftp	0.0.0.0:0	Listen   (S)
27	net> \fItcp status 406284\fR
28	Local: stalo:1001 Remote: rwsyss.wimsey.b:ftp State: Estab.
.ta 0.3i 1.0i 2.0i 3.0i 4.0i 5.0i 6.0i
29		Init seq	Unack	Next	Resent	CWind	Thrsh	Wind	MSS Queue	Total
30	Send:	393870	393887	393887	0	1047	65535	4096	1024	0	22
31	Recv:	dc7f2533	dc7f25c1	0	6000	0	141
32	Backoff 0 Timer stopped SRTT 1544 ms Mean dev 745 ms
33	net> 
34	
35	ftp> \fIhash\fR
36	HASH MARK (#) on 1k boundaries is ON
37	ftp> \fIbell\fR
38	BEEP at end of tranfer is ON
39	ftp> \fItype i\fR
40	\fB200 \fRType set to I.
41	ftp> \fIget china-l\fR
42	\fB200 \fRPORT command successful.
43	\fB150 \fROpening BINARY mode data connection for china-l (14832 bytes).
44	##############\fB226 \fRTransfer complete.
45	Get complete, 14832 bytes received in 0 secs
46	
47	ftp> \fIquit\fR
48	\fB221 \fRGoodbye.
49	ClosWait
50	Last ACK
51	Closed (Reset)
52	net> \fIexit\fR
.PP
The following explains in detail each line of the above session.
.IP \fB1-8\fR
The banner that
.B net
displays when you start it up.
Note that this banner may change somewhat in your version of
.BR net .
.IP \fB9\fR
.B net
names the file it opened to read its startup commands.
.IP \fB10\fR
.B net
attaches an Ethernet device to a session named ``ne0''.
A device cannot be used unless it is first attached.
.B net
also displays the Ethernet card's Ethernet address.
This information can sometimes be useful if you are debugging ARP.
.IP \fB11\fR
.B net
has issued a prompt, and the user has entered the command to begin
an FTP session with system
.BR rwsyss .
.B net
displays this prompt after it has executed all commands in the startup script.
.IP \fB12-13\fR
TCP has initiated a connection with
.BR rwsyss .
No work can be done on a TCP connection until it has become established.
.IP \fB14\fR
This is a typical response from an FTP server.
The remote FTP server simply sends the three-digit message that appears at
the beginning of the message; the text is local client's interpretation of
that three-digit number.
In this case, message 220 indicates that
.B net
has established connections with the remote server.
.IP \fB15\fR
.B net
sees that the remote server is ready for a user name,
because its previous message began with the number 220.
Therefore, it prompts the user for his name; and the user type it (in this case,
.BR rw ).
.B net
then sends that name to the remote server.
.IP \fB16\fR
Message 331 from the remote server indicates that
it has received the user's name, and now wants the password.
.IP \fB17\fR
In response to message 331,
.B net
shuts off echoing and displays a prompt for the password.
After the user types the password and presses
.BR <return> ,
.B net
dispatches the password the the remote FTP server and turns on echoing again.
.IP \fB18\fR
Message 230 from the remote server indicates that it has
evaluated and accepted the password and user name.
User
.B rw
is now logged in and can do FTP work.
.IP \fB19\fR
The user has typed the escape character.
This special keystroke lets him return to the
.B net>
prompt.
At this prompt, the user can issue any of
.BR net 's
commands.
.IP
.B cohulip
can have any number
of ``sessions'' going simultaneously.
For example, you can have an FTP session with two different
systems while also having a TELNET chat with a third.
To move from one session to another, you must
``escape'' from the current session to the
.B net>
prompt, then use a
.B net
command to enter the other session.
In addition, you must escape to the
.B net>
prompt before you can issue a command that modifies
the whole of the TCP/IP software.
.IP \fB20\fR
The user has typed command
.BR "tcp status" ,
which shows the overall status of the TCP software.
.IP \fB21-26\fR
These lines show the output of command
.BR "tcp status" :
.DM
	conout 1, conin 0, reset out 0, runt 0, chksum err 0, bdcsts 0
.DE
.B conout
is the current number of outgoing connections;
that is, connections initiated from the local host.
.B conin
is the current number of connections initiated from
a remote host to this host.
.B "reset out"
is the number of connections that have been reset.
Reseting a connection closes it without notification
of the remote site.
.B runt
is the number of datagrams that were less than the minimum
length needed to carry an IP header.
.B "chksum err"
is the number of datagrams whose checksum show that the datagram was corrupt.
.B bdcsts
is the number of datagrams that were rejected because
they were broadcast datagrams, rather than addressed datagrams.
.DM
	  &TCB RcvQ SndQ Local socket            Remote socket           State
	406284    0    0 stalo:1001              rwsyss.wimsey.b:ftp     Estab.  
	405ebc    0    0 stalo:echo              0.0.0.0:0               Listen   (S)
	40608c    0    0 stalo:telnet            0.0.0.0:0               Listen   (S)
	405fa4    0    0 stalo:ftp               0.0.0.0:0               Listen   (S)
.DE
These lines give the status of each ``socket.''
Each connection or potential connection has a transmission-control block
(TCB).
The number under
.B &TCB
is the address of a given session's TCB;
you can be used this address to direct
.B tcp
commands to a particular session.
.II "receive queue"
.II "send queue"
.II RcvQ
.II SndQ
.B RcvQ
and
.B SndQ
are, respectively, the receive queue and the send queue \(em that is,
the number of bytes that have been received and have not yet been used,
and the number of bytes sent but have not yet been acknowledged by the remote
host.
A build-up in the receive queue
indicates that data are coming in faster than they are being used
locally.
A build-up in the send queue
.I may
indicate that the transmission path is clogged.
.IP
The local socket gives the IP address of the local host plus and the port
it has linked to the connection;
the remote socket gives the remote site's IP address and the port it has
linked to the connection \(em usually a ``well-known'' port that is associated
with a given server.
An address of 0.0.0.0 indicates that a connection is not yet established.
.IP
There are ten possible states for a TCP connection.
Most states are transient.
The
.B Listen
state indicates that a local server awaits a request from a remote site.
In this display, three servers are running and awaiting connection requests:
the
.B echo
server, the TELNET server and the FTP server.
The one connection that is in state
.B Estab.
is the FTP-control connection with
.BR rwsyss .
.IP \fB27\fR
This is a variant of the
.B "tcp status"
command that yields detailed information
on a particular connection.
Argument 406284 is the address of the TCB for the session that is logged
into site
.BR rwsyss ,
as shown in the above table.
.IP \fB28-32\fR
These give the output that
.B net
generated in respond to the previous command.
.DM
	Local: stalo:1001 Remote: rwsyss.wimsey.b:ftp State: Estab.
.DE
This is the general information about who is connected, and the TCP state. 
.DM
	      Init seq    Unack     Next Resent CWind Thrsh  Wind  MSS Queue      Total
	Send:   393870   393887   393887      0  1047 65535  4096 1024     0         22
	Recv: dc7f2533          dc7f25c1      0              6000          0        141
.DE
This displays information for both the send setup and the receive setup.
Each TCP session starts out with an initial sequence number;
this number represents the starting point of bytes that are sent and
received over the connection.
.RS
.IP \fBUnack\fR
The sequence number of the last byte transmitted that
whose receipt the remote host has not yet acknowledged.
.IS \fBNext\fR
A value that represents the sequence-number
acknowledgement expected from the other end of the connection.
.IS \fBResent\fR
The number of datagrams that have been resent due to not
being acknowledged within the time limits kept by TCP.
.IS \fBCwind\fR
The amount of space available in the current ``window.''
TCP is a ``sliding window'' style protocol.
.IS \fBThrsh\fR
The number of miliseconds of timeout that will cause a ``slow
start'' to kick in.
The slow-start situation puts a delay between datagrams
to allow an overloaded network to recover from congestion.
.IS \fBWind\fR
The window size that each of the connection ``bid''
at the start of the connection.
.IS \fBMSS\fR
The maximum segment size of each side as ``bid'' at the beginning
of the connection.
.IS \fBmss\fR
The maximum data size of each datagram.
.IS \fBQueue\fR
The number of outstanding bytes in the channel.
Total is the total number of bytes either
sent or received since the connection began.
.DM
	Backoff 0 Timer stopped SRTT 1544 ms Mean dev 745 ms
.DE
TCP has sophisticated mechanisms to deal with network congestion.
This line tells you about the current state
of the backoff timer and calculations that TCP is performing
to give the best performance without worsening network congestion.
There are four fields in this line:
.DS
	Backoff ###
	Timer state
	SRTT #### ms
	Mean dev #### ms
.DE
These fields tell you the state of congestion that exists
on your connections.
.B cohulip
supports
two types of timer:
linear and exponential.
In the linear backoff timer,
.B net
increments
the value of
.B Backoff
by one step each time
.B net
retransmits a datagram due to a timeout.
In an exponential backoff,
.B net
doubles the backoff value each time a datagram retransmission occurs.
.B net
then multiplies the backoff value by the
.BR SRTT ,
and adds that product to the sum of one  second and the mean deviation
in order to determine the amount of time to wait for the next retransmission
timeout.
The effect of this is that if a datagram is not acknowledged
by the remote site within the normal round trip time,
.B net
assumes that it is lost, and retransmits it.
Then the timer is set at a longer
amount of time than the round-trip time.
If the second datagram is not acknowledged within the timeout period,
it is retransmitted again
and the timeout period is increased even more.
This can continue until very long periods of time pass between attempts.
The acknowledgement of a datagram turns off the backoff, unless the
timeout figures have exceeded the slow-start threshold.
.IP
.B SRTT
is the ``smoothed'' round-trip time, in miliseconds.
.B "Mean dev"
is the mean deviation, in milliseconds.
As you can see, TCP does a fair amount of arithmetic to
keep things flowing smoothly.
.IP \fB33-34\fR
The user has pressed
.B <enter>
to return to the current session.
.IP \fB35-36\fR
The user turns on the hash-mark function for FTP, and
.B net
replies that it is on.
.IP \fB37-38\fR
The user turns on the bell function, and
.B net
acknowledges it.
.B net
will now beep when it finishes transferring a file.
.IP \fB39-40\fR
The user sets the FTP session to type `i', and
.B net
acknowledges the command.
This means that the user wants files to be transmitted in ``image''
(binary) mode.
.B net
also recognizes `b' (``binary'') as a synonym for ``image.''
The other available modes are `a' (``ASCII''); and `l',
which lets you specify an oddball byte length for ASCII text.
.IP \fB41\fR
Now we cut to the chase:
the user tells
.B net
to get (i.e., download) file
.B china-l
from the remote site.
.B net
will copy it into the user's current directory on the local host.
.IP \fB42-46\fR
These lines give progress reports about the file transfer.
FTP always opens a second TCP connection over which data is
transferred.
Message 200 indicates that
.B net
established the second channel with the remote server.
Message 150 tells the user that the file has been opened
and transfer of data begun.
.IP
The hash-mark function in the local software displays a ``hash''
character `#' after it transfers each kilobyte of data.
Message 226 from the remote host comes from the ``command'' connection.
It indicates that the transfer of data is complete.
(Sometimes the transfer-complete message
can arrive before all of the data arrives! This does not indicate
that an error has happened.)
.IP
Line 45 indicates that
.b net
has received the 14,832 bytes, and that it has detected the closure
of the data connection.
.IP 
Finally, line 47 shows that
.B net
has beeped to indicate that file transfer has completed, as the user
requested earlier.
.IP \fB47\fR
The user issues a command to close the connection gracefully.
.B net
sends this command to the remote host, which initiates the closure sequence.
.IP
A TCP connection does not close instantly.
TCP pauses a bit to ensure that no data is lost.
It gets and acknowledges some more datagrams from the remote site.
When the connection has finally closed entirely,
.B net
automatically returns the user to its
.B net>
prompt.
.IP \fB48-51\fR
Message 221 from the remote site acknowledges that the connection is now
closed.
The other three lines show that
.B net
has performed the housekeeping chores associated with
closing a connection properly.
.IP \fB52\fR
The user exits from
.BR net .
.SH "Anonymous FTP"
.PP
``Anonymous FTP'' means that a site permits user ``anonymous'' to access
itself via FTP.
In this way, anyone can use the information that you have made available
on your system.
What user ``anonymous'' can do depends entirely upon how that site's
administrator has structured it.
.PP
The following sub-section describes how to use anonymous FTP to
access a remote host.
.II "Yanoff, Scott"
It is adapted from the document \fIA Short Guide to Anonymous ftp\fR,
which was written by Scott Yanoff (yanoff@csd4.csd.uwm.edu).
.Sh "Accessing a Remote Host via Anonymous FTP"
.PP
A great deal of useful information is stored in files at computers
throughout the country and the world.
Many of these file are freely available to users of the Internet.
A simple method for transferring such files from a remote computer to a
user's computer is anonymous FTP.
Anonymous FTP allows a user to transfer files without having an account
at the remote computer (i.e., the user is anonymous).
.PP
To access an anonymous FTP site, you must know the site's name.
For example, nic.ddn.mil is the name of the Network Information Center
of the Department of Defense Network. 
The procedure for accessing this site follows.
The text in Roman text is printed by
.BR net .
The text in
.I italics
gives what the user types on her local system to access nic.ddn.mil;
and the text in
.B bold
is returned by the remote site.
Each line is numbered; the numbers do not actually appear on the screen:
.sp \n(pDu
.nf
.ta 0.3i
1	net> \fIftp nic.ddn.mil\fR
2	Connected to nic.ddn.mil
3	\fB220 \fRNIC.DDN.MIL FTP Server Process 5z(47)-6 at Tue 30-Jul-91 12:56-PDT\fR
4	Name  (nic.ddn.mil:msmith) : \fIanonymous\fR
5	Password  (nic.ddn.mil:anonymous) :\fI---------\fR
6	\fB331 \fRANONYMOUS  user ok, send real ident as password.\fR
7	\fB230 \fRUser ANONYMOUS logged in at Tue  30-Jul-91  12:56-PDT,  job 46.\fR
8	\fRftp>\fR
.PP
The following explains each line in turn:
.IP \fB1\fR 0.3i
At the
.B net
prompt, user FTPs to nic.ddn.mil.
.IP \fB2\fR
User is connected to the FTP site.
As explained earlier, the remote server returns only the number of the message;
the text of the message is generated by the local client \(em in this case,
.BR net .
.IP \fB3\fR
Remote host notes the time of the user's login.
.IP \fB4\fR
The user logs in as ``anonymous''.
.IP \fB5\fR
The user enters password of ``guest'',
which does not appear on screen.
.IP \fB6-7\fR
Remote host acknowledges the user's login, and notes time.
.IP \fB8\fR
The user sees the prompt
.BR ftp> ,
and now begin to explore the remote host.
.PP
Once you have accessed the FTP site, to transfer a file you may have to 
change directories to the directory that your file is located in.
It is a good idea to list the contents of the directory before attempting to
transfer a file:
.sp \n(pDu
.nf
.ta 0.3i
1	\fB230\fR- Guest login ok, access restrictions apply.\fR
2	Starting cwd is /pub.
3	\fB230 \fRLocal time is: Wed Jul 31 14:18:29 1991\fR
4	\fRftp> \fIdir\fR
5	\fB200 \fRPORT command successful.\fR
6	\fB150 \fROpening ASCII mode data connection for /bin/ls.\fR
7	\fBREADME\fR
8	\fBnic\fR
9	\fB226 \fRTransfer complete.\fR
10	\fR11 bytes received in 0.1 seconds (0.01 Kbytes/s)\fR
11	\fRftp> \fIcd nic\fR
12	\fB250 \fRCWD command successful.\fR
13	\fRftp> \fIdir\fR
14	\fB200 \fRPORT command successful.\fR
15	\fB150 \fROpening ASCII mode data connection for /bin/ls.\fR
16	\fBinterest.groups\fR
17	\fBnetworking.terms\fR
18	\fB226 \fRTransfer complete.\fR
19	\fR74 bytes received in 0.11 seconds (0.66 Kbytes/s)\fR
20	\fRftp> \fIget interest.groups\fR
21	\fB200 \fRPORT command successful.\fR
22	\fB150 \fROpening ASCII mode data connection for interest.groups (721283 bytes).\fR
23	\fB226 \fRTransfer complete.\fR
24	\fR738182 bytes received in 15 seconds (48 Kbytes/s)\fR
25	\fRftp> \fIquit\fR
26	\fB221 \fRGoodbye.\fR
.PP
The following explains the above in detail:
.IP \fB1-3\fR
Remote host allows user access.
.IP \fB4\fR
User uses FTP command
.B dir
to display contents of current directory.
.IP \fB5-6\fR
Remote host acknowledges
.B dir
command and begins sequence.
.IP \fB7-8\fR
Listing of directories.
.IP \fB9-10\fR
Remote host completes display and notes the time it took.
.IP \fB11\fR
User uses FTP command
.B cd
to enter directory
.BR nic .
.IP \fB12\fR
Remote host acknowledges change of directory.
.IP \fB13\fR
User invokes FTP command
.B dir
to view contents of the current directory, which is now directory
.BR nic .
.IP \fB14-15\fR
Remote host acknowledges receipt of command.
.IP \fB16-17\fR
Remote host displays contents of current directory.
.IP \fB18-19\fR
Remote host completes display and notes the time it took.
.IP \fB20\fR
User asks FTP to download file
.B interest.groups
to her local host.
.IP \fB21-24\fR
Remote host downloads file, notes size of file, and computes the time the
file transfer took.
.IP \fB25\fR
User logs off the remote host.
.IP \fB26\fR
Remote host acknowledges her departure.
.Sh "Configuring cohulip for Anonymous FTP"
.PP
If you wish, you can open your site for anonymous FTP.
Then, as long as you are ``on the air,'' users can log into your system
and access whatever files you make available to them.
.PP
To open your site to anonymous FTP requires only three steps:
preparing a directory (or directories) for the users to access;
modifying the file
.BR $NETHOME/ftpusers ;
and then starting the FTP server.
The following discusses each of these steps in detail.
.PP
To begin, select a directory for these users to log into.
.I
Do not put any files into this directory that you do not want broadcast
to the world!
.R
If you expect a lot of traffic on your system, you may wish to set aside
an entire file system for anonymous FTP; otherwise, a portion of an
an existing file system will serve.
.PP
Next, you must modify file
.BR $NETHOME/ftpusers .
This file names every user who has permission to log into your system.
An entry in this file consists of the user's name, his password, then between
one and eight pairs of directories and permissions.
These name the directories to which the anonymous user has access,
and what the user can do there.
Permissions state what the user can do there;
it is the sum of the following values:
.DS
.ta 0.5i 0.8i
	\fB1\fR	Read an existing file
	\fB2\fR	Create a new file and write matter into it
	\fB4\fR	Overwrite an existing file or delete a file
.DE
Note that when you name a directory in
.BR ftpusers ,
it and all of its subdirectories become accessible by the user.
.PP
For anonymous FTP, the user's name should be
.BR anonymous ,
and the password `*', which indicates all passwords.
The directory should be one that contains nothing sensitive.
It is not a good idea to give overwrite permission to an anonymous user.
The following gives an example:
.DM
	anonymous * /projects/pub 3
.DE
Here, user
.B anonymous
can access directory
.B /projects/pub
and its subdirectories.
The users can read files and create new files, but not overwrite or delete
any existing files.
.PP
Once you have selected your file and modified
.BR ftpusers ,
all that remains is to add the command
.B "start ftp"
to your startup script, then invoke
.BR net .
Your system is now open for anonymous FTP.
.SH "Tracing and Debugging a cohulip Session"
.PP
The
.B net
command
.B trace
permits you to dump a copy of the datagrams that you exchange
with a remote site.
You can dump datagrams either to the screen or into a file.
This section describes how to initiate a trace, then how to interpret
its output.
.PP
.II "Wright, Randy"
This section is adapted from various mail messages written by Randy Wright.
.Sh "Initiating a Trace"
.PP
The following describes how to initiate a trace of an FTP session to site
.B raven
that is performed through a SLIP connection to an Internet provider.
The description here is easily adapted to an Ethernet connection.
.PP
To initiate a trace, do the following:
.IP \(bu 0.3i
Invoke
.BR net .
Dial your Internet provider and log in, and set the IP addresses of your
local host and domain-name server in the usual manner.
.IP \(bu
Enter the following commands at the
.B net>
prompt:
.DM
	trace to /usr/net/tracefile
	trace sl0 211
.DE
The first
.B trace
command redirects its output into file
.BR /usr/net/tracefile .
The second command tells it to trace session
.BR sl0 .
The digits ``211'' are three flags that set the following behaviors:
.RS
.IP \fB2\fR 0.3i
Decode and display both data and headers.
.IS \fB1\fR
Enable tracing of incoming datagrams.
.IS \fB1\fR
Enable tracing of outgoing datagrams.
.RE
.IP
For details on the syntax of
.BR trace ,
see its entry in the chapter entitled \fIRunning net\fR.
.IP \(bu
Once the trace is launched, type the command
.B "ftp raven"
at the
.B net>
prompt.
The data datagrams are recorded in
a file called
.BR /usr/net/tracefile .
.IP \(bu
After you have logged in, type the escape character
.B <ctrl-]>
to return to the
.B net>
prompt.
.IP \(bu
Issue the command:
.DM
	tcp status
.DE
This displays the sockets status.
Look for the
.B ftp
socket that is connected to the remote site.
Write onto a piece of paper the numbers of the
.B RcvQ
and the
.BR SndQ .
The former identifies the receive queue, and the latter the send queue.
.IP \(bu
To turn off tracing, enter the command from the
.B net>
prompt:
.DM
	trace sl0 000
.DE
.Sh "Interpreting a Packet"
.PP
Now that the trace has been captured, you can read it.
The following introduces the structure of a TCP datagram, and suggests how
you can read it.
.PP
As you recall from the chapter on TCP/IP basics, a typical datagram is
built in layers:
20 bytes of IP header, followed by 20 bytes of TCP header, followed by
a variable amount of data.
That chapter describes each byte of each header in detail.
.PP
It is possible to get corrupted datagrams over modem connections.
This will show up in the messages logged by the
.B trace
command,
because the tracing software
analyzes the datagrams and detects mal-formed datagrams.
This is discussed below.
.Sh "Reading a Tracefile"
.PP
The following example reads the tracefile that we captured during the
first part of this section.
For purposes of this example, we assume that there is a problem with
a connection to remote site
.BR raven :
it hangs after login.
We'll also assume that
.B RecQ
is 0 and the
.B SndQ
is 16.
.PP
The following gives the first datagram recorded in the tracefile.
The local host has sent it to
.BR raven :
.DM
	sl0 sent:
	IP: len 44 199.3.32.100->137.229.10.39 ihl 20 ttl 31 prot TCP
	TCP: 1001->21 Seq x138ce20 SYN Wnd 1500 MSS 1500
	0000  45 00 00 2c 00 00 00 00 1f 06 20 59 c7 03 20 64  E..,...... YG. d
	0010  89 e5 0a 27 03 e9 00 15 01 38 ce 20 00 00 00 00  .e.'.i...8N ....
	0020  60 02 05 dc 43 58 00 00 02 04 05 dc              `..\eCX.....\e
.DE
This IP datagram is being sent out of the serial port.
It contains a TCP SYN datagram
that alerts the remote computer to setup a connection.
The remote host is supposed to reply with a SYN ACK datagram.
This SYN and SYN ACK allows the two hosts to agree on window size,
message size, and the number that is assigned to the first data byte.
The printout is hexadecimal bytes in network order rather than in Intel order.
.PP
A breakdown of the fields in the datagram appears below.
The
.B Seq
number is a random number generated to represent the
first byte of data in your data stream that you wish to send to
.BR raven .
.PP
The TCP software tracks and acknowledges bytes of data:
that's why it emphasizes byte numbers.
Each datagram also has a checksum.
If the checksum does not add up correctly, the remote host tosses the
datagram into the bit bucket.
.PP
The second datagram appears as follows.
The local host has received it from
.BR raven :
.DM
	sl0 recv:
	IP: len 40 137.229.10.39->199.3.32.100 ihl 20 ttl 39 prot TCP
	TCP: 21->1001 Seq x28cb5c00 Ack x138ce21 SYN ACK Wnd 16384
	0000  45 00 00 28 23 ab 00 00 27 06 f4 b1 89 e5 0a 27  E..(#+..'.t1.e.'
	0010  c7 03 20 64 00 15 03 e9 28 cb 5c 00 01 38 ce 21  G. d...i(K\e..8N!
	0020  50 12 40 00 9c 3b 00 00                          P.@..;..
.DE
This a SYN ACK datagram from
.BR raven .
It wants to have a TCP window size (\fBWnd\fR) of 16,384 bytes;
however, in the first datagram you had said that you wanted a window size
of 1,500 bytes.
The protocol specifies that the smaller of the two will be used.
.B raven
has informed you of the first byte in its data stream.
It has also confirmed the first byte in your data stream.
.PP
The third datagram appears as follows.
The local host has sent it to
.BR raven :
.DM
	sl0 sent:
	IP: len 40 199.3.32.100->137.229.10.39 ihl 20 ttl 31 prot TCP
	TCP: 1001->21 Seq x138ce21 Ack x28cb5c01 ACK Wnd 1500
	0000  45 00 00 28 00 01 00 00 1f 06 20 5c c7 03 20 64  E..(...... \eG. d
	0010  89 e5 0a 27 03 e9 00 15 01 38 ce 21 28 cb 5c 01  .e.'.i...8N!(K\e.
	0020  50 10 05 dc d6 60 00 00                          P..\eV`..
.DE
Instruction \fBSeq\fR acknowledges that byte 138ce21 is the position in your
sent data stream.
Instruction \fBAck\fR states that byte 28cb5c01
is the next byte you want from
.BR raven .
.PP
The fourth datagram appears as follows.
The local host has received it from
.BR raven :
.DM
	sl0 recv:
	IP: len 130 137.229.10.39->199.3.32.100 ihl 20 ttl 39 prot TCP
	TCP: 21->1001 Seq x28cb5c01 Ack x138ce21 PSH ACK Wnd 16384
	0000  45 00 00 82 24 0d 00 00 27 06 f3 f5 89 e5 0a 27  E...$...'.su.e.'
	0010  c7 03 20 64 00 15 03 e9 28 cb 5c 01 01 38 ce 21  G. d...i(K\..8N!
	0020  50 18 40 00 ad f4 00 00 32 32 30 20 72 61 76 65  P.@.-t..220 rave
	0030  6e 2e 61 6c 61 73 6b 61 2e 65 64 75 20 46 54 50  n.alaska.edu FTP
	0040  20 73 65 72 76 65 72 20 28 56 65 72 73 69 6f 6e   server (Version
	0050  20 77 75 2d 32 2e 34 28 32 29 20 46 72 69 20 41   wu-2.4(2) Fri A
	0060  70 72 20 32 32 20 31 31 3a 30 30 3a 33 35 20 41  pr 22 11:00:35 A
	0070  4b 44 54 20 31 39 39 34 29 20 72 65 61 64 79 2e  KDT 1994) ready.
	0080  0d 0a                                            ..
.DE
If displayed on the screen, it would appear as follows:
.DM
	220 raven.alaska.edu FTP server (Version wu-2.4(2) Fri Apr 22 11:00:35 AKDT 1994) ready.
.DE
The fifth datagram appears as follows.
The local host sent it to
.BR raven :
.DM
	sl0 sent:
	IP: len 40 199.3.32.100->137.229.10.39 ihl 20 ttl 31 prot TCP
	TCP: 1001->21 Seq x138ce21 Ack x28cb5c5b ACK Wnd 1500
	0000  45 00 00 28 00 02 00 00 1f 06 20 5b c7 03 20 64  E..(...... [G. d
	0010  89 e5 0a 27 03 e9 00 15 01 38 ce 21 28 cb 5c 5b  .e.'.i...8N!(K\[
	0020  50 10 05 dc d6 06 00 00                          P..\V...
.DE
It acknowledges that the local host received the previous message.
.PP
The sixth datagram also goes from the local host to
.BR raven :
.DM
	sl0 sent:
	>IP: len 56 199.3.32.100->137.229.10.39 ihl 20 ttl 31 prot TCP
	TCP: 1001->21 Seq x138ce21 Ack x28cb5c5b PSH ACK Wnd 1500
	0000  45 00 00 38 00 03 00 00 1f 06 20 4a c7 03 20 64  E..8...... JG. d
	0010  89 e5 0a 27 03 e9 00 15 01 38 ce 21 28 cb 5c 5b  .e.'.i...8N!(K\[
	0020  50 18 05 dc 4e 12 00 00 55 53 45 52 20 61 6e 6f  P..\N...USER ano
	0030  6e 79 6d 6f 75 73 0d 0a                          nymous..
.DE
The local command
.B net
has prompted you for a user name, obtained it and stuck it into this datagram.
Note that with FTP, the commands for login identifier and password are
generated on your local host \(em \fInot\fR by the remote host.
.PP
The seventh datagram repeats the sixth:
.DM
	sl0 sent:
	IP: len 56 199.3.32.100->137.229.10.39 ihl 20 ttl 31 prot TCP
	TCP: 1001->21 Seq x138ce21 Ack x28cb5c5b PSH ACK Wnd 1500
	0000  45 00 00 38 00 04 00 00 1f 06 20 49 c7 03 20 64  E..8...... IG. d
	0010  89 e5 0a 27 03 e9 00 15 01 38 ce 21 28 cb 5c 5b  .e.'.i...8N!(K\[
	0020  50 18 05 dc 4e 12 00 00 55 53 45 52 20 61 6e 6f  P..\N...USER ano
	0030  6e 79 6d 6f 75 73 0d 0a                          nymous..
.DE
.B net
did not receive an acknowledgement for the previous datagram, so
it is resending it.
Note that
.B net
uses a ``backoff'' timer system:
When it sends datagram, it sets a timer.
When the timer expires,
.B net
resends the datagram; then doubles the timer's time and set the timer again.
This results in increasing amounts of time being spent waiting between sends.
When
.B net
receives an acknowledgement, it cancels all timers and
sends the next datagram, if there is one.
.PP
For the sake of brevity, we will not show the next five datagrams.
They repeat the previous two, sending them at ever-lengthening intervals.
The acknowledgment of the datagram
.B "USER anonymous"
never came despite seven tries.
At this point, the impatient user pressed the escape key \fB<ctrl-]>\fR
and \fBclose\fRd the FTP session.
.PP
So, what caused the problem?
The datagrams appear to be correct, so
two possible causes come to mind:
the modem does not have modem control turned on, or
an upstream site has botched up the routes.
.PP
If your modem has little lights that flash when data go through,
you can use the command
.B kick
to test the modem.
This command order TCP to ignore the timeout and ``kick'' the next
datagram out to its device.
To invoke this command, press the escape character
.B <ctrl-]>
to return to the
.B net>
prompt, then type
.BR kick .
The modem lights should flash as the datagram goes out the wire.
If they do not, then the problem is somehow involved with your modem
or serial connection.
.Sh "Dump of a Malformed Datagram"
.PP
As noted above, the command
.B trace
analyzes datagrams as it dumps them, and marks any malformed datagrams
that it finds.
For example:
.DM
	sl0 recv:
	IP: len 3338 73.80.32.97->100.100.114.101 ihl 52 ttl 108 tos 10 
	id 18798 offs 45832 DF MF CHECKSUM ERROR (9549)
.DE
This checksum message means something is wrong with the datagrams.
Protocol problems almost always produce this message.
This message can also appear if the modem overruns the serial port,
or if something is wrong in the startup script.
.PP
A closer look at the datagram contents reveals that it is not
an IP datagram at all.
The first digit in an IP datagram usually is 0x45.
This datagram begins with 0x0d \(em a carriage return character:
.DM
	0000  0d 0a 0d 0a 49 6e 76 61 6c 69 64 20 49 50 20 61  ....Invalid IP a
	0010  64 64 72 65 73 73 2c 20 73 6b 69 70 70 69 6e 67  ddress, skipping
	0020  20 62 75 74 7a 65 6e 2d 73 6c 69 70 0d 0a 49 6e   butzen-slip..In
	0030  76 61 6c 69 64 20 49 50 20 61 64 64 72 65 73 73  valid IP address
	0040  2c 20 73 6b 69 70 70 69 6e 67 20 61 64 64 0d 0a  , skipping add..
	0050  50 61 63 6b 65 74 20 6d 6f 64 65 20 65 6e 61 62  Packet mode enab
	0060  6c 65 64 0d 0a                                   led..
.DE
If all your datagrams were like this, then you could assume that
your IP provider had not yet launched SLIP.
.SH "cohulip and DOS"
.PP
You can use
.B cohulip
to access a machine that is running \*(MD.
You can do so via Ethernet or SLIP.
.Sh "cohulip and DOS via SLIP"
.PP
.II "MS-DOS^accessing via SLIP"
.II "Chalmers, Robert"
The following directions, which are adapted from mail by
Robert Chalmers (earth@nanguo.cstpl.com.au) describe how to
get \*(MD and \*(CO to exchange files via SLIP.
.PP
.II WinTrumpet
.II WinSoc
.II WinQvtnet
If you have an \*(MD machine that runs Windows,
get a copy of
.BR WinTrumpet ,
.BR WinSoc ,
and
.BR WinQvtnet .
A copy of Microsoft's TCP/IP would also be helpful.
.PP
To start a SLIP session from Windows to
.BR cohlip ,
do the following:
.IP \(bu 0.3i
Configure your
.B WinSoc/Wintrumpet
set up, using
.B tcpman.exe
to be a SLIP host.
This is easy:
just point and click.
Make sure your hosts are in the the file
.BR Windows\ehosts .
.IP \(bu
Then set up your modem so that it auto-answers.
If it is Hayes-compatible, use the modem command ATS0=1.
.IP \(bu
Run
.BR tcpman ,
so you have the
.B Wintrumpet
window open and telling you that SLIP is started.
You don't need to dial out from your \*(MD machine.
.IP \(bu
Next, invoke
.B net
on your \*(CO machine, with the configuration file used for SLIP.
Then, simply dial the \*(MD machine.
Put only the telephone number of your \*(MD machine into the dialing script
that is part of the
.B attach
command.
.IP \(bu
When the \*(MD side is connected,
click on
.B QvtNet
and open a connection to
the
.B cohulip
host.
.PP
In the blink of an eye, you are connected.
You get a login prompt; from there you can login in,
use FTP to transfer files, and so on.
At this point the Microsoft TCP/IP will also talk to your \*(CO side.
.PP
Note that in some instances, your connection will drop if nothing is
sent through the modem for approximately five minutes.
If this is a problem, use the command
.B ping
to ping the remote site continually.
This will ensure that some datagrams are always moving between your local
host and the remote machine, and so keep the connection open.
.PP
You can also use SLIP to communicate directly serial lines, without
needing modems between the two computers.
Just be sure to use a null modem in your serial line.
For details, see the entries for
.B terminal
and
.B RS-232
in the \*(CO Lexicon.
.Sh "cohulip and DOS via Netware"
.PP
.II Netware
.II "MS-DOS^accessing via Ethernet"
The following directions, which are adapted from a mail message by
Bret Johnson, describe how to connect \*(CO and \*(MD via Ethernet,
using Netware and LAN Workplace (LWP) on the \*(MD side.
.IP \fBGetting the Software\fR
Presumably, you already have a copy of
.BR cohulip .
Contact your local reseller for Unixware and LWP.
.IP "\fBSetting up LAN Workplace for MS-DOS\fR"
First, install LWP as described in the manual.
Then edit configuration files
.BR ETHERS ,
.BR FTPDUSR.LOG ,
.BR RESOLV.CFG ,
and
.BR HOSTS ;
all are in directory
.BR C:\eNET\eTCP :
.RS
.IP \fBETHERS\fR
This file links an Ethernet address to an IP address, as shown in the
following example:
.DM           
	# Ethernet Address	IP Address
	02:00:02:00:df:fe       223.254.254.10
	00:00:1b:33:c4:ac       223.254.254.20
.DE
.IP \fBFTPDUSR.LOG\fR
This is your FTP password file, much like
.BR cohulip 's
file
.BR $NETHOME/ftusers .
An example follows:
.DM
	# username:password
	bret:BRETPASS
	kimberly:KIMPASS
.DE
.IP \fBHOSTS\fR
This file is where you define other computers in your network.
It is analogous to the
.B cohulip
file
.BR net.hosts .
If you have a domain name server (DNS), it will check the DNS first,
then this file.
An example follows:
.DM
	# IP Address    name and optional aliases
	223.254.254.10  bret.bjohns.jcc.com bret
	223.254.254.20  kim.bjohns.jcc.com kim
	127.0.0.1       loopback
	198.234.99.85   olc_mar.odn.ohio.gov reg6
.DE
Other than file
.BR FTPDUSR.LOG ,
this is the only configuration file you really
need to get LWP up and running in a small network.
.RE
.IP "\fBSet your PATH\fR"
Now, set your
.B PATH
to where LWP executable file lives:
.DM
	PATH C:\NET\BIN;%path%
.DE
.IP "\fBTest the Configuration\fR"
Run a few programs to check that everything set up correctly; for example
.DM
	PING 223.254.254.10
.DE
or
.DM
	PING bret
.DE
These should return something like:
.DM
	223.254.254.10 is alive
	bret is alive
.DE
The command
.DM
	FTP 223.254.254.10
.DE
or
.DM
	FTP bret
.DE
should return:
.DM
	220 bjohns FTP version cohulip 2.1 ready
.DE
or:
.DM
	remote name:
.DE
Command
.DM
	TNVT220 223.254.254.10
.DE
or
.DM
	TNVT220 bret
.DE
should return:
.DM
	coherent login:
.DE
.PP
If the tests work out correctly, all should be welland you can safely use
LWP and
.BR cohulip .
.PP
You may encounter some problems access \*(MD from \*(CO.
When you TELNET from \*(CO to a box runing LWP XPC,
.B cohulip
flies past the XPC prompt and exits from the TELNET session.
When you FTP from \*(CO to LWP, you can log in but you never receive
a prompt for a password.
You must explicitly type in
.BR ftp 's
.B pass
command with your password.
.SH "Routing Between Networks"
.PP
.B cohulip
is not robust enough to act as a gateway between two networks.
However, you can use
.B cohulip
to access more than one network simultaneously, and so
(in a very limited way)
you can move files from a machine on one network to a machine on another.
.II "Wright, Randy"
The following descriptions is adapted from mail messages by Randy Wright.
.Sh "Connecting Between Networks"
.PP
Note that because
.B cohulip
is endowed with ``host''-style IP services,
you should be very careful when hooking it into more than one Ethernet
network simultaneously.
That is because
.B cohulip
can create data storms in networks that have more
than one possible path to the any spot on the LAN.
.PP
However, you can use
.B cohulip
on both SLIP and Ethernet simultaneously.
If you have a smallish ``tree'' style LAN and cooperation from your Internet
provider,
you get Internet services directly to the Ethernet-only machines.
The key to this is to set up the routing tables correctly.
Here's an example:
.ie p .PH 1 1 \\*(XD/routing.eps
.el \{\
.DM
                                  |  <-- SLIP to Internet provider
                              +---+------------+ 
                              | cohulip        | 
                              | 199.199.10.01  | <- cocoh.gate.com 
                              +------|---------+
                                     |  <- ethernet network: 199.199.10.0
          +-----------------------------------------------+
          |                                               |
      +---+----------+                                +---+----------+
      | cohulip      | <- coolcoh.gate.com            | SLIK IP      |
      | 199.199.10.2 |                                | 199.199.10.3 | 
      +--------------+             slick.gate.com ->  +--------------+
.DE
\}
.PP	                                    
In this setup, site
.B cocoh.gate.com
is acting as a SLIP \(<-\(-> Ethernet router.
The network is simple enough that this is a practical thing to do.
The trick is setting up the routing tables correctly.
The routing table for site
.B cocoh
contains the following entries:
.DM
	default	        sl0
	199.199.10.2    ne0
	199.199.10.3    ne0
.DE
To set these, add the following commands to
.BR coco 's
startup script:
.DM
	route add default sl0
	route add 199.199.10.2 ne0
	route add 199.199.10.3 ne0
.DE
The routing tables for sites
.B coolcoh
and
.B slick
are:
.DM
	default         ne0
.DE
Add the following command to each site's startup script:
.DM
	route add default ne0
.DE
If your Internet provider can be persuaded to route all datagrams
destined for network 199.199.10.0 to site
.B cocoh
(if it is up), then sites
.B coolcoh
and
.B slick
will be able to
.BR ftp ,
.BR telnet ,
etc., over the Internet.
.PP
If the Internet provider provides excellent service,
he might be persuaded to provide entries in his name server to
resolve the names
.B coolcoh.gate.com
and
.B slick.gate.com
as well as
.BR cocoh.gate.com .
You'll probably need to buy full-time connectivity
to get this level of service, but that is what is needed for all the
Internet world to be able to find you by name.
.PP
This kind of network is acceptable for many more hosts on the Ethernet than the
simple 3 that are shown here.
Note, however, that there is two big limitation to this arrangement.
First, the machines on the LAN can access the Internet only while the machine
with SLIP is dialed into your Internet provider.
Second,
.B cohulip
is not robust enough to know whether a machine on the LAN is ``on the air''
or not; thus, it cannot send the message ``host unreachable''
should someone the Internet attempt to send a datagram to a machine on
your LAN that was inaccessible.
If, however, intermittent access is acceptable on your LAN, and if
you are willing to subject remote users to a ``no answer'' situation
rather than the pleasanter ``host unreachable'' message, then
.B cohulip
can provide some rudimentary but useful routing services.
.Sh "Firewall Between Networks"
.PP
If the Internet service provider does not co-operate, then you must
use a two-step transfer to move data between the Ethernet-only
machines and the Internet.
In this way,
.B cohulip
can serve as a firewall between two networks.
In this method, you run two versions of
.BR net :
one configured for Ethernet and the other for SLIP.
.PP
To begin,
you must create two versions of your startup script:
one for the network accessed via SLIP, and the other for the network
accessed via Ethernet.
Call one
.B startup.slip
and the other
.BR startup.ether .
.PP
.B startup.net
should invoke the
.B telunix
server as well as those for TELNET and FTP.
Invoke it with the command:
.DM
	net startup.ether
.DE
Let this copy of
.B net
run all the time.
You can embed the command in script
.BR /etc/rc ,
so that it is invoked automatically when you boot your system.
.PP
.B startup.slip
should be configured for SLIP, and to dial the Internet provider.
A user on a machine with Ethernet-only access would use
.B telunix
to log into the ``firewall'' machine, then run the command
.DM
	net startup.slip
.DE
to access the Internet.
In this way, all users on all Ethernet machines can
access the Internet via SLIP,
but the Internet cannot have access to anything on your Ethernet.
.SH "telunix \(em Remote Login"
.PP
The
.B telunix
server lets users on remote system log into your system via the application
.BR telnet .
Unlike
.BR telnet ,
.B telunix
provides a modicum of login protection for your system.
.PP
Before you can use
.BR telunix ,
you must have installed pseudo-ttys into your kernel.
If you did not do so when you installed \*(CO onto your system, you can do
so now.
For information on how to do this, read the entry for
.B pty
in the \*(CO Lexicon.
.PP
To enable the login server,
use the command:
.DM
	start telunix
.DE
You can give this either from command prompt or from within a startup file.
By default, the login server is connected to socket 513; however,
.B telunix
takes an optional second argument with which you can set the socket
to which the is connected.
.PP
If a user simply closes the TELNET session while logged in, it appears
that the login closes normally, but there is no mechanism for closing the
TELNET session when a user logs out.
Also, there is no processing of user's end-of-line sequence.
You may wish to put something like the following into file
.B $HOME/.profile
of every user who will log in only via
.BR telunix :
.DM
	stty -echo
	echo "Welcome Message ..."
	echo "To prevent double prompts, do "eol unix" before starting telnet." 
	echo "Use "exit" to log off, then "close" from your end to close session."
	cd /usr/public  # or whatever you want to do with him...
.DE
What you do with this guy after he logs on to your machine is up to you.
.SH "Traffic Jams on the Information Superhighway"
.PP
Computer networks, like disk drives, suffer from a corollary to
Parkinson's Law:
that is, data immediately increases to fill the space available to it.
However, there are ways to cope with this congestion, to ensure that
your jobs are executed as quickly as possible.
.PP
The following information should be helpful to user who use
.BR cohulip 's
SLIP to access the Internet.
The information can also be applied to busy LANs over Ethernet.
.II "Wright, Randy"
It was adapted from mail messages written by Randy Wright.
.PP
To begin, you must remember that traffic conditions on the Internet
vary from second to second.
Sometimes the traffic is heavy; other times, it is light.
(The easiest solution to a congestion problem is to defer your
Internet work until traffic light \(em generally, during the middle
of the night.)
It is also worth noting that some
Internet providers oversell their bandwidth.
You may be sharing a 56-kilobaud link with another 50 sites, or more.
.PP
These situations present traffic situations to which TCP reacts
in defined ways.
Thus, you can tune TCP to react optimally to various traffic loads.
.Sh "Basics of TCP"
.PP
This is a
.I simplified
explanation of some TCP features.
It is somewhat technical, but it has been trimmed and edited to make it
easier for novices to grasp.
.PP
TCP has some sophisticated mechanisms to detect and respond to
network errors and slowdowns.
It keeps track of how long the typical round-trip time
is between the endpoints of the connection.
.II SRTT
.II "smoothed round-trip time"
Using statistical techniques, it constantly updates a value
known as the smoothed round-trip time (SRTT), and the mean
deviation from that SRTT.
The values lets your local host determine how long it should expect
to wait before the remote host acknowledges the data it has sent.
.II "timeout value"
We will call this interval of time the
.IR "timeout value" .
And yes, TCP does expect the remote host to acknowledge receipt of every
byte sent.
This mechanism stops TCP from jamming more data into a
connection may already be choked with data.
.PP
.II "window size"
TCP has a user-settable number known as the
.IR "window size" .
TCP will not allow more than that window-size bytes of data to be
unacknowledged at any one time.
Thus, no more than
.I window-size
bytes can be unacknowledged for
.I timeout
miliseconds before TCP concludes that something went wrong
and begins to retransmit the unacknowledged data.
.PP
In brief, a TCP sender expects the TCP receiver to say ``thank you''
for each byte received.
If the gratitude is not forthcoming,
a TCP sender, in effect, clears its throat and restates itself
over and over until the receiver responds correctly.
The sender will not stop asking for acknowledgement until hell freezes over.
.PP
If the dialogue between the TCP receiver and the TCP sender
gets out of hand, a higher-level protocol (such as FTP)
or the user may intervene, usually by aborting the connection.
.BR cohulip 's
implementation of FTP
is not robust enough to detect a stalled transfer, so you must do it by hand.
.PP
If traffic is light on the networks and no equipment is malfunctioning,
the acknowledgements normally do arrive before TCP's timeout occurs.
However, if there is heavy traffic, datagrams can get stuck in long queues
that exists all over the networks.
Remember, to get from your local host to the remote host, a datagram must
pass through several intervening machines, perhaps as many as a dozen or more.
.II routing
(The number of machines through which the datagram must pass is based on the
.I routing
by which the datagram moves from your machine to the remote host.
Routing is something of a black art, and is discussed elsewhere.)
.PP
When the TCP sender does not receive acknowledgement of the receipt of
a datagram within the expected time, it enters a kind of congestion mode.
It retransmits the unacknowledged datagram (or datagrams), but
uses a special
.I backoff
facility to increase the timeout \(em that is, to back off from
retransmission.
The sender will retransmit repeatedly until it receives an acknowledgement;
however, with each retransmission, it increases its timeout value.
This mechanism of increasing the timeout value is part of the TCP protocol;
it is designed to help prevent the ``gridlock'' that occurs on the Internet
when sending sites continually retransmit data into a choked connection.
.Sh "How To Tune Your TCP Timer"
.PP
TCP limits how much it will increase its timeout value \(em that is,
it limits the degree to which it will back off from retransmission.
We call this value its
.IR "maximum backoff" .
.PP
.B cohulip
offers two differs ways by which TCP can compute its backoff value:
linear and exponential.
.I Linear
computation increases the timeout by an equal ammount with each retransmission.
.I Exponential
computation doubles the timeout with each retransmission.
.PP
At the prompt
.BR net> ,
you can change the timer type and maximum backoff.
The command is:
.DM
	tcp timer [linear|exponential] [<max backoff minutes>]
.DE
The default is a linear computation and a 30-minute maximum backoff.
As delivered,
.B cohulip
does not allow you to set the maximum backoff to more than five minutes.
If your connection's timeout value has increased to one minute,
in all probability the connection is broken and you should quit.
.PP
Note that if your modem overruns the serial port,
your TCP system can be fooled into believing there is a congestion problem.
You should use a 16550 UART if your modem is faster than 2400 baud.
For details, see the entries for
.B modem
and
.B asy
in the \*(CO Lexicon.
.Sh "How To Detect Congestion"
.PP
On a TELNET session, congestion is obvious:
when you type a key, nothing happens.
.PP
On an FTP session, however, it is more difficult to detect congestion, because
FTP does much of its work silently, in the background.
.II "ftp^hash"
Before you use FTP to transmit or receive a file,
you should type the command
.B hash
at the
.BR ftp>
prompt.
This tells FTP
to display the ``hash'' character `#' whenever it sends or receive
one kilobyte of data.
(Note that FTP's
hash command has nothing to do with hash tables, which is a programming
technique for looking up data quickly.)
.II "ftp^abort"
This feature lets you observe the movement of data;
if transmission appears to be stalled, you can then invoke the FTP command
.B abort
to abort the transmission, and try again later.
.PP
.II "tcp^status"
To observe TCP's status in detail, use
.BR net 's
command
.BR "tcp status" .
(NB, you must enter this command at the prompt
.BR net> ;
it will not do anything if you type it at the
.B ftp>
prompt.)
This command comes in two flavors:
.DS
	\fBtcp status\fR
	\fBtcp status \fItcb\fR
.DE
The first version of this command lists all the
TCP connections or potential connections currently available.
The following gives an example of its output:
.DM
	conout 1, conin 0, reset out 0, runt 0, chksum err 0, bdcsts 0
	    &TCB RcvQ SndQ Local socket            Remote socket           State
	  406284    0    0 stalo:1001              rwsyss.wimsey.b:ftp     Estab.
	  405ebc    0    0 stalo:echo              0.0.0.0:0               Listen   (S)
	  40608c    0    0 stalo:telnet            0.0.0.0:0               Listen   (S)
	  405fa4    0    0 stalo:ftp               0.0.0.0:0               Listen   (S)
.DE
This display shows that there is one
.B conout
(or outgoing connection),
and that it is an FTP conection between systems
.B stalo
and
.BR rwsyss .
.II "datagram^runt"
The first line of the status display also states that there have been
no runt datagrams (i.e., no datagrams that are too small),
and no checksum errors (i.e., your modem is operating correctly).
.PP
The second version of the command
.B "tcp status"
displays detailed information about a given TCP session.
.II "TCP control block"
.II TCB
To elicit this information, you must pass
.B "tcp status"
the address of the TCP session's TCP control block (TCB).
In the above display, a session's TCB is the hexadecimal number
in the column that is headed
.BR &TCB .
.PP
For example, the above display shows that TCB of the FTP session connecting
.B stalo
and
.B rwsyss
has an address of 406284.
Therefore, to see detailed information on this session, we type:
.DM
	tcp status 406284
.DE
This displays the following:
.DM
	Local: stalo:1001 Remote: rwsyss.wimsey.b:ftp State: Estab.
	      Init seq    Unack     Next Resent CWind Thrsh  Wind  MSS Queue      Total
	Send:   1e8480   1e8497   1e8497      0  1047 65535  4096 1024     0         22
	Recv: db5b68c3          db5b6951      0              6000          0        141
	Backoff 0 Timer stopped SRTT 1449 ms Mean dev 835 ms
.DE
This tells me some details on our FTP connection between
.B stalo
and
.BR rwsyss .
In particular, the fifth line of the status display shows the condition
of the timer; we will call this the
.IR "timer-status line" .
.PP
In the above example, the timer-status line has four fields:
.DS
	Backoff value
	Timer state (started or stopped)
	SRTT time, in milliseconds
	Mean deviation, in milliseconds
.DE
The backoff value is an integer from 0 to 255.
This value gives the total backoff time in terms of a number of multiples
of the standard backoff time.
Remember that when TCP retransmits a datagram, it increases the total backoff
time:
if it is using the linear method, it adds the standard backoff time to the
total backoff time; whereas if it is using the exponential method, it doubles
the total backoff time.
If the backoff value is greater than zero, TCP has begun to retransmit
datagrams;
if you know the method by which TCP computes the total backoff time,
you can quickly figure out how many times TCP has retransmitted a datagram.
.PP
The timer state gives the state of the time:
either
.B stopped
or
.BR running .
If the timer state is
.BR running ,
the timer-status line also shows the amount of time left to run,
and the current timeout value in milliseconds.
.PP
Under good conditions, the value of backoff stays at zero or 1.
If the value of backoff reaches ten,
the timer will probably be running and it will be
nearing one minute between retries; at this point,
you probably should try to leave off the Internet, because you are running
up your telephone bill for no good purpose.
.Sh "What To Do If TCP Is Jammed"
.PP
First, you can ``kick'' TCP.
There are two ways to do this.
.PP
.II kick
If the current session is the one you want to kick, just go to the
.B net>
prompt and type:
.DM
	kick
.DE
.II "tcp^kick"
But if you want to kick your FTP data connection or the connection
of some incoming session with your servers, use the command
.DS
	tcp kick \fItcb_address\fR
.DE
where
.I tcp_address
is the address of the session's TCP control block, as displayed by the command
.BR "tcp status" .
This command forces TCP to retransmit immediately any unsent data or
acknowledgment datagrams.
.PP
The ``kick'' commands
do not help if you are the receiving a file via FTP.
Only the sending party can kick things effectively.
.PP
Second, trying increasing the size of the window and the MSS.
When you installed
.BR cohulip ,
the installation program embedded the commands
.DM
	tcp mss 1500
	tcp window 1500
.DE
in your default startup script.
You can try increasing these values, for example, to 6,000 bytes.
The larger the size of a datagram, the more efficient your connection
will be \(em within reason, of course.
Note that increasing the size of a value will not affect the operation of
any sessions that are being executed at that moment.
.PP
When you connect to a remote site, your site and it negotiate over the
maximum size of a datagram, with the smaller of the two values being used.
You can use the command
.B trace
to copy that negotiation into a file.
If the remote site ``bids'' a very large size for datagrams,
you probably can increase the size of your datagrams without risking that
a site that stands between you and the remote host will fragment your
datagrams.
.PP
If all else fails, try working late at night.
