# 
# Informix 4GL program to insert data into UPS Ground Service Zone 
# Chart (ground) table.
# By Vladimir Smelyansky at Mark Williams Co. 10-10-90
#
# Changed to function 10-30-90 by vlad
#
DATABASE mwc

GLOBALS "globals0.4gl"

FUNCTION ups_grzone()

	OPEN FORM current_form FROM "ground"
	DISPLAY FORM current_form

	MENU ""
	COMMAND "Add" "Add a new row"
		INPUT BY NAME p_ground.*
		INSERT INTO ground VALUES (p_ground.*)

	COMMAND "Find" "Find the row"
		CALL grzn_find()
		IF chosen THEN
			NEXT OPTION "Modify"
		END IF

	COMMAND "Modify" "Modify the row"
		IF chosen THEN
			CALL grzn_modify()
		ELSE 
			CALL msgs("No row has been chosen.")
		END IF 
		NEXT OPTION "Find"

	COMMAND "Delete" "Delete the row"
		CALL msgs("")
		IF chosen THEN
			CALL yn("Are you sure <y/n> ?") RETURNING answer
			IF answer = "y" THEN
				DELETE FROM ground
				  WHERE from_zip = p_ground.from_zip
					AND zone = p_ground.zone
				LET chosen = FALSE
				CLEAR FORM
			END IF
		ELSE
			CALL msgs("No row has been chasen.")
		END IF
		NEXT OPTION "Find"

	COMMAND "Report" "Print report"
		CALL report_out()

	COMMAND "Exit" "Exit from program"
		EXIT MENU
	END MENU

	CLOSE FORM current_form
	CLEAR SCREEN
END FUNCTION

#
# Find entry in the ground table
#
FUNCTION grzn_find()
	DEFINE  exist 	SMALLINT,
		answer	CHAR(1)

	CLEAR FORM

	CONSTRUCT query1 ON ground.* FROM ground.*

	LET s1 = "SELECT * FROM ground WHERE ",
		query1 CLIPPED

	PREPARE s_w FROM s1

	DECLARE qg_curs CURSOR FOR s_w

	LET exist = FALSE
	LET chosen = FALSE

	FOREACH qg_curs INTO p_ground.*
		LET exist = TRUE

		DISPLAY BY NAME p_ground.*

		CALL yn("Select this row <y/n> ?") RETURNING answer

		IF answer = "y" THEN
			LET chosen = TRUE
			EXIT FOREACH
		END IF

	END FOREACH

	CLOSE qg_curs

	IF exist = FALSE THEN
		CALL msgs("No entry found")
	ELSE
		IF chosen = FALSE THEN
			CALL msgs("No more enrty")
		END IF
	END IF
END FUNCTION	

#
# Modify row in the ground table
#
FUNCTION grzn_modify()

	INPUT BY NAME p_ground.*
		WITHOUT DEFAULTS

	UPDATE ground
		SET ground.* = p_ground.*
		WHERE from_zip = p_ground.from_zip
END FUNCTION

# Print report
FUNCTION report_out()

	DECLARE gr_curs CURSOR FOR SELECT * FROM ground

	START REPORT gr_report

	FOREACH gr_curs INTO p_ground.*
		OUTPUT TO REPORT gr_report(p_ground.*)
		CALL msgs("Reporting ....")
	END FOREACH

	FINISH REPORT gr_report

	CLOSE gr_curs

	CALL msgs("Done")
END FUNCTION

#
# Print UPS Zone Chart for ground service
# 
REPORT gr_report(p_ground)
	DEFINE p_ground RECORD LIKE ground.*

	OUTPUT
		TOP MARGIN 0
		BOTTOM MARGIN 0
		LEFT MARGIN 20
		PAGE LENGTH 80
		REPORT TO PIPE "c10 | lp"

	ORDER BY p_ground.from_zip

	FORMAT

	PAGE HEADER 
		PRINT "UPS Shipping Charges & Zone Chart"
		PRINT
		PRINT COLUMN 10, "Mark Williams Co",
			COLUMN 40, "UPS shipper number: IL 612-750"
		PRINT
		PRINT "Ground Service Zone Chart for IL: 60062" 
		SKIP 4 LINES
		PRINT 	" Zip", COLUMN 8, "Pref", 
			COLUMN 15, "Zone"
		SKIP 1 LINE

	 ON EVERY ROW
		PRINT   p_ground.from_zip USING " &&&", 
			COLUMN 5, p_ground.to_zip USING " - &&&",
			COLUMN 15, p_ground.zone USING "###"
END REPORT			
					 

