#
# Code to maintain states and countrys file
#
GLOBALS "globals0.4gl"

FUNCTION state_menu()
	DISPLAY FORM state_form

	LET chosen = FALSE

	MENU "STATES"
	COMMAND "Add" "Add a new state"
		LET answer = "y"
		WHILE answer = "y"
			CALL enter_state()

			CALL yn("Enter another state <y/n>")
				RETURNING answer
		END WHILE

	COMMAND "Query" "Search for a state"
		CALL query_state()

		IF chosen THEN
			NEXT OPTION "Modify"
		END IF

	COMMAND "Modify" "Modify a state"
		IF chosen THEN
			CALL change_state()
		ELSE
			MESSAGE "No state has been chosen. ",
				"Use the Query option"
			NEXT OPTION "Query"
		END IF

	COMMAND "Delete" "Delete a state"
		IF chosen THEN
			CALL yn("Are you sure <y/n>")
				RETURNING answer

			IF answer = "y" THEN
				CALL delete_state()
				LET chosen = FALSE
			END IF
		ELSE
			MESSAGE "No state has been chosen. ",
				"Use the Query option"
			NEXT OPTION "Query"
		END IF

	COMMAND "Report" "Report on all States and Countrys"
		DECLARE st_curs CURSOR FOR SELECT * FROM states

		START REPORT state_list

		FOREACH st_curs INTO p_states.*
			OUTPUT TO REPORT state_list(p_states.*)
		END FOREACH

		FINISH REPORT state_list

		CLOSE st_curs
	COMMAND "Exit" "Leave this menu."
		EXIT MENU
	END MENU

	CLEAR SCREEN
END FUNCTION

REPORT state_list(p_states)
	DEFINE p_states RECORD LIKE states.*

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		RIGHT MARGIN 70
		PAGE LENGTH 80

	ORDER BY p_states.country, p_states.state

	FORMAT
	PAGE HEADER
		PRINT "States and Countries"
		SKIP 2 LINES

	ON EVERY ROW
		LET p_dest.dest_name = NULL

		SELECT	*
		  INTO	p_dest.*
		  FROM	dests
		 WHERE	dest_no = p_states.dest_no

		PRINT	p_states.country, " ",
			p_states.state,
			p_states.blue_zone USING "####",
			p_states.red_zone USING "####",
			p_states.dest_no USING "###", " ",
			p_dest.dest_name
END REPORT

# Check that p_states does not duplicate existing entry
FUNCTION state_dup()
	DEFINE ctr SMALLINT

	IF p_states.state IS NULL THEN
		IF p_states.country IS NULL THEN
			MESSAGE "No state or country"
			RETURN 0
		ELSE
			SELECT	COUNT(*) INTO ctr FROM states
			 WHERE 	state IS NULL AND
	 			country = p_states.country
		END IF
	ELSE
		IF p_states.country IS NULL THEN
			SELECT	COUNT(*) INTO ctr FROM states
			 WHERE 	state = p_states.state AND
	 			country IS NULL
		ELSE
			SELECT	COUNT(*) INTO ctr FROM states
			 WHERE 	state = p_states.state AND
	 			country = p_states.country
		END IF
	END IF

	IF ctr > 0 THEN
		MESSAGE "Duplicate entry"
		RETURN 0
	END IF

	RETURN 1
END FUNCTION

FUNCTION enter_state()
	MESSAGE ""
	CLEAR FORM

	INPUT BY NAME p_states.*
	AFTER FIELD dest_no
		IF p_states.dest_no IS NULL THEN
			NEXT FIELD dest_no
		END IF

		SELECT	*
		  INTO	p_dest.*
		  FROM	dests
		 WHERE	dest_no = p_states.dest_no

		IF status = NOTFOUND THEN
			NEXT FIELD dest_no
		END IF

		DISPLAY BY NAME p_dest.dest_name
	END INPUT

	CALL state_dup() RETURNING i_no

	IF i_no = 0 THEN
		RETURN
	END IF

	INSERT INTO states VALUES (p_states.*)

	MESSAGE "Row added"
END FUNCTION

FUNCTION query_state()
	DEFINE exist SMALLINT

	CLEAR FORM

	CONSTRUCT BY NAME query1 ON states.*

	LET s1 = "SELECT * FROM states WHERE ", query1 CLIPPED

	PREPARE s_1 FROM s1

	DECLARE ts_curs CURSOR FOR s_1

	LET exist = FALSE
	LET chosen = FALSE

	FOREACH ts_curs INTO p_states.*
		LET exist = TRUE

		DISPLAY BY NAME p_states.*

		SELECT	*
		  INTO	p_dest.*
		  FROM	dests
		 WHERE	dest_no = p_states.dest_no

		DISPLAY BY NAME p_dest.dest_name

		CALL yn("Enter 'y' to select this state")
			RETURNING answer

		IF answer = "y" THEN
			LET chosen = TRUE
			EXIT FOREACH
		END IF
	END FOREACH

	CLOSE ts_curs

	IF exist = FALSE THEN
		MESSAGE "No state found"
	ELSE
		IF chosen = FALSE THEN
			MESSAGE "No more states"
		END IF
	END IF
END FUNCTION

FUNCTION change_state()
	DEFINE s RECORD LIKE states.*

	MESSAGE ""
	LET s.state = p_states.state
	LET s.country = p_states.country

	INPUT BY NAME p_states.*
		WITHOUT DEFAULTS
	AFTER FIELD dest_no
		IF p_states.dest_no IS NULL THEN
			NEXT FIELD dest_no
		END IF

		SELECT	*
		  INTO	p_dest.*
		  FROM	dests
		 WHERE	dest_no = p_states.dest_no

		IF status = NOTFOUND THEN
			NEXT FIELD dest_no
		END IF

		DISPLAY BY NAME p_dest.dest_name
	END INPUT

	IF s.state IS NULL THEN
		DELETE FROM states
		 WHERE state IS NULL AND country = s.country
	ELSE
		 IF s.country IS NULL THEN
			DELETE FROM states
			 WHERE state = s.state AND country IS NULL
		ELSE
			DELETE FROM states
			 WHERE state = s.state AND country = s.country
		END IF
	END IF

	INSERT INTO states VALUES (p_states.*)

	MESSAGE "Row changed"
END FUNCTION

FUNCTION delete_state()
	IF p_states.state IS NULL THEN
		DELETE FROM states
		 WHERE state IS NULL AND country = p_states.country
	ELSE
		 IF p_states.country IS NULL THEN
			DELETE FROM states
			 WHERE state = p_states.state AND country IS NULL
		ELSE
			DELETE FROM states
			 WHERE state = p_states.state AND
			       country = p_states.country
		END IF
	END IF
	CLEAR FORM
	MESSAGE "Row deleted"
END FUNCTION
