#
# Strange reports not on normal menu
#
GLOBALS "globals0.4gl"

#
# Which report do we run?
#
MAIN
	OPTIONS MESSAGE LINE 22,
		PROMPT LINE 21,
		DELETE KEY CONTROL-V,
		NEXT KEY CONTROL-N,
		PREVIOUS KEY CONTROL-P

	OPEN FORM big_form FROM "mainline"
	DISPLAY FORM big_form

	MENU "REPORT"
	COMMAND "Detail" "Detail report for credit"
		CALL a_report(2)
	COMMAND "Mail" "Mailing labels"
		CALL ad_report(2)
	COMMAND "State" "Sales by state"
		CALL st_report()
	COMMAND "Address" "Report by addr for rs"
		CALL ad_report(1)
	COMMAND "File" "File output for accting"
		CALL a_report(1)
	COMMAND "Xfile" "Detail file for accting"
		CALL a_report(4)
	COMMAND "Bounce" "Bounced Check report"
		CALL b_report(0)
	COMMAND "Com" "Commercial Invoice forms"
		CALL a_report(3)
	COMMAND "Hip" "Shipping Report"
		CALL b_report(1)
	COMMAND "Exit" "Exit report menu"
		EXIT MENU
	END MENU
END MAIN

#
# This sets up the bounced check report.
#
FUNCTION b_report(sw)
	DEFINE sw SMALLINT

	CONSTRUCT BY NAME query1 ON
		invoice_no, invoice_date, ship_date, ship_no,
		invoice.term_no, itotal, back_flag

	CASE
	WHEN sw = 0
		LET s1 = "SELECT * FROM invoice, customer ",
			 " WHERE bounce IS NOT NULL",
			   " AND customer.cust_no = invoice.cust_no AND ",
			 query1 CLIPPED
	WHEN sw = 1
		LET s1 = "SELECT * FROM invoice, customer, terms",
			 " WHERE customer.cust_no = invoice.cust_no",
			 "   AND terms.term_no = invoice.term_no",
			 "   AND ", query1 CLIPPED
	END CASE

	PREPARE s_9 FROM s1

	DECLARE bo_curs CURSOR FOR s_9

	MESSAGE ""

	CASE
	WHEN sw = 0
		START REPORT bo_report

		FOREACH bo_curs INTO p_invoice.*, p_cust.*
			OUTPUT TO REPORT bo_report(p_invoice.*, p_cust.*)
		END FOREACH

		FINISH REPORT bo_report
	WHEN sw = 1
		LET qtot[1] = 0
		LET qtot[2] = 0
		LET finTot[1] = 0
		LET finTot[2] = 0

		START REPORT sh_report

		FOREACH bo_curs INTO p_invoice.*, p_cust.*, p_term.*
			# Calculate delay
			LET p_invoice.term_no = p_invoice.ship_date -
						p_invoice.invoice_date
			IF p_invoice.term_no IS NULL THEN
				LET p_invoice.term_no = 20000
			END IF

			OUTPUT TO REPORT
			  sh_report(p_invoice.*, p_cust.*, p_term.*)
		END FOREACH

		FINISH REPORT sh_report
	END CASE 

	CLOSE bo_curs
END FUNCTION

#
# Bounced check report
#
REPORT bo_report(i, c)
	DEFINE i RECORD LIKE invoice.*
	DEFINE c RECORD LIKE customer.*

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	FORMAT
	PAGE HEADER
		PRINT	PAGENO USING "page <<<", 20 SPACES,
			"Bounced Check Report", 20 SPACES, TODAY
		PRINT	query1 CLIPPED
		PRINT	"invoice  phone", 30 SPACES,
			"name", 35 SPACES, "amount"
		SKIP 2 LINES

	ON EVERY ROW
		PRINT	i.invoice_no USING "#####", " ",
			c.phone_no,
			c.contact, i.itotal USING "##,###.##"
END REPORT

#
# Shipping Report
#
REPORT sh_report(i, c, t)
	DEFINE i RECORD LIKE invoice.*
	DEFINE c RECORD LIKE customer.*
	DEFINE t RECORD LIKE terms.*
	DEFINE c_amt LIKE invoice.itotal

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY i.term_no, i.ship_no, i.invoice_no

	FORMAT
	PAGE HEADER
		PRINT	PAGENO USING "page <<<", 31 SPACES,
			"Shipping Report", 31 SPACES, TODAY, "  ", TIME
		PRINT	query1 CLIPPED
		PRINT	"invoice    date      ",
			"name", 17 SPACES, 
			"shipper", 12 SPACES,
			"amount   ship date     bf    credit  terms"
		SKIP 1 LINE

	ON EVERY ROW
		LET qtot[1] = qtot[1] + 1
		LET finTot[1] = finTot[1] + i.itotal

		SELECT SUM(cmemo.amount)
		  INTO c_amt
		  FROM cmemo
		 WHERE cmemo.invoice_no = i.invoice_no
		
		PRINT	i.invoice_no USING "#####", "   ",
			i.invoice_date, "   ",
			c.contact[1, 20], " ",
			p_ship.ship_name, " ",
			i.itotal USING "##,###.##", "  ",
			i.ship_date, " ",
			i.back_flag, " ",
			c_amt USING "##,###.##", "  ",
			t.term_name

		IF i.term_no > 10 AND i.icomments IS NOT NULL THEN
			PRINT	4 SPACES, i.icomments
		END IF

	BEFORE GROUP OF i.ship_no
		SELECT * INTO p_ship.* FROM shippers
		 WHERE ship_no = i.ship_no

	BEFORE GROUP OF i.term_no
		SKIP 1 LINE
		CASE
		WHEN i.term_no = 20000
			PRINT "No ship date on record."
		WHEN i.term_no = 0
			PRINT "Shipped that day."
		OTHERWISE
			PRINT "Shipping delay ", i.term_no USING "-<<<<"
		END CASE
		SKIP 1 LINE

	AFTER GROUP OF i.term_no
		SKIP 1 LINE
		PRINT	qtot[1] USING "#####", 49 SPACES,
			finTot[1] USING "##,###,###.##"

		LET qtot[2] = qtot[2] + qtot[1]
		LET finTot[2] = finTot[2] + finTot[1]
		LET qtot[1] = 0
		LET finTot[1] = 0

	ON LAST ROW
		SKIP 1 LINE
		PRINT	qtot[2] USING "#####", 49 SPACES,
			finTot[2] USING "##,###,###.##"
END REPORT

#
# This sets up the detail report, the output file for accounting and
# the commercial invoice forms.
#
FUNCTION a_report(sw)
	DEFINE sw SMALLINT

	CONSTRUCT BY NAME query1 ON
		invoice.invoice_no, invoice_date, customer.contact, phone_no,
		invoice.icomments, invoice.inq_src, term_no, discount, taxes,
		inv_line.prod_no

	LET s1 = "SELECT * FROM customer, invoice, inv_line ",
		 "WHERE invoice.cust_no = customer.cust_no AND ",
		 "inv_line.invoice_no = invoice.invoice_no AND ",
		 query1 CLIPPED

	PREPARE s_2 FROM s1

	DECLARE q_curs CURSOR FOR s_2

	FOR counter = 1 TO 3 # clear totals
		LET qtot[counter] = 0
		LET dTot[counter] = 0
		LET subTot[counter] = 0
		LET taxTot[counter] = 0
		LET finTot[counter] = 0
		LET shipTot[counter] = 0
	END FOR

	MESSAGE ""

	CASE
	WHEN sw = 1
		START REPORT f_report

		FOREACH q_curs INTO p_cust.*, p_invoice.*, p_line.*
			OUTPUT TO REPORT f_report(p_invoice.*)
		END FOREACH

		FINISH REPORT f_report
		run "doscp acct.fil /dev/fd0"

	WHEN sw = 2
		START REPORT d_report
		
		FOREACH q_curs INTO p_cust.*, p_invoice.*, p_line.*
			SELECT SUM(amount) INTO ctotal FROM cmemo
			 WHERE cmemo.invoice_no = p_invoice.invoice_no

			IF ctotal <> 0 THEN
				LET p_invoice.discount = ctotal

				OUTPUT TO REPORT
					d_report(p_cust.*, p_invoice.*)
			END IF
		END FOREACH

		FINISH REPORT d_report

	WHEN sw = 3
		START REPORT com_report

		FOREACH q_curs INTO p_cust.*, p_invoice.*, p_line.*
			OUTPUT TO REPORT
				com_report(p_cust.*, p_invoice.*, p_line.*)
		END FOREACH
		
		FINISH REPORT com_report

	WHEN sw = 4
		START REPORT x_report

		FOREACH q_curs INTO p_cust.*, p_invoice.*, p_line.*
			OUTPUT TO REPORT
				x_report(p_invoice.*, p_line.*)
		END FOREACH
		
		FINISH REPORT x_report
	END CASE

	CLOSE q_curs
END FUNCTION

#
# This sets up sales by state
#
FUNCTION st_report()
	CONSTRUCT BY NAME query1 ON
		state, country, zipcode,
		invoice_date, icomments, prod_no, inq_src

	LET s1 = "SELECT * FROM invoice, address, inv_line ",
		 "WHERE add_type <> \"b\" AND ",
		 "address.cust_no = invoice.cust_no AND ",
		 "inv_line.invoice_no = invoice.invoice_no AND ",
		 query1 CLIPPED

	PREPARE s_4 FROM s1

	DECLARE x_curs CURSOR FOR s_4

	FOR counter = 1 TO 3 # clear totals
		LET qtot[counter] = 0
		LET dTot[counter] = 0
	END FOR

	MESSAGE ""

	START REPORT s_report
		
	FOREACH x_curs INTO p_invoice.*, s_address.*, p_line.*
		IF s_address.country IS NULL THEN
			LET s_address.country = " USA"
		END IF

		IF s_address.state IS NULL THEN
			LET s_address.state = " - "
		END IF

		OUTPUT TO REPORT
			 s_report(s_address.*, p_line.*)
	END FOREACH

	FINISH REPORT s_report

	CLOSE x_curs
END FUNCTION

#
# State report
#
REPORT s_report(a, l)
	DEFINE a RECORD LIKE address.*
	DEFINE l RECORD LIKE inv_line.*

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY a.country, a.state, a.cust_no

	FORMAT
	PAGE HEADER
		PRINT	PAGENO USING "page <<<", 16 SPACES, "Sales by State",
			10 SPACES, TODAY
		PRINT	query1 CLIPPED
		PRINT	18 SPACES, "Items", 10 SPACES, "Customers"
		SKIP 2 LINES

	AFTER GROUP OF a.state
		IF a.country = " USA" OR a.country = "CANADA" THEN
			PRINT a.state, 
			      10 SPACES,
			      qtot[1] USING "###,###",
			      10 SPACES,
			      dTot[1] USING "###,###"
		END IF
		LET qtot[2] = qtot[2] + qtot[1]
		LET qtot[1] = 0
		LET dTot[2] = dTot[2] + dTot[1]
		LET dTot[1] = 0
		
	AFTER GROUP OF a.country
		PRINT	a.country, qtot[2] USING "###,###",
			10 SPACES, dTot[2] USING "###,###"

		SKIP 1 LINE
		LET qtot[3] = qtot[3] + qtot[2]
		LET qtot[2] = 0
		LET dTot[3] = dTot[3] + dTot[2]
		LET dTot[2] = 0

	ON EVERY ROW
		LET qtot[1] = qtot[1] + l.quantity

	AFTER GROUP OF a.cust_no
		LET dTot[1] = dTot[1] + 1

	ON LAST ROW
		PRINT	"Total", 9 SPACES, qtot[3] USING "###,###",
			10 SPACES, dTot[3] USING "###,###"
END REPORT

#
# This sets up address driven reports
#
FUNCTION ad_report(sw)
	DEFINE sw SMALLINT

	CONSTRUCT query1 ON
		address.state, line1, country,
		invoice.invoice_no, contact, invoice_date, phone_no,
		icomments, invoice.inq_src, term_no, discount, taxes
	FROM
		address.state, line1, country,
		invoice.invoice_no, contact, invoice_date, phone_no,
		icomments, invoice.inq_src, term_no, discount, taxes

	LET s1 = "SELECT * FROM customer, invoice, address ",
		 "WHERE address.cust_no = invoice.cust_no AND ",
		 "customer.cust_no = invoice.cust_no AND ",
		 "address.add_type <> \"b\" AND ",
		 query1 CLIPPED

	PREPARE s_3 FROM s1

	DECLARE st_curs CURSOR FOR s_3

	FOR counter = 1 TO 3 # clear totals
		LET qtot[counter] = 0
		LET dTot[counter] = 0
		LET subTot[counter] = 0
		LET taxTot[counter] = 0
		LET finTot[counter] = 0
		LET shipTot[counter] = 0
	END FOR

	MESSAGE ""

	CASE
	WHEN sw = 1
		START REPORT sw_report
			
		FOREACH st_curs INTO p_cust.*, p_invoice.*, s_address.*
			OUTPUT TO REPORT 
				sw_report(p_cust.*, p_invoice.*, s_address.*)
		END FOREACH

		FINISH REPORT sw_report
	WHEN sw = 2
		START REPORT m_report
			
		FOREACH st_curs INTO p_cust.*, p_invoice.*, s_address.*
			OUTPUT TO REPORT
				 m_report(p_cust.*, p_invoice.*, s_address.*)
		END FOREACH

		FINISH REPORT m_report
	END CASE

	CLOSE st_curs
END FUNCTION

#
# Round cash amounts
#
FUNCTION roundMoney(n)
	DEFINE n, roundMoney MONEY(10, 2), w INTEGER

	LET w = (n * 100) + 0.5
	LET n = w
	RETURN n / 100.0
END FUNCTION

#
# Export data to accounting.
#
REPORT f_report(p_invoice)
	DEFINE p_invoice RECORD LIKE invoice.*

	OUTPUT
		REPORT TO PIPE "pacct"
		LEFT MARGIN 0
		TOP MARGIN 0
		BOTTOM MARGIN 0

	ORDER BY p_invoice.invoice_no
	FORMAT
	BEFORE GROUP OF p_invoice.invoice_no
		PRINT	p_invoice.invoice_no, " ",
			p_invoice.invoice_date, " ",
			p_invoice.itotal
	ON LAST ROW
		PRINT	"***"
END REPORT

#
# DETAIL REPORT
#
REPORT d_report(p_cust, p_invoice)
	DEFINE	p_cust RECORD LIKE customer.*
	DEFINE	p_invoice RECORD LIKE invoice.*
	
	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY p_invoice.invoice_no
	FORMAT
	    PAGE HEADER
		PRINT	PAGENO USING "page <<<<", 17 SPACES,
			"CREDIT DETAIL REPORT",
			17 SPACES, TODAY
		PRINT	query1 CLIPPED
		PRINT	"Invoice  Invoice date   SubTotal     ",
			"Taxes  Shipping    Credit     Total"
		SKIP 2 LINES

	    BEFORE GROUP OF p_invoice.invoice_no
		LET subTot[1] = subTot[1] + p_invoice.subtotal
		LET taxTot[1] = taxTot[1] + p_invoice.taxes
		LET shipTot[1] = shipTot[1] + p_invoice.ship_amt
		LET dTot[1] = dTot[1] + p_invoice.discount
		LET finTot[1]  = finTot[1] + p_invoice.itotal
		PRINT	p_invoice.invoice_no USING "######", 4 SPACES,
			p_invoice.invoice_date,
			p_invoice.subtotal,
			p_invoice.taxes,
			p_invoice.ship_amt,
			p_invoice.discount,
			p_invoice.itotal

	    ON LAST ROW
		PRINT	subTot[1],
			taxTot[1],
			shipTot[1],
			dTot[1],
			finTot[1]
END REPORT

#
# Print to mailing labels
#
REPORT m_report (p_cust, p_invoice, s_address)
	DEFINE	p_cust RECORD LIKE customer.*
	DEFINE  p_invoice RECORD LIKE invoice.*,
		s_address RECORD LIKE address.*

	OUTPUT
		REPORT TO PIPE "mform | lp "
#		REPORT TO "test.data"
		LEFT MARGIN 0
		TOP MARGIN 0
		BOTTOM MARGIN 0

	ORDER BY s_address.zipcode, p_invoice.invoice_no

	FORMAT
	ON EVERY ROW		
		PRINT	p_cust.contact CLIPPED
		PRINT	s_address.line1 CLIPPED
		PRINT	s_address.line2 CLIPPED
		PRINT	s_address.line3 CLIPPED
		CALL addline(s_address.*) RETURNING s1
		PRINT	s1 CLIPPED

	ON LAST ROW
		SKIP 5 LINES
END REPORT

#
# Report by address for Bob Swartz
#
REPORT sw_report (p_cust, p_invoice, s_address)
	DEFINE	p_cust RECORD LIKE customer.*
	DEFINE  p_invoice RECORD LIKE invoice.*,
		s_address RECORD LIKE address.*

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY s_address.country, s_address.state

	FORMAT
	    PAGE HEADER
		PRINT   PAGENO USING "page <<<<", 16 SPACES, "Address Report",
			10 SPACES, TODAY
		PRINT	query1 CLIPPED
		SKIP 2 LINES
	    ON EVERY ROW
		PRINT	p_invoice.invoice_no, " ",
			s_address.country, " ",
			s_address.state, " "
	    ON LAST ROW
		PRINT	"END OF REPORT"
END REPORT

#
# Commercial Invoice forms
#
REPORT com_report(p_cust, p_invoice, r_line)
	DEFINE	p_cust RECORD LIKE customer.*
	DEFINE	p_invoice RECORD LIKE invoice.*
	DEFINE	r_line RECORD LIKE inv_line.*

	DEFINE pname CHAR(60)
	DEFINE ctr SMALLINT

	OUTPUT
	REPORT TO PIPE "comform | lp"
#	REPORT TO "test.data"
	LEFT MARGIN 0
	TOP MARGIN 0
	BOTTOM MARGIN 0

	ORDER BY p_invoice.invoice_no
	FORMAT
	BEFORE GROUP OF p_invoice.invoice_no
		SELECT * INTO s_address.* FROM address
		 WHERE cust_no = p_invoice.cust_no AND
		       add_type <> "b"

		PRINT	p_cust.contact CLIPPED
		PRINT	p_cust.phone_no CLIPPED
		PRINT	s_address.line1 CLIPPED
		PRINT	s_address.line2 CLIPPED
		PRINT	s_address.line3 CLIPPED

		LET	pname = s_address.country CLIPPED
		LET	s_address.country = NULL
		CALL addline(s_address.*) RETURNING s1
		PRINT	s1 CLIPPED
		PRINT	pname CLIPPED

		SELECT * INTO p_ship.* FROM shippers
		 WHERE ship_no = p_invoice.ship_no

		SELECT * INTO p_term.* FROM terms
		 WHERE term_no = p_invoice.term_no

		PRINT	TODAY
		PRINT	p_invoice.invoice_no USING "<<<<<<<<<"

	ON EVERY ROW
		SELECT * INTO p_product.* FROM product
		 WHERE prod_no = r_line.prod_no

		LET pname = p_product.prod_name CLIPPED,
			    " ",
			    p_product.comment1

		LET rtot = p_invoice.subtotal - p_invoice.discount
		LET rtot = (rtot / p_invoice.subtotal) * p_product.price
		PRINT r_line.quantity USING "####"
		LET ctr = ctr + r_line.quantity
		PRINT pname

		IF rtot = 0.0 THEN
			LET rtot = 1.0
		END IF
		PRINT rtot
		LET rtot = rtot * r_line.quantity
		PRINT rtot

	AFTER GROUP OF p_invoice.invoice_no
		PRINT "***"
		# Things are put to rtot to stabilize printing
		# if there is a 100% discount the commercial
		# invoice prints differently
		LET	rtot = p_invoice.subtotal - p_invoice.discount
		IF rtot <= 0 THEN
			LET rtot = ctr
			PRINT	"1"
			PRINT rtot
			LET rtot = rtot + p_invoice.ship_amt
			PRINT rtot
		ELSE
			PRINT	"0"
			PRINT	rtot 
			LET rtot = p_invoice.itotal
			PRINT	rtot
		END IF

	ON LAST ROW
		PRINT "***"
END REPORT

#
# Detail file for accounting
#
REPORT x_report(p_invoice, r_line)
	DEFINE	p_invoice RECORD LIKE invoice.*
	DEFINE	r_line RECORD LIKE inv_line.*

	OUTPUT
		REPORT TO PIPE "xacct"
#		REPORT TO "test.data"
		LEFT MARGIN 0
		TOP MARGIN 0
		BOTTOM MARGIN 0

	ORDER BY p_invoice.invoice_no
	FORMAT
	BEFORE GROUP OF p_invoice.invoice_no
		SELECT * INTO p_term.* FROM terms
		 WHERE terms.term_no = p_invoice.term_no

		PRINT	"I",
			p_invoice.invoice_no, " ",
			p_invoice.invoice_date, " ",
			p_term.term_name CLIPPED, " ",
			p_invoice.ship_amt, " ",
			p_invoice.discount, " ",
			p_invoice.taxes, " ",
			p_invoice.itotal

	ON EVERY ROW
		SELECT * INTO p_product.* FROM product
		 WHERE prod_no = r_line.prod_no

		LET rtot = p_product.price * r_line.quantity
		PRINT	"P",
			r_line.prod_no, " ",
			r_line.quantity, " ",
			rtot

	ON LAST ROW
		PRINT "***"
END REPORT
