#
# Reports for invoice program
#
GLOBALS "globals0.4gl"

#
# Which report do we run?
#
MAIN
	OPTIONS MESSAGE LINE 22,
		PROMPT LINE 21,
		DELETE KEY CONTROL-K,
		NEXT KEY CONTROL-N,
		PREVIOUS KEY CONTROL-P

	OPEN FORM big_form FROM "mainline"
	DISPLAY FORM big_form

	MENU "REPORT"
	COMMAND "Prod" "Product Report"
		CALL a_report(0)
	COMMAND "Terms" "Terms report"
		CALL x_report(1)
	COMMAND "Detail" "Detail report"
		CALL x_report(2)
	COMMAND "Freeze" "Freeze some invoices"
		CALL refrig()
	COMMAND "Mag" "Inquiry source report"
		CALL a_report(3)
	COMMAND "Jay" "Inquiry file for Jay"
		CALL a_report(4)
	COMMAND "User" "Report by user"
		CALL x_report(6)
	COMMAND "State" "State tax report"
		CALL st_report(0)
	COMMAND "Cust" "Customer listing"
		CALL st_report(1)
	COMMAND "Exit" "Exit report menu"
		EXIT MENU
	END MENU
END MAIN

FUNCTION clear_totals()
	LET i_no = 0

	FOR counter = 1 TO 3 # clear totals
		LET qtot[counter] = 0
		LET dTot[counter] = 0
		LET subTot[counter] = 0
		LET taxTot[counter] = 0
		LET finTot[counter] = 0
		LET shipTot[counter] = 0
	END FOR
END FUNCTION

#
# Determine weekly or monthly report.
#
FUNCTION ismonth()
	CALL yn("Monthly report <y/n>") RETURNING answer

	IF answer = "y" THEN
		LET chosen = 28
	ELSE
		LET chosen = 7
	END IF
END FUNCTION

#
# Turns on frozen flag on specified records.
#
FUNCTION refrig()
	CONSTRUCT BY NAME query1 ON invoice_date, ship_date, invoice_no

	IF query1 CLIPPED == " 1=1" THEN
		MESSAGE "Dont freeze the world"
		RETURN
	END IF

	LET s1 = "UPDATE invoice SET frozen = \"f\" WHERE ", query1 CLIPPED

	PREPARE s_8 FROM s1

	EXECUTE s_8
END FUNCTION

#
# This sets up invoice list, product report, terms report,
# and inquiry source report which are very similar.
#
FUNCTION a_report(sw)
	DEFINE sw SMALLINT

	CONSTRUCT BY NAME query1 ON
		invoice.invoice_no, invoice.user_id, invoice_date, ship_date,
		product.prod_name, invoice.inq_src, term_no, inv_line.prod_no,
		discount, bounce, batch_ix, back_flag, tym_flag, contact

	LET s1 = "SELECT * FROM invoice, customer, inv_line, product ",
		 "WHERE ", query1 CLIPPED,
		 "  AND customer.cust_no = invoice.cust_no",
		 "  AND inv_line.invoice_no = invoice.invoice_no",
		 "  AND product.prod_no = inv_line.prod_no"

	PREPARE s_1 FROM s1

	DECLARE q_curs CURSOR FOR s_1

	CALL clear_totals()

	MESSAGE ""	# To prevent spooler message from eating screen.

	CASE sw
	WHEN 0
		CALL yn("Detail report <y/n>") RETURNING answer

		START REPORT p_report
		
		FOREACH q_curs
		   INTO p_invoice.*, p_cust.*, p_line.*, p_product.*
			OUTPUT TO REPORT
			 p_report(p_cust.*, p_invoice.*, p_line.*, p_product.*)
		END FOREACH

		FINISH REPORT p_report
	WHEN 2
		DROP TABLE marked
		CREATE TABLE marked (
		     invoice_no INTEGER
		);

		START REPORT k_report

		FOREACH q_curs
		   INTO p_invoice.*, p_cust.*, p_line.*, p_product.*
			OUTPUT TO REPORT k_report(p_invoice.invoice_no)
		END FOREACH

		FINISH REPORT k_report

	WHEN 3
		CALL ismonth()

		CALL yn("Original inquiry <y/n> ") RETURNING answer

		START REPORT m_report
		
		FOREACH q_curs
		   INTO p_invoice.*, p_cust.*, p_line.*, p_product.*
			IF answer = "y" THEN
				LET p_invoice.inq_src = p_cust.inq_src
			END IF

			LET p_invoice.invoice_date = p_invoice.invoice_date /
				chosen

			OUTPUT TO REPORT
			 m_report(p_cust.*, p_invoice.*, p_line.*, p_product.*)
		END FOREACH

		FINISH REPORT m_report
	WHEN 4
		START REPORT j_report
		
		FOREACH q_curs
		   INTO p_invoice.*, p_cust.*, p_line.*, p_product.*
			LET p_invoice.invoice_date = p_invoice.invoice_date /
				7
			OUTPUT TO REPORT j_report(p_invoice.*, p_line.*)
		END FOREACH

		FINISH REPORT j_report

		RUN "mail stephen < jay.data"
	END CASE

	CLOSE q_curs
END FUNCTION

#
# This sets up detail report and report by user
#
FUNCTION x_report(sw)
	DEFINE sw SMALLINT

	CONSTRUCT BY NAME query1 ON
		invoice.invoice_no, invoice.user_id, invoice_date, ship_date,
		invoice.cust_no, ship_no, invoice.inq_src, term_no, discount,
		bounce, batch_ix, ref_no, tym_flag, back_flag

	LET s1 = "SELECT * FROM invoice, customer",
		 " WHERE customer.cust_no = invoice.cust_no AND ",
		 query1 CLIPPED

	PREPARE s_2 FROM s1

	DECLARE x_curs CURSOR FOR s_2

	CALL clear_totals()

	MESSAGE ""	# To prevent spooler message from eating screen.

	CASE sw
	WHEN 1
		CALL yn("Summary report <y/n>") RETURNING answer

		START REPORT t_report
		
		FOREACH x_curs
		   INTO p_invoice.*, p_cust.*
			OUTPUT TO REPORT t_report(p_cust.*, p_invoice.*)
		END FOREACH

		FINISH REPORT t_report
	WHEN 2
		START REPORT d_report
		
		FOREACH x_curs
		   INTO p_invoice.*, p_cust.*
			OUTPUT TO REPORT d_report(p_cust.*, p_invoice.*)
		END FOREACH

		FINISH REPORT d_report
	WHEN 6
		START REPORT u_report
		
		FOREACH x_curs
		   INTO p_invoice.*, p_cust.*
			IF p_invoice.user_id IS NULL THEN
				LET p_invoice.user_id = "unknown"
			END IF
			OUTPUT TO REPORT u_report(p_cust.*, p_invoice.*)
		END FOREACH

		FINISH REPORT u_report
	END CASE

	CLOSE x_curs
END FUNCTION

#
# Display a message and get a y or n
#
FUNCTION yn(msg)
	DEFINE msg CHAR(50)
	DEFINE ans CHAR(1)

	LABEL loop:
		PROMPT msg CLIPPED, " " FOR ans
		IF ans IS NULL THEN
			return "n"
		END IF
		IF ans = "y" OR ans = "n" THEN
			RETURN ans
		END IF
	GOTO loop
END FUNCTION

#
# This sets up both state tax and report by address which
# are very similar.
#
FUNCTION st_report(sw)
	DEFINE sw SMALLINT

	CONSTRUCT BY NAME query1 ON
		term_no, invoice_date, address.state, line1,
		invoice.invoice_no, customer.contact,
		phone_no, invoice.icomments, invoice.inq_src, discount,
		taxes, back_flag

	LET s1 = "SELECT * FROM customer, invoice, address ",
		 "WHERE address.cust_no = invoice.cust_no AND ",
		 "customer.cust_no = invoice.cust_no AND ",
		 "address.add_type <> \"b\"  AND ",
		 query1 CLIPPED

	PREPARE s_3 FROM s1

	DECLARE st_curs CURSOR FOR s_3

	CALL clear_totals()

	MESSAGE ""	# To prevent spooler message from eating screen.

	CASE sw
	WHEN 0
		START REPORT s_report
			
		FOREACH st_curs INTO p_cust.*, p_invoice.*, s_address.*
			OUTPUT TO REPORT
				 s_report(p_cust.*, p_invoice.*, s_address.*)
		END FOREACH

		FINISH REPORT s_report
	WHEN 1
		START REPORT sw_report
			
		FOREACH st_curs INTO p_cust.*, p_invoice.*, s_address.*
			OUTPUT TO REPORT
				 sw_report(p_cust.*, p_invoice.*, s_address.*)
		END FOREACH

		FINISH REPORT sw_report
	END CASE

	CLOSE st_curs
END FUNCTION

#
# Round cash amounts
#
FUNCTION roundMoney(n)
	DEFINE n, roundMoney MONEY(10, 2), w INTEGER

	LET w = (n * 100) + 0.5
	LET n = w
	RETURN n / 100.0
END FUNCTION

#
# DETAIL REPORT
#
REPORT d_report(p_cust, p_invoice)
	DEFINE	p_cust RECORD LIKE customer.*
	DEFINE	p_invoice RECORD LIKE invoice.*
	
	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY p_invoice.invoice_no
	FORMAT
	PAGE HEADER
		PRINT	PAGENO USING "page <<<<", 31 SPACES, "DETAIL REPORT",
			31 SPACES, TODAY
		PRINT	query1 CLIPPED
		PRINT	"Invoice   Ref No   Invoice date   SubTotal     ",
			"Taxes  Shipping   Discount     Total B-O TYM"
		SKIP 2 LINES

	ON EVERY ROW
		LET subTot[1] = subTot[1] + p_invoice.subtotal
		LET taxTot[1] = taxTot[1] + p_invoice.taxes
		LET shipTot[1] = shipTot[1] + p_invoice.ship_amt
		LET dTot[1] = dTot[1] + p_invoice.discount
		LET finTot[1]  = finTot[1] + p_invoice.itotal
		PRINT	p_invoice.invoice_no USING "######",
			p_invoice.ref_no USING "##########", 4 SPACES,
			p_invoice.invoice_date,
			p_invoice.subtotal,
			p_invoice.taxes,
			p_invoice.ship_amt,
			p_invoice.discount,
			p_invoice.itotal,
			p_invoice.back_flag USING "####",
			p_invoice.tym_flag USING "####"

	ON LAST ROW
		SKIP 1 LINE
		PRINT	subTot[1],
			taxTot[1],
			shipTot[1],
			dTot[1],
			finTot[1]
END REPORT

#
# User report
#
REPORT u_report(p_cust, p_invoice)
	DEFINE	p_cust RECORD LIKE customer.*
	DEFINE	p_invoice RECORD LIKE invoice.*
	
	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY p_invoice.user_id, p_invoice.invoice_no
	FORMAT
	    PAGE HEADER
		PRINT	PAGENO USING "page <<<<", 20 SPACES, "USER REPORT",
			20 SPACES, TODAY
		PRINT	query1 CLIPPED
		PRINT	"Invoice  Customer Name"
		SKIP 2 LINES

	    BEFORE GROUP OF p_invoice.user_id
	    	SKIP 1 LINE
		PRINT	"*** ", p_invoice.user_id CLIPPED, " ***"
		
	    BEFORE GROUP OF p_invoice.invoice_no
		LET i_no = i_no + 1
		PRINT	p_invoice.invoice_no USING "######", 4 SPACES,
			p_cust.contact

	    ON LAST ROW
	    	SKIP 1 LINE
	    	PRINT	i_no, " invoices"
END REPORT

#
# The terms report.
#
REPORT t_report (p_cust, p_invoice)
	DEFINE	p_cust RECORD LIKE customer.*,
		p_invoice RECORD LIKE invoice.*

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY p_invoice.term_no, p_invoice.invoice_no

	FORMAT
	PAGE HEADER
		IF answer = "y" THEN
			PRINT   PAGENO USING "page <<<<",
				11 SPACES, "Summary Terms Report ",
				10 SPACES, TODAY
			PRINT	query1 CLIPPED
			PRINT	"Terms      Subtotal     Ship Amt",
				8 SPACES, "Taxes", 8 SPACES, "Total"
		ELSE
			PRINT   PAGENO USING "page <<<<",
				22 SPACES, "Detail Terms Report ",
				22 SPACES, TODAY
			PRINT	query1 CLIPPED
			PRINT	"Terms invoice  customer  Contact", 36 SPACES,
				"Amount   Batch B-O TYM"
		END IF
		SKIP 1 LINE

	BEFORE GROUP OF p_invoice.term_no
	    	SELECT * INTO p_term.* FROM terms
		 WHERE terms.term_no = p_invoice.term_no

	AFTER GROUP OF p_invoice.term_no
		LET subTot[2] = subTot[2] + subTot[1]
		LET shipTot[2] = shipTot[2] + shipTot[1]
		LET taxTot[2] = taxTot[2] + taxTot[1]
		LET finTot[2] = finTot[2] + finTot[1]
		IF answer = "y" THEN
			PRINT	p_term.term_name,
				subtot[1],
				shipTot[1],
				taxTot[1],
				finTot[1]
		END IF
		LET subTot[1] = 0
		LET shipTot[1] = 0
		LET taxTot[1] = 0
		LET finTot[1] = 0

	ON EVERY ROW
		LET subTot[1] = subTot[1] + p_invoice.subtotal
		LET shipTot[1] = shipTot[1] + p_invoice.ship_amt
		LET taxTot[1] = taxTot[1] + p_invoice.taxes
		LET finTot[1] = finTot[1] + p_invoice.itotal

		IF answer != "y" THEN
		   	PRINT	p_term.term_name, " ",
				p_invoice.invoice_no USING "######", "  ",
				p_invoice.cust_no USING "######", "    ",
				p_cust.contact,
				p_invoice.itotal, " ",
				p_invoice.batch_ix,
				p_invoice.back_flag USING "####",
				p_invoice.tym_flag USING "####"
		END IF

	ON LAST ROW
		IF answer != "y" THEN
			SKIP 1 LINE
			PRINT	11 SPACES, "Subtotal     Ship Amt",
				 8 SPACES, "Taxes", 8 SPACES, "Total"
		END IF
		SKIP 1 LINE
		PRINT	6 SPACES, subTot[2], shipTot[2], taxTot[2], finTot[2]
END REPORT

#
# The special marker report.
#
REPORT k_report(i_no)
	DEFINE i_no INTEGER

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY i_no

	FORMAT
	AFTER GROUP OF i_no
		INSERT INTO marked VALUES (i_no)
END REPORT

#
# The product report
#
REPORT p_report (p_cust, p_invoice, p_line, p_product)
	DEFINE	p_cust RECORD LIKE customer.*,
		p_invoice RECORD LIKE invoice.*,
		p_line RECORD LIKE inv_line.*,
		p_product RECORD LIKE product.*

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY p_line.prod_no, p_invoice.term_no, p_invoice.invoice_no

	FORMAT
	PAGE HEADER
		PRINT	PAGENO USING "page <<<<", 16 SPACES, "Product Report ",
			10 SPACES, TODAY
		PRINT	query1 CLIPPED
		PRINT	"Terms  Code Quantity ",
			"Subtotal     Ship Amt", 8 SPACES,
			"Taxes", 5 SPACES, "Discount", 8 SPACES, "Total"
		SKIP 2 LINES

	BEFORE GROUP OF p_line.prod_no
		SKIP 1 LINE
		PRINT	p_product.prod_name CLIPPED, " ",
			p_product.comment1 CLIPPED

	AFTER GROUP OF p_line.prod_no
		LET qtot[3] = qtot[3] + qtot[2]
		LET subTot[3] = subTot[3] + subTot[2]
		LET shipTot[3] = shipTot[3] + shipTot[2]
		LET taxTot[3] = taxTot[3] + taxTot[2]
		LET finTot[3] = finTot[3] + finTot[2]
		LET dTot[3] = dTot[3] + dTot[2]
		PRINT	6 SPACES,
			p_line.prod_no USING "####",
			qtot[2] USING "######",
			subtot[2],
			shipTot[2],
			taxTot[2],
			dTot[2],
			finTot[2]
		LET qtot[2] = 0
		LET subTot[2] = 0
		LET shipTot[2] = 0
		LET taxTot[2] = 0
		LET finTot[2] = 0
		LET dTot[2] = 0

	BEFORE GROUP OF p_invoice.term_no
		IF answer == "y" THEN
			SKIP 1 LINE
		END IF

	    	SELECT * INTO p_term.* FROM terms
		 WHERE terms.term_no = p_invoice.term_no

	AFTER GROUP OF p_invoice.term_no
		LET qtot[2] = qtot[2] + qtot[1]
		LET subTot[2] = subTot[2] + subTot[1]
		LET shipTot[2] = shipTot[2] + shipTot[1]
		LET taxTot[2] = taxTot[2] + taxTot[1]
		LET finTot[2] = finTot[2] + finTot[1]
		LET dTot[2] = dTot[2] + dTot[1]
		PRINT	p_term.term_name,
			p_line.prod_no USING "####",
			qtot[1] USING "######",
			subtot[1],
			shipTot[1],
			taxTot[1],
			dTot[1],
			finTot[1]
		LET qtot[1] = 0
		LET subTot[1] = 0
		LET shipTot[1] = 0
		LET taxTot[1] = 0
		LET finTot[1] = 0
		LET dTot[1] = 0

	ON EVERY ROW
		LET qtot[1] = qtot[1] + p_line.quantity
		LET rtot = p_line.quantity * p_product.price
		LET subTot[1] = subTot[1] + rtot
		IF answer == "y" THEN
			PRINT	p_invoice.invoice_no, p_line.quantity,
				rtot
		END IF
		IF p_invoice.subtotal = 0 THEN
			LET part = 1.0
		ELSE
			let part = rtot / p_invoice.subtotal
		END IF
		LET stot = p_invoice.ship_amt * part
		LET shipTot[1] = shipTot[1] + roundMoney(stot)
		LET ttot = p_invoice.taxes * part
		LET taxTot[1] = taxTot[1] + roundMoney(ttot)
		LET ctotal = p_invoice.discount * part
		LET dTot[1] = dTot[1] + roundMoney(ctotal)
		LET ftot = p_invoice.itotal * part
		LET finTot[1] = finTot[1] + roundMoney(ftot) 

	ON LAST ROW
		PRINT	10 SPACES, qtot[3] USING "######",
			subTot[3], shipTot[3],
			taxTot[3], dTot[3], finTot[3]
END REPORT

#
# The inquiry source report.
#
REPORT m_report (p_cust, p_invoice, p_line, p_product)
	DEFINE	p_cust RECORD LIKE customer.*,
		p_invoice RECORD LIKE invoice.*,
		p_line RECORD LIKE inv_line.*,
		p_product RECORD LIKE product.*
	DEFINE	per_name CHAR(8)
	DEFINE  orig	 CHAR(9)

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY	p_invoice.invoice_date,
			p_invoice.inq_src

	FORMAT
	PAGE HEADER
		IF chosen = 7 THEN
			LET per_name = "Weekly"
		ELSE
			LET per_name = "Monthly"
		END IF

		IF answer = "y" THEN
			LET orig = "Original"
		ELSE
			LET orig = NULL
		END IF

		PRINT   PAGENO USING "page <<<<", 14 SPACES,
			orig CLIPPED,
			" Inquiry Source Report, ",
			per_name CLIPPED, " Totals",
			14 SPACES, TODAY

		PRINT	query1 CLIPPED
		PRINT	22 SPACES, "Quantity ",
			"Subtotal     Ship Amt", 8 SPACES, "Total",
			5 SPACES, "Efficency"
		SKIP 2 LINES

	AFTER GROUP OF p_invoice.inq_src
	    	SELECT * INTO p_mag.* FROM magazines
		 WHERE magazines.inq_src = p_invoice.inq_src

		LET qtot[2] = qtot[2] + qtot[1]
		LET subTot[2] = subTot[2] + subTot[1]
		LET shipTot[2] = shipTot[2] + shipTot[1]
		LET finTot[2] = finTot[2] + finTot[1]
		LET p_invoice.invoice_date = p_invoice.invoice_date * chosen
		IF p_mag.cost != 0 THEN
			LET eff = subTot[1] / p_mag.cost
			IF chosen = 7 THEN
				LET eff = eff * 4
			END IF
		ELSE
			LET eff = NULL
		END IF
		PRINT	p_mag.mag_name,
			qtot[1] USING "######",
			subTot[1],
			shipTot[1],
			finTot[1],
			eff
		LET qtot[1] = 0
		LET subTot[1] = 0
		LET shipTot[1] = 0
		LET finTot[1] = 0

	AFTER GROUP OF  p_invoice.invoice_date
		LET qtot[3] = qtot[3] + qtot[2]
		LET subTot[3] = subTot[3] + subTot[2]
		LET shipTot[3] = shipTot[3] + shipTot[2]
		LET finTot[3] = finTot[3] + finTot[2]
		PRINT	p_invoice.invoice_date, 10 SPACES,
			qtot[2] USING "######",
			subtot[2],
			shipTot[2],
			finTot[2]
		SKIP 1 LINE
		LET qtot[2] = 0
		LET subTot[2] = 0
		LET shipTot[2] = 0
		LET finTot[2] = 0

	ON EVERY ROW
		LET qtot[1] = qtot[1] + p_line.quantity
		LET rtot = p_line.quantity * p_product.price
		LET subTot[1] = subTot[1] + rtot
		IF  p_invoice.subtotal = 0 THEN
			LET part = 1.0
		ELSE
			LET part = rtot / p_invoice.subtotal
		END IF
		LET stot = p_invoice.ship_amt * part
		LET shipTot[1] = shipTot[1] + roundMoney(stot)
		LET ftot = p_invoice.itotal * part
		LET finTot[1] = finTot[1] + roundMoney(ftot) 

	ON LAST ROW
		PRINT	20 SPACES, qtot[3] USING "######",
			subTot[3], shipTot[3],
			finTot[3]
		PRINT	"END OF REPORT"
END REPORT

#
# The inquiry source file for Jay Alter.
#
REPORT j_report (p_invoice, p_line)
	DEFINE	p_invoice RECORD LIKE invoice.*,
		p_line RECORD LIKE inv_line.*

	DEFINE	ct, i SMALLINT
	DEFINE	qt ARRAY[99] OF SMALLINT

	OUTPUT
		REPORT TO PIPE "forrdb > jay.data"
		LEFT MARGIN 0
		TOP MARGIN 0
		BOTTOM MARGIN 0

	ORDER BY	p_invoice.invoice_date

	FORMAT
	FIRST PAGE HEADER
	    	SELECT MAX(inq_src) INTO ct FROM magazines
		FOR i = 1 TO ct
			LET qt[i] = 0
		END FOR

	AFTER GROUP OF p_invoice.invoice_date
		IF qtot[1] = 0 THEN	# first time make rdb header
			LET qtot[1] = 1

			PRINT	"we*"
			FOR i = 1 TO ct
				IF i = ct THEN
					PRINT	i USING "&&"
				ELSE
					PRINT	i USING "&&", "*"
				END IF
			END FOR

			PRINT	"__*"
			FOR i = 1 TO ct
				IF i = ct THEN
					PRINT	"__"
				ELSE
					PRINT	"__*"
				END IF
			END FOR
		END IF

		LET p_invoice.invoice_date = p_invoice.invoice_date * 7
		PRINT	p_invoice.invoice_date, "*"
		FOR i = 1 TO ct
			IF i = ct THEN
				PRINT	qt[i] USING "<<<<&"
			ELSE
				PRINT	qt[i] USING "<<<<&", "*"
			END IF
			LET qt[i] = 0
		END FOR

	ON EVERY ROW
		LET i = p_invoice.inq_src
		LET qt[i] = qt[i] + p_line.quantity
END REPORT

#
# State tax report
#
REPORT s_report (p_cust, p_invoice, s_address)
	DEFINE	p_cust RECORD LIKE customer.*,
		p_invoice RECORD LIKE invoice.*,
		s_address RECORD LIKE address.*

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY p_invoice.invoice_no

	FORMAT
	    PAGE HEADER
		PRINT   PAGENO USING "page <<<<", 16 SPACES, "Tax Report",
			10 SPACES, TODAY
		PRINT	query1 CLIPPED
		PRINT	"INV. #", 9 SPACES, "CUST. NAME",
			20 SPACES, "CITY"
		PRINT	13 SPACES,
			"SUBTOTAL  SHIPPING    TAXES  DISCOUNT       TOTAL"
		SKIP 2 LINES

	    ON EVERY ROW
		LET subTot[1] = subTot[1] + p_invoice.subtotal
		LET shipTot[1] = shipTot[1] + p_invoice.ship_amt
		LET taxTot[1] = taxTot[1] + p_invoice.taxes
		LET dTot[1]   = dTot[1] + p_invoice.discount
		LET finTot[1] = finTot[1] + p_invoice.itotal

		PRINT	p_invoice.invoice_no USING "#####", " ",
			p_cust.contact,
			s_address.city
		PRINT	9 SPACES, p_invoice.subtotal USING "#,###,###.##",
			p_invoice.ship_amt USING "###,###.##",
			p_invoice.taxes USING "##,###.##",
			p_invoice.discount USING "##,###.##",
			p_invoice.itotal USING "#,###,###.##"
		SKIP 1 LINE
	    ON LAST ROW
		PRINT	"Total    ", subTot[1] USING "#,###,###.##",
			shipTot[1] USING "###,###.##",
			taxTot[1] USING "##,###.##",
			dTot[1] USING "##,###.##",
			finTot[1] USING "#,###,###.##"
		PRINT	"END OF REPORT"
END REPORT

#
# Report by address for Bob Swartz
#
REPORT sw_report (p_cust, p_invoice, s_address)
	DEFINE	p_cust RECORD LIKE customer.*,
		p_invoice RECORD LIKE invoice.*,
		s_address RECORD LIKE address.*

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY s_address.line1

	FORMAT
	    PAGE HEADER
		PRINT   PAGENO USING "page <<<<", 16 SPACES, "Address Report",
			10 SPACES, TODAY
		PRINT	query1 CLIPPED
		SKIP 2 LINES
	    ON EVERY ROW
		NEED 4 LINES
		PRINT	p_cust.contact, s_address.line1
		IF s_address.line2 IS NOT NULL THEN
			PRINT	38 SPACES, s_address.line2
		END IF
		IF s_address.line3 IS NOT NULL THEN
			PRINT	38 SPACES, s_address.line3
		END IF
		CALL addline(s_address.*) RETURNING s1
		PRINT	38 SPACES, s1 CLIPPED

		IF s_address.country IS NOT NULL THEN
			PRINT	38 SPACES, s_address.country CLIPPED
		END IF

		SKIP 1 LINE

	    ON LAST ROW
		PRINT	"END OF REPORT"
END REPORT
