DATABASE mwc

MAIN
	DEFINE	prod		LIKE product.prod_no,
		cust_number	LIKE cprodlst.cust_no

	DECLARE real_curs CURSOR FOR
		SELECT cprodlst.cust_no, cprodlst.prod_no
		INTO cust_number, prod
		FROM cprodlst
		WHERE cprodlst.prod_no IN(85,86)
		ORDER BY cprodlst.cust_no


	START REPORT real_orders
		FOREACH real_curs
			OUTPUT TO REPORT real_orders(cust_number)
		END FOREACH
	FINISH REPORT real_orders

END MAIN

REPORT real_orders(customer_number)
	DEFINE	customer_number	LIKE customer.cust_no,
		counter	INTEGER

	FORMAT
		PAGE HEADER
			PRINT COLUMN 1, "page: ", PAGENO using "<<<"
			PRINT COLUMN 30, "Real Orders of GCC Sources"
			SKIP 1 line
		AFTER GROUP OF customer_number
			PRINT COLUMN 5, customer_number
			LET counter = counter + 1

		ON LAST ROW
			SKIP 1 LINE
			PRINT COLUMN 3, "Total customers: ", counter USING "<<<<"
END REPORT
