DATABASE mwc

MAIN
	DEFINE l RECORD LIKE inv_line.*

	DECLARE curs CURSOR FOR
	 SELECT inv_line.* FROM invoice, inv_line
	  WHERE invoice_date = TODAY AND
		inv_line.invoice_no = invoice.invoice_no

	START REPORT q_rep

	FOREACH curs INTO l.*
		OUTPUT TO REPORT q_rep(l.*)
	END FOREACH

	FINISH REPORT q_rep

	CLOSE curs
END MAIN

REPORT q_rep(l)
	DEFINE l RECORD LIKE inv_line.*
	DEFINE p RECORD LIKE product.*
	DEFINE ct, tot SMALLINT
	DEFINE st, gt MONEY(8, 2)

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 60

	ORDER BY l.prod_no
	
	FORMAT
	FIRST PAGE HEADER
		LET tot = 0
		LET gt = 0
		PRINT TIME, 20 SPACES, "Quick Daily Report for ", TODAY
		SKIP 2 LINES

	BEFORE GROUP OF l.prod_no
		LET ct = 0
		LET st = 0

	ON EVERY ROW
		LET ct = ct + l.quantity

	AFTER GROUP OF l.prod_no
		SELECT * INTO p.* FROM product WHERE prod_no = l.prod_no
		LET st = ct * p.price
		LET gt = gt + st
		LET tot = tot + ct
		PRINT p.prod_name, p.comment1, ct, st
		
	ON LAST ROW
		SKIP 1 LINE
		PRINT 60 SPACES, tot, gt
END REPORT
