#
# Code to do product file
#
GLOBALS "globals0.4gl"

FUNCTION prod_menu()
	DISPLAY FORM prod_form
	
	LET chosen = FALSE

	MESSAGE "Type the first letter of the option ",
		"you want to select."

	MENU "PRODUCT"
	COMMAND "Add" "Add a new product."
	        LET answer = "y"
	        WHILE answer = "y"
			CALL enter_prod()
       
			CALL yn("Enter another product <y/n>")
				RETURNING answer
		END WHILE
     
	COMMAND "Query" "Search for a product."
		CALL query_prod()

		IF chosen THEN
			NEXT OPTION "Modify"
		END IF
	
	COMMAND "Backorder" "Free Invoices of backordered products"
		CALL free_back()

	COMMAND "Unback" "Back orders completed"
		UPDATE invoice
		   SET back_flag = NULL
		 WHERE back_flag = 2

	COMMAND "Modify" "Modify a product."
		IF chosen THEN
			CALL change_prod()
		ELSE
			MESSAGE "No product has been chosen. ",
				"Use the Query option to select ",
				"a product."
			NEXT OPTION "Query"
      		END IF

	COMMAND "Exit" "Leave the product menu."
		EXIT MENU
	END MENU

	CLEAR SCREEN
END FUNCTION

#
# Check invoices with backordered products, see if they
# are still frozen and maybe unfreeze.
#
FUNCTION free_back()
	WHENEVER ERROR GOTO no_sws
	LOCK TABLE sws IN EXCLUSIVE MODE
	WHENEVER ERROR STOP

	CALL yn("Take a $ amount off of backorder") RETURNING answer

	LET counter = 0
	LET ctotal  = 0

	IF answer <> "y" THEN
		MESSAGE
		"How many invoices can we take off backorder, 0 for unlimited "

		INPUT BY NAME p_product.weight
		IF p_product.weight IS NOT NULL THEN
			LET counter = p_product.weight
		END IF

		LET s1 = "SELECT * FROM invoice, inv_line, product ",
			 "WHERE back_flag == 1",
			 "  AND term_no != 13",
			 "  AND inv_line.invoice_no = invoice.invoice_no",
			 "  AND product.prod_no = inv_line.prod_no"
	ELSE
		MESSAGE "How much cash do we need"

		INPUT BY NAME p_product.price
		IF p_product.price IS NOT NULL THEN
			LET ctotal = p_product.price
		END IF

		LET s1 = "SELECT * FROM invoice, inv_line, product ",
			 "WHERE back_flag == 1",
			 "  AND term_no < 5",
			 "  AND inv_line.invoice_no = invoice.invoice_no",
			 "  AND product.prod_no = inv_line.prod_no"
	END IF

	PREPARE s_2 FROM s1

	DECLARE b_curs CURSOR FOR s_2

	START REPORT p_report

	FOREACH b_curs INTO p_invoice.*, p_line.*, p_product.*
		OUTPUT TO REPORT p_report(p_invoice.*, p_line.*, p_product.*)
	END FOREACH

	FINISH REPORT p_report

	UNLOCK TABLE sws

	RETURN

LABEL no_sws:
	PROMPT "Exclusive function in use" FOR answer
END FUNCTION

#
# free backup done as a report.
#
REPORT p_report(i, l, p)
	DEFINE i RECORD LIKE invoice.*
	DEFINE l RECORD LIKE inv_line.*
	DEFINE p RECORD LIKE product.*

	DEFINE sw, done SMALLINT

	OUTPUT
		REPORT TO PIPE "c10 | lp"
		PAGE LENGTH 80

	ORDER BY i.invoice_no

	FORMAT
	FIRST PAGE HEADER
		LET done = 0
		PRINT	PAGENO USING "page <<<<", 31 SPACES,
			"FREE BACKORDER REPORT",  31 SPACES, TODAY

	PAGE HEADER
		PRINT	PAGENO USING "page <<<<", 31 SPACES, 
			"FREE BACKORDER REPORT",  31 SPACES, TODAY

	BEFORE GROUP OF i.invoice_no
		LET sw = done

	ON EVERY ROW
		IF p.b_flag = 1 THEN
			LET sw = 1
		END IF

	AFTER GROUP OF i.invoice_no
		IF sw == 0 THEN
			PRINT i.invoice_no
			IF i.term_no < 5 THEN
				UPDATE invoice
				   SET back_flag = 2, tym_flag = 1
				 WHERE invoice_no = i.invoice_no
			ELSE
				UPDATE invoice
				   SET back_flag = 2
				 WHERE invoice_no = i.invoice_no
			END IF

			IF counter <> 0 THEN
				LET counter = counter - 1
				IF counter = 0 THEN
					PRINT "Count completed"
					LET done = 1
				END IF
			END IF

			IF ctotal > 0.0 THEN
				LET ctotal = ctotal - i.itotal
				IF ctotal <= 0.0 THEN
					PRINT "Amount completed"
					LET done = 1
				END IF
			END IF
		END IF
END REPORT
	
#
# product report
#
REPORT prod_list (r_prod)
	DEFINE r_prod RECORD LIKE product.*

	OUTPUT
		REPORT TO "prod.lst"
		LEFT MARGIN 0
		TOP MARGIN 0
		BOTTOM MARGIN 0
		PAGE LENGTH 80
	FORMAT
	ON EVERY ROW
		PRINT	r_prod.prod_no USING "###", " ",
			r_prod.prod_name, " ",
			r_prod.comment1,
			r_prod.price,
			r_prod.weight
END REPORT

FUNCTION enter_prod()
	MESSAGE ""
	CLEAR FORM

	INPUT BY NAME p_product.*
	AFTER FIELD prod_name
		IF p_product.prod_name IS NULL THEN
			NEXT FIELD prod_name
		END IF
	AFTER FIELD price
		IF p_product.price IS NULL THEN
			NEXT FIELD price
		END IF
	END INPUT

	LET p_product.prod_no =  0

	INSERT INTO product VALUES (p_product.*)

	LET p_product.prod_no = SQLCA.SQLERRD[2]

	DISPLAY p_product.prod_no TO prod_no

	MESSAGE "Row added."
END FUNCTION

FUNCTION query_prod()
	DEFINE  p_name CHAR(30),
		answer CHAR(1),
		exist SMALLINT

	MESSAGE ""
	CLEAR FORM

	CONSTRUCT BY NAME query1 ON product.*

	LET s1 = "SELECT * FROM product WHERE ", query1 CLIPPED

	PREPARE s_1 FROM s1
	DECLARE c_curs CURSOR FOR s_1

	LET exist = FALSE
	LET chosen = FALSE

	FOREACH c_curs INTO p_product.*
		LET exist = TRUE

		DISPLAY BY NAME p_product.* 

		CALL yn("Enter 'y' to select this product")
			RETURNING answer

       	   	IF answer = "y" THEN
			LET chosen = TRUE
			EXIT FOREACH
		END IF
	END FOREACH

	CLOSE c_curs

	IF exist = FALSE THEN
		MESSAGE "No product rows found."
	ELSE
		IF chosen = FALSE THEN
			MESSAGE "There are no more product rows."
		END IF
	END IF
END FUNCTION

FUNCTION change_prod()
	INPUT BY NAME p_product.*
		WITHOUT DEFAULTS

	UPDATE product 
		SET product.* = p_product.*
		WHERE prod_no = p_product.prod_no
END FUNCTION 

FUNCTION delete_prod()
	DELETE FROM product WHERE prod_no = 
		p_product.prod_no
	CLEAR FORM
END FUNCTION 
