#
# Print customer number, name, and address of every customer who bought
# COHERENT, who lives in the U.S., but who does *not* have version 4.2
# 
# by fwb, 3/28/94
#
DATABASE mwc

MAIN
	DEFINE cust_number LIKE customer.cust_no
	DEFINE candidates INTEGER
	DEFINE total_addresses INTEGER
	DEFINE total_42_bought INTEGER  # number of 4.2-related products
					# a given customer has purchased

	DEFINE new_contact LIKE customer.contact
	DEFINE new_line1 LIKE address.line1
	DEFINE new_line2 LIKE address.line2
	DEFINE new_city LIKE address.city
	DEFINE new_state LIKE address.state
	DEFINE new_zipcode LIKE address.zipcode

# find every customer who'd bought COHERENT before release 4.2
	DECLARE curs_customer CURSOR FOR
	SELECT	UNIQUE invoice.cust_no
	FROM	invoice, inv_line, customer, address
	WHERE	inv_line.prod_no IN (1, 2, 26, 27, 44, 45, 60, 61)
			AND
		inv_line.invoice_no = invoice.invoice_no
			AND
		invoice.cust_no = customer.cust_no
			AND
		(customer.all_nfo IS NULL
			OR
		(customer.all_nfo != "x"
			AND
		 customer.all_nfo != "X"))
 			AND
		(customer.cust_no = address.cust_no
			AND
		 address.country IS NULL)

# check whether this customer bought 4.2
	LET candidates = 0
	START REPORT mail_list
        FOREACH curs_customer INTO cust_number
	    SELECT
                COUNT(*)
                INTO    total_42_bought
                FROM    invoice, inv_line
                WHERE   invoice.cust_no = cust_number
                            AND
                        invoice.invoice_no = inv_line.invoice_no
			    AND
# magic product numbers for 4.2 updates
                        inv_line.prod_no IN (94, 95, 98, 99, 113,
				114, 107, 108, 109, 110, 115, 116,
			        117, 118, 256, 257)

# if customer did not buy 4.2, select the name and address
	    IF total_42_bought = 0 THEN
		LET candidates = candidates + 1

		LET total_addresses = 0
		
		SELECT	COUNT(*)
			INTO	total_addresses
			FROM	address
			WHERE	address.cust_no = cust_number

		IF total_addresses = 1 THEN
			SELECT contact, line1, line2, city, state, zipcode
				INTO	new_contact, new_line1, new_line2,
					new_city, new_state, new_zipcode
				FROM	customer, address
				WHERE	customer.cust_no = cust_number
						AND
					address.cust_no = customer.cust_no

			OUTPUT TO REPORT mail_list (cust_number, new_contact,
						new_line1, new_line2, new_city,
						new_state, new_zipcode)
		END IF
            END IF
        END FOREACH
	FINISH REPORT mail_list

# display number of candidates to sanity check this program
	DISPLAY "Number of candidates: ", candidates

END MAIN

REPORT mail_list (cust_number, new_contact, new_line1,
		new_line2, new_city, new_state, new_zipcode)

DEFINE cust_number LIKE customer.cust_no
DEFINE new_contact LIKE customer.contact
DEFINE new_line1 LIKE address.line1
DEFINE new_line2 LIKE address.line2
DEFINE new_city LIKE address.city
DEFINE new_state LIKE address.state
DEFINE new_zipcode LIKE address.zipcode

	OUTPUT
		TOP MARGIN 0
		BOTTOM MARGIN 0
		LEFT MARGIN 0
		REPORT TO "mail_no42.rep"

	FORMAT

# report has following format:
#   1-  9 - customer number
#  12- 49 - customer name
#  50- 88 - address, line 1
#  90-128 - address, line 2
# 130-150 - city
# 155-159 - state
# 160-171 - ZIP code
	ON EVERY ROW
		PRINT	cust_number USING "#########",
			COLUMN  12, new_contact,
			COLUMN  50, new_line1,
			COLUMN  90, new_line2,
			COLUMN 130, new_city,
			COLUMN 155, new_state,
			COLUMN 160, new_zipcode

END REPORT
