DATABASE mwc

#
# Program to send a letter to marked customers
#
MAIN	
	DEFINE	p_cust	  RECORD LIKE customer.*
	DEFINE  s_address RECORD LIKE address.*
	DEFINE	p_invoice RECORD LIKE invoice.*

	DECLARE curs CURSOR FOR
	 SELECT invoice.*, customer.*, address.*
	   FROM marked, invoice, customer, address
	  WHERE marked.invoice_no = invoice.invoice_no
	    AND customer.cust_no = invoice.cust_no
	    AND address.cust_no = invoice.cust_no
	    AND address.add_type <> "s"

	START REPORT mail_list

	FOREACH curs INTO p_invoice.*, p_cust.*, s_address.*
		OUTPUT TO REPORT mail_list (p_invoice.*, p_cust.*, s_address.*)
	END FOREACH

	FINISH REPORT mail_list

	CLOSE curs
END MAIN

#
# Letters
#
REPORT mail_list (p_invoice, p_cust, p_add)
	DEFINE p_invoice RECORD LIKE invoice.*
	DEFINE p_cust RECORD LIKE customer.*
	DEFINE p_add  RECORD LIKE address.*
	DEFINE s1 CHAR(80)

	OUTPUT
		REPORT TO "letters.r"
		LEFT MARGIN 0
		TOP MARGIN 0
		BOTTOM MARGIN 0

	ORDER BY p_add.zipcode, p_cust.cust_no

	FORMAT
	FIRST PAGE HEADER
		PRINT	".in 2i"

	ON EVERY ROW		
		PRINT	".sp 22"
		PRINT	".nf"
		PRINT	"September 23, 1992"
		PRINT	".sp"
		PRINT	p_cust.contact CLIPPED
		IF p_add.line1 IS NOT NULL THEN
			PRINT	p_add.line1 CLIPPED
		END IF
		IF p_add.line2 IS NOT NULL THEN
			PRINT	p_add.line2 CLIPPED
		END IF
		IF p_add.line3 IS NOT NULL THEN
			PRINT	p_add.line3 CLIPPED
		END IF
		CALL	addline(p_add.*) RETURNING s1
		PRINT	s1 CLIPPED
		IF p_add.country IS NOT NULL THEN
			PRINT	p_add.country CLIPPED
		END IT
		PRINT	".fi"
		PRINT	".sp"
		PRINT	"Dear ", p_cust.contact CLIPPED, ":"
		PRINT	".sp"
		PRINT	"Thank you very much for your order!"
		PRINT	".sp"
		PRINT	"We acknowledge the receipt of your payment in ",
			"the amount of ",
			p_invoice.itotal USING "$<<<,<<<.<<",
			" for Coherent 4.0."
		PRINT	".sp"
		PRINT	"Unfortunately due to manufacturing delays we are"
		PRINT	"currently on backorder. We expect to be shipping"
		PRINT   "in two to three weeks."
		PRINT	".sp"
		PRINT	"We regret any inconvenience this may have caused."
		PRINT	".sp"
		PRINT	".nf"
		PRINT	"Sincerly,"
		PRINT	".sp 4"
		PRINT	"Christine Lamb"
		PRINT	"Accounts Receivable"
		PRINT	".bp"
END REPORT

#
# Create city, state country zip address line.
#
FUNCTION addline(a)
	DEFINE a RECORD LIKE address.*
	DEFINE w CHAR(80)

	IF a.zipcode IS NOT NULL THEN
		LET w = a.zipcode CLIPPED
	ELSE
		LET w = NULL
	END IF

#	IF a.country IS NOT NULL THEN
#		LET w = a.country CLIPPED, " ", w CLIPPED
#	END IF

	IF a.state IS NOT NULL THEN
		LET w = a.state CLIPPED, " ", w CLIPPED
	END IF

	IF a.city IS NOT NULL THEN
		LET w = a.city CLIPPED, ", ", w CLIPPED
	END IF

	RETURN w
END FUNCTION
