#
# Globals for unified mwc database
#
DATABASE mwc

GLOBALS
	DEFINE	p_product RECORD LIKE product.*
	DEFINE	p_invoice RECORD LIKE invoice.*
	DEFINE	p_cust	  RECORD LIKE customer.*
	DEFINE  s_address RECORD LIKE address.*
	DEFINE  b_address RECORD LIKE address.*
	DEFINE  p_line    RECORD LIKE inv_line.*
	DEFINE  p_ship	  RECORD LIKE shippers.*
	DEFINE  p_mag	  RECORD LIKE magazines.*
	DEFINE	p_term	  RECORD LIKE terms.*
	DEFINE	p_freight RECORD LIKE freight.*
	DEFINE	p_dest	  RECORD LIKE dests.*
	DEFINE  p_memo	  RECORD LIKE cmemo.*
	DEFINE  p_payment RECORD LIKE payment.*
	DEFINE	p_reg 	  RECORD LIKE regcard.*
	DEFINE	p_nreg	  RECORD LIKE newreg.*
	DEFINE  p_shipreg RECORD LIKE shipreg.*
	DEFINE	p_auth	  RECORD LIKE auth.*
	DEFINE  p_states  RECORD LIKE states.*
	DEFINE	p_batch	  RECORD LIKE batch.*
	DEFINE  p_sws	  RECORD LIKE sws.*
	DEFINE  chosen SMALLINT
	DEFINE  ctotal, ptotal, rtot, stot, ttot, ftot, part MONEY(8,2) 
	DEFINE  subTot, shipTot, dTot, taxTot, finTot ARRAY[3] OF MONEY(10, 2)
	DEFINE  eff DECIMAL(8,2)
	DEFINE	s1, query1 CHAR(500)
	DEFINE  qtot, qtota, qtotb ARRAY[3] OF INTEGER
	DEFINE counter SMALLINT
	DEFINE	taxpct DECIMAL(3,1)
	DEFINE  i_no INTEGER
	DEFINE answer CHAR(1)
	DEFINE user_id CHAR(9)
	DEFINE cd_no CHAR(20)
	DEFINE mwc_freight ARRAY[30] OF MONEY(6,2)
	DEFINE p_items ARRAY[10] OF RECORD
		prod_no LIKE inv_line.prod_no,
		quantity LIKE inv_line.quantity,
		price LIKE product.price,
		extension MONEY(8, 2),
		prod_name LIKE product.prod_name,
		comment1 LIKE product.comment1,
		b_flag LIKE product.b_flag
	END RECORD

	DEFINE shiploc	SMALLINT	# shipper location
	DEFINE recnumber INTEGER	# UPS record number
	DEFINE tbl	CHAR(10)
	DEFINE p_pickup RECORD LIKE pickup_line.*
	DEFINE p_wzp	RECORD LIKE w_z_p.*
	DEFINE p_ground RECORD LIKE ground.*

	DEFINE p_bad 	RECORD LIKE bad_disk.*  # bad media records
	DEFINE p_call	RECORD LIKE call_tag.*	# UPS Call tag

# Arrays to keep UPS summary data: number of pieces, total weight, & charges.
	DEFINE	rgr_pieces	ARRAY[9] OF SMALLINT  # \
	DEFINE	rgr_weight	ARRAY[9] OF SMALLINT  #   Ground residential USA
	DEFINE	rgr_charges	ARRAY[9] OF MONEY     # /

	DEFINE	cgr_pieces	ARRAY[9] OF SMALLINT  # \
	DEFINE	cgr_weight	ARRAY[9] OF SMALLINT  #   Ground commercial USA
	DEFINE	cgr_charges	ARRAY[9] OF MONEY     # /

	DEFINE	air_pieces	ARRAY[8] OF SMALLINT  # \ 
	DEFINE	air_weight	ARRAY[8] OF SMALLINT  #    Air USA
	DEFINE	air_charges	ARRAY[8] OF MONEY     # /

	DEFINE	can_pieces	ARRAY[6] OF SMALLINT  # \
	DEFINE	can_weight	ARRAY[6] OF SMALLINT  #   For CANADA	
	DEFINE	can_charges	ARRAY[6] OF MONEY     # /
 
	DEFINE	int_pieces	ARRAY[8] OF SMALLINT  # \
	DEFINE	int_weight	ARRAY[8] OF SMALLINT  #   International	
	DEFINE	int_charges	ARRAY[8] OF MONEY     # /

END GLOBALS
