#
# Sample data for junk database.
# Strange sequence runs faster by
# Doing all deletes from each TABLE in turn
# This is the difference between 10 Hours and 1 hour
#
# It is nessisary to ALTER a table after DELETES to get
# real compression on disk
#

DATABASE mwc


MAIN
	DEFINE modulo 	SMALLINT
	DEFINE l_no, i_no, c_no, last_cust INTEGER

	CALL setup()

	LET modulo = 100
	LET last_cust = 100000
	LET l_no = 0

	DECLARE curs CURSOR FOR
	 SELECT customer.cust_no, invoice.invoice_no
	   FROM customer, OUTER invoice
	  WHERE customer.cust_no = invoice.cust_no
	  ORDER BY customer.cust_no
	
	FOREACH curs INTO c_no, i_no
	   	IF c_no mod modulo == 0 OR # mark items to keep
		   c_no > last_cust THEN
			IF l_no != c_no THEN # these records are 1 per customer
				LET l_no = c_no

			   	UPDATE address SET sample = 1
				 WHERE cust_no = c_no
			   	UPDATE regcard SET sample = 1 
				 WHERE cust_no = c_no
			   	UPDATE newreg SET sample = 1 
				 WHERE cust_no = c_no
		 		UPDATE shipreg SET sample = 1
			         WHERE cust_no = c_no
			   	UPDATE customer SET sample = 1
	      			 WHERE cust_no = c_no
				 MESSAGE "customer ", c_no,
				 	 " added to sample "
			END IF

			IF i_no IS NOT NULL THEN # these are per invoice
				UPDATE invoice SET sample = 1
				 WHERE invoice_no = i_no
				UPDATE inv_line SET sample = 1
				 WHERE invoice_no = i_no
				UPDATE cmemo SET sample = 1
				 WHERE invoice_no = i_no
				UPDATE auth SET sample = 1
				 WHERE invoice_no = i_no
				UPDATE payment SET sample = 1
				 WHERE invoice_no = i_no
				MESSAGE "invoice ", i_no,
					" added to sample "
			END IF
		END IF
	END FOREACH

	CLOSE curs
	MESSAGE "marking done "

	# Kill unmarked items and remove extra row.
	# remove and recreate indices to make them shrink
	DROP INDEX c_address
   	DELETE FROM address WHERE sample IS NULL
	ALTER TABLE address	DROP(sample)
	CREATE CLUSTER INDEX c_address ON address (cust_no)
	MESSAGE "address reindexed "

	DROP INDEX c_regcard
   	DELETE FROM regcard WHERE sample IS NULL
	ALTER TABLE regcard	DROP(sample)
	CREATE UNIQUE CLUSTER INDEX i_ser_no ON regcard (ser_no)
	CREATE INDEX c_regcard ON regcard (cust_no)
	MESSAGE "regcard reindexed "

	DROP INDEX c_newreg
   	DELETE FROM newreg WHERE sample IS NULL
	ALTER TABLE newreg	DROP(sample)
	CREATE UNIQUE CLUSTER INDEX i_nser_no ON newreg (ser_no)
	CREATE INDEX c_newreg ON newreg (cust_no)
	MESSAGE "newreg reindexed "

	DROP INDEX cust_ship
 	DELETE FROM shipreg WHERE sample IS NULL
	ALTER TABLE shipreg	DROP(sample)
	CREATE UNIQUE CLUSTER INDEX ser_ship ON shipreg (ser_no)
	CREATE INDEX cust_ship ON shipreg (cust_no)
	MESSAGE "shipreg reindexed "

	DROP INDEX c_customer
   	DELETE FROM customer WHERE sample IS NULL
	ALTER TABLE customer	DROP(sample)
	CREATE UNIQUE CLUSTER INDEX c_customer ON customer (cust_no)
	CREATE INDEX c_crunch ON customer (crunch)
	MESSAGE "customer reindexed "

	DROP INDEX i_invoice_no
	DROP INDEX c_invoice
	MESSAGE "invoice indices dropped"
	DELETE FROM invoice WHERE sample IS NULL
	MESSAGE "invoice non samples deleted "
	ALTER TABLE invoice	DROP(sample)
	MESSAGE "invoice sample row dropped "
	CREATE UNIQUE CLUSTER INDEX i_invoice_no ON invoice (invoice_no)
	MESSAGE "i_invoice_no created "
	CREATE INDEX c_invoice ON invoice (cust_no)
	MESSAGE "c_invoice created "
	CREATE INDEX i_invoice_date ON invoice (invoice_date)
	MESSAGE "i_invoice_date created "
	CREATE INDEX b_invoice ON invoice (batch_ix)
	MESSAGE "b_invoice created "
	CREATE INDEX d_invoice ON invoice (card_no);
	MESSAGE "invoice reindexed "

	DROP INDEX i_line
	DELETE FROM inv_line WHERE sample IS NULL
	ALTER TABLE inv_line	DROP(sample)
	CREATE CLUSTER INDEX i_line ON inv_line (invoice_no)
	MESSAGE "inv_line reindexed "

	DROP INDEX c_invoice_no
	DELETE FROM cmemo WHERE sample IS NULL
	ALTER TABLE cmemo	DROP(sample)
	CREATE INDEX c_invoice_no ON cmemo (invoice_no)
	CREATE INDEX b_credit ON cmemo (batch_ix)
	MESSAGE "cmemo reindexed "

	DROP INDEX a_invoice_no
	DELETE FROM auth WHERE sample IS NULL
	ALTER TABLE auth	DROP(sample)
	CREATE UNIQUE CLUSTER INDEX i_auth ON auth (auth_no)
	CREATE INDEX a_invoice_no ON auth (invoice_no)
	MESSAGE "auth reindexed "

	DROP INDEX p_invoice_no
	DELETE FROM payment WHERE sample IS NULL
	ALTER TABLE payment	DROP(sample)
	CREATE INDEX p_invoice_no ON payment (invoice_no)
	MESSAGE "payments reindexed "
END MAIN

# Broken up to test a theory about Informix
FUNCTION setup()
   	UPDATE sws SET systm = "JUNK"

	# drop any indices not used by this program, recreate later
	WHENEVER ERROR CONTINUE
	DROP TABLE workf
	DROP INDEX i_ser_no
	DROP INDEX i_nser_no
	DROP INDEX ser_ship
	DROP INDEX c_crunch
	DROP INDEX i_invoice_date
	DROP INDEX d_invoice
	DROP INDEX b_invoice
	DROP INDEX b_credit
	DROP INDEX i_auth
	WHENEVER ERROR STOP
	MESSAGE "Indices dropped "

	# add sample flag
	ALTER TABLE invoice 	ADD(sample SMALLINT)
	MESSAGE "sample column added to invoice "
	ALTER TABLE customer 	ADD(sample SMALLINT)
	MESSAGE "sample column added to customer "
	ALTER TABLE address 	ADD(sample SMALLINT)
	MESSAGE "sample column added to address "
	ALTER TABLE regcard 	ADD(sample SMALLINT)
	MESSAGE "sample column added to regcard "
	ALTER TABLE newreg 	ADD(sample SMALLINT)
	MESSAGE "sample column added to newreg "
	ALTER TABLE shipreg 	ADD(sample SMALLINT)
	MESSAGE "sample column added to shipreg "
	ALTER TABLE inv_line 	ADD(sample SMALLINT)
	MESSAGE "sample column added to inv_line "
	ALTER TABLE cmemo	ADD(sample SMALLINT)
	MESSAGE "sample column added to cmemo "
	ALTER TABLE auth	ADD(sample SMALLINT)
	MESSAGE "sample column added to auth "
	ALTER TABLE payment 	ADD(sample SMALLINT)
	MESSAGE "sample column added to payment "
END FUNCTION
